/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.partitiontask.task;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.partitiontask.api.ISubTaskExecutor;
import kd.mpscmm.msbd.partitiontask.exception.PartitionTaskErrorCode;
import kd.mpscmm.msbd.partitiontask.task.PartitionTaskHelper;

public class SubTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SubTask.class);
    private static final List<String> NOTRUNNING_STATUS = Arrays.asList("A", "B", "E");

    public void execute(RequestContext ctx, Map<String, Object> paramMap) throws KDException {
        Long taskLogId = (Long)paramMap.get("taskid");
        String execAppId = (String)paramMap.get("appId");
        if (StringUtils.isEmpty((String)execAppId)) {
            execAppId = "im";
        }
        String selectors = "param_tag,maintasklogid,schemeid.id,schemeid.subtaskexec,taskstatus,schemeid.retryinterval";
        DynamicObject taskLogInfo = BusinessDataServiceHelper.loadSingle((Object)taskLogId, (String)"msbd_tasklog", (String)selectors);
        Long mainTaskId = taskLogInfo.getLong("maintasklogid");
        Map params = null;
        int retryInterval = 60;
        try {
            if (this.cannotExecute(taskLogInfo)) {
                return;
            }
            params = (Map)SerializationUtils.fromJsonString((String)taskLogInfo.getString("param_tag"), Map.class);
            PartitionTaskHelper.setRunTask(taskLogId, this.taskId);
            DynamicObject taskScheme = taskLogInfo.getDynamicObject("schemeid");
            retryInterval = taskScheme.getInt("retryinterval");
            String subTaskClass = taskScheme.getString("subtaskexec");
            this.executeTask(subTaskClass, params);
            PartitionTaskHelper.setSuccessTask(taskLogId);
            PartitionTaskHelper.subTaskRunningCountMinus(mainTaskId.toString());
            PartitionTaskHelper.deleteJob(this.taskId);
        }
        catch (Exception e) {
            logger.error("\u5b50\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            PartitionTaskHelper.subTaskRunningCountMinus(mainTaskId.toString());
            String errMsg = e.toString();
            PartitionTaskHelper.setErrTask(taskLogId, errMsg);
            this.autoRetry(taskLogId, mainTaskId, retryInterval, execAppId);
            throw new KDException((Throwable)e, PartitionTaskErrorCode.getExecTaskError(), new Object[0]);
        }
        finally {
            String countStr = (String)PartitionTaskHelper.getPartitionCache().get(mainTaskId.toString());
            if (countStr != null && Integer.parseInt(countStr) <= 0) {
                String mutexKey;
                PartitionTaskHelper.subTaskRunningCountClear(mainTaskId.toString());
                if (params != null && !StringUtils.isEmpty((String)(mutexKey = (String)params.get("mutexkey")))) {
                    PartitionTaskHelper.releaseMutex(mutexKey, mainTaskId);
                }
            }
            this.executeNextTask(mainTaskId, execAppId);
        }
    }

    private void executeNextTask(Long mainTaskLogId, String execAppId) {
        try (DLock dLock = DLock.create((String)String.valueOf(mainTaskLogId), (String)ResManager.loadKDString((String)"\u5206\u6279\u6846\u67b6\u4efb\u52a1\u9501%s", (String)"mainTaskLock", (String)"mpscmm-msbd-partitiontask", (Object[])new Object[]{mainTaskLogId}));){
            dLock.lock();
            QFilter filter = new QFilter("maintasklogid", "=", (Object)mainTaskLogId).and("taskstatus", "=", (Object)"C");
            DynamicObjectCollection taskObjs = QueryServiceHelper.query((String)"msbd_tasklog", (String)"id,name", (QFilter[])filter.toArray(), (String)"", (int)1);
            if (taskObjs != null && !taskObjs.isEmpty()) {
                DynamicObject task = (DynamicObject)taskObjs.get(0);
                Long taskLogId = task.getLong("id");
                PartitionTaskHelper.dispatchSubJob(task.getString("name"), taskLogId, execAppId);
            }
        }
    }

    private void autoRetry(Long taskLogId, Long mainTaskId, int retryInterval, String execAppId) {
        DynamicObject taskLog = QueryServiceHelper.queryOne((String)"msbd_tasklog", (String)"retrytimeremain,taskstatus", (QFilter[])new QFilter("id", "=", (Object)taskLogId).toArray());
        if (this.cannotExecute(taskLog)) {
            return;
        }
        int retryTimeRemain = taskLog.getInt("retrytimeremain");
        if (retryTimeRemain > 0) {
            PartitionTaskHelper.atskRetryTimesMinus(taskLogId);
            PartitionTaskHelper.subTaskRunningCountPlus(mainTaskId.toString());
            PartitionTaskHelper.setWaitRetryTask(taskLogId);
            try {
                Thread.sleep(retryInterval * 1000);
            }
            catch (InterruptedException e) {
                logger.error("\u7ebf\u7a0b\u4f11\u7720\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
            PartitionTaskHelper.deleteJob(this.taskId);
            PartitionTaskHelper.retryTask(Collections.singletonList(taskLogId), execAppId);
        }
    }

    private void executeTask(String subTaskClass, Map<String, Object> paramMap) throws Exception {
        paramMap.put("taskid", this.taskId);
        Object subTaskImpl = TypesContainer.getOrRegisterSingletonInstance((String)subTaskClass);
        if (!(subTaskImpl instanceof ISubTaskExecutor)) {
            throw new KDException(PartitionTaskErrorCode.getImplementsSubTask(), new Object[0]);
        }
        ((ISubTaskExecutor)subTaskImpl).execute(paramMap);
    }

    private boolean cannotExecute(DynamicObject taskLogInfo) {
        if (taskLogInfo == null) {
            logger.error("\u4efb\u52a1\u4e0d\u5b58\u5728");
            return true;
        }
        String status = taskLogInfo.getString("taskstatus");
        return NOTRUNNING_STATUS.contains(status);
    }
}

