/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.ext;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.mpscmm.msbd.expoint.workbench.BizOperatorAndGroup;
import kd.sdk.mpscmm.msbd.expoint.workbench.IWorkBenchPlugin;

public class InvWorkBenchDefaultExpand
implements IWorkBenchPlugin {
    private static final Log log = LogFactory.getLog(InvWorkBenchDefaultExpand.class);
    private static final String ORG = "org";
    private static final String WAREHOUSE = "warehouse";
    private static final String MATERIAL = "material";
    private static final String MATERIAL_GROUP = "materialgroup";
    private static final String OPERATOR_GROUP = "id";
    private static final String OPERATOR = "entryentity.id";
    private static final String WAREHOUSE_SETTING_ENTITY = "im_warehousesetup";
    private static final String OPERATOR_MATERIAL_REL_ENTITY = "im_invoperatormat";
    private static final String OPERATOR_ENTITY = "bd_operator";
    private static final String OPERATOR_GROUP_ENTITY = "bd_operatorgroup";

    public Set<String> preparePropertys(String entityNumber, String domainNumber) {
        HashSet<String> fieldSet = new HashSet<String>(16);
        switch (entityNumber) {
            case "im_purinbill": {
                fieldSet.add(ORG);
                fieldSet.add("billentry.material");
                fieldSet.add("billentry.warehouse");
                break;
            }
            case "sm_delivernotice": {
                fieldSet.add(ORG);
                fieldSet.add("billentry.material");
                fieldSet.add("billentry.warehouse");
                break;
            }
            case "im_materialreqbill": {
                fieldSet.add(ORG);
                fieldSet.add("billentry.material");
                fieldSet.add("billentry.warehouse");
                break;
            }
        }
        return fieldSet;
    }

    public BizOperatorAndGroup getBizOperatorAndGroup(DynamicObject bizData, DynamicObject entryRowData, boolean genTaskByEntry) {
        Object materialGroupNext2;
        Object materialNext2;
        Object next;
        if (!genTaskByEntry) {
            return new BizOperatorAndGroup();
        }
        Map<String, Long> map = this.convert2ImObjMap(bizData, entryRowData);
        Long orgId = map.get(ORG);
        Long warehouseId = map.get(WAREHOUSE);
        Long materialId = map.get(MATERIAL);
        Long materialGroupId = map.get("materialGroup");
        HashSet<Long> opWarehouseSet = new HashSet<Long>();
        HashSet<Long> opByMaterialOrMaterialGroupSet = new HashSet<Long>();
        HashSet<Long> opGroupByMaterialOrMaterialGroupSet = new HashSet<Long>();
        QFilter warehouseFilter = new QFilter(ORG, "=", (Object)orgId).and(WAREHOUSE, "=", (Object)warehouseId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)WAREHOUSE_SETTING_ENTITY, (String)"operatorentity.operatoruser", (QFilter[])warehouseFilter.toArray(), null);){
            while (dataSet.hasNext()) {
                next = dataSet.next();
                Long operatorId = next.getLong("operatorentity.operatoruser");
                opWarehouseSet.add(operatorId);
            }
        }
        if (opWarehouseSet.isEmpty()) {
            return new BizOperatorAndGroup();
        }
        QFilter materialFilter = new QFilter(ORG, "=", (Object)orgId).and(MATERIAL, "=", (Object)materialId);
        DataSet materialDataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)OPERATOR_MATERIAL_REL_ENTITY, (String)"operator, operatorgroup, controldimension", (QFilter[])materialFilter.toArray(), null);
        next = null;
        try {
            while (materialDataset.hasNext()) {
                materialNext2 = materialDataset.next();
                String controlDimension = materialNext2.getString("controldimension");
                this.addSetByControlDimension(controlDimension, opByMaterialOrMaterialGroupSet, opGroupByMaterialOrMaterialGroupSet, (Row)materialNext2);
            }
        }
        catch (Throwable materialNext2) {
            next = materialNext2;
            throw materialNext2;
        }
        finally {
            if (materialDataset != null) {
                if (next != null) {
                    try {
                        materialDataset.close();
                    }
                    catch (Throwable materialNext2) {
                        ((Throwable)next).addSuppressed(materialNext2);
                    }
                } else {
                    materialDataset.close();
                }
            }
        }
        QFilter materialGroupFilter = new QFilter(ORG, "=", (Object)orgId).and(MATERIAL_GROUP, "=", (Object)materialGroupId);
        DataSet materialGroupDataset = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)OPERATOR_MATERIAL_REL_ENTITY, (String)"operator, operatorgroup, controldimension", (QFilter[])materialGroupFilter.toArray(), null);
        materialNext2 = null;
        try {
            while (materialGroupDataset.hasNext()) {
                materialGroupNext2 = materialGroupDataset.next();
                String controlDimension = materialGroupNext2.getString("controldimension");
                this.addSetByControlDimension(controlDimension, opByMaterialOrMaterialGroupSet, opGroupByMaterialOrMaterialGroupSet, (Row)materialGroupNext2);
            }
        }
        catch (Throwable materialGroupNext2) {
            materialNext2 = materialGroupNext2;
            throw materialGroupNext2;
        }
        finally {
            if (materialGroupDataset != null) {
                if (materialNext2 != null) {
                    try {
                        materialGroupDataset.close();
                    }
                    catch (Throwable materialGroupNext2) {
                        ((Throwable)materialNext2).addSuppressed(materialGroupNext2);
                    }
                } else {
                    materialGroupDataset.close();
                }
            }
        }
        QFilter operatorGroupFilter = new QFilter(OPERATOR_GROUP, "in", opGroupByMaterialOrMaterialGroupSet).or(new QFilter(OPERATOR, "in", opByMaterialOrMaterialGroupSet));
        DataSet operatorGroupDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)OPERATOR_GROUP_ENTITY, (String)OPERATOR, (QFilter[])operatorGroupFilter.toArray(), null);
        materialGroupNext2 = null;
        try {
            while (operatorGroupDataSet.hasNext()) {
                Row operatorGroupNext = operatorGroupDataSet.next();
                Long operatorIdByOperatorGroup = operatorGroupNext.getLong(OPERATOR);
                opByMaterialOrMaterialGroupSet.add(operatorIdByOperatorGroup);
            }
        }
        catch (Throwable operatorGroupNext) {
            materialGroupNext2 = operatorGroupNext;
            throw operatorGroupNext;
        }
        finally {
            if (operatorGroupDataSet != null) {
                if (materialGroupNext2 != null) {
                    try {
                        operatorGroupDataSet.close();
                    }
                    catch (Throwable operatorGroupNext) {
                        ((Throwable)materialGroupNext2).addSuppressed(operatorGroupNext);
                    }
                } else {
                    operatorGroupDataSet.close();
                }
            }
        }
        HashSet<Long> setIntersection = new HashSet<Long>();
        setIntersection.addAll(opWarehouseSet);
        setIntersection.retainAll(opByMaterialOrMaterialGroupSet);
        setIntersection.remove(0L);
        if (!setIntersection.isEmpty()) {
            log.info("\u53d6\u4ea4\u96c6");
            DynamicObject[] operatorList = BusinessDataServiceHelper.load((String)OPERATOR_ENTITY, (String)"operatornumber, opergrpnumber, operatorname, opergrpname, opergrptype, invalid", (QFilter[])new QFilter[]{new QFilter(OPERATOR_GROUP, "in", setIntersection), new QFilter("invalid", "=", (Object)false)}, (String)"id asc", (int)1);
            if (operatorList == null || operatorList.length == 0) {
                return new BizOperatorAndGroup();
            }
            DynamicObject operator = operatorList[0];
            String opGroupNum = operator.getString("opergrpnumber");
            DynamicObject operatorGroup = BusinessDataServiceHelper.loadSingle((String)OPERATOR_GROUP_ENTITY, (String)"number, name, operatorgrouptype", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)opGroupNum)});
            BizOperatorAndGroup bizOperatorAndGroup = new BizOperatorAndGroup();
            bizOperatorAndGroup.setOperator(operator);
            bizOperatorAndGroup.setGroup(operatorGroup);
            return bizOperatorAndGroup;
        }
        return new BizOperatorAndGroup();
    }

    private Map<String, Long> convert2ImObjMap(DynamicObject biData, DynamicObject entryRowData) {
        String key = biData.getDataEntityType().getName();
        HashMap<String, Long> map = new HashMap<String, Long>();
        switch (key) {
            case "im_purinbill": {
                map.put(ORG, biData.getLong("org.id"));
                map.put(MATERIAL, entryRowData.getLong("material.id"));
                map.put("materialGroup", this.getMaterialGroupIdByMaterial(entryRowData.getLong("material.id")));
                map.put(WAREHOUSE, entryRowData.getLong("warehouse.id"));
                break;
            }
            case "sm_delivernotice": {
                map.put(ORG, biData.getLong("deliverorg.id"));
                map.put(MATERIAL, entryRowData.getLong("material.id"));
                map.put("materialGroup", this.getMaterialGroupIdByMaterial(entryRowData.getLong("material.id")));
                map.put(WAREHOUSE, entryRowData.getLong("warehouse.id"));
                break;
            }
            case "im_materialreqbill": {
                map.put(ORG, biData.getLong("bizorg.id"));
                map.put(MATERIAL, entryRowData.getLong("material.id"));
                map.put("materialGroup", this.getMaterialGroupIdByMaterial(entryRowData.getLong("material.id")));
                map.put(WAREHOUSE, entryRowData.getLong("warehouse.id"));
                break;
            }
        }
        return map;
    }

    private Long getMaterialGroupIdByMaterial(Long materialId) {
        if (materialId == null) {
            return null;
        }
        QFilter materialFilter = new QFilter(OPERATOR_GROUP, "=", (Object)materialId);
        DynamicObject materialObj = BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])materialFilter.toArray());
        if (materialObj == null) {
            return null;
        }
        QFilter qFilter = new QFilter(MATERIAL, "=", (Object)materialObj.getLong("masterid.id"));
        DynamicObject materialGroupStandard = BusinessDataServiceHelper.loadSingle((String)"bd_materialgroupdetail", (String)"standard,group,createorg,material", (QFilter[])new QFilter[]{qFilter});
        if (materialGroupStandard == null) {
            return null;
        }
        DynamicObject materialGroup = materialGroupStandard.getDynamicObject("group");
        if (materialGroup == null) {
            return null;
        }
        return (Long)materialGroup.getPkValue();
    }

    private void addSetByControlDimension(String controlDimension, Set<Long> opByMaterialOrMaterialGroupSet, Set<Long> opGroupByMaterialOrMaterialGroupSet, Row row) {
        Long operatorId = row.getLong("operator");
        Long operatorGroupId = row.getLong("operatorgroup");
        if ("OPER_MATER".equalsIgnoreCase(controlDimension) || "OPER_MATERGRP".equalsIgnoreCase(controlDimension)) {
            opByMaterialOrMaterialGroupSet.add(operatorId);
        } else if ("OPERGRP_MATER".equalsIgnoreCase(controlDimension) || "OPERGRP_MATERGRP".equalsIgnoreCase(controlDimension)) {
            opGroupByMaterialOrMaterialGroupSet.add(operatorGroupId);
        }
    }
}

