/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.form.container.MessageCarouselContainer;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.GridCardPlugin;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.config.YzjTokenHelper;
import kd.bos.yzj.model.YzjConfig;

public class CloudHubSubscribePlugin
extends GridCardPlugin {
    private static final String YZJ_SHARE_GETMSGLIST = "/imsdk/pub/msglist.do?";
    private static Log log = LogFactory.getLog(CloudHubSubscribePlugin.class);
    public static final int CARD_MAX_MSGCOUNT = 5;
    private static final String IMAGE_KEY = "imageap";
    private static final String LABEL_KEY = "caption";
    private static final String URL_KEY = "urlap";
    private static final String CARD_TITLE = "title";
    private static final String LBT_KEY = "lbtap";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        MessageCarouselContainer lbtAp = (MessageCarouselContainer)this.getControl(LBT_KEY);
        lbtAp.addItemClickListener((ItemClickListener)this);
    }

    protected void refreshCard(Map<String, String> allConfigMap) {
        super.refreshCard(allConfigMap);
        String pubAcctId = allConfigMap.get("pubid");
        String pubName = allConfigMap.get("pubname");
        this.showSubscribe(pubAcctId, pubName);
    }

    public void itemClick(ItemClickEvent evt) {
        super.click((EventObject)evt);
        Control ctrl = (Control)evt.getSource();
        String key = ctrl.getKey();
        if (LBT_KEY.equals(key)) {
            if (this.isDesignMode()) {
                return;
            }
            int index = (Integer)evt.getParamsMap().get("rowKey");
            String data = this.getPageCache().get("data");
            if (StringUtils.isEmpty((CharSequence)data)) {
                return;
            }
            List msgList = (List)SerializationUtils.fromJsonString((String)data, List.class);
            Map dataMap = (Map)msgList.get(index);
            Map propMap = (Map)dataMap.get(URL_KEY);
            if (propMap == null || propMap.get("text") == null || kd.bos.util.StringUtils.isEmpty((String)propMap.get("text").toString())) {
                return;
            }
            this.getView().openUrl(propMap.get("text").toString());
        }
    }

    public void showSubscribe(String subId, String pubName) {
        Map<String, Object> msgListMap;
        if (kd.bos.util.StringUtils.isNotEmpty((String)pubName)) {
            Label title = (Label)this.getControl(CARD_TITLE);
            title.setText(pubName);
        }
        if ((msgListMap = this.getYzjMsgList(subId)) == null || msgListMap.size() <= 0) {
            return;
        }
        Boolean successFlag = (Boolean)msgListMap.get("success");
        if (!successFlag.booleanValue()) {
            return;
        }
        Map items = (Map)msgListMap.get("data");
        if (items == null) {
            return;
        }
        ArrayList list = (ArrayList)items.get("list");
        if (list.size() <= 0) {
            return;
        }
        list.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> arg0, Map<String, Object> arg1) {
                SimpleDateFormat fmtDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    Date d1 = fmtDate.parse(arg0.get("sendTime").toString());
                    Date d2 = fmtDate.parse(arg1.get("sendTime").toString());
                    if (d1.getTime() < d2.getTime()) {
                        return 1;
                    }
                    if (d1.getTime() > d2.getTime()) {
                        return -1;
                    }
                }
                catch (Exception exception) {
                    log.error((Throwable)exception);
                }
                return 0;
            }
        });
        HashMap<String, String> labelPropMap = null;
        HashMap<String, String> imagePropMap = null;
        HashMap controlMap = null;
        ArrayList msgList = new ArrayList();
        for (Map msgMap : list) {
            if (msgList.size() >= 5) break;
            controlMap = new HashMap();
            labelPropMap = new HashMap<String, String>();
            String msgType = msgMap.get("msgType").toString().trim();
            String content = (String)msgMap.get("content");
            labelPropMap.put("text", content);
            controlMap.put(LABEL_KEY, labelPropMap);
            imagePropMap = new HashMap<String, String>();
            imagePropMap.put("imageKey", "/private/subscribe_pic1.png");
            controlMap.put(IMAGE_KEY, imagePropMap);
            if ("5".equals(msgType) || "6".equals(msgType)) {
                ArrayList lstDetail;
                Map param = (Map)msgMap.get("param");
                if (param == null || param.size() == 0) continue;
                if ("5".equals(msgType)) {
                    lstDetail = (ArrayList)param.get("attach");
                    Map mapDetail = (Map)lstDetail.get(0);
                    String msgUrl = (String)mapDetail.get("value");
                    labelPropMap = new HashMap();
                    labelPropMap.put("text", msgUrl);
                    controlMap.put(URL_KEY, labelPropMap);
                } else if ("6".equals(msgType)) {
                    lstDetail = (ArrayList)param.get("list");
                    for (Map mapDetail : lstDetail) {
                        controlMap = new HashMap();
                        String text = (String)mapDetail.get(CARD_TITLE);
                        labelPropMap = new HashMap();
                        labelPropMap.put("text", text);
                        controlMap.put(LABEL_KEY, labelPropMap);
                        imagePropMap = new HashMap();
                        String imageKey = (String)mapDetail.get("thumbUrl");
                        imagePropMap.put("imageKey", imageKey);
                        controlMap.put(IMAGE_KEY, imagePropMap);
                        labelPropMap = new HashMap();
                        String msgUrl = (String)mapDetail.get("url");
                        labelPropMap.put("text", msgUrl);
                        controlMap.put(URL_KEY, labelPropMap);
                        msgList.add(controlMap);
                    }
                    continue;
                }
            }
            msgList.add(controlMap);
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("data", msgList);
        dataMap.put("k", LBT_KEY);
        this.getPageCache().put("data", SerializationUtils.toJsonString(msgList));
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        proxy.addAction("u", dataMap);
    }

    private Map<String, Object> getYzjMsgList(String publicAcctId) {
        YzjConfig config = YzjConfigServiceHelper.getConfig();
        if (!config.isEnable()) {
            return null;
        }
        String yzjHost = config.getUrl();
        try {
            Map<String, String> header = this.getHttpRequestHeaderJson();
            String sYzjTicket = YzjTokenHelper.getToken((YzjConfig)config, (String)"ticket");
            if (StringUtils.isNotBlank((CharSequence)sYzjTicket) && sYzjTicket != null) {
                HashMap<String, Object> dep = new HashMap<String, Object>();
                dep.put("useMS", true);
                dep.put("msgId", "");
                dep.put("count", 500);
                dep.put("userId", publicAcctId);
                dep.put("type", "new");
                String sOrgJson = JSONUtils.toString(dep);
                String sHttpResponse = HttpClientUtils.postjson((String)(yzjHost + YZJ_SHARE_GETMSGLIST + "ticket=" + sYzjTicket), header, (String)sOrgJson);
                Map mpResult = (Map)JSONUtils.cast((String)sHttpResponse, HashMap.class);
                return mpResult;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return null;
    }

    private Map<String, String> getHttpRequestHeaderJson() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/json;charset=UTF-8");
        return header;
    }
}

