/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class CustomDefaultParamPlugin
extends AbstractFormPlugin {
    private static final String BTNOK = "btnok";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PARAMNAME = "paramname";
    private static final String PARAMVALUE = "paramvalue";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterBindData(EventObject e) {
        String paramStr = (String)this.getView().getFormShowParameter().getCustomParam("params");
        if (StringUtils.isNotEmpty((String)paramStr)) {
            Map params = (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class);
            params.forEach((key, value) -> {
                int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                this.getModel().setValue(PARAMNAME, key, index);
                this.getModel().setValue(PARAMVALUE, value, index);
            });
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String sourceKey = source.getKey();
        if (BTNOK.equals(sourceKey)) {
            this.getView().returnDataToParent((Object)this.getCustomParams());
            this.getView().close();
        }
    }

    private Map getCustomParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject entry : entries) {
            String paramName = entry.getString(PARAMNAME);
            String paramValue = entry.getString(PARAMVALUE);
            if (!StringUtils.isNotEmpty((String)paramName)) continue;
            params.put(paramName, paramValue);
        }
        return params;
    }
}

