/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;

public class MessageCenterCardConfigPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(MessageCenterCardConfigPlugin.class);
    private static final String BTN_OK = "button_ok";
    private static final String CHECKBOXFLEXPANELAP = "checkboxflexpanelap";
    private static final String COMBOFLEXPANELAP = "comboflexpanelap";
    private static final String CHECK_MSG = "check_msg_";
    private static final String CO_MSG = "co_msg_";
    private static final String SELECT_NUM = "selectNum";
    private static final String NODE_ID = "nodeId";
    private static final String NODE_COLOR = "nodeColor";
    private static final String ORANGLE = "#FF991C";
    private static final String RED = "#FB2323";
    private static final String GRAY = "#666666";
    private static Map<String, List<Map<String, Object>>> msgCenterCardOptionsMap = new ConcurrentHashMap<String, List<Map<String, Object>>>(16);

    private String getFieldKey(String prefix, String nodeId) {
        return prefix + nodeId.toLowerCase(Locale.ENGLISH);
    }

    private List<Map<String, Object>> loadMsgCenterCardOptions() {
        String userId = RequestContext.get().getCurrUserId() + "";
        List<Map<String, Object>> msgCenterCardOptions = msgCenterCardOptionsMap.get(userId);
        if (msgCenterCardOptions == null) {
            this.initMsgCenterCardOptions();
            msgCenterCardOptions = msgCenterCardOptionsMap.get(userId);
        }
        return msgCenterCardOptions;
    }

    private void initMsgCenterCardOptions() {
        String userId = RequestContext.get().getCurrUserId() + "";
        List msgCenterCardOptions = MessageCenterServiceHelper.getMsgCenterCardOptions((String)userId);
        if (msgCenterCardOptions != null) {
            msgCenterCardOptionsMap.put(userId, msgCenterCardOptions);
        } else {
            logger.info("loadMsgCenterCardOptions is empty");
        }
    }

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs e) {
        super.loadCustomControlMetas(e);
        this.initMsgCenterCardOptions();
        this.buildFlexPanel(CHECKBOXFLEXPANELAP, e.getItems());
        this.buildFlexPanel(COMBOFLEXPANELAP, e.getItems());
    }

    private void buildFlexPanel(String flexPanelKey, List<Map<String, Object>> items) {
        FlexPanelAp flexPanelAp = new FlexPanelAp();
        flexPanelAp.setKey(flexPanelKey);
        List<Map<String, Object>> msgCenterCardOptions = this.loadMsgCenterCardOptions();
        for (Map<String, Object> map : msgCenterCardOptions) {
            String id = map.get("id").toString();
            String name = (String)map.get("name");
            if (CHECKBOXFLEXPANELAP.equals(flexPanelKey)) {
                flexPanelAp.getItems().add(this.buildCheckBoxAp(id, name));
                continue;
            }
            if (!COMBOFLEXPANELAP.equals(flexPanelKey)) continue;
            flexPanelAp.getItems().add(this.buildComboAp(id, name));
        }
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", flexPanelKey);
        mapHead.put("items", (String)flexPanelAp.createControl().get("items"));
        items.add(mapHead);
    }

    public void afterCreateNewData(EventObject e) {
        List<Map<String, Object>> msgCenterCardOptions = this.loadMsgCenterCardOptions();
        if (msgCenterCardOptions == null || msgCenterCardOptions.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u53ef\u7528\u7684\u6d88\u606f\u4e2d\u5fc3\u5361\u7247\u670d\u52a1\u3002", (String)"MessageCenterCardConfigPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        } else {
            Map selectMsgType = (Map)this.getView().getFormShowParameter().getCustomParam("selectMsgType");
            Map<String, String> nodeMap = this.getSelectMsgIdAndColor(selectMsgType);
            for (Map<String, Object> map : msgCenterCardOptions) {
                String nodeId = map.get("id").toString();
                String color = nodeMap.get(nodeId);
                if (color != null) {
                    this.getModel().setValue(this.getFieldKey(CHECK_MSG, nodeId), (Object)true);
                    this.getModel().setValue(this.getFieldKey(CO_MSG, nodeId), (Object)color);
                    continue;
                }
                this.getModel().setValue(this.getFieldKey(CO_MSG, nodeId), (Object)GRAY);
            }
            this.updateLabelNum(nodeMap.size() + "");
        }
    }

    private Map<String, String> getSelectMsgIdAndColor(Map<String, Map<String, String>> selectMsgType) {
        HashMap<String, String> nodeMap = new HashMap<String, String>();
        if (selectMsgType != null) {
            selectMsgType.values().forEach(msgType -> {
                String nodeId = (String)msgType.get(NODE_ID);
                String nodeColor = (String)msgType.get(NODE_COLOR);
                if (nodeColor == null) {
                    nodeColor = ORANGLE;
                }
                nodeMap.put(nodeId, nodeColor);
            });
        }
        return nodeMap;
    }

    public void click(EventObject evt) {
        super.click(evt);
        List<Map<String, Object>> msgCenterCardOptions = this.loadMsgCenterCardOptions();
        if (msgCenterCardOptions == null) {
            return;
        }
        ArrayList returnData = new ArrayList();
        for (Map<String, Object> map : msgCenterCardOptions) {
            String id = map.get("id").toString();
            Object isCheck = this.getModel().getValue(this.getFieldKey(CHECK_MSG, id));
            if (isCheck == null || !"true".equals(isCheck.toString())) continue;
            HashMap<String, String> returnMap = new HashMap<String, String>();
            String name = (String)map.get("name");
            String color = this.getModel().getValue(this.getFieldKey(CO_MSG, id)).toString();
            returnMap.put("cardType", "msbd_card_msgcenter");
            returnMap.put(NODE_ID, id);
            returnMap.put("nodeText", name);
            returnMap.put(NODE_COLOR, color);
            returnData.add(returnMap);
        }
        this.getView().returnDataToParent(returnData);
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (name.startsWith(CHECK_MSG)) {
            Object isCheck = this.getModel().getValue(name);
            if (isCheck == null) {
                return;
            }
            int num = 0;
            String selectNum = this.getPageCache().get(SELECT_NUM);
            if (selectNum != null) {
                num = Integer.parseInt(selectNum);
            }
            num = "true".equals(isCheck.toString()) ? num + 1 : num - 1;
            this.updateLabelNum(num + "");
        }
    }

    private void updateLabelNum(String num) {
        Label label = (Label)this.getView().getControl("numlabelap");
        label.setText(num);
        this.getPageCache().put(SELECT_NUM, num);
    }

    private FieldAp buildCheckBoxAp(String id, String name) {
        String key = this.getFieldKey(CHECK_MSG, id);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setFontSize(14);
        fieldAp.setKey(key);
        fieldAp.setId(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setHeight(new LocaleString("18px"));
        fieldAp.setWidth(new LocaleString("100px"));
        fieldAp.setFireUpdEvt(true);
        Margin margin = new Margin();
        margin.setTop("13px");
        margin.setBottom("13px");
        Style style = new Style();
        style.setMargin(margin);
        fieldAp.setStyle(style);
        CheckBoxField checkBoxField = new CheckBoxField();
        checkBoxField.setKey(key);
        checkBoxField.setId(key);
        checkBoxField.setName(new LocaleString(name));
        checkBoxField.setDefValue(true);
        checkBoxField.setShowStyle(2);
        fieldAp.setField((Field)checkBoxField);
        return fieldAp;
    }

    private FieldAp buildComboAp(String id, String name) {
        String key = this.getFieldKey(CO_MSG, id);
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey(key);
        fieldAp.setId(key);
        fieldAp.setName(new LocaleString(name));
        fieldAp.setFireUpdEvt(true);
        fieldAp.setShowTitle(false);
        fieldAp.setFieldStyle(2);
        fieldAp.setHeight(new LocaleString("28px"));
        fieldAp.setWidth(new LocaleString("200px"));
        fieldAp.setComboShowStyle(2);
        Margin margin = new Margin();
        margin.setTop("8px");
        margin.setBottom("8px");
        Style style = new Style();
        style.setMargin(margin);
        fieldAp.setStyle(style);
        ComboField comboField = new ComboField();
        comboField.setKey(key);
        comboField.setId(key);
        comboField.setEnableNull(false);
        comboField.setMustInput(true);
        comboField.setItems(this.getComboItems());
        comboField.setDefValue(GRAY);
        fieldAp.setField((Field)comboField);
        return fieldAp;
    }

    private List<ComboItem> getComboItems() {
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(3);
        ComboItem grayComboItem = new ComboItem(1, new LocaleString(ResManager.loadKDString((String)"\u6df1\u7070\uff08\u7edf\u8ba1\u7c7b\u6570\u5b57\uff09", (String)"MessageCenterCardConfigPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0])), GRAY);
        grayComboItem.setImageKey("/images/pc/other/Dark grey.png");
        comboItemList.add(grayComboItem);
        ComboItem redComboItem = new ComboItem(2, new LocaleString(ResManager.loadKDString((String)"\u7ea2\u8272\uff08\u91cd\u8981\u8b66\u793a\uff09", (String)"MessageCenterCardConfigPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0])), RED);
        redComboItem.setImageKey("/images/pc/other/Red.png");
        comboItemList.add(redComboItem);
        ComboItem orangleComboItem = new ComboItem(3, new LocaleString(ResManager.loadKDString((String)"\u6a59\u8272\uff08\u9700\u8981\u91cd\u70b9\u5f3a\u8c03\u7684\u6570\u5b57\u6216\u91d1\u989d\uff09", (String)"MessageCenterCardConfigPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0])), ORANGLE);
        orangleComboItem.setImageKey("/images/pc/other/orange.png");
        comboItemList.add(orangleComboItem);
        return comboItemList;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            MainEntityType newMainType = (MainEntityType)oldMainType.clone();
            this.buildFieldProp(newMainType);
            e.setNewEntityType(newMainType);
        }
        catch (CloneNotSupportedException ex) {
            logger.info("MessageCenterCardConfigPlugin--getEntityType:" + ex.getMessage());
        }
    }

    private void buildFieldProp(MainEntityType newMainEntityType) {
        List<Map<String, Object>> msgCenterCardOptions = this.loadMsgCenterCardOptions();
        if (msgCenterCardOptions == null) {
            return;
        }
        for (Map<String, Object> map : msgCenterCardOptions) {
            String id = map.get("id").toString();
            String name = (String)map.get("name");
            BooleanProp langProp = new BooleanProp();
            langProp.setName(this.getFieldKey(CHECK_MSG, id));
            langProp.setDisplayName(new LocaleString(name));
            langProp.setDbIgnore(true);
            langProp.setAlias("");
            langProp.setDefValue((Object)Boolean.FALSE);
            newMainEntityType.registerSimpleProperty((DynamicSimpleProperty)langProp);
            ComboProp comboProp = new ComboProp();
            comboProp.setName(this.getFieldKey(CO_MSG, id));
            comboProp.setDisplayName(new LocaleString(name));
            comboProp.setDbIgnore(true);
            comboProp.setAlias("");
            comboProp.setDefValue((Object)GRAY);
            newMainEntityType.registerSimpleProperty((DynamicSimpleProperty)comboProp);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        super.onGetControl(e);
        if (e.getKey().startsWith(CO_MSG) || e.getKey().startsWith(CHECK_MSG)) {
            FieldEdit textEdit = new FieldEdit();
            textEdit.setKey(e.getKey());
            textEdit.setFieldKey(e.getKey());
            textEdit.setView(this.getView());
            e.setControl((Control)textEdit);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildEdit(CHECKBOXFLEXPANELAP, CHECK_MSG);
        this.buildEdit(COMBOFLEXPANELAP, CO_MSG);
    }

    private void buildEdit(String panelKey, String fieldKeyPrefix) {
        List<Map<String, Object>> msgCenterCardOptions = this.loadMsgCenterCardOptions();
        if (msgCenterCardOptions == null) {
            return;
        }
        Container container = (Container)this.getView().getControl(panelKey);
        List items = container.getItems();
        for (Map<String, Object> map : msgCenterCardOptions) {
            String id = map.get("id").toString();
            String key = this.getFieldKey(fieldKeyPrefix, id);
            String name = (String)map.get("name");
            FieldEdit fieldEdit = new FieldEdit();
            fieldEdit.setKey(key);
            fieldEdit.setFieldKey(key);
            fieldEdit.setView(this.getView());
            fieldEdit.setCaption(new LocaleString(name));
            items.add(fieldEdit);
        }
        this.getView().createControlIndex(items);
    }
}

