/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.workbench.formplugin.GridCardPlugin;
import kd.mpscmm.msbd.workbench.util.CardUtils;

public class MessageCenterCardPlugin
extends GridCardPlugin {
    private static final String ICON_DEL_PREFIX = "icon_del";
    public static final String ICON_PREFIX = "iconap";
    public static final String LABEL_PREFIX = "label";
    public static final String TITLE = "title";
    public static final String BTN_ADD = "btn_add";
    public static final String PANEL_ADDBTN = "flexpanel_addbtn";
    public static final String PANEL_MSGCARD = "msgcentercard_panel";
    public static final String CLOSECALLBACK_CARDCONFIG = "Card_Config";
    public static final String CLOSECALLBACK_TITLEEDIT = "ModifyCardCaption";
    public static final String FORM_CAPTION_MODIFY = "bos_card_modifycaption";
    public static final String ITEM_COUNT = "itemCount";
    public static final String ITEM_DATA = "itemData";
    public static final String CENTER = "center";
    public static final String PX = "-30px";
    private static final String NODE_ID = "nodeId";
    private static final String NODE_COLOR = "nodeColor";
    private static final String ORANGLE = "#FF991C";
    private static final String DFLEXPANEL = "dflexpanel";
    private static final String ITEM_INDEX = "itemIndex";
    private List<String> opIdList = null;
    private List<Map<String, Object>> mMsgCenterCardOptions = null;
    private static final Log logger = LogFactory.getLog(MessageCenterCardPlugin.class);

    @Override
    public void initialize() {
        super.initialize();
        this.lstrDefaultTitle = new LocaleString(ResManager.loadKDString((String)"\u6d88\u606f\u4e2d\u5fc3", (String)"MessageCenterCardPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        this.TITLE_DEFAULT = this.lstrDefaultTitle.getLocaleValue();
        this.TITLE_MAPENTRYSTR_DEFAULT = CardUtils.getMapEntryStrFromLocaleString(this.lstrDefaultTitle);
    }

    private String getMessageCenterCardKeyPrefix() {
        return this.getCardId() + "#" + DFLEXPANEL;
    }

    private List<Map<String, Object>> getMsgCentreCardOptions() {
        if (this.mMsgCenterCardOptions == null) {
            String userId = RequestContext.get().getUserId();
            this.mMsgCenterCardOptions = MessageCenterServiceHelper.getMsgCenterCardOptions((String)userId);
        }
        return this.mMsgCenterCardOptions;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_ADD});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        String operate = "";
        Object source = evt.getSource();
        if (source instanceof Control) {
            operate = ((Control)source).getKey();
        }
        logger.info("MessageCenterCardPlugin--click--key:" + operate);
        if (BTN_ADD.equals(operate)) {
            this.openCardConfigPage();
        } else if (operate.startsWith(ICON_PREFIX) || operate.startsWith(LABEL_PREFIX)) {
            AppInfo app;
            String id = operate.substring(operate.indexOf("#") + 1);
            id = this.getOriginalOpId(this.getAllMsgCenterOpIds(), id);
            String billFormId = null;
            List<Map<String, Object>> msgCenterCardOptions = this.getMsgCentreCardOptions();
            for (Map<String, Object> map : msgCenterCardOptions) {
                if (!map.get("id").toString().equals(id)) continue;
                billFormId = map.get("billFormId").toString();
                break;
            }
            if ((app = AppMetadataCache.getAppInfo((String)"wftask")) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8df3\u8f6c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"MessageCenterCardPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return;
            }
            HashMap<String, Object> customParam = new HashMap<String, Object>();
            customParam.put("id", id);
            customParam.put("billFormId", billFormId);
            customParam.put("view", this.getView());
            customParam.put("appmainnumber", app.getHomeNum());
            customParam.put("appname", app.getName());
            HashMap<String, Object> customparameters = new HashMap<String, Object>();
            customparameters.put("openPage", id);
            customparameters.put("billFormId", billFormId);
            if ("wf_msg_message".equalsIgnoreCase(billFormId)) {
                customparameters.put("tabType", 2);
            } else {
                customparameters.put("tabType", 1);
            }
            customParam.put("customparameters", customparameters);
            OpenPageUtils.openApp((String)app.getNumber(), null, customParam, (IFormView)this.getView());
            logger.info("MessageCenterCardPlugin--click--end, appNum:" + app.getNumber());
        } else if (operate.startsWith(ICON_DEL_PREFIX)) {
            this.deleteNode(operate);
        }
    }

    private void deleteNode(String id) {
        Map<String, String> cardInfo = this.getCurCardConfigMap();
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        if (configMap == null) {
            return;
        }
        String index = id.substring(ICON_DEL_PREFIX.length());
        configMap.remove(index);
        String config = SerializationUtils.toJsonString(configMap);
        cardInfo.put("config", config);
        this.updateCurCardConfigMap(cardInfo);
        Container c = (Container)this.getView().getControl(PANEL_MSGCARD);
        c.deleteControls(new String[]{this.getMessageCenterCardKeyPrefix() + index});
    }

    private void openCardConfigPage() {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("msbd_card_msgcenterconfig");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(true);
        fsp.setCustomParam("selectMsgType", CardUtils.getDetailConfigMap(this.getCurCardConfigMap()));
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_CARDCONFIG));
        this.getView().showForm(fsp);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLOSECALLBACK_CARDCONFIG.equals(actionId)) {
            Object returnDataObj = e.getReturnData();
            if (returnDataObj == null) {
                return;
            }
            this.refreshMessageCard((List)returnDataObj);
        }
    }

    private void refreshMessageCard(List<Map<String, String>> returnData) {
        Map<String, String> oldDataMap = this.getCurCardConfigMap();
        Map<String, Object> oldConfigMap = CardUtils.getDetailConfigMap(oldDataMap);
        List<String> oldDatas = this.getOldDatas(returnData, oldConfigMap);
        oldDatas.forEach(index -> this.deleteNode(ICON_DEL_PREFIX + index));
        List<Map<String, String>> newDatas = this.getNewDatas(returnData, oldConfigMap);
        newDatas.forEach(this::createNode);
        Map<String, Map<String, String>> updateDatas = this.getUpdateData(returnData, oldConfigMap);
        updateDatas.forEach(this::updateNode);
    }

    private List<Map<String, String>> getNewDatas(List<Map<String, String>> returnData, Map<String, Object> oldConfigMap) {
        if (oldConfigMap == null) {
            return returnData;
        }
        Set oldNodeIds = oldConfigMap.values().stream().map(mapData -> ((Map)mapData).get(NODE_ID).toString()).collect(Collectors.toSet());
        return returnData.stream().filter(data -> !oldNodeIds.contains(data.get(NODE_ID))).collect(Collectors.toList());
    }

    private Map<String, Map<String, String>> getUpdateData(List<Map<String, String>> returnData, Map<String, Object> oldConfigMap) {
        HashMap<String, Map<String, String>> updateNodeMap = new HashMap<String, Map<String, String>>();
        if (oldConfigMap == null) {
            return updateNodeMap;
        }
        HashMap oldNodeMap = new HashMap();
        oldConfigMap.forEach((index, mapData) -> {
            Map oldMap = (Map)mapData;
            String nodeId = (String)oldMap.get(NODE_ID);
            String nodeColor = oldMap.getOrDefault(NODE_COLOR, ORANGLE);
            ArrayList nodeList = (ArrayList)oldNodeMap.get(nodeId);
            if (nodeList == null) {
                nodeList = new ArrayList();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("index", (String)index);
            map.put("color", nodeColor);
            nodeList.add(map);
            oldNodeMap.put(nodeId, nodeList);
        });
        returnData.forEach(data -> {
            String nodeId = (String)data.get(NODE_ID);
            if (oldNodeMap.containsKey(nodeId)) {
                List nodeList = (List)oldNodeMap.get(nodeId);
                nodeList.forEach(map -> {
                    String newColor;
                    String index = (String)map.get("index");
                    String oldColor = (String)map.get("color");
                    if (!oldColor.equals(newColor = (String)data.get(NODE_COLOR))) {
                        updateNodeMap.put(index, (Map<String, String>)data);
                    }
                });
            }
        });
        return updateNodeMap;
    }

    private List<String> getOldDatas(List<Map<String, String>> returnData, Map<String, Object> oldConfigMap) {
        ArrayList<String> list = new ArrayList<String>();
        if (oldConfigMap == null) {
            return list;
        }
        Set nodeIds = returnData.stream().map(data -> (String)data.get(NODE_ID)).collect(Collectors.toSet());
        oldConfigMap.forEach((index, data) -> {
            Map beforeData = (Map)data;
            String nodeId = (String)beforeData.get(NODE_ID);
            if (!nodeIds.contains(nodeId)) {
                list.add((String)index);
            }
        });
        return list;
    }

    private void updateNode(String index, Map<String, String> data) {
        Map<String, String> cardInfo = this.getCurCardConfigMap();
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        if (configMap == null) {
            configMap = new HashMap<String, Object>();
        }
        configMap.put(index, SerializationUtils.toJsonString(data));
        String config = SerializationUtils.toJsonString(configMap);
        cardInfo.put("config", config);
        this.updateCurCardConfigMap(cardInfo);
        HashMap<String, String> controlMetadata = new HashMap<String, String>();
        String color = data.get(NODE_COLOR);
        controlMetadata.put("fc", color);
        String originNodeId = this.getNodeIdByIndex(index).toLowerCase(Locale.ENGLISH);
        this.getView().updateControlMetadata(ICON_PREFIX + index + "#" + originNodeId, controlMetadata);
    }

    private void createNode(Map<String, String> dataMap) {
        int itemCount = 0;
        String count = this.getPageCache().get(ITEM_COUNT);
        if (count != null) {
            itemCount = Integer.parseInt(count.toString());
        }
        ++itemCount;
        Map itemData = null;
        String data = this.getPageCache().get(ITEM_DATA);
        itemData = data == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)data.toString(), Map.class);
        Map<String, String> cardInfo = this.getCurCardConfigMap();
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        if (configMap == null) {
            configMap = new HashMap<String, Object>();
        }
        String index = Integer.toString(itemCount);
        this.createNode(itemData.size() + 1, Integer.parseInt(index), dataMap, this.isDesignMode(), -1);
        itemData.put(index, dataMap);
        this.getPageCache().put(ITEM_DATA, SerializationUtils.toJsonString(itemData));
        this.getPageCache().put(ITEM_COUNT, Integer.toString(itemCount));
        configMap.put(index, SerializationUtils.toJsonString(dataMap));
        String config = SerializationUtils.toJsonString(configMap);
        cardInfo.put("config", config);
        this.updateCurCardConfigMap(cardInfo);
    }

    public void onGetControl(OnGetControlArgs e) {
        Button button;
        super.onGetControl(e);
        String key = e.getKey();
        if (key.startsWith(ICON_DEL_PREFIX)) {
            button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            button.addClickListener((ClickListener)this);
            e.setControl((Control)button);
        }
        if (this.isDesignMode()) {
            return;
        }
        if (key.startsWith(ICON_PREFIX) || key.startsWith(LABEL_PREFIX) || key.equals("vectorap")) {
            button = new Button();
            button.setKey(key);
            button.setView(this.getView());
            if (!key.equals("vectorap")) {
                button.addClickListener((ClickListener)this);
            }
            e.setControl((Control)button);
        }
    }

    private void createNode(int total, int itemCount, Map<String, String> returndata, boolean designMode, int index) {
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey(this.getMessageCenterCardKeyPrefix() + itemCount);
        flexAp.setDirection("column");
        flexAp.setGrow(1);
        flexAp.setJustifyContent(CENTER);
        flexAp.setAlignItems(CENTER);
        flexAp.setAlignContent(CENTER);
        flexAp.setShrink(0);
        flexAp.setOverflow("hidden");
        Style sty = new Style();
        Margin mrg = new Margin();
        mrg.setTop(PX);
        sty.setMargin(mrg);
        flexAp.setStyle(sty);
        if (total > 1) {
            Style style = new Style();
            Border border = new Border();
            border.setLeft("1px_solid_#E2E2E2");
            style.setBorder(border);
            Margin mrge = new Margin();
            mrge.setTop(PX);
            style.setMargin(mrge);
            flexAp.setStyle(style);
        }
        String nodeId = returndata.get(NODE_ID);
        String obj = this.getItem(nodeId);
        String count = obj.substring(0, obj.indexOf("|"));
        String title = obj.substring(obj.indexOf("|") + 1);
        String nodeColor = returndata.get(NODE_COLOR);
        if (nodeColor == null) {
            nodeColor = ORANGLE;
        }
        LabelAp numAp = new LabelAp();
        numAp.setKey(ICON_PREFIX + itemCount + "#" + nodeId);
        numAp.setName(new LocaleString(count));
        numAp.setFontSize(60);
        numAp.setGrow(0);
        numAp.setForeColor(nodeColor);
        numAp.setClickable(true);
        LabelAp numTitle = new LabelAp();
        numTitle.setKey(LABEL_PREFIX + itemCount + "#" + nodeId);
        numTitle.setName(new LocaleString(title));
        numTitle.setTextAlign(CENTER);
        numTitle.setForeColor("#666666");
        numTitle.setFontSize(14);
        numTitle.setClickable(true);
        if (designMode) {
            Style style1 = flexAp.getStyle();
            if (style1 == null) {
                style1 = new Style();
            }
            Margin margin = new Margin();
            margin.setTop("0px");
            style1.setMargin(margin);
            flexAp.setStyle(style1);
            IconAp icondel = new IconAp();
            icondel.setKey(ICON_DEL_PREFIX + itemCount);
            icondel.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664", (String)"MessageCenterCardPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0])));
            icondel.setImageKey("/icons/pc/other/deleteicon_normal.png");
            icondel.setHeight(new LocaleString("19px"));
            icondel.setWidth(new LocaleString("19px"));
            icondel.setZIndex(1);
            icondel.setClickable(true);
            Style style2 = new Style();
            margin = new Margin();
            margin.setBottom("-20px");
            margin.setLeft("50px");
            style2.setMargin(margin);
            icondel.setStyle(style2);
            flexAp.getItems().add(icondel);
        }
        flexAp.getItems().add(numAp);
        flexAp.getItems().add(numTitle);
        Container c = (Container)this.getView().getControl(PANEL_MSGCARD);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(flexAp.createControl());
        if (designMode) {
            c.insertControls(index, list);
            this.setItemIndexPageCache(itemCount + "", nodeId);
            HashMap<String, Boolean> item = new HashMap<String, Boolean>();
            item.put("draggable", true);
            item.put("droppable", true);
            this.getView().updateControlMetadata(this.getMessageCenterCardKeyPrefix() + itemCount, item);
        } else {
            c.addControls(list);
        }
    }

    private void setItemIndexPageCache(String index, String nodeId) {
        String itemIndex = this.getPageCache().get(ITEM_INDEX);
        Map itemIndexMap = StringUtils.isNotEmpty((String)itemIndex) ? (Map)SerializationUtils.fromJsonString((String)itemIndex, Map.class) : new HashMap();
        itemIndexMap.put(index, nodeId);
        this.getPageCache().put(ITEM_INDEX, SerializationUtils.toJsonString(itemIndexMap));
    }

    private String getItem(String nodeId) {
        String count = null;
        String name = null;
        List<Map<String, Object>> msgCenterCardOptions = this.getMsgCentreCardOptions();
        for (Map<String, Object> map : msgCenterCardOptions) {
            if (!map.get("id").toString().equals(nodeId)) continue;
            count = map.get("count").toString();
            name = map.get("name") != null ? map.get("name").toString() : "null";
            break;
        }
        return count + "|" + name;
    }

    @Override
    protected void refreshCard(Map<String, String> allConfigMap) {
        logger.info("MessageCenterCardPlugin--refreshCard begin... cardId:" + this.getCardId());
        super.refreshCard(allConfigMap);
        boolean isDesignMode = this.isDesignMode();
        this.getView().setVisible(Boolean.valueOf(isDesignMode), new String[]{PANEL_ADDBTN});
        if (allConfigMap == null || allConfigMap.size() == 0) {
            return;
        }
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(allConfigMap);
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        HashMap<String, String> itemMap = new HashMap();
        int itemCount = 0;
        int index = 0;
        HashMap<String, HashMap<String, String>> itemData = new HashMap<String, HashMap<String, String>>(16);
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            itemCount = Integer.parseInt(entry.getKey());
            itemMap = (Map)configMap.get(entry.getKey());
            this.createNode(++index, itemCount, itemMap, isDesignMode, -1);
            itemData.put(Integer.toString(itemCount), itemMap);
        }
        logger.info("MessageCenterCardPlugin--refreshCard end...");
        this.getPageCache().put(ITEM_DATA, SerializationUtils.toJsonString(itemData));
        this.getPageCache().put(ITEM_COUNT, Integer.toString(itemCount));
    }

    private List<String> getAllMsgCenterOpIds() {
        if (this.opIdList == null) {
            this.opIdList = new ArrayList<String>(10);
            List<Map<String, Object>> msgCenterCardOptions = this.getMsgCentreCardOptions();
            String id = null;
            for (Map<String, Object> map : msgCenterCardOptions) {
                id = map.get("id").toString();
                this.opIdList.add(id);
            }
        }
        return this.opIdList;
    }

    private String getOriginalOpId(List<String> pOpIdList, String pOpId) {
        for (String originalOpId : pOpIdList) {
            if (!originalOpId.equalsIgnoreCase(pOpId)) continue;
            return originalOpId;
        }
        return pOpId;
    }

    public void customEvent(CustomEventArgs e) {
        String eventName;
        String key = e.getKey();
        if ("refreshFromGridContainer".equals(key)) {
            this.refreshFromGridContainer();
        }
        if ("drop".equals(eventName = e.getEventName())) {
            String data = e.getEventArgs();
            try {
                this.dragMessageCenterCard(data);
            }
            catch (Exception ex) {
                logger.error("dragMessageCenterCard error", (Throwable)ex);
            }
        }
    }

    private void dragMessageCenterCard(String data) throws Exception {
        String[] exchangeData = (String[])SerializationUtils.fromJsonString((String)data, String[].class);
        String key1 = exchangeData[0];
        String key2 = exchangeData[1];
        String cardId = this.getCardId();
        if (!key1.startsWith(cardId) || !key2.startsWith(cardId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u5728\u540c\u4e00\u4e2a\u6d88\u606f\u4e2d\u5fc3\u5361\u7247\u4e2d\u62d6\u62fd\u3002", (String)"MessageCenterCardPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return;
        }
        String key = this.getMessageCenterCardKeyPrefix();
        String index1 = key1.replace(key, "");
        String index2 = key2.replace(key, "");
        Map<String, String> cardInfo = this.getCurCardConfigMap();
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        Object exchangeData1 = configMap.get(index1);
        Object exchangeData2 = configMap.get(index2);
        if (exchangeData1 == null || exchangeData2 == null) {
            logger.info("exchangeData is null");
            return;
        }
        configMap.put(index1, exchangeData2);
        configMap.put(index2, exchangeData1);
        cardInfo.put("config", SerializationUtils.toJsonString(configMap));
        this.updateCurCardConfigMap(cardInfo);
        this.updateMsgCenterCardMetadata((Map)exchangeData1, index2);
        this.updateMsgCenterCardMetadata((Map)exchangeData2, index1);
    }

    private void updateMsgCenterCardMetadata(Map<String, String> nodeData, String index) {
        HashMap<String, Object> colorAndNumData = new HashMap<String, Object>();
        String nodeId = nodeData.get(NODE_ID);
        String nodeColor = nodeData.get(NODE_COLOR);
        String obj = this.getItem(nodeId);
        String count = obj.substring(0, obj.indexOf("|"));
        if (nodeColor == null) {
            nodeColor = ORANGLE;
        }
        colorAndNumData.put("fc", nodeColor);
        colorAndNumData.put("caption", this.getCaption(count));
        String originNodeId = this.getNodeIdByIndex(index).toLowerCase(Locale.ENGLISH);
        this.getView().updateControlMetadata(ICON_PREFIX + index + "#" + originNodeId, colorAndNumData);
        HashMap<String, Map<String, String>> msgTypeCaption = new HashMap<String, Map<String, String>>();
        String title = obj.substring(obj.indexOf("|") + 1);
        msgTypeCaption.put("caption", this.getCaption(title));
        this.getView().updateControlMetadata(LABEL_PREFIX + index + "#" + originNodeId, msgTypeCaption);
    }

    private String getNodeIdByIndex(String index) {
        String itemIndex = this.getPageCache().get(ITEM_INDEX);
        String nodeId = null;
        if (StringUtils.isNotEmpty((String)itemIndex)) {
            Map itemIndexMap = (Map)SerializationUtils.fromJsonString((String)itemIndex, Map.class);
            nodeId = (String)itemIndexMap.get(index);
        }
        if (nodeId == null) {
            logger.info("getNodeIdByIndex nodeId is null");
            nodeId = "";
        }
        return nodeId;
    }

    private Map<String, String> getCaption(String text) {
        HashMap<String, String> caption = new HashMap<String, String>();
        String lang = RequestContext.get().getLang().name();
        caption.put(lang, text);
        return caption;
    }

    private void refreshFromGridContainer() {
        try {
            HashMap prop = new HashMap(1);
            prop.put("items", new ArrayList());
            this.getView().updateControlMetadata(PANEL_MSGCARD, prop);
            this.getPageCache().put(ITEM_DATA, null);
            this.getPageCache().put(ITEM_COUNT, null);
            boolean isDesignMode = this.isDesignMode();
            if (isDesignMode) {
                FlexPanelAp flexAp = new FlexPanelAp();
                flexAp.setKey(PANEL_ADDBTN);
                flexAp.setDirection("column");
                flexAp.setJustifyContent(CENTER);
                flexAp.setGrow(0);
                Style sty = new Style();
                Margin mrg = new Margin();
                mrg.setTop(PX);
                sty.setMargin(mrg);
                flexAp.setStyle(sty);
                IconAp icondel = new IconAp();
                icondel.setKey(BTN_ADD);
                icondel.setName(new LocaleString(ResManager.loadKDString((String)"\u6dfb\u52a0", (String)"MessageCenterCardPlugin_4", (String)"mpscmm-msbd-workbench", (Object[])new Object[0])));
                icondel.setImageKey("/icons/pc/entrance/addicon_48_48.png");
                icondel.setHeight(new LocaleString("48px"));
                icondel.setWidth(new LocaleString("48px"));
                icondel.setRadius("0px");
                flexAp.getItems().add(icondel);
                Container c = (Container)this.getView().getControl(PANEL_MSGCARD);
                ArrayList<Map> list = new ArrayList<Map>();
                list.add(flexAp.createControl());
                c.addControls(list);
            }
            Map<String, String> cardInfo = this.getCurCardConfigMap();
            this.refreshCard(cardInfo);
        }
        catch (Exception exception) {
            logger.error("\u5207\u6362\u9875\u7b7e\u5237\u65b0\u6d88\u606f\u4e2d\u5fc3\u5361\u7247\u51fa\u9519", (Throwable)exception);
        }
    }
}

