/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.TreeService;
import kd.bos.portal.service.impl.TreeServiceImpl;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.workbench.service.PortalMenuService;
import kd.mpscmm.msbd.workbench.util.PortalUsableFuncUtil;

public class SelectBillPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static Log logger = LogFactory.getLog(SelectBillPlugin.class);
    private static final String TREE_CLOUDAPPMENU = "tree_cloudappmenu";
    private static final String TREE_MENU1 = "tree_menu1";
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";
    public static final String CACHE_SEL_APPID = "cache_sel_appId";
    public static final String CACHE_SEL_APPNUM = "cache_sel_appNum";
    public static final String CACHE_SEL_FORMNUM = "cache_sel_formnum";
    public static final String CACHE_SEL_MENUID = "cache_sel_menuid";
    private PortalMenuService menuService;
    private TreeService treeService;

    public void initialize() {
        this.menuService = new PortalMenuService(this.getPageCache());
        this.treeService = new TreeServiceImpl();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
        TreeView treeCloudAppMenu = (TreeView)this.getView().getControl(TREE_CLOUDAPPMENU);
        treeCloudAppMenu.addTreeNodeClickListener((TreeNodeClickListener)this);
        TreeView treeMenu = (TreeView)this.getView().getControl(TREE_MENU1);
        treeMenu.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initCloudAppTree();
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = "";
        Object source = evt.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        switch (key) {
            case "btnok": {
                HashMap<String, String> returnData = new HashMap<String, String>();
                TreeView tvCloudAppMenu = (TreeView)this.getControl(TREE_CLOUDAPPMENU);
                Map appNodeInfo = tvCloudAppMenu.getTreeState().getFocusNode();
                TreeView tvMenu1 = (TreeView)this.getControl(TREE_MENU1);
                Map menu1Info = tvMenu1.getTreeState().getFocusNode();
                if (!this.validateInfo(appNodeInfo, menu1Info)) {
                    return;
                }
                String menuId = null;
                String appId = (String)appNodeInfo.get("id");
                menuId = (String)menu1Info.get("id");
                String appNum = AppMetadataCache.getAppNumberById((String)appId);
                AppMenuInfo menuInfo = AppMetadataCache.getAppMenuInfo((String)appNum, (String)menuId);
                String formNum = menuInfo.getFormId();
                returnData.put(CACHE_SEL_APPID, appId);
                returnData.put(CACHE_SEL_APPNUM, appNum);
                returnData.put(CACHE_SEL_FORMNUM, formNum);
                returnData.put(CACHE_SEL_MENUID, menuId);
                this.getView().returnDataToParent(returnData);
                this.getView().close();
                break;
            }
        }
    }

    private boolean validateInfo(Map<String, Object> appNodeInfo, Map<String, Object> menu1Info) {
        if (appNodeInfo == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u83dc\u5355\u8282\u70b9\uff01", (String)"SelectBillPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        if (menu1Info == null) {
            String parentId = (String)appNodeInfo.get("parentid");
            if (StringUtils.isEmpty((String)parentId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6dfb\u52a0\u4e91\u8282\u70b9\uff0c \u8bf7\u9009\u62e9\u83dc\u5355\u8282\u70b9\u3002", (String)"SelectBillPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                return false;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6dfb\u52a0\u5e94\u7528\u8282\u70b9\uff0c \u8bf7\u9009\u62e9\u83dc\u5355\u8282\u70b9\u3002", (String)"SelectBillPlugin_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        Boolean isParent = (Boolean)menu1Info.get("isParent");
        if (isParent.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u660e\u7ec6\u83dc\u5355\u9879\uff01", (String)"SelectBillPlugin_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void initCloudAppTree() {
        PortalUsableFuncUtil portalUtil = new PortalUsableFuncUtil(logger, this.getView());
        JSONArray resultApps = portalUtil.getUserHasPerApp();
        if (resultApps == null || resultApps.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5e94\u7528\u3002", (String)"SelectBillPlugin_4", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return;
        }
        TreeNode rootNode = this.treeService.buildTree(resultApps);
        TreeView tree = (TreeView)this.getView().getControl(TREE_CLOUDAPPMENU);
        tree.addNodes(rootNode.getChildren());
        this.treeService.clickCurrentAppNode(this.getView(), TREE_CLOUDAPPMENU, rootNode, (TreeNodeClickListener)this);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeView srcTreeView = (TreeView)e.getSource();
        Map focusNodeMap = srcTreeView.getTreeState().getFocusNode();
        String treeKey = srcTreeView.getKey();
        String nodeId = (String)focusNodeMap.get("id");
        if (TREE_CLOUDAPPMENU.equals(treeKey)) {
            this.clearMenu1TreeView();
            String parentId = (String)focusNodeMap.get("parentid");
            if (StringUtils.isEmpty((String)parentId)) {
                return;
            }
            this.initMenuTree(nodeId);
        }
    }

    private void clearMenu1TreeView() {
        TreeView menu1Tv = (TreeView)this.getControl(TREE_MENU1);
        menu1Tv.deleteAllNodes();
    }

    private void initMenuTree(String appId) {
        TreeView menuTree = (TreeView)this.getControl(TREE_MENU1);
        List<TreeNode> menuNodeList = this.getMenuNodeList(appId);
        menuTree.addNodes(menuNodeList);
    }

    private List<TreeNode> getMenuNodeList(String appID) {
        Long userId = RequestContext.get().getCurrUserId();
        List<AppMenuInfo> menus = this.menuService.getHasPermMenuByAppId(userId, appID, false);
        if (menus == null) {
            return null;
        }
        Map<String, List<AppMenuInfo>> menuMap = menus.stream().filter(menu -> !"perm_superusercard".equals(menu.getFormId()) && menu.getParentId() != null).collect(Collectors.groupingBy(AppMenuInfo::getParentId));
        return this.getCurAndSubMenus(appID, appID, menuMap);
    }

    private List<TreeNode> getCurAndSubMenus(String appID, String menuParentId, Map<String, List<AppMenuInfo>> menuMap) {
        List<AppMenuInfo> menuInfos = menuMap.get(menuParentId);
        if (CollectionUtils.isEmpty(menuInfos)) {
            return new ArrayList<TreeNode>();
        }
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(menuInfos.size());
        for (AppMenuInfo menu : menuInfos) {
            String parentId = menu.getParentId();
            String menuId = menu.getId();
            String text = menu.getName().getLocaleValue();
            String formId = menu.getFormId();
            if (StringUtils.isNotEmpty((String)formId) && !this.billCardTypeValid(formId)) continue;
            List<TreeNode> subTreeNode = this.getCurAndSubMenus(appID, menuId, menuMap);
            TreeNode treeNode = new TreeNode(parentId, menuId, text, (Object)formId);
            if (!CollectionUtils.isEmpty(subTreeNode)) {
                treeNode.addChildren(subTreeNode);
            } else if (StringUtils.isEmpty((String)formId)) continue;
            if (appID.equals(parentId)) {
                treeNode.setParentid("");
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private boolean billCardTypeValid(String formId) {
        String modelType;
        try {
            MainEntityType met = EntityMetadataCache.getDataEntityType((String)FormMetadataCache.getFormConfig((String)formId).getEntityTypeId());
            if (!(met instanceof BillEntityType)) {
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
        try {
            modelType = FormMetadataCache.getFormConfig((String)formId).getModelType();
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return false;
        }
        return "base".equals(modelType) || "bill".equals(modelType) || "list".equals(modelType);
    }
}

