/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.operation.RecordSaveFormServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.workbench.enums.CardCountType;
import kd.mpscmm.msbd.workbench.enums.CountErrorCode;
import kd.mpscmm.msbd.workbench.enums.UnitEnum;
import kd.mpscmm.msbd.workbench.formplugin.GridCardPlugin;
import kd.mpscmm.msbd.workbench.pojo.CountRst;
import kd.mpscmm.msbd.workbench.util.BillCountCardUtils;
import kd.mpscmm.msbd.workbench.util.CardUtils;

public class WorkBenchBillStatsListPlugin
extends GridCardPlugin {
    public static final String MPSCMM_MSBD_WORKBENCH = "mpscmm-msbd-workbench";
    public static final String CARDPANEL = "cardpanel";
    public static final String NODE_DATA = "nodeData";
    public static final String MAX_COUNT = "maxCount";
    public static final String CENTER = "center";
    public static final String PX = "-30px";
    public static final String DFLEXPANEL = "dflexpanel";
    public static final String DLABEL = "dlabel";
    public static final String APPNUM = "appnum";
    public static final String INDEX = "index";
    public static final String MENUID = "menuid";
    public static final String IMAGE_LOADING_PREFIX = "imageloading";
    public static final String IMAGE_FRESH_PREFIX = "imagefresh";
    public static final String KEY_REFRESHCOUNT = "refreshlistcount";
    public static final String IMAGE_FRESH_URL = "/images/pc/other/xtfw_loading_32_32.gif";
    private static Log logger = LogFactory.getLog(WorkBenchBillStatsListPlugin.class);
    private static final String CTRLKEY_PREFIX_STATSITEM = "vector_statsitem_";
    public static final String KEY_UNIT_PREFIX = "unit_";

    @Override
    public void initialize() {
        super.initialize();
        this.lstrDefaultTitle = new LocaleString(ResManager.loadKDString((String)"\u5361\u7247\u6807\u9898", (String)"WorkBenchBillStatsListPlugin_0", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
        this.TITLE_DEFAULT = this.lstrDefaultTitle.getLocaleValue();
        this.TITLE_MAPENTRYSTR_DEFAULT = CardUtils.getMapEntryStrFromLocaleString(this.lstrDefaultTitle);
    }

    public void customEvent(CustomEventArgs e) {
        if (e.getKey().equals("refreshFromGridContainer")) {
            Map<String, String> cardInfo = this.getCurCardConfigMap();
            this.reFreshCards(cardInfo, Boolean.FALSE, Boolean.FALSE);
        }
    }

    @Override
    protected void refreshCard(Map<String, String> cardInfo) {
        super.refreshCard(cardInfo);
        Object isFreshClick = this.getView().getFormShowParameter().getCustomParam("isFreshClick");
        if (isFreshClick != null && Boolean.parseBoolean(isFreshClick.toString())) {
            this.reFreshCards(cardInfo, Boolean.TRUE, Boolean.TRUE);
        } else {
            this.reFreshCards(cardInfo, Boolean.FALSE, Boolean.TRUE);
        }
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (this.isDesignMode() && key.startsWith("iconap")) {
            this.newButtonForClick(key, e);
            return;
        }
        if (key.startsWith("iconap") || key.startsWith("icon_del") || key.startsWith("addbtn") || key.equalsIgnoreCase("buttonap") || key.equalsIgnoreCase("vectorap") || key.startsWith(DFLEXPANEL) || key.startsWith(DLABEL) || key.startsWith(KEY_REFRESHCOUNT)) {
            this.newButtonForClick(key, e);
        }
    }

    private void newButtonForClick(String key, OnGetControlArgs e) {
        Button button = new Button();
        button.setKey(key);
        button.setView(this.getView());
        if (!key.equalsIgnoreCase("vectorap")) {
            button.addClickListener((ClickListener)this);
        }
        e.setControl((Control)button);
    }

    @Override
    public void click(EventObject e) {
        String index;
        super.click(e);
        String key = "";
        Object source = e.getSource();
        if (source instanceof Control) {
            key = ((Control)source).getKey();
        }
        if (this.isDesignMode() && (key.startsWith("iconap") || key.startsWith(DLABEL))) {
            String index2 = key.substring("iconap".length());
            this.showConfigForm(index2);
            return;
        }
        if ("addbtn".equals(key)) {
            this.showConfigForm(null);
            return;
        }
        if (key.startsWith(DFLEXPANEL)) {
            index = key.substring(DFLEXPANEL.length());
            key = "iconap" + index;
        } else if (key.startsWith(DLABEL)) {
            index = key.substring(DLABEL.length());
            key = "iconap" + index;
        }
        if (key.startsWith("iconap")) {
            String appId;
            Map nodeData = null;
            String obj = this.getPageCache().get(NODE_DATA);
            nodeData = obj == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)obj.toString(), Map.class);
            String index3 = key.substring("iconap".length());
            Map nodeInfo = (Map)nodeData.get(index3);
            String entityNumber = (String)nodeInfo.get("entityid");
            String schemaId = (String)nodeInfo.get("filterschema");
            String appNum = this.getView().getFormShowParameter().getAppId();
            if (StringUtils.isEmpty((String)appNum) && StringUtils.isEmpty((String)(appNum = (String)nodeInfo.get(APPNUM))) && StringUtils.isNotEmpty((String)(appId = (String)nodeInfo.get("appid")))) {
                appNum = AppMetadataCache.getAppNumberById((String)appId);
            }
            if (StringUtils.isEmpty((String)appNum)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5361\u7247\u7684\u5e94\u7528ID\u4e3a\u7a7a\uff0c\u5efa\u8bae\u91cd\u73b0\u6dfb\u52a0\u5361\u7247", (String)"WorkBenchBillStatsListPlugin_1", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
                return;
            }
            this.openBillListPage(appNum, entityNumber, schemaId, nodeInfo);
        } else if (key.startsWith("icon_del")) {
            this.deleteNode(key);
        }
        if (KEY_REFRESHCOUNT.equals(key)) {
            this.reFreshCards(null, Boolean.TRUE, Boolean.FALSE);
        }
    }

    private void reFreshCards(Map<String, String> cardInfo, Boolean isReFresh, Boolean isRebuildNode) {
        if (cardInfo == null) {
            cardInfo = this.getCurCardConfigMap();
        }
        boolean isDesignMode = this.isDesignMode();
        this.getView().setVisible(Boolean.valueOf(isDesignMode), new String[]{"flexpanelap10"});
        if (cardInfo == null || cardInfo.size() == 0) {
            return;
        }
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        Map itemMap = null;
        int curStatsItemIndex = 0;
        int maxIndex = 0;
        HashMap<String, Map> nodeData = new HashMap<String, Map>(8);
        Iterator<Map.Entry<String, Object>> it = configMap.entrySet().iterator();
        while (it.hasNext()) {
            ++curStatsItemIndex;
            Map.Entry<String, Object> entry = it.next();
            int statsItemIndex = Integer.parseInt(entry.getKey());
            if (maxIndex < statsItemIndex) {
                maxIndex = statsItemIndex;
            }
            itemMap = (Map)entry.getValue();
            if (isRebuildNode.booleanValue()) {
                this.createNode(curStatsItemIndex, statsItemIndex, itemMap, isDesignMode);
            }
            nodeData.put(Integer.toString(statsItemIndex), itemMap);
            this.setLoadingImage(String.valueOf(statsItemIndex), Boolean.TRUE);
            this.sendActionReFresh(String.valueOf(statsItemIndex), isReFresh);
        }
        this.getPageCache().put(NODE_DATA, SerializationUtils.toJsonString(nodeData));
        this.getPageCache().put(MAX_COUNT, Integer.toString(maxIndex));
    }

    private void setLoadingImage(String index, Boolean isVisible) {
        HashMap<String, Boolean> controlMetadata = new HashMap<String, Boolean>();
        controlMetadata.put("vi", isVisible);
        this.getView().updateControlMetadata(IMAGE_LOADING_PREFIX + index, controlMetadata);
        HashMap<String, Boolean> numMap = new HashMap<String, Boolean>();
        numMap.put("vi", isVisible == false);
        this.getView().updateControlMetadata("iconap" + index, numMap);
        this.getView().updateControlMetadata(KEY_UNIT_PREFIX + index, numMap);
    }

    private void showConfigForm(String index) {
        FormShowParameter fsp = new FormShowParameter();
        if (StringUtils.isNotEmpty((String)index)) {
            Map<String, String> allConfigMap = this.getCurCardConfigMap();
            Map<String, Object> configMap = CardUtils.getDetailConfigMap(allConfigMap);
            String showConfigMapStr = SerializationUtils.toJsonString((Object)configMap.get(index));
            fsp.setCustomParam("configJson", (Object)showConfigMapStr);
            fsp.setCustomParam("edit", (Object)"true");
            fsp.setCustomParam(INDEX, (Object)index);
        }
        fsp.setFormId("msbd_card_billstatsconfig");
        fsp.setCustomParam("source", (Object)"billstatslist");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "Card_Config"));
        this.getView().showForm(fsp);
    }

    private void deleteNode(String id) {
        Map<String, String> cardInfo = this.getCurCardConfigMap();
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
        if (configMap == null) {
            return;
        }
        Map nodeData = null;
        String obj = this.getPageCache().get(NODE_DATA);
        nodeData = obj == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)obj.toString(), Map.class);
        String index = id.substring("icon_del".length());
        nodeData.remove(index);
        this.getPageCache().put(NODE_DATA, SerializationUtils.toJsonString(nodeData));
        configMap.remove(index);
        String config = SerializationUtils.toJsonString(configMap);
        cardInfo.put("config", config);
        this.updateCurCardConfigMap(cardInfo);
        index = id.substring("icon_del".length());
        Container c = (Container)this.getView().getControl(CARDPANEL);
        c.deleteControls(new String[]{DFLEXPANEL + index});
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if (e.getActionId().equals("Card_Config")) {
            Map retData = (Map)e.getReturnData();
            if (retData == null) {
                return;
            }
            Map<String, String> cardInfo = this.getCurCardConfigMap();
            Map<String, Object> configMap = CardUtils.getDetailConfigMap(cardInfo);
            if (configMap == null) {
                configMap = new HashMap<String, Object>();
            }
            int maxCount = 0;
            String obj = this.getPageCache().get(MAX_COUNT);
            if (obj != null) {
                maxCount = Integer.parseInt(obj.toString());
            }
            Map nodeData = null;
            obj = this.getPageCache().get(NODE_DATA);
            nodeData = obj == null ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)obj.toString(), Map.class);
            int index = 0;
            if ("true".equals(retData.get("edit"))) {
                String indexStr = (String)retData.get(INDEX);
                index = Integer.parseInt(indexStr);
                retData.remove("edit");
                retData.remove(INDEX);
                Map cardConfig = (Map)configMap.get(indexStr);
                if (StringUtils.isEmpty((String)((String)retData.get(APPNUM)))) {
                    String appnum = (String)cardConfig.get(APPNUM);
                    retData.put(APPNUM, appnum);
                }
                if (StringUtils.isEmpty((String)((String)retData.get(MENUID)))) {
                    String menuid = (String)cardConfig.get(MENUID);
                    retData.put(MENUID, menuid);
                }
                this.updateCard(indexStr, retData, Boolean.FALSE);
                this.updateNumTitle(DLABEL + indexStr, CardUtils.getLocaleStrFromMapEntryStr((String)retData.get("numtitle")));
            } else {
                this.createNode(nodeData.size() + 1, ++maxCount, retData, this.isDesignMode());
                index = maxCount;
                this.getPageCache().put(MAX_COUNT, Integer.toString(maxCount));
                this.sendActionReFresh(String.valueOf(maxCount), Boolean.TRUE);
            }
            nodeData.put(Integer.toString(index), retData);
            this.getPageCache().put(NODE_DATA, SerializationUtils.toJsonString(nodeData));
            configMap.put(Integer.toString(index), SerializationUtils.toJsonString((Object)retData));
            String config = SerializationUtils.toJsonString(configMap);
            cardInfo.put("config", config);
            this.updateCurCardConfigMap(cardInfo);
        }
    }

    private void updateNumTitle(String key, LocaleString title) {
        HashMap<String, LocaleString> data = new HashMap<String, LocaleString>();
        data.put("caption", title);
        this.getView().updateControlMetadata(key, data);
    }

    private void createNode(int index, int maxCount, Map<String, String> nodeInfo, boolean isDesignMode) {
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey(DFLEXPANEL + maxCount);
        flexAp.setDirection("column");
        flexAp.setGrow(1);
        flexAp.setJustifyContent(CENTER);
        flexAp.setAlignItems(CENTER);
        flexAp.setAlignContent(CENTER);
        flexAp.setShrink(0);
        flexAp.setOverflow("hidden");
        Style sty = new Style();
        Margin mrg = new Margin();
        mrg.setTop(PX);
        sty.setMargin(mrg);
        mrg.setRight("15px");
        Padding padding = new Padding();
        padding.setTop("16px");
        sty.setPadding(padding);
        flexAp.setStyle(sty);
        FlexPanelAp subFlexAp = new FlexPanelAp();
        subFlexAp.setKey("dsubflexpanel" + maxCount);
        subFlexAp.setJustifyContent("space-between");
        subFlexAp.setGrow(0);
        subFlexAp.setAlignContent(CENTER);
        subFlexAp.setAlignItems(CENTER);
        if (index > 1) {
            Style style = new Style();
            Border border = new Border();
            border.setLeft("1px_solid_#E2E2E2");
            style.setBorder(border);
            Margin mrge = new Margin();
            mrge.setTop(PX);
            mrge.setRight("15px");
            style.setMargin(mrge);
            Padding padding1 = new Padding();
            padding1.setTop("16px");
            style.setPadding(padding1);
            flexAp.setStyle(style);
        }
        ImageAp imageAp = new ImageAp();
        String imageKey = IMAGE_LOADING_PREFIX + maxCount;
        imageAp.setKey(imageKey);
        imageAp.setImageKey(IMAGE_FRESH_URL);
        imageAp.setHeight(new LocaleString("32px"));
        imageAp.setWidth(new LocaleString("32px"));
        imageAp.setGrow(0);
        imageAp.setClickable(false);
        imageAp.setIndex(0);
        subFlexAp.getItems().add(imageAp);
        LabelAp numAp = new LabelAp();
        String iconKey = "iconap" + maxCount;
        numAp.setKey(iconKey);
        String statsValue = this.getPageCache().get(iconKey);
        if (StringUtils.isEmpty((String)statsValue)) {
            numAp.setName(new LocaleString("--"));
            numAp.setFontSize(60);
            numAp.setForeColor("#bbbbbb");
        } else {
            numAp.setName(new LocaleString(statsValue));
            numAp.setFontSize(60);
            String forecolor = this.getPageCache().get(iconKey + "_forecolor");
            numAp.setForeColor("0".equals(statsValue) ? "#bbbbbb" : forecolor);
        }
        numAp.setGrow(0);
        numAp.setClickable(true);
        numAp.setIndex(0);
        subFlexAp.getItems().add(numAp);
        LabelAp unitAp = new LabelAp();
        String unitKey = KEY_UNIT_PREFIX + maxCount;
        unitAp.setKey(unitKey);
        unitAp.setName(new LocaleString("--"));
        unitAp.setFontSize(16);
        unitAp.setForeColor("#ABABAB");
        unitAp.setTextAlign(CENTER);
        unitAp.setFontWeight("bold");
        unitAp.setGrow(0);
        unitAp.setClickable(true);
        unitAp.setIndex(0);
        Style styleUnit = unitAp.getStyle();
        if (styleUnit == null) {
            styleUnit = new Style();
        }
        Margin marginUnit = new Margin();
        marginUnit.setLeft("4px");
        marginUnit.setTop("20px");
        styleUnit.setMargin(marginUnit);
        unitAp.setStyle(styleUnit);
        subFlexAp.getItems().add(unitAp);
        if (isDesignMode) {
            Style style1 = flexAp.getStyle();
            if (style1 == null) {
                style1 = new Style();
            }
            Margin margin = new Margin();
            margin.setTop("0px");
            style1.setMargin(margin);
            flexAp.setStyle(style1);
            IconAp icondel = new IconAp();
            icondel.setKey("icon_del" + maxCount);
            icondel.setName(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664", (String)"WorkBenchBillStatsListPlugin_2", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0])));
            icondel.setImageKey("/icons/pc/other/deleteicon_normal.png");
            icondel.setHeight(new LocaleString("19px"));
            icondel.setWidth(new LocaleString("19px"));
            icondel.setZIndex(1);
            Style style2 = new Style();
            margin = new Margin();
            margin.setTop("-50px");
            style2.setMargin(margin);
            icondel.setStyle(style2);
            subFlexAp.getItems().add(icondel);
        }
        LabelAp numTitle = new LabelAp();
        numTitle.setKey(DLABEL + maxCount);
        String numTitleMapEntryStr = nodeInfo.get("numtitle");
        LocaleString lsNumTitle = CardUtils.getLocaleStrFromMapEntryStr(numTitleMapEntryStr);
        if (lsNumTitle == null) {
            numTitle.setName(new LocaleString(numTitleMapEntryStr));
        } else {
            numTitle.setName(lsNumTitle);
        }
        numTitle.setTextAlign(CENTER);
        numTitle.setForeColor("#666666");
        numTitle.setFontSize(14);
        numTitle.setClickable(true);
        flexAp.getItems().add(subFlexAp);
        flexAp.getItems().add(numTitle);
        if (!isDesignMode) {
            flexAp.setClickable(true);
        }
        Container c = (Container)this.getView().getControl(CARDPANEL);
        ArrayList<Map> list = new ArrayList<Map>();
        list.add(flexAp.createControl());
        if (isDesignMode) {
            c.insertControls(-1, list);
        } else {
            c.addControls(list);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("fs", "var(--kd-cq-secondary-font-size, 14px)");
        this.getView().updateControlMetadata(DLABEL + maxCount, map);
    }

    public void openBillListPage(String appNum, String entityNumber, String schemaId, Map<String, String> nodeInfo) {
        AppMenuInfo menu;
        AppInfo appInfo = null;
        try {
            appInfo = AppMetadataCache.getAppInfo((String)appNum);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5e94\u7528{0}\u83b7\u53d6\u4e0d\u5230\u8fd0\u884c\u671f\u4fe1\u606f\uff0c\u53ef\u80fd\u5e94\u7528\u672a\u542f\u7528\u6216\u4e0d\u53ef\u89c1\u3002", (String)"WorkBenchBillStatsListPlugin_3", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[]{appNum}));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        JSONObject parameter = new JSONObject();
        String menuId = nodeInfo.get(MENUID);
        if (StringUtils.isNotEmpty((String)menuId) && Objects.nonNull(menu = AppMetadataCache.getAppMenuInfo((String)appNum, (String)menuId))) {
            map.put("menuname", menu.getName());
            map.put("openType", menu.getOpenType());
            map.put("permItem", menu.getPermission());
            if (Objects.nonNull(menu.getParams())) {
                JSONObject menuParamJson = JSONObject.parseObject((String)menu.getParams());
                parameter.putAll((Map)menuParamJson);
            }
        }
        map.put("view", this.getView());
        map.put("appname", appInfo.getName().getLocaleValue());
        String formNum = appInfo.getHomeNum();
        map.put("appmainnumber", formNum);
        map.put("formnumber", entityNumber);
        map.put("parametertype", "ListShowParameter");
        parameter.put("filterSchemeId", (Object)schemaId);
        map.put("parameter", parameter);
        if (StringUtils.isEmpty((String)menuId)) {
            menuId = CardUtils.findMenuId(appNum, entityNumber);
            if (StringUtils.isEmpty((String)menuId)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5361\u7247\u627e\u4e0d\u5230\u83dc\u5355ID\u7684\u4fe1\u606f\uff0c\u5efa\u8bae\u91cd\u65b0\u914d\u7f6e\u5361\u7247", (String)"WorkBenchBillStatsListPlugin_4", (String)MPSCMM_MSBD_WORKBENCH, (Object[])new Object[0]));
                return;
            }
            boolean isAllUserApp = appInfo.isAllUserApp();
            if (isAllUserApp) {
                parameter.put("IsolationOrg", (Object)"false");
            }
        } else {
            boolean isolationOrg = CardUtils.getIsolationOrg(appNum, menuId);
            if (!isolationOrg) {
                parameter.put("IsolationOrg", (Object)"false");
            }
        }
        OpenPageUtils.openAppForCardCount((String)appNum, (String)menuId, map, (IFormView)this.getView());
    }

    public void clientCallBack(ClientCallBackEvent e) {
        super.clientCallBack(e);
        if (e == null || StringUtils.isEmpty((String)e.getName())) {
            return;
        }
        String[] names = e.getName().split("_");
        String eventName = names[0];
        Boolean isReFresh = Boolean.parseBoolean(names[1]);
        String curStatsItemIndex = eventName;
        Map<String, Object> configMap = CardUtils.getDetailConfigMap(this.getCurCardConfigMap());
        if (configMap == null || configMap.size() == 0) {
            return;
        }
        Map itemMap = null;
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            String statsItemIndex = entry.getKey();
            if (!statsItemIndex.equals(curStatsItemIndex)) continue;
            itemMap = (Map)entry.getValue();
            RecordSaveFormServiceHelper.recordForm((String)((String)itemMap.get("entityid")));
            this.updateCard(eventName, itemMap, isReFresh);
            break;
        }
    }

    private void updateCard(String index, Map<String, String> itemMap, Boolean isReFresh) {
        String entityId;
        String dataType = itemMap.get("datatype");
        BillCountCardUtils billCountCardUtils = new BillCountCardUtils(this.getView(), this.getPageCache(), this.getModel(), logger);
        CountRst countRst = StringUtils.isEmpty((String)dataType) || "count".equals(dataType) ? billCountCardUtils.getBillCountWithCache(itemMap, isReFresh, CardCountType.COUNT) : billCountCardUtils.getBillCountWithCache(itemMap, isReFresh, CardCountType.SUM);
        String number = countRst.getCount();
        String unit = itemMap.get("unit");
        String scale = itemMap.get("scale");
        if (StringUtils.isNotEmpty((String)countRst.getTimeStamp()) && this.expireTimeUpdate(entityId = itemMap.get("entityid"), index, countRst.getTimeStamp()).booleanValue()) {
            return;
        }
        BigDecimal billCountBigDecimal = null;
        try {
            billCountBigDecimal = new BigDecimal(number);
        }
        catch (Exception exception) {
            logger.info("\u5355\u636e\u7edf\u8ba1\u8fd4\u56de\u9519\u8bef\uff0c\u8f6c\u6362\u5931\u8d25\uff0c\u7ed3\u679c\uff1a" + number);
        }
        String color = itemMap.get("numcolor");
        boolean isEnd = false;
        if (billCountBigDecimal == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_UNIT_PREFIX + index});
            isEnd = true;
        }
        String errorCode = countRst.getErrorCode();
        if (billCountBigDecimal != null && BigDecimal.ZERO.compareTo(billCountBigDecimal) == 0 || CountErrorCode.SCHEMEDELETE.name().equals(errorCode)) {
            color = "#bbbbbb";
            number = CountErrorCode.SCHEMEDELETE.name().equals(errorCode) ? countRst.getCount() : "0";
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_UNIT_PREFIX + index});
            isEnd = true;
        }
        if (!isEnd && billCountBigDecimal != null && billCountBigDecimal.compareTo(BigDecimal.ZERO) != 0) {
            if (StringUtils.isNotEmpty((String)dataType) && dataType.equals("sum")) {
                if (StringUtils.isNotEmpty((String)unit) && !"1".equals(unit)) {
                    billCountBigDecimal = billCountBigDecimal.divide(new BigDecimal(unit));
                    String unitName = UnitEnum.getName(Integer.valueOf(unit));
                    this.getView().setVisible(Boolean.TRUE, new String[]{KEY_UNIT_PREFIX + index});
                    HashMap<String, LocaleString> propUnit = new HashMap<String, LocaleString>();
                    propUnit.put("caption", new LocaleString(unitName));
                    this.getView().updateControlMetadata(KEY_UNIT_PREFIX + index, propUnit);
                } else {
                    this.getView().setVisible(Boolean.FALSE, new String[]{KEY_UNIT_PREFIX + index});
                }
                if (StringUtils.isNotEmpty((String)scale)) {
                    DecimalFormat df = new DecimalFormat(",##" + scale);
                    number = df.format(billCountBigDecimal);
                }
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{KEY_UNIT_PREFIX + index});
            }
        }
        HashMap<String, Object> controlMetadata = new HashMap<String, Object>();
        if (CountErrorCode.SCHEMEDELETE.name().equals(errorCode)) {
            controlMetadata.put("fs", 18);
        } else {
            controlMetadata.put("fs", 60);
        }
        controlMetadata.put("caption", new LocaleString(number));
        controlMetadata.put("fc", color);
        this.getView().updateControlMetadata("iconap" + index, controlMetadata);
        this.setLoadingImage(index, Boolean.FALSE);
    }

    private Boolean expireTimeUpdate(String entityId, String index, String updateTime) {
        String useCache = RecordSaveFormServiceHelper.getProptyByTenant((String)"portal.card.use.cache.enable");
        if (StringUtils.isNotEmpty((String)useCache) && !Boolean.parseBoolean(useCache)) {
            return false;
        }
        String updateTimeRedisCache = RecordSaveFormServiceHelper.getFormUpdateTimeCache((String)entityId);
        if (StringUtils.isNotEmpty((String)updateTime) && StringUtils.isNotEmpty((String)updateTimeRedisCache) && Long.parseLong(updateTime) < Long.parseLong(updateTimeRedisCache)) {
            this.sendActionReFresh(index, Boolean.TRUE);
            return true;
        }
        return false;
    }

    private void sendActionReFresh(String name, Boolean isFresh) {
        if (isFresh.booleanValue()) {
            this.setLoadingImage(name, Boolean.TRUE);
        }
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("name", name + "_" + isFresh);
        param.put("duration", 0);
        param.put("async", true);
        proxy.addAction("addClientCallBack", param);
    }

    @Override
    public void doFilterCardConfig(Map<String, String> configMap, Set<String> hasPermMenuIds) {
        Map<String, Object> billConfigInfo = CardUtils.getDetailConfigMap(configMap);
        if (billConfigInfo == null) {
            return;
        }
        Iterator<Map.Entry<String, Object>> configIter = billConfigInfo.entrySet().iterator();
        while (configIter.hasNext()) {
            Map.Entry<String, Object> valueObj = configIter.next();
            Map itemMap = (Map)valueObj.getValue();
            String billStatsMenuId = (String)itemMap.get(MENUID);
            if (hasPermMenuIds.contains(billStatsMenuId)) continue;
            configIter.remove();
        }
    }
}

