/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;

public class OpServiceBasePlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    private static final String UPDATE_OP_FIELD_KEY = "updopfieldno";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"opname"});
        BasedataEdit BOTPRule = (BasedataEdit)this.getControl("botprule");
        BOTPRule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit printTpl = (BasedataEdit)this.getControl("printtemplate");
        printTpl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initPrintLangCombo();
        IDataModel model = this.getModel();
        String actType = (String)model.getValue("actiontype");
        this.handleVisible(actType);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object obj = e.getChangeSet()[0].getNewValue();
        if ("actiontype".equals(key)) {
            this.handleVisible((String)obj);
            this.clearChangeVal((String)obj);
        } else if ("opname".equals(key)) {
            if (StringUtils.isBlank((CharSequence)((String)obj))) {
                this.getModel().setValue("op", (Object)"");
            }
        } else if ("srcobj".equals(key)) {
            this.getModel().setValue("botprule", null);
        } else if ("isasync".equals(key)) {
            Boolean isAsync = (Boolean)this.getModel().getValue("isasync");
            this.getView().setEnable(isAsync, new String[]{"pushstatus"});
            this.getModel().setValue("pushstatus", (Object)"save");
        }
    }

    private void clearChangeVal(String actType) {
        if (StringUtils.isBlank((CharSequence)actType)) {
            return;
        }
        switch (actType) {
            case "PUSH": {
                this.clearOpService();
                break;
            }
            case "BIZOP": {
                this.clearBotpService();
                break;
            }
            case "SERVICE": {
                this.clearPushAndOP();
                break;
            }
            case "PRINT": {
                this.clearNoPrint();
                break;
            }
            case "LOAD": {
                this.clearNoLoad();
                break;
            }
            case "CERBILL": {
                this.clearNoCreBill();
                break;
            }
        }
    }

    private void handleVisible(String actType) {
        IFormView view = this.getView();
        if (StringUtils.isBlank((CharSequence)actType)) {
            return;
        }
        switch (actType) {
            case "PUSH": {
                this.setPushVisible(view);
                break;
            }
            case "BIZOP": {
                this.setBizOpVisible(view);
                break;
            }
            case "SERVICE": {
                this.setServiceVisible(view);
                break;
            }
            case "PRINT": {
                this.setPrintVisible(view);
                break;
            }
            case "LOAD": {
                this.setLoadVisible(view);
                break;
            }
            case "CERBILL": {
                this.setCreBillVisible(view);
                break;
            }
        }
        boolean isAsync = (Boolean)this.getModel().getValue("isasync");
        if ("CERBILL".equals(actType) && isAsync) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"pushstatus"});
        }
    }

    private void clearNoPrint() {
        IDataModel model = this.getModel();
        model.setValue("opname", (Object)"");
        model.setValue("op", (Object)"");
        model.setValue("mservice", null);
        model.setValue("botprule", null);
        model.setValue("srcobj", null);
        model.setValue("desc", null);
        model.setValue("isasync", (Object)false);
        model.setValue("pushstatus", (Object)"save");
    }

    private void setPrintVisible(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"printtemplate"});
        view.setVisible(Boolean.TRUE, new String[]{"printlang"});
        view.setVisible(Boolean.TRUE, new String[]{"srcobj"});
        view.setVisible(Boolean.FALSE, new String[]{"botprule"});
        view.setVisible(Boolean.FALSE, new String[]{"pushstatus"});
        view.setVisible(Boolean.FALSE, new String[]{"opname"});
        view.setVisible(Boolean.FALSE, new String[]{"mservice"});
        view.setVisible(Boolean.FALSE, new String[]{"isasync"});
    }

    private void clearPushAndOP() {
        IDataModel model = this.getModel();
        model.setValue("opname", (Object)"");
        model.setValue("op", (Object)"");
        model.setValue("botprule", null);
        model.setValue("srcobj", null);
        model.setValue("desc", null);
        model.setValue("pushstatus", (Object)"save");
        model.setValue("printtemplate", null);
        model.setValue("isasync", (Object)true);
        model.setValue("printlang", (Object)"");
    }

    private void clearBotpService() {
        IDataModel model = this.getModel();
        model.setValue("mservice", null);
        model.setValue("botprule", null);
        model.setValue("srcobj", null);
        model.setValue("desc", null);
        model.setValue("pushstatus", (Object)"save");
        model.setValue("printtemplate", null);
        model.setValue("isasync", (Object)true);
        model.setValue("printlang", (Object)"");
    }

    private void clearOpService() {
        IDataModel model = this.getModel();
        model.setValue("opname", (Object)"");
        model.setValue("op", (Object)"");
        model.setValue("srcobj", null);
        model.setValue("desc", null);
        model.setValue("mservice", null);
        model.setValue("printtemplate", null);
        model.setValue("printlang", (Object)"");
        model.setValue("pushstatus", (Object)"save");
        model.setValue("isasync", (Object)true);
    }

    private void clearNoLoad() {
        IDataModel model = this.getModel();
        model.setValue("opname", (Object)"");
        model.setValue("op", (Object)"");
        model.setValue("botprule", null);
        model.setValue("srcobj", null);
        model.setValue("desc", null);
        model.setValue("mservice", null);
        model.setValue("printtemplate", null);
        model.setValue("pushstatus", (Object)"save");
        model.setValue("printlang", (Object)"");
        model.setValue("isasync", (Object)false);
    }

    private void clearNoCreBill() {
        IDataModel model = this.getModel();
        model.setValue("opname", (Object)"");
        model.setValue("op", (Object)"");
        model.setValue("botprule", null);
        model.setValue("srcobj", null);
        model.setValue("desc", null);
        model.setValue("mservice", null);
        model.setValue("printtemplate", null);
        model.setValue("pushstatus", (Object)"save");
        model.setValue("printlang", (Object)"");
        model.setValue("isasync", (Object)true);
    }

    private void setServiceVisible(IFormView view) {
        view.setVisible(Boolean.FALSE, new String[]{"srcobj"});
        view.setVisible(Boolean.FALSE, new String[]{"botprule"});
        view.setVisible(Boolean.FALSE, new String[]{"pushstatus"});
        view.setVisible(Boolean.FALSE, new String[]{"opname"});
        view.setVisible(Boolean.TRUE, new String[]{"mservice"});
        view.setVisible(Boolean.FALSE, new String[]{"printtemplate"});
        view.setVisible(Boolean.FALSE, new String[]{"printlang"});
        view.setVisible(Boolean.FALSE, new String[]{"isasync"});
    }

    private void setBizOpVisible(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"srcobj"});
        view.setVisible(Boolean.FALSE, new String[]{"botprule"});
        view.setVisible(Boolean.FALSE, new String[]{"pushstatus"});
        view.setVisible(Boolean.TRUE, new String[]{"opname"});
        view.setVisible(Boolean.FALSE, new String[]{"mservice"});
        view.setVisible(Boolean.FALSE, new String[]{"printtemplate"});
        view.setVisible(Boolean.FALSE, new String[]{"printlang"});
        view.setVisible(Boolean.FALSE, new String[]{"isasync"});
    }

    private void setPushVisible(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"srcobj"});
        view.setVisible(Boolean.TRUE, new String[]{"botprule"});
        view.setVisible(Boolean.TRUE, new String[]{"pushstatus"});
        view.setVisible(Boolean.TRUE, new String[]{"isasync"});
        view.setVisible(Boolean.FALSE, new String[]{"opname"});
        view.setVisible(Boolean.FALSE, new String[]{"mservice"});
        view.setVisible(Boolean.FALSE, new String[]{"printtemplate"});
        view.setVisible(Boolean.FALSE, new String[]{"printlang"});
    }

    private void setLoadVisible(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"srcobj"});
        view.setVisible(Boolean.FALSE, new String[]{"botprule"});
        view.setVisible(Boolean.FALSE, new String[]{"pushstatus"});
        view.setVisible(Boolean.FALSE, new String[]{"opname"});
        view.setVisible(Boolean.FALSE, new String[]{"mservice"});
        view.setVisible(Boolean.FALSE, new String[]{"printtemplate"});
        view.setVisible(Boolean.FALSE, new String[]{"printlang"});
        view.setVisible(Boolean.FALSE, new String[]{"isasync"});
    }

    private void setCreBillVisible(IFormView view) {
        view.setVisible(Boolean.TRUE, new String[]{"srcobj"});
        view.setVisible(Boolean.FALSE, new String[]{"botprule"});
        view.setVisible(Boolean.TRUE, new String[]{"pushstatus"});
        view.setVisible(Boolean.FALSE, new String[]{"opname"});
        view.setVisible(Boolean.FALSE, new String[]{"mservice"});
        view.setVisible(Boolean.FALSE, new String[]{"printtemplate"});
        view.setVisible(Boolean.FALSE, new String[]{"printlang"});
        view.setVisible(Boolean.TRUE, new String[]{"isasync"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("opname".equals(key)) {
            this.showOpForm();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey;
        switch (fieldKey = e.getProperty().getName()) {
            case "botprule": {
                this.beforeBotpSelect(e);
                break;
            }
            case "printtemplate": {
                this.beforePrintSelect(e);
                break;
            }
        }
    }

    private void beforePrintSelect(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject srcObj = (DynamicObject)model.getValue("srcobj");
        if (srcObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5b9e\u4f53\u3002", (String)"OpServiceBasePlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("billformid", "=", srcObj.getPkValue()));
    }

    private void beforeBotpSelect(BeforeF7SelectEvent e) {
        IDataModel model = this.getModel();
        DynamicObject srcObj = (DynamicObject)model.getValue("srcobj");
        if (srcObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5b9e\u4f53\u3002", (String)"OpServiceBasePlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(new QFilter("enabled", "=", (Object)Boolean.TRUE));
        qFilters.add(new QFilter("sourceentitynumber", "=", srcObj.getPkValue()));
    }

    public void showOpForm() {
        IDataModel model = this.getModel();
        CloseCallBack closeBack = new CloseCallBack((IFormPlugin)this, UPDATE_OP_FIELD_KEY);
        DynamicObject srcObj = (DynamicObject)model.getValue("srcobj");
        if (srcObj == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u5b9e\u4f53\u3002", (String)"OpServiceBasePlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            return;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("formId", srcObj.getPkValue());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msbd_workbench_bizop");
        showParameter.setCustomParam("params", (Object)jsonObject);
        showParameter.setCloseCallBack(closeBack);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (UPDATE_OP_FIELD_KEY.equals(actionId)) {
            IDataModel model = this.getModel();
            String returnData = (String)e.getReturnData();
            JSONObject info = JSON.parseObject((String)returnData);
            if (info == null || info.isEmpty()) {
                return;
            }
            model.setValue("op", (Object)info.getString("op"));
            model.setValue("opname", (Object)info.getString("opname"));
        }
    }

    private void initPrintLangCombo() {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(10);
        ComboEdit printLangCombo = (ComboEdit)this.getView().getControl("printlang");
        IInteService iInteService = (IInteService)ServiceFactory.getService(IInteService.class);
        List enableLangList = iInteService.getLocalLangForPrint("1");
        for (EnabledLang lang : enableLangList) {
            ComboItem item = new ComboItem();
            item.setValue(lang.getNumber());
            item.setCaption(new LocaleString(lang.getName()));
            comboItems.add(item);
        }
        printLangCombo.setComboItems(comboItems);
    }
}

