/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.formplugin.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;

public class TaskSubjectConfigFormPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String CACHE_COMBO_ITEMS_MAP = "comboItemsMap";
    private static final String BILL_FIELD = "billfield";
    private static final String CONST_KEY = "const";
    private static final String CODING_EXAMPLE = "codingexample";
    private static final String SPLIT_SIGN = "splitsign";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button cancel = (Button)this.getControl("btncancel");
        cancel.addClickListener((ClickListener)this);
        Button ok = (Button)this.getControl("btnok");
        ok.addClickListener((ClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IFormView view = this.getView();
        String entityNumber = (String)view.getFormShowParameter().getCustomParam("entryNumber");
        if (StringUtils.isEmpty((String)entityNumber)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u672a\u7ed1\u5b9a\u6765\u6e90\u5355\u636e\u3002", (String)"TaskSubjectConfigFormPlugin_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            view.setStatus(OperationStatus.VIEW);
            return;
        }
        Boolean genTaskByEntry = (Boolean)view.getFormShowParameter().getCustomParam("gentaskbyentry");
        if (genTaskByEntry == null) {
            genTaskByEntry = Boolean.FALSE;
        }
        String entryKey = (String)view.getFormShowParameter().getCustomParam("entrykey");
        List<ComboItem> comboItems = this.createComboItems(entityNumber, genTaskByEntry, entryKey);
        ComboEdit comboEdit = (ComboEdit)this.getControl(BILL_FIELD);
        comboEdit.setComboItems(comboItems);
        this.buildEntryData();
    }

    private void buildEntryData() {
        String taskSubjectConf = (String)this.getView().getFormShowParameter().getCustomParam("tasksubjectcfg");
        if (StringUtils.isNotEmpty((String)taskSubjectConf)) {
            Map taskSubjectConfMap = (Map)SerializationUtils.fromJsonString((String)taskSubjectConf, Map.class);
            List taskSubjectConfList = taskSubjectConfMap.getOrDefault("config", Collections.emptyList());
            String splitSign = taskSubjectConfMap.getOrDefault("split", "");
            this.getModel().setValue(SPLIT_SIGN, (Object)splitSign);
            this.getModel().beginInit();
            for (Map dataMap : taskSubjectConfList) {
                int newEntryRow = this.getModel().createNewEntryRow(ENTRY_ENTITY);
                this.getModel().setValue(BILL_FIELD, dataMap.get(BILL_FIELD), newEntryRow);
                this.getModel().setValue(CONST_KEY, dataMap.get(CONST_KEY), newEntryRow);
            }
            this.getModel().endInit();
            this.getView().updateView(ENTRY_ENTITY);
            this.getView().updateView(SPLIT_SIGN);
            this.setCodingExample();
        }
    }

    private List<ComboItem> createComboItems(String entityNumber, boolean genTaskByEntry, String entryKey) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allEntities = entityType.getAllEntities();
        HashSet subEntryKeySet = new HashSet(8);
        for (Map.Entry entityTypeEntry : allEntities.entrySet()) {
            EntityType entityTypeEntryValue = (EntityType)entityTypeEntry.getValue();
            if (!(entityTypeEntryValue instanceof SubEntryType)) continue;
            subEntryKeySet.add(entityTypeEntry.getKey());
        }
        EntityTypeUtil typeUtil = new EntityTypeUtil();
        List filterFields = typeUtil.getFilterFields((IDataEntityType)entityType, false);
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(filterFields.size());
        HashMap<String, String> comboItemsMap = new HashMap<String, String>(filterFields.size());
        for (FilterField filterField : filterFields) {
            String entityKey = filterField.getEntityKey();
            if (subEntryKeySet.contains(entityKey) || genTaskByEntry && !entityKey.equals(entryKey) && !entityKey.equals(entityNumber)) continue;
            LocaleString caption = new LocaleString();
            caption.setLocaleValue(filterField.getFullFieldCaption());
            String fullFieldName = filterField.getFullFieldName();
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(caption);
            comboItem.setValue(fullFieldName);
            comboItems.add(comboItem);
            comboItemsMap.put(fullFieldName, caption.getLocaleValue());
        }
        this.getPageCache().put(CACHE_COMBO_ITEMS_MAP, SerializationUtils.toJsonString(comboItemsMap));
        return comboItems;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        if (CONST_KEY.equalsIgnoreCase(propName) || BILL_FIELD.equalsIgnoreCase(propName) || SPLIT_SIGN.equalsIgnoreCase(propName)) {
            this.setCodingExample();
        }
    }

    public void click(EventObject evt) {
        Control c = (Control)evt.getSource();
        IDataModel model = this.getModel();
        String key = c.getKey();
        if ("btncancel".equals(key)) {
            this.getView().close();
        } else if ("btnok".equals(key)) {
            String codingExample = (String)model.getValue(CODING_EXAMPLE);
            int size = model.getEntryRowCount(ENTRY_ENTITY);
            ArrayList entryDataList = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                String constant = (String)model.getValue(CONST_KEY, i);
                String billFiled = (String)model.getValue(BILL_FIELD, i);
                if (StringUtils.isEmpty((String)constant) && StringUtils.isEmpty((String)billFiled)) {
                    String tipTpl = ResManager.loadKDString((String)"\u89c4\u5219\u8bbe\u7f6e\u7b2c%1$s\u884c\uff0c\u5e38\u91cf\u548c\u5355\u636e\u5b57\u6bb5\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"TaskSubjectConfigFormPlugin_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
                    this.getView().showTipNotification(String.format(tipTpl, i + 1));
                    return;
                }
                HashMap<String, String> entryDataMap = new HashMap<String, String>(2);
                entryDataMap.put(CONST_KEY, constant);
                entryDataMap.put(BILL_FIELD, billFiled);
                entryDataList.add(entryDataMap);
            }
            String splitSign = (String)model.getValue(SPLIT_SIGN);
            HashMap<String, Object> retMap = new HashMap<String, Object>(4);
            retMap.put("ex", codingExample);
            retMap.put("config", entryDataList);
            retMap.put("split", splitSign);
            this.getView().returnDataToParent(retMap);
            this.getView().close();
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        this.setCodingExample();
    }

    private void setCodingExample() {
        IDataModel model = this.getView().getModel();
        int size = model.getEntryRowCount(ENTRY_ENTITY);
        if (size == 0) {
            model.setValue(CODING_EXAMPLE, null);
            return;
        }
        StringBuilder appendNumber = new StringBuilder();
        String comboItemsMapStr = this.getPageCache().get(CACHE_COMBO_ITEMS_MAP);
        String splitSign = (String)model.getValue(SPLIT_SIGN);
        Map comboItemsMap = (Map)SerializationUtils.fromJsonString((String)comboItemsMapStr, Map.class);
        for (int i = 0; i < size; ++i) {
            String fieldNumber;
            String fieldName;
            String constant;
            if (i != 0 && StringUtils.isNotEmpty((String)splitSign)) {
                appendNumber.append(splitSign);
            }
            if (StringUtils.isNotEmpty((String)(constant = (String)model.getValue(CONST_KEY, i)))) {
                appendNumber.append(constant);
            }
            if (!StringUtils.isNotEmpty((String)(fieldName = (String)comboItemsMap.get(fieldNumber = (String)model.getValue(BILL_FIELD, i))))) continue;
            appendNumber.append(fieldName);
        }
        String appendNumberString = appendNumber.toString();
        model.setValue(CODING_EXAMPLE, (Object)appendNumberString);
        this.getView().updateView(CODING_EXAMPLE);
    }
}

