/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.ILicenseService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.yzj.config.YzjConfigServiceHelper;
import kd.bos.yzj.model.YzjConfig;
import kd.mpscmm.msbd.workbench.constant.SchemeType;
import kd.mpscmm.msbd.workbench.constant.scheme.GroupSchemeRel;
import kd.mpscmm.msbd.workbench.constant.scheme.OrgSchemeRel;
import kd.mpscmm.msbd.workbench.constant.scheme.RoleSchemeRel;
import kd.mpscmm.msbd.workbench.constant.scheme.SchemeRel;
import kd.mpscmm.msbd.workbench.constant.scheme.UserSchemeRel;
import kd.mpscmm.msbd.workbench.constant.scheme.UserTypeSchemeRel;

public class CardUtils {
    public static final String CARD_NAME = "groupname";
    public static final String EVENT_RTN_ADDCARD = "event_rtn_addcard";
    public static final String CARDINDEX_QUICKLAUNCH = "1";
    public static final String CARDINDEX_BILLSTATSCONFIG = "2";
    public static final String CARDINDEX_BILLSTATS_LIST = "3";
    public static final String CARDINDEX_YZJ_SUBSCRIBE_CONFIG = "4";
    public static final String CARDINDEX_MSGCENTER = "5";
    public static final String CARDINDEX_QING_CONFIG = "6";
    public static final String CARDINDEX_CUSTOM_CONFIG = "7";
    public static final String CARDINDEX_USERCENTER_CONFIG = "8";
    public static final String CONFIG = "config";
    public static final String SCHEME = "scheme.";
    public static final String SCHEME1 = "scheme";
    public static final String PROTAL_SCHEME_GROUP_REL = "msbd_scheme_group";
    public static final String ID_DESC = "id desc";
    public static final String ZH_CN = "zh_CN";
    public static final String EN_US = "en_US";
    public static final String NUMTITLE = "numtitle";
    private IFormView iFormView = null;
    private IPageCache iPageCache = null;
    private IDataModel iDataModel = null;
    private Log logger = null;
    public static final String PGCACHE_CURRENT_SCHEME = "pgCache_currentScheme";
    public static final String PGCACHE_CURRENT_SCHEME_TYPE = "pgCache_currentSchemeType";
    public static final String PGCACHE_GRID_LAYOUT = "pgCache_grid_layout";
    public static final String PGCACHE_HIDECARDIDS = "pgCache_hideCardIds";
    public static final String PGCACHE_PERMFILTERCARDINFO = "pgCache_permFilterCardInfo";
    public static final String PREFIX_FIELD = "f:";
    public static final String SHOWABLE_MENULIST = "childMenuList";
    public static final String CTRL_GRIDCONTAINER = "gridcontainerap";
    private static Log log = LogFactory.getLog(CardUtils.class);
    private static DistributeSessionlessCache shareSchemeCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("shareScheme", new DistributeCacheHAPolicy(true, true));

    public CardUtils() {
    }

    public CardUtils(IFormView pFormView, IPageCache pPageCache, IDataModel pDataModel, Log plogger) {
        this.iFormView = pFormView;
        this.iPageCache = pPageCache;
        this.iDataModel = pDataModel;
        this.logger = plogger;
    }

    public static boolean checkCurSchemeOwner(Long userId, Long schemeId) {
        if (schemeId != null) {
            try {
                DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)schemeId, (String)"msbd_wrokbench_scheme", (String)"id,creator");
                if (schemeObj == null) {
                    return false;
                }
                DynamicObject userDynamicObject = schemeObj.getDynamicObject("creator");
                Long creatorId = userDynamicObject.getLong("id");
                if (creatorId.equals(userId)) {
                    return true;
                }
            }
            catch (Exception e) {
                log.error("checkCurSchemeOwner error", (Throwable)e);
            }
        }
        return false;
    }

    public static boolean checkCurSchemeCustomizable(String schemeId, IFormView view) {
        return CardUtils.checkCurSchemeCustomizable(schemeId, view, true);
    }

    public static boolean checkCurSchemeCustomizable(String schemeId, IFormView view, boolean showTips) {
        Long userId = RequestContext.get().getCurrUserId();
        if (StringUtils.isNotEmpty((String)schemeId)) {
            block9: {
                try {
                    DynamicObject schemeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(schemeId), (String)"msbd_wrokbench_scheme", (String)"id,isedit,creator,enable ");
                    if (schemeObj == null) break block9;
                    boolean enable = schemeObj.getBoolean("enable");
                    if (!enable) {
                        if (view != null && showTips) {
                            view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u5df2\u88ab\u7981\u7528\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"CardUtils_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                        }
                        return false;
                    }
                    boolean isEdit = schemeObj.getBoolean("isedit");
                    if (!isEdit) {
                        boolean canEdit;
                        DynamicObject creatorDy = schemeObj.getDynamicObject("creator");
                        boolean bl = canEdit = creatorDy != null && userId.equals(creatorDy.getLong("id"));
                        if (canEdit) {
                            return true;
                        }
                        break block9;
                    }
                    return true;
                }
                catch (Exception e) {
                    if (view != null && showTips) {
                        view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u53ef\u80fd\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u754c\u9762\u3002", (String)"CardUtils_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
                    }
                    return false;
                }
            }
            if (view != null && showTips) {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848\u4e0d\u652f\u6301\u4e2a\u6027\u4fee\u6539\u3002", (String)"CardUtils_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    public static DynamicObject[] loadAllMainPageCardConfig(Long schemeId) {
        String selFields = "id,cardid,config,cardtype,cardtitle,customname";
        QFilter filter = new QFilter(SCHEME1, "=", (Object)schemeId);
        Map mainPageCardConfigs = BusinessDataServiceHelper.loadFromCache((String)"msbd_workbenchcardconf", (String)selFields, (QFilter[])filter.toArray());
        if (mainPageCardConfigs == null || mainPageCardConfigs.size() == 0) {
            return new DynamicObject[0];
        }
        HashMap<String, DynamicObject> validCardConfigMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject curDObj : mainPageCardConfigs.values()) {
            if (curDObj == null) continue;
            String cardId = curDObj.getString("cardid");
            DynamicObject cardConfigDObj = (DynamicObject)validCardConfigMap.get(cardId);
            if (cardConfigDObj == null) {
                validCardConfigMap.put(cardId, curDObj);
                continue;
            }
            Long inMapCardConfigId = cardConfigDObj.getLong("id");
            Long curCardConfigId = curDObj.getLong("id");
            if (inMapCardConfigId >= curCardConfigId) continue;
            validCardConfigMap.put(cardId, curDObj);
        }
        if (CollectionUtils.isEmpty(validCardConfigMap)) {
            return new DynamicObject[0];
        }
        Collection validCardConfigObjs = validCardConfigMap.values();
        for (DynamicObject dObj : validCardConfigObjs) {
            CardUtils.replaceSomeCardConfigForLangLoad(dObj);
        }
        return validCardConfigObjs.toArray(new DynamicObject[0]);
    }

    public static List<Long> getCardIdsFromLayout(String layout) {
        ArrayList<Long> cardIdList = new ArrayList<Long>();
        if (StringUtils.isEmpty((String)layout)) {
            return cardIdList;
        }
        JSONArray jsonArr = JSON.parseArray((String)layout);
        for (Object object : jsonArr) {
            JSONObject jsonObj = (JSONObject)object;
            String cardId = jsonObj.getString("i");
            if (StringUtils.isEmpty((String)cardId)) continue;
            long lCardId = 0L;
            try {
                lCardId = Long.parseLong(cardId);
            }
            catch (Exception e) {
                continue;
            }
            cardIdList.add(lCardId);
        }
        return cardIdList;
    }

    public static String getAppIdFromView(IFormView view) {
        String appId = view.getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appId)) {
            appId = (String)view.getFormShowParameter().getCustomParam("appid");
        }
        String bizAppId = null;
        if (StringUtils.isNotEmpty((String)appId)) {
            AppInfo app = AppMetadataCache.getAppInfo((String)appId);
            bizAppId = app != null ? app.getId() : appId;
        }
        return bizAppId;
    }

    public static DynamicObject loadScheme(SchemeType schemeType, Long userId, String selFields, IFormView view) {
        return CardUtils.loadScheme(schemeType, userId, selFields, null, view);
    }

    public static DynamicObject loadScheme(SchemeType schemeType, Long userId, String selFields, List<QFilter> otherQFilters, IFormView view) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        qFilters.add(new QFilter("schemetype", "=", (Object)schemeType.getValue()));
        qFilters.add(new QFilter("formnum", "=", (Object)view.getEntityId()));
        if (schemeType == SchemeType.UserScheme) {
            qFilters.add(new QFilter("creator", "=", (Object)userId));
        }
        qFilters.add(new QFilter("enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        if (!CollectionUtils.isEmpty(otherQFilters)) {
            qFilters.addAll(otherQFilters);
        }
        QFilter[] arrQFilter = qFilters.toArray(new QFilter[0]);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_wrokbench_scheme", (String)selFields, (QFilter[])arrQFilter);
    }

    public static HashMap<String, Object> getLayoutForNewCard(String layout, int width, int height, int gridCols) {
        int y;
        int x;
        int y2;
        if (StringUtils.isEmpty((String)layout)) {
            return new HashMap<String, Object>(0);
        }
        List cardList = (List)SerializationUtils.fromJsonString((String)layout, List.class);
        int maxRow = 0;
        Map cardMap = null;
        for (int i = 0; i < cardList.size(); ++i) {
            cardMap = (Map)cardList.get(i);
            y2 = (Integer)cardMap.get("y");
            int h = (Integer)cardMap.get("h");
            int x2 = (Integer)cardMap.get("x");
            int w = (Integer)cardMap.get("w");
            if (y2 > maxRow) {
                maxRow = y2;
            }
            if (y2 + h > maxRow + 1) {
                maxRow = y2 + h;
            }
            if (gridCols >= x2 + w) continue;
            gridCols = x2 + w;
        }
        int[][] gridValue = new int[maxRow + 1][gridCols];
        for (y2 = 0; y2 < maxRow; ++y2) {
            for (x = 0; x < gridCols; ++x) {
                gridValue[y2][x] = 0;
            }
        }
        for (int i = 0; i < cardList.size(); ++i) {
            cardMap = (Map)cardList.get(i);
            x = (Integer)cardMap.get("x");
            y = (Integer)cardMap.get("y");
            int ww = (Integer)cardMap.get("w");
            int hh = (Integer)cardMap.get("h");
            for (int indexY = y; indexY < y + hh; ++indexY) {
                for (int indexX = x; indexX < x + ww; ++indexX) {
                    gridValue[indexY][indexX] = 1;
                }
            }
        }
        if (width > gridCols || width < 1) {
            width = 4;
        }
        if (height <= 0 || height > 5) {
            height = 1;
        }
        int xx = -1;
        int yy = -1;
        for (y = 0; y < maxRow + 1; ++y) {
            for (int x3 = 0; x3 < gridCols && x3 <= gridCols - width; ++x3) {
                int sum = 0;
                for (int wy = y; wy < y + height; ++wy) {
                    if (wy > maxRow) continue;
                    for (int wx = x3; wx < x3 + width; ++wx) {
                        if (gridValue[wy][wx] <= 0) continue;
                        sum = 1;
                        break;
                    }
                    if (sum > 0) break;
                }
                if (sum != 0) continue;
                xx = x3;
                yy = y;
                break;
            }
            if (yy > -1) break;
        }
        if (xx == -1) {
            xx = 0;
        }
        if (yy == -1) {
            yy = maxRow + 1;
        }
        HashMap<String, Object> layoutMap = new HashMap<String, Object>(16);
        layoutMap.put("x", xx);
        layoutMap.put("y", yy);
        layoutMap.put("w", width);
        layoutMap.put("h", height);
        return layoutMap;
    }

    public static void showModifyCaptionForm(IFormView fv, IFormPlugin formPlugin, String cardTitleMapEntryStr) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("msbd_card_modifycaption");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setShowTitle(true);
        fsp.setCloseCallBack(new CloseCallBack(formPlugin, "ModifyCardCaption"));
        fsp.setCustomParam(CARD_NAME, (Object)cardTitleMapEntryStr);
        fv.showForm(fsp);
    }

    public static boolean getIsolationOrg(String appNum, String menuId) {
        AppInfo appInfo;
        boolean isAllUserApp;
        boolean isolationOrg = true;
        if (StringUtils.isNotEmpty((String)menuId)) {
            JSONObject jsonObj;
            String strIsolationOrg;
            String falseStr;
            AppMenuInfo menuInfo = AppMetadataCache.getAppMenuInfo((String)appNum, (String)menuId);
            if (menuInfo == null) {
                return isolationOrg;
            }
            String params = menuInfo.getParams();
            if (StringUtils.isNotEmpty((String)params) && (falseStr = "false").equals(strIsolationOrg = (jsonObj = JSON.parseObject((String)params)).getString("IsolationOrg"))) {
                isolationOrg = false;
            }
        } else if (StringUtils.isNotEmpty((String)appNum) && (isAllUserApp = (appInfo = AppMetadataCache.getAppInfo((String)appNum)).isAllUserApp())) {
            isolationOrg = false;
        }
        return isolationOrg;
    }

    public static String getEntityNumByFormNum(String formNum) {
        String entityNumber = FormMetadataCache.getFormConfig((String)formNum).getEntityTypeId();
        String empty = "empty";
        if (StringUtils.isEmpty((String)entityNumber) || empty.equals(entityNumber)) {
            entityNumber = formNum;
        }
        return entityNumber;
    }

    public static boolean isHaveSchemeRecord(String schemeId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)schemeId)};
        String sql = "SELECT COUNT(1) FROM T_BAS_FILTERSCHEME T1 WHERE T1.FSCHEMEID =?";
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                if (rs.next() && rs.getInt(1) > 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        boolean isHaveRecord = (Boolean)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)action);
        return isHaveRecord;
    }

    public static String getMainViewFormId(IFormView fv) {
        IFormView mainView = fv.getMainView();
        String mainPageFormId = null;
        if (mainView == null) {
            mainPageFormId = "pc_main_console";
        } else {
            mainPageFormId = mainView.getEntityId();
            if (StringUtils.isEmpty((String)mainPageFormId)) {
                mainPageFormId = "pc_main_console";
            }
        }
        return mainPageFormId;
    }

    public static boolean isMainPage(IFormView mainFormView) {
        String entityId = mainFormView.getEntityId();
        String mainPageFormId = CardUtils.getMainViewFormId(mainFormView);
        return mainPageFormId.equals(entityId);
    }

    public static LocaleString getLocaleStrFromMapEntryStr(String mapEntryStr) {
        if (StringUtils.isEmpty((String)mapEntryStr)) {
            return null;
        }
        int leftStartIdx = mapEntryStr.indexOf("[");
        int rightStartIdx = mapEntryStr.indexOf("]");
        if (leftStartIdx == -1 || rightStartIdx == -1) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(16);
        String entryContentStr = mapEntryStr.substring(leftStartIdx + 1, rightStartIdx);
        if (StringUtils.isEmpty((String)entryContentStr)) {
            return null;
        }
        String[] entryMapArr = entryContentStr.split(",");
        for (int i = 0; i < entryMapArr.length; ++i) {
            String[] keyValueArr;
            if (StringUtils.isEmpty((String)entryMapArr[i]) || (keyValueArr = entryMapArr[i].split("=")) == null || keyValueArr.length == 1) continue;
            map.put(keyValueArr[0].trim(), entryMapArr[i].substring(keyValueArr[0].length() + 1).trim());
        }
        LocaleString ls = LocaleString.fromMap(map);
        return ls;
    }

    public static String getMapEntryStrFromLocaleString(LocaleString lstr) {
        String result = null;
        if (lstr == null) {
            return result;
        }
        StringBuilder sb = new StringBuilder("[");
        int entryCount = lstr.entrySet().size();
        int i = 0;
        for (Map.Entry entry : lstr.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            sb.append(key).append("=").append(value);
            if (i != entryCount - 1) {
                sb.append(",");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public static String getMapEntryStrFromOrmLocaleValue(OrmLocaleValue olv) {
        String mapEntryStr = olv.entrySet().toString();
        return mapEntryStr;
    }

    public static String findMenuId(String appNum, String entityNum) {
        List appMenusInfoByAppId = AppMetadataCache.getAppMenusInfoByAppId((String)appNum);
        for (AppMenuInfo appMenuInfo : appMenusInfoByAppId) {
            if (!entityNum.equals(appMenuInfo.getFormId())) continue;
            return appMenuInfo.getId();
        }
        return null;
    }

    public static Map<String, Object> getDetailConfigMap(Map<String, String> cardInfo) {
        String configObj = cardInfo.get(CONFIG);
        Map configMap = null;
        if (configObj instanceof String) {
            String config = configObj;
            if (StringUtils.isEmpty((String)config)) {
                return null;
            }
            config = CardUtils.convertToPureJson(config);
            configMap = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
        } else {
            configMap = (Map)((Object)configObj);
        }
        return configMap;
    }

    public static List<Long> getShareSchemeIds(Long userId, IFormView view) {
        return CardUtils.getShareSchemeIdsCache(userId, view);
    }

    private static List<Long> getShareSchemeIdsCache(Long userId, IFormView view) {
        List shareSchemeIds;
        String key = CardUtils.getShareSchemeIdsKey(userId);
        String portalType = CardUtils.getShareSchemeCacheType(CardUtils.getAppIdFromView(view));
        String shareSchemeIdsCache = (String)shareSchemeCache.get(portalType, key);
        if (shareSchemeIdsCache == null) {
            shareSchemeIds = CardUtils.getShareSchemeIdsByUser(userId, view);
            shareSchemeCache.put(portalType, key, (Object)SerializationUtils.toJsonString((Object)shareSchemeIds));
        } else {
            shareSchemeIds = (List)SerializationUtils.fromJsonString((String)shareSchemeIdsCache, List.class);
        }
        return shareSchemeIds;
    }

    private static String getShareSchemeIdsKey(Long userId) {
        return String.format("%s_shareSchemeIds", userId);
    }

    private static String getShareSchemeCacheType(String formNum) {
        return formNum + "_portalscheme_" + RequestContext.get().getAccountId();
    }

    public static void removeShareIdsCache(String formNum) {
        shareSchemeCache.removeType(CardUtils.getShareSchemeCacheType(formNum));
    }

    public static List<Long> getShareSchemeIdsByUser(Long userId, IFormView view) {
        List<Long> groupSchemeIds = CardUtils.getGroupSchemeIds(userId, view);
        List<Long> orgSchemeIds = CardUtils.getOrgSchemeIds(userId, view);
        List<Long> userSchemeIds = CardUtils.getUserSchemeIds(userId, view);
        List<Long> roleSchemeIds = CardUtils.getRoleSchemeIds(userId, view);
        List<Long> usertypeSchemeIds = CardUtils.getUserTypeSchemeIds(userId, view);
        ArrayList<Long> allShareSchemeIds = new ArrayList<Long>(10);
        if (groupSchemeIds != null) {
            allShareSchemeIds.addAll(groupSchemeIds);
        }
        if (orgSchemeIds != null) {
            allShareSchemeIds.addAll(orgSchemeIds);
        }
        if (userSchemeIds != null) {
            allShareSchemeIds.addAll(userSchemeIds);
        }
        if (roleSchemeIds != null) {
            allShareSchemeIds.addAll(roleSchemeIds);
        }
        if (usertypeSchemeIds != null) {
            allShareSchemeIds.addAll(usertypeSchemeIds);
        }
        return allShareSchemeIds.stream().distinct().sorted(Comparator.comparing(Long::longValue).reversed()).collect(Collectors.toList());
    }

    private static List<Long> getUserTypeSchemeIds(Long userId, IFormView view) {
        List<QFilter> qFilters = CardUtils.initBaseFilter(view);
        List<Long> userTypes = CardUtils.getUserTypeByUserid(userId);
        if (userTypes != null && !userTypes.isEmpty()) {
            qFilters.add(new QFilter("usertypes", "in", userTypes));
            DynamicObject[] schemes = BusinessDataServiceHelper.load((String)UserTypeSchemeRel.MAIN_ENTITY_TYPE, (String)SCHEME1, (QFilter[])qFilters.toArray(new QFilter[0]), (String)ID_DESC);
            List<Long> schemeId = Arrays.stream(schemes).map(v -> v.getLong("scheme_id")).distinct().collect(Collectors.toList());
            return schemeId;
        }
        return Collections.emptyList();
    }

    private static List<Long> getUserTypeByUserid(Long userId) {
        DynamicObject load = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user", (String)"usertypes");
        if (load == null) {
            return Collections.emptyList();
        }
        DynamicObjectCollection userTypes = (DynamicObjectCollection)load.get("usertypes");
        if (userTypes == null || userTypes.isEmpty()) {
            return Collections.emptyList();
        }
        return userTypes.stream().map(CardUtils::getPkIdFromUserType).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static Long getPkIdFromUserType(DynamicObject data) {
        if (data == null) {
            return null;
        }
        DynamicObject userTypeData = (DynamicObject)data.get("fbasedataid");
        if (userTypeData == null) {
            return null;
        }
        return (Long)userTypeData.getPkValue();
    }

    private static List<Long> getRoleSchemeIds(Long userId, IFormView view) {
        List<QFilter> qFilters = CardUtils.initBaseFilter(view);
        Set<String> roleIds = CardUtils.getRoleByUserid(userId);
        if (roleIds != null && !roleIds.isEmpty()) {
            qFilters.add(new QFilter("roles", "in", roleIds));
            DynamicObject[] schemes = BusinessDataServiceHelper.load((String)RoleSchemeRel.MAIN_ENTITY_TYPE, (String)SCHEME1, (QFilter[])qFilters.toArray(new QFilter[0]), (String)ID_DESC);
            List<Long> schemeId = Arrays.stream(schemes).map(v -> v.getLong("scheme_id")).distinct().collect(Collectors.toList());
            return schemeId;
        }
        return Collections.emptyList();
    }

    private static Set<String> getRoleByUserid(Long userId) {
        Set roleIds = PermissionServiceHelper.getRolesByUser((Long)userId);
        return roleIds;
    }

    private static List<Long> getUserSchemeIds(Long userId, IFormView view) {
        List<QFilter> qfList = CardUtils.initBaseFilter(view);
        qfList.add(new QFilter(UserSchemeRel.PROP_USER, "=", (Object)userId));
        DynamicObject[] schemes = BusinessDataServiceHelper.load((String)UserSchemeRel.MAIN_ENTITY_TYPE, (String)SCHEME1, (QFilter[])qfList.toArray(new QFilter[0]), (String)ID_DESC);
        List<Long> schemeId = Arrays.stream(schemes).map(v -> v.getLong("scheme_id")).distinct().collect(Collectors.toList());
        return schemeId;
    }

    private static List<QFilter> initBaseFilter(IFormView view) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("scheme.schemetype", "=", (Object)SchemeType.GroupScheme.getValue()));
        qfList.add(new QFilter("scheme.enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        String formNum = view.getEntityId();
        qfList.add(new QFilter("scheme.formnum", "=", (Object)formNum));
        String modeType = CardUtils.convertModeType();
        QFilter isMultiOrgFilter = new QFilter("scheme.ismultiorg", "=", (Object)modeType);
        qfList.add(isMultiOrgFilter);
        return qfList;
    }

    public static List<Long> getGroupSchemeIds(Long userId, IFormView view) {
        DynamicObject[] groupUsers = BusinessDataServiceHelper.load((String)"msbd_group_user", (String)"group", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        QFilter groupUserFilter = new QFilter("scheme.creator", "=", (Object)userId);
        if (groupUsers != null && groupUsers.length > 0) {
            ArrayList<Long> groupIds = new ArrayList<Long>(groupUsers.length);
            for (DynamicObject group : groupUsers) {
                groupIds.add(group.getLong("group_id"));
            }
            groupUserFilter.or(new QFilter("group", "in", groupIds));
        }
        qfList.add(groupUserFilter);
        qfList.add(new QFilter("scheme.schemetype", "=", (Object)SchemeType.GroupScheme.getValue()));
        qfList.add(new QFilter("scheme.enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        String formNum = view.getEntityId();
        qfList.add(new QFilter("scheme.formnum", "=", (Object)formNum));
        String modeType = CardUtils.convertModeType();
        QFilter isMultiOrgFilter = new QFilter("scheme.ismultiorg", "=", (Object)modeType);
        qfList.add(isMultiOrgFilter);
        Object[] schemeGroups = BusinessDataServiceHelper.load((String)PROTAL_SCHEME_GROUP_REL, (String)SCHEME1, (QFilter[])qfList.toArray(new QFilter[0]), (String)ID_DESC);
        ArrayList<Long> resultList = new ArrayList<Long>();
        if (ArrayUtils.isNotEmpty((Object[])schemeGroups)) {
            for (Object schemeGroup : schemeGroups) {
                resultList.add(schemeGroup.getLong("scheme_id"));
            }
            return resultList;
        }
        return null;
    }

    public static List<Long> getOrgSchemeIds(Long userId, IFormView view) {
        List<Long> orgIds = CardUtils.getOrgIds(userId);
        if (CollectionUtils.isEmpty(orgIds)) {
            return null;
        }
        Object bizAppId = null;
        String formNum = null;
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        qfList.add(new QFilter("org", "in", orgIds));
        qfList.add(new QFilter("scheme.schemetype", "=", (Object)SchemeType.GroupScheme.getValue()));
        qfList.add(new QFilter("scheme.enable", "=", (Object)CARDINDEX_QUICKLAUNCH));
        formNum = view.getEntityId();
        qfList.add(new QFilter("scheme.formnum", "=", (Object)formNum));
        String modeType = CardUtils.convertModeType();
        QFilter isMultiOrgFilter = new QFilter("scheme.ismultiorg", "=", (Object)modeType);
        qfList.add(isMultiOrgFilter);
        Object[] schemeGroups = BusinessDataServiceHelper.load((String)"msbd_scheme_org", (String)SCHEME1, (QFilter[])qfList.toArray(new QFilter[0]), (String)ID_DESC);
        ArrayList<Long> resultList = new ArrayList<Long>();
        if (ArrayUtils.isNotEmpty((Object[])schemeGroups)) {
            for (Object schemeGroup : schemeGroups) {
                resultList.add(schemeGroup.getLong("scheme_id"));
            }
            return resultList;
        }
        return null;
    }

    public static List<Long> getOrgIds(Long userId) {
        try {
            ArrayList<Long> orgIds = new ArrayList<Long>(5);
            String selectFields = "id, ispartjob, dpt, position,entryentity";
            QFilter idFilter = new QFilter("id", "=", (Object)userId);
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            QFilter[] filters = new QFilter[]{idFilter, enableFilter};
            Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])filters);
            if (userMap == null || userMap.isEmpty()) {
                return null;
            }
            for (DynamicObject userObj : userMap.values()) {
                DynamicObjectCollection entryCol = userObj.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryCol) {
                    DynamicObject dpt = (DynamicObject)entry.get("dpt");
                    if (dpt == null) continue;
                    orgIds.add(Long.parseLong(dpt.getPkValue().toString()));
                }
            }
            return orgIds;
        }
        catch (NumberFormatException e) {
            log.error("\u83b7\u53d6\u4eba\u5458\u7ec4\u7ec7\u5f02\u5e38\uff1a", (Object)e.getMessage());
            return null;
        }
    }

    public static Long getGroupSchemeId(Long userId, IFormView view) {
        List<Long> groupSchemeIds = CardUtils.getShareSchemeIds(userId, view);
        if (groupSchemeIds == null || groupSchemeIds.isEmpty()) {
            return null;
        }
        return groupSchemeIds.get(0);
    }

    public static String replaceBackSlach(String layout) {
        String splitStr = "\\\"";
        while (layout.contains(splitStr)) {
            layout = layout.replaceAll("\\\\\"", "\"");
        }
        return layout;
    }

    private Long saveWorkBenchScheme(SchemeType schemeType, String layout, Long curSchemeId, DynamicObject saveAsSchemeObj) {
        ORM orm = ORM.create();
        Long userId = RequestContext.get().getCurrUserId();
        String formNum = this.iFormView.getEntityId();
        DynamicObject queryScheme = null;
        String selFields = "id,layout,user,modifier,modifytime,number,name,enable,isedit,ismultiorg";
        ArrayList<QFilter> delQfList = new ArrayList<QFilter>();
        ArrayList<QFilter> queryQfList = new ArrayList<QFilter>();
        String modeType = CardUtils.convertModeType();
        QFilter modelTypeDelFilter = new QFilter("scheme.ismultiorg", "=", (Object)modeType);
        QFilter modelTypeQueryFilter = new QFilter("ismultiorg", "=", (Object)modeType);
        if (curSchemeId == null) {
            if (schemeType == SchemeType.SysDefScheme || schemeType == SchemeType.UserScheme) {
                delQfList.add(new QFilter("scheme.enable", "=", (Object)true));
                queryQfList.add(new QFilter("enable", "=", (Object)true));
                delQfList.add(new QFilter("scheme.formnum", "=", (Object)formNum));
                queryQfList.add(new QFilter("formnum", "=", (Object)formNum));
                delQfList.add(new QFilter("scheme.schemetype", "=", (Object)schemeType.getValue()));
                queryQfList.add(new QFilter("schemetype", "=", (Object)schemeType.getValue()));
                if (schemeType == SchemeType.UserScheme) {
                    delQfList.add(new QFilter("scheme.creator", "=", (Object)userId));
                    queryQfList.add(new QFilter("creator", "=", (Object)userId));
                }
                delQfList.add(modelTypeDelFilter);
                queryQfList.add(modelTypeQueryFilter);
                queryScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_wrokbench_scheme", (String)selFields, (QFilter[])queryQfList.toArray(new QFilter[0]));
                if (queryScheme != null) {
                    DeleteServiceHelper.delete((String)"msbd_workbenchcardconf", (QFilter[])delQfList.toArray(new QFilter[0]));
                }
            }
        } else {
            delQfList.add(modelTypeDelFilter);
            queryQfList.add(modelTypeQueryFilter);
            queryQfList.add(new QFilter("id", "=", (Object)curSchemeId));
            queryScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_wrokbench_scheme", (String)selFields, (QFilter[])queryQfList.toArray(new QFilter[0]));
            if (queryScheme != null) {
                delQfList.add(new QFilter(SCHEME1, "=", (Object)curSchemeId));
                DeleteServiceHelper.delete((String)"msbd_workbenchcardconf", (QFilter[])delQfList.toArray(new QFilter[0]));
            }
        }
        if (schemeType == SchemeType.GroupScheme && curSchemeId != null && queryScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6848ID\u6570\u636e\u5e93\u67e5\u65e0\u8bb0\u5f55\uff0c\u53ef\u80fd\u7f13\u5b58\u6709\u95ee\u9898\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u5237\u65b0\u9875\u9762\u3002", (String)"CardUtils_4", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
        }
        if (queryScheme == null) {
            queryScheme = BusinessDataServiceHelper.newDynamicObject((String)"msbd_wrokbench_scheme");
            queryScheme.set("ismultiorg", (Object)modeType);
            queryScheme.set("creator", (Object)userId);
            queryScheme.set("createtime", (Object)new Date());
            if (schemeType == SchemeType.SysDefScheme) {
                queryScheme.set("schemetype", (Object)SchemeType.SysDefScheme.getValue());
                queryScheme.set("isedit", (Object)CARDINDEX_QUICKLAUNCH);
            } else if (schemeType == SchemeType.GroupScheme) {
                queryScheme.set("schemetype", (Object)SchemeType.GroupScheme.getValue());
                queryScheme.set("isedit", (Object)saveAsSchemeObj.getBoolean("isedit"));
                queryScheme.set("number", (Object)saveAsSchemeObj.getString("number"));
            } else {
                queryScheme.set("schemetype", (Object)SchemeType.UserScheme.getValue());
                queryScheme.set("isedit", (Object)CARDINDEX_QUICKLAUNCH);
            }
            queryScheme.set("formnum", (Object)formNum);
            queryScheme.set("user", (Object)0L);
            if (StringUtils.isEmpty((String)queryScheme.getString("number"))) {
                String schemeNum = CodeRuleServiceHelper.getNumber((String)"msbd_wrokbench_scheme", (DynamicObject)queryScheme, null);
                if (StringUtils.isEmpty((String)schemeNum)) {
                    Long lnum = orm.genLongId("msbd_wrokbench_scheme");
                    schemeNum = Long.toString(lnum);
                }
                queryScheme.set("number", (Object)schemeNum);
            }
            LocaleString scheme = this.getSchemeName(schemeType, saveAsSchemeObj);
            queryScheme.set("name", (Object)scheme);
            queryScheme.set("enable", (Object)CARDINDEX_QUICKLAUNCH);
            queryScheme.set("ismultiorg", (Object)modeType);
        } else {
            queryScheme.set("modifier", (Object)userId);
            queryScheme.set("modifytime", (Object)new Date());
        }
        queryScheme.set("layout", (Object)layout);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{queryScheme});
        Long schemeId = (Long)queryScheme.getPkValue();
        if (schemeType == SchemeType.GroupScheme && saveAsSchemeObj != null) {
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("groupids"), schemeId, new GroupSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("orgids"), schemeId, new OrgSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("userids"), schemeId, new UserSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("roleids"), schemeId, new RoleSchemeRel());
            this.saveMainPageRel(saveAsSchemeObj.getDynamicObjectCollection("usertypeids"), schemeId, new UserTypeSchemeRel());
        }
        return schemeId;
    }

    private LocaleString getSchemeName(SchemeType schemeType, DynamicObject saveAsSchemeObj) {
        Long userId = RequestContext.get().getCurrUserId();
        String userName = "";
        if (schemeType == SchemeType.UserScheme) {
            Map userInfoByID = UserServiceHelper.getUserInfoByID((long)userId);
            userName = ResManager.loadKDString((String)"{0}\u7684", (String)"CardUtils_5", (String)"mpscmm-msbd-workbench", (Object[])new Object[]{userInfoByID.get("name")});
        }
        String schemeName = null;
        String formName = this.iFormView.getFormShowParameter().getFormName();
        schemeName = schemeType == SchemeType.SysDefScheme ? ResManager.loadKDString((String)"{0}\u9ed8\u8ba4\u65b9\u6848", (String)"CardUtils_6", (String)"mpscmm-msbd-workbench", (Object[])new Object[]{formName}) : (schemeType == SchemeType.GroupScheme ? saveAsSchemeObj.getString("name") : ResManager.loadKDString((String)"{0}{1}\u4e2a\u6027\u65b9\u6848", (String)"CardUtils_7", (String)"mpscmm-msbd-workbench", (Object[])new Object[]{userName, formName}));
        String langName = RequestContext.get().getLang().name();
        LocaleString scheme = null;
        switch (langName) {
            case "zh_CN": {
                scheme = new LocaleString(ZH_CN, schemeName);
                break;
            }
            case "zh_TW": {
                scheme = new LocaleString("zh_TW", schemeName);
                break;
            }
            default: {
                scheme = new LocaleString(EN_US, schemeName);
            }
        }
        return scheme;
    }

    private void saveMainPageRel(DynamicObjectCollection usertypeids, Long schemeId, SchemeRel type) {
        ArrayList<DynamicObject> relations = new ArrayList<DynamicObject>();
        for (DynamicObject id : usertypeids) {
            DynamicObject groupBean = (DynamicObject)id.get(1);
            DynamicObject schemeGroupRel = BusinessDataServiceHelper.newDynamicObject((String)type.getEntityName());
            schemeGroupRel.set(type.getFieldName(), groupBean.getPkValue());
            schemeGroupRel.set(SCHEME1, (Object)schemeId);
            relations.add(schemeGroupRel);
        }
        SaveServiceHelper.save((DynamicObject[])relations.toArray(new DynamicObject[0]));
    }

    private void saveMainPageAllCardConfig(SchemeType schemeType, Long schemeId, String layout, Map<String, String> allCardConfigMap) {
        List<Long> cardIds = CardUtils.getCardIdsFromLayout(layout);
        DeleteServiceHelper.delete((String)"msbd_workbenchcardconf", (QFilter[])new QFilter[]{new QFilter(SCHEME1, "=", (Object)schemeId)});
        ArrayList<DynamicObject> newDObjs = new ArrayList<DynamicObject>(1);
        for (Long cardId : cardIds) {
            String cardConfigStr = allCardConfigMap.get(String.valueOf(cardId));
            if (StringUtils.isEmpty((String)cardConfigStr)) continue;
            Map oneCardConfigMap = (Map)SerializationUtils.fromJsonString((String)cardConfigStr, Map.class);
            String cardType = (String)oneCardConfigMap.get("cardType");
            boolean isSetDefault = schemeType == SchemeType.SysDefScheme || schemeType == SchemeType.GroupScheme;
            String configStr = SerializationUtils.toJsonString((Object)oneCardConfigMap);
            configStr = CardUtils.convertToPureJson(configStr);
            Map configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
            LocaleString lsCardTitle = this.replaceCardTitleConfigForLangSave(configMap);
            LocaleString lsCustomName = this.replaceSomeCardConfigForLangSave(cardType, configMap);
            configStr = SerializationUtils.toJsonString((Object)configMap);
            configStr = CardUtils.convertToPureJson(configStr);
            DynamicObject newDObj = BusinessDataServiceHelper.newDynamicObject((String)"msbd_workbenchcardconf");
            newDObj.set("cardid", (Object)cardId);
            newDObj.set("user", (Object)0L);
            newDObj.set("cardtype", (Object)cardType);
            newDObj.set(CONFIG, (Object)configStr);
            newDObj.set(SCHEME1, (Object)schemeId);
            newDObj.set("cardtitle", (Object)lsCardTitle);
            newDObj.set("customname", (Object)lsCustomName);
            newDObjs.add(newDObj);
        }
        if (newDObjs != null && newDObjs.size() > 0) {
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)newDObjs.get(0)).getDataEntityType(), (Object[])newDObjs.toArray(new Object[0]));
        }
    }

    public boolean saveWorkBenchInfo(SchemeType schemeType, String layout, Map<String, String> allCardConfigMap, Long curSchemeId, DynamicObject saveAsObj) {
        if (StringUtils.isEmpty((String)layout)) {
            return false;
        }
        try (TXHandle txHandle = TX.required();){
            try {
                Long schemeId = this.saveWorkBenchScheme(schemeType, layout, curSchemeId, saveAsObj);
                this.saveMainPageAllCardConfig(schemeType, schemeId, layout, allCardConfigMap);
                this.iPageCache.put(PGCACHE_CURRENT_SCHEME, String.valueOf(schemeId));
                this.iPageCache.put(PGCACHE_CURRENT_SCHEME_TYPE, schemeType.getValue());
            }
            catch (Exception e) {
                txHandle.markRollback();
                String errorInfo = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a", (String)"CardUtils_8", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
                this.logger.info(errorInfo + e.getMessage());
                this.iFormView.showErrorNotification(errorInfo + e.getMessage());
                boolean bl = false;
                if (txHandle != null) {
                    if (var7_7 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return bl;
            }
            String appNum = this.iFormView.getFormShowParameter().getAppId();
            String appId = appNum == null ? null : AppMetadataCache.getAppInfo((String)appNum).getId();
            CardUtils.removeShareIdsCache(appId);
        }
        return true;
    }

    public static String getNewLayout(IFormView mainPageFormView, String gridContainerKey) {
        String newLayout = "";
        try {
            IPageCache mainPageCache = (IPageCache)mainPageFormView.getService(IPageCache.class);
            String controlstates = mainPageCache.get("controlstates");
            JSONObject object = (JSONObject)JSONObject.parse((String)controlstates);
            String string = newLayout = object == null || object.getJSONObject(gridContainerKey) == null ? null : object.getJSONObject(gridContainerKey).getString("layout");
            if (StringUtils.isEmpty((String)newLayout)) {
                newLayout = mainPageCache.get(PGCACHE_GRID_LAYOUT);
            } else {
                mainPageCache.put(PGCACHE_GRID_LAYOUT, newLayout);
            }
        }
        catch (Exception e) {
            log.error("getNewLayout: ", (Throwable)e);
        }
        return newLayout;
    }

    public static String getNewLayoutInMainpageCache(IFormView mainPageFormView) {
        IPageCache mainPageCache = (IPageCache)mainPageFormView.getService(IPageCache.class);
        String newLayout = mainPageCache.get(PGCACHE_GRID_LAYOUT);
        return newLayout;
    }

    public static boolean checkHasModifySchemeRight(Long userId) {
        String appIdPortal = "18XSXYEL8//U";
        String setDefaultLayoutEnittyNum = "msbd_workbench_setlayout";
        int hasPerm = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)0L, (String)appIdPortal, (String)setDefaultLayoutEnittyNum, (String)"4715a0df000000ac");
        if (hasPerm == 1) {
            return true;
        }
        log.info("\u6ca1\u6709\u5355\u636e\u6743\u9650\uff0cuserid:" + userId);
        return false;
    }

    public static String convertToPureJson(String configStr) {
        configStr = CardUtils.replaceBackSlach(configStr);
        configStr = configStr.replaceAll("\"\\{", "\\{").replaceAll("\\}\"", "\\}");
        return configStr;
    }

    private LocaleString replaceSomeCardConfigForLangSave(String cardType, Map<String, Object> configMap) {
        LocaleString result = null;
        if ("msbd_card_billstats".equals(cardType)) {
            String numtitle = (String)configMap.get(NUMTITLE);
            result = CardUtils.getLocaleStrFromMapEntryStr(numtitle);
            if (result == null) {
                result = new LocaleString(ZH_CN, numtitle);
            }
            configMap.put(NUMTITLE, "f:customname");
        } else if ("msbd_card_billstats_list".equals(cardType)) {
            Object detailConfigObj = configMap.get(CONFIG);
            Map detailConfigMap = null;
            if (detailConfigObj instanceof Map) {
                detailConfigMap = (Map)detailConfigObj;
            } else if (detailConfigObj instanceof String) {
                detailConfigMap = (Map)SerializationUtils.fromJsonString((String)((String)detailConfigObj), Map.class);
            }
            if (detailConfigMap == null) {
                return new LocaleString();
            }
            ArrayList<LocaleString> list = new ArrayList<LocaleString>(1);
            for (Map.Entry entry : detailConfigMap.entrySet()) {
                Object oneItemObj = entry.getValue();
                Map<String, String> oneItemMap = new HashMap(2);
                if (oneItemObj instanceof Map) {
                    oneItemMap = (Map)oneItemObj;
                } else if (oneItemObj instanceof String) {
                    oneItemMap = (Map)SerializationUtils.fromJsonString((String)((String)oneItemObj), Map.class);
                }
                String strNumTitle = (String)oneItemMap.get(NUMTITLE);
                LocaleString lsNumTitle = CardUtils.getLocaleStrFromMapEntryStr(strNumTitle);
                if (lsNumTitle == null) {
                    lsNumTitle = new LocaleString(ZH_CN, strNumTitle);
                }
                list.add(lsNumTitle);
                oneItemMap.put(NUMTITLE, "f:customname");
            }
            result = new LocaleString();
            for (LocaleString lStr : list) {
                for (Map.Entry entry : lStr.entrySet()) {
                    String key = (String)entry.getKey();
                    result.put(key, (Object)"");
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                LocaleString lStr;
                lStr = (LocaleString)list.get(i);
                for (String key : result.keySet()) {
                    String value = (String)lStr.get((Object)key);
                    String oldValue = (String)result.get((Object)key);
                    if (StringUtils.isEmpty((String)value)) {
                        value = "";
                    }
                    if (i == 0) {
                        result.put(key, (Object)value);
                        continue;
                    }
                    result.put(key, (Object)(oldValue + "," + value));
                }
            }
        }
        return result;
    }

    private static void replaceSomeCardConfigForLangLoad(DynamicObject cardConfigObj) {
        String cardType = cardConfigObj.getString("cardtype");
        String configStr = cardConfigObj.getString(CONFIG);
        if (StringUtils.isEmpty((String)(configStr = CardUtils.convertToPureJson(configStr)))) {
            return;
        }
        Map configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
        if ("msbd_card_billstats".equals(cardType)) {
            ILocaleString localeStr;
            String numTitleValue = (String)configMap.get(NUMTITLE);
            String numTitleFieldName = "";
            if (numTitleValue.startsWith(PREFIX_FIELD) && (numTitleFieldName = numTitleValue.substring(PREFIX_FIELD.length())).equals("customname") && (localeStr = cardConfigObj.getLocaleString("customname")) instanceof OrmLocaleValue) {
                OrmLocaleValue olv = (OrmLocaleValue)localeStr;
                String mapEntryStr = olv.entrySet().toString();
                configMap.put(NUMTITLE, mapEntryStr);
                configStr = SerializationUtils.toJsonString((Object)configMap);
                cardConfigObj.set(CONFIG, (Object)configStr);
            }
        } else if ("msbd_card_billstats_list".equals(cardType)) {
            Object detailConfigObj = configMap.get(CONFIG);
            if (detailConfigObj == null) {
                return;
            }
            if (detailConfigObj instanceof Map) {
                Map detailConfigMap = (Map)detailConfigObj;
                int statsItemCount = detailConfigMap.size();
                if (statsItemCount == 0) {
                    return;
                }
                ILocaleString localeStr = cardConfigObj.getLocaleString("customname");
                LocaleString[] lstrArr = new LocaleString[statsItemCount];
                if (localeStr instanceof OrmLocaleValue) {
                    OrmLocaleValue olv = (OrmLocaleValue)localeStr;
                    for (Map.Entry entry : olv.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (StringUtils.isEmpty((String)value)) continue;
                        String[] valueArr = value.split(",");
                        if (lstrArr.length < valueArr.length) {
                            String[] valueArrNew = new String[lstrArr.length];
                            System.arraycopy(valueArr, 0, valueArrNew, 0, lstrArr.length);
                            valueArr = valueArrNew;
                        }
                        for (int i = 0; i < valueArr.length; ++i) {
                            if (lstrArr[i] == null) {
                                lstrArr[i] = new LocaleString();
                                lstrArr[i].setItem(key, (Object)valueArr[i]);
                                continue;
                            }
                            lstrArr[i].setItem(key, (Object)valueArr[i]);
                        }
                    }
                }
                int i = 0;
                for (Map.Entry entry : detailConfigMap.entrySet()) {
                    Object oneItemObj = entry.getValue();
                    Map oneItemMap = (Map)oneItemObj;
                    String numberTitle = CardUtils.getMapEntryStrFromLocaleString(lstrArr[i]);
                    if (StringUtils.isNotEmpty((String)numberTitle)) {
                        oneItemMap.put(NUMTITLE, numberTitle);
                    }
                    ++i;
                }
                configStr = SerializationUtils.toJsonString((Object)configMap);
                cardConfigObj.set(CONFIG, (Object)configStr);
            }
        }
    }

    private LocaleString replaceCardTitleConfigForLangSave(Map<String, Object> configMap) {
        String cardTitle = (String)configMap.remove("cardtitle");
        LocaleString lsCardTitle = CardUtils.getLocaleStrFromMapEntryStr(cardTitle);
        if (lsCardTitle == null) {
            lsCardTitle = new LocaleString(ZH_CN, cardTitle);
        }
        return lsCardTitle;
    }

    public static String convertModeType() {
        ILicenseService licenseService = (ILicenseService)ServiceFactory.getService(ILicenseService.class);
        int modeType = licenseService.getModeType();
        if (modeType == 1) {
            return "0";
        }
        if (modeType == 2) {
            return CARDINDEX_BILLSTATSCONFIG;
        }
        return CARDINDEX_QUICKLAUNCH;
    }

    public static List<String> getHideMenus() {
        ArrayList<String> hideMenus = new ArrayList<String>();
        YzjConfig yzjConfig = YzjConfigServiceHelper.getParameterConfig();
        if (!yzjConfig.isEnable()) {
            hideMenus.add("18XQT0JJ0JMG");
            hideMenus.add("/90RRNI+R8G0");
            hideMenus.add("/Z3FWD66YIIB");
        }
        if (OrgUnitServiceHelper.getOrgmanageMode() != 1 || !PermissionServiceHelper.isAdminUser((long)RequestContext.get().getCurrUserId()) || !RunModeServiceHelper.isGalaxyMode()) {
            hideMenus.add("06XYF4U+6QN1");
        }
        return hideMenus;
    }

    public static List<String> getProductBlackMenus(String appid) {
        return (List)DispatchServiceHelper.invokeBOSService((String)"service", (String)"ProductSettingService", (String)"getAppMenuBlackList", (Object[])new Object[]{appid});
    }

    public static void setDefaultScheme(Long schemeId, String bizAppId, String entityId) {
        Long userId = RequestContext.get().getCurrUserId();
        String selectProperties = "id,scheme.id, scheme.schemetype, scheme.enable,scheme.bizapp,scheme.formnum";
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        filterList.add(userFilter);
        QFilter formNumFilter = new QFilter("scheme.formnum", "=", (Object)entityId);
        filterList.add(formNumFilter);
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        DynamicObjectCollection userScthemeCol = QueryServiceHelper.query((String)"msbd_defaultscheme_user", (String)selectProperties, (QFilter[])filters);
        if (userScthemeCol == null || userScthemeCol.size() == 0) {
            CardUtils.addOrUpdateSctheme(null, userId, schemeId, Boolean.TRUE);
        } else {
            DynamicObject dyobj = (DynamicObject)userScthemeCol.get(0);
            CardUtils.addOrUpdateSctheme(dyobj.getLong("id"), userId, schemeId, Boolean.FALSE);
        }
    }

    public static Long getDefaultSchemeId(String bizAppId, String entityId, IFormView formView) {
        Long userId = RequestContext.get().getCurrUserId();
        String selectProperties = "id,scheme, scheme.schemetype, scheme.enable,scheme.bizapp,scheme.formnum";
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter userFilter = new QFilter("user", "=", (Object)userId);
        filterList.add(userFilter);
        QFilter enableFilter = new QFilter("scheme.enable", "=", (Object)Boolean.TRUE);
        filterList.add(enableFilter);
        QFilter formNumFilter = new QFilter("scheme.formnum", "=", (Object)entityId);
        filterList.add(formNumFilter);
        QFilter modelTypeFilter = new QFilter("scheme.ismultiorg", "=", (Object)CardUtils.convertModeType());
        filterList.add(modelTypeFilter);
        QFilter[] filters = filterList.toArray(new QFilter[filterList.size()]);
        DynamicObject schemeUserInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_defaultscheme_user", (String)selectProperties, (QFilter[])filters);
        if (schemeUserInfo != null) {
            String schemeType = schemeUserInfo.getString("scheme.schemetype");
            DynamicObject schemeDyObj = schemeUserInfo.getDynamicObject(SCHEME1);
            Long schemeId = schemeDyObj.getLong("id");
            if (SchemeType.GroupScheme.getValue().equals(schemeType) && formView != null) {
                boolean isOwner = CardUtils.checkCurSchemeOwner(userId, schemeId);
                if (isOwner) {
                    return schemeId;
                }
                List<Long> schemeIds = CardUtils.getShareSchemeIds(userId, formView);
                if (schemeIds != null && schemeIds.contains(schemeId)) {
                    return schemeId;
                }
            } else {
                return schemeId;
            }
        }
        return null;
    }

    private static void addOrUpdateSctheme(Long id, Long userId, Long schemeId, Boolean isAdd) {
        ArrayList<DynamicObject> newDObjs = new ArrayList<DynamicObject>(1);
        DynamicObject newDObj = BusinessDataServiceHelper.newDynamicObject((String)"msbd_defaultscheme_user");
        newDObj.set("user", (Object)userId);
        newDObj.set(SCHEME1, (Object)schemeId);
        if (isAdd.booleanValue()) {
            newDObjs.add(newDObj);
            SaveServiceHelper.save((IDataEntityType)((DynamicObject)newDObjs.get(0)).getDataEntityType(), (Object[])newDObjs.toArray(new Object[0]));
        } else {
            newDObj.set("id", (Object)id);
            newDObjs.add(newDObj);
            SaveServiceHelper.update((DynamicObject)newDObj);
        }
    }
}

