/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mpscmm.msbd.workbench.service.IExecute;

public class IdentifyUtils {
    private static final Log logger = LogFactory.getLog(IdentifyUtils.class);
    public static final String USER_AGREEMENT = "userAgreement";
    public static final String TENANT_AGREEMENT = "tenantAgreement";
    public static final String IS_USER_AGREE = "isUserAgree";
    public static final String IS_TENANT_AGREE = "isTenantAgree";
    public static final String AGREEMENT_TYPE = "agreementType";
    public static final String GAI_PRIVACY_AGREEMENT = "gai_privacy_agreement";
    public static final long GAI_GROUP_ID = 606L;

    public static void executeWithTxNew(IExecute function) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                function.execute();
            }
            catch (Exception e) {
                txHandle.markRollback();
                throw e;
            }
        }
    }

    public static void executeWithCatchException(IExecute function) {
        try {
            function.execute();
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u4e0e\u7ba1\u7406\u5458\u8054\u7cfb\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{0}\u3002", (String)"MpscmmCommonMsg_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[]{e.getMessage()}));
        }
    }

    public static boolean checkGaiPrivacy(IFormView view, IFormPlugin formPlugin) {
        long currUserId = RequestContext.get().getCurrUserId();
        boolean tenantAgree = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPrivacyService", (String)IS_TENANT_AGREE, (Object[])new Object[0]);
        boolean userAgree = (Boolean)DispatchServiceHelper.invokeBizService((String)"ai", (String)"gai", (String)"GaiPrivacyService", (String)IS_USER_AGREE, (Object[])new Object[0]);
        if (!tenantAgree) {
            boolean adminUser = PermissionServiceHelper.isAdminUser((long)currUserId);
            if (adminUser) {
                IdentifyUtils.showGaiPrivacy(view, formPlugin, IS_TENANT_AGREE);
            } else {
                view.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u79df\u6237\u672a\u7b7e\u7f72\u82cd\u7a79GPT\u670d\u52a1\u534f\u8bae\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u7b7e\u7f72\u3002", (String)"ImWorkbenchCardListFormPlugin_2", (String)"scmc-im-formplugin", (Object[])new Object[0]));
            }
        } else if (!userAgree) {
            IdentifyUtils.showGaiPrivacy(view, formPlugin, IS_USER_AGREE);
        }
        return tenantAgree && userAgree;
    }

    private static void showGaiPrivacy(IFormView view, IFormPlugin formPlugin, String privacyType) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(GAI_PRIVACY_AGREEMENT);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        if (IS_USER_AGREE.equals(privacyType)) {
            fsp.setCustomParam(AGREEMENT_TYPE, (Object)USER_AGREEMENT);
            if (formPlugin != null) {
                fsp.setCloseCallBack(new CloseCallBack(formPlugin, USER_AGREEMENT));
            }
        } else if (IS_TENANT_AGREE.equals(privacyType)) {
            fsp.setCustomParam(AGREEMENT_TYPE, (Object)TENANT_AGREEMENT);
            if (formPlugin != null) {
                fsp.setCloseCallBack(new CloseCallBack(formPlugin, TENANT_AGREEMENT));
            }
        }
        view.showForm(fsp);
    }
}

