/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.service.PermissionServiceImpl;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.smc.ManageServiceHelper;

public class PortalUsableFuncUtil {
    private Log logger = null;
    private IFormView view = null;

    public PortalUsableFuncUtil(Log logger) {
        this.logger = logger;
    }

    public PortalUsableFuncUtil(Log logger, IFormView view) {
        this.logger = logger;
        this.view = view;
    }

    public JSONArray getAllAppsInSystem() {
        String portalAppInfo = MetadataDao.getAllPortalAppCache();
        String log = ResManager.loadKDString((String)"\u6574\u4f53\u7f13\u5b58\u540e\u8017\u65f6\uff1a", (String)"PortalUsableFuncUtil_0", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)portalAppInfo)) {
            log = ResManager.loadKDString((String)"\u6574\u4f53\u7f13\u5b58\u524d\u8017\u65f6\uff1a", (String)"PortalUsableFuncUtil_1", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
        }
        long start = System.currentTimeMillis();
        JSONArray allAppsInSystem = BizAppServiceHelp.getAllAppInfo();
        this.logger.warn(log + (double)(System.currentTimeMillis() - start) / 1000.0 + "\u79d2");
        return allAppsInSystem;
    }

    public JSONArray getAppsAfterFilter(JSONArray allApps, Long userId) {
        PermissionServiceImpl permissionService;
        Set appBlackSet;
        if (allApps != null && allApps.size() > 0) {
            this.logger.info("PortalUsableFuncUtil--allApps:" + SerializationUtils.toJsonString((Object)allApps));
        }
        allApps = this.getAvailableApps(allApps);
        this.logger.info("PortalUsableFuncUtil--getAvailableApps:" + SerializationUtils.toJsonString((Object)allApps));
        this.filterByDisabledAppIds(allApps);
        List userBizApps = PermissionServiceHelper.getUserBizApps((Long)userId);
        if (userBizApps == null || userBizApps.size() == 0) {
            if (this.view != null) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u6743\u9650\u5e94\u7528\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5...", (String)"PortalUsableFuncUtil_2", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            }
            return allApps;
        }
        this.logger.info("\u83b7\u53d6\u6709\u6743\u9650\u7684\u5e94\u7528\uff1a" + SerializationUtils.toJsonString((Object)userBizApps));
        String userTypeInContext = RequestContext.get().getUserType();
        if (kd.bos.util.StringUtils.isEmpty((String)userTypeInContext)) {
            if (this.view != null) {
                this.view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7528\u6237\u7c7b\u578b\u5931\u8d25", (String)"PortalUsableFuncUtil_3", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]));
            }
            return allApps;
        }
        String[] userType = userTypeInContext.split(",");
        List<String> userTypeList = Stream.of(userType).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (PermissionServiceHelper.isAdminUser((long)userId) || userId.equals(10L)) {
            userTypeList.add("1");
        }
        boolean isSuperAdmin = PermissionServiceHelper.isAdminUser((long)userId, (String)"10");
        if (userId.equals(10L)) {
            isSuperAdmin = true;
        }
        if (!CollectionUtils.isEmpty(userTypeList)) {
            this.logger.info("\u4eba\u5458\u7c7b\u578b\uff1a" + SerializationUtils.toJsonString(userTypeList));
        }
        if ((appBlackSet = (permissionService = new PermissionServiceImpl()).getAppBlackSet(userId)) != null && appBlackSet.size() > 0) {
            this.logger.info("\u5168\u5458\u5e94\u7528\u9ed1\u540d\u5355\uff1a" + SerializationUtils.toJsonString((Object)appBlackSet));
        }
        List appGroups = AppGroupUtils.getAppGroups((long)userId);
        HashMap<String, HashMap<String, JSONObject>> cloudAppMap = new HashMap<String, HashMap<String, JSONObject>>(20);
        for (String appGroup : appGroups) {
            String cloudAppJsonStr = BizAppServiceHelp.getAppGroupAllAppInfo((String)appGroup);
            JSONArray cloudAppJson = JSONArray.parseArray((String)cloudAppJsonStr);
            for (Object appJson : cloudAppJson) {
                JSONObject jsob = (JSONObject)appJson;
                String id = jsob.getString("cloudid");
                HashMap<String, JSONObject> appMap = (HashMap<String, JSONObject>)cloudAppMap.get(id);
                if (appMap == null) {
                    appMap = new HashMap<String, JSONObject>(20);
                    cloudAppMap.put(id, appMap);
                }
                appMap.put(jsob.getString("id"), jsob);
            }
        }
        this.logger.info("PortalUsableFuncUtil--allGrayApps: " + SerializationUtils.toJsonString(cloudAppMap));
        if (!cloudAppMap.isEmpty()) {
            for (JSONArray cloudAndApp : allApps) {
                Map cloudApp;
                String cloudId = "";
                for (JSONObject cloudOrApp : cloudAndApp) {
                    if (cloudOrApp.get((Object)"iscloud") != null) {
                        cloudId = cloudOrApp.getString("id");
                        continue;
                    }
                    if (cloudOrApp.get((Object)"iscloud") != null) continue;
                    String appId = cloudOrApp.getString("id");
                    String cloudid = cloudOrApp.getString("cloudid");
                    Map appMap = (Map)cloudAppMap.get(cloudid);
                    if (appMap == null) continue;
                    appMap.remove(appId);
                }
                if (!StringUtils.isNotBlank((CharSequence)cloudId) || (cloudApp = (Map)cloudAppMap.get(cloudId)) == null) continue;
                cloudAndApp.addAll(cloudApp.values());
            }
        }
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp;
            cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null) continue;
                String appId = cloudOrApp.getString("id");
                if ((appBlackSet == null || !appBlackSet.contains(appId)) && !this.filterApp(cloudOrApp, false, userBizApps, userTypeList, isSuperAdmin)) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        this.filterAppsByPrivateOrPublicCloud(allApps);
        return allApps;
    }

    private void filterByDisabledAppIds(JSONArray allApps) {
        Set disabledAppIds = ManageServiceHelper.getDisabledAppIds();
        if (CollectionUtils.isEmpty((Collection)disabledAppIds)) {
            return;
        }
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                String appId;
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null || !disabledAppIds.contains(appId = cloudOrApp.getString("id"))) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
    }

    public Set<String> getUserHasPerAppIds() {
        Map<String, String> appIdsWithCloud = this.getHasPerAppIdsWithCloud();
        if (appIdsWithCloud == null || appIdsWithCloud.size() == 0) {
            return null;
        }
        return appIdsWithCloud.keySet();
    }

    public Map<String, String> getHasPerAppIdsWithCloud() {
        JSONArray allApps = this.getAllAppsInSystem();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        if ((allApps = this.getAppsAfterFilter(allApps, userId)) == null || allApps.size() == 0) {
            return null;
        }
        HashMap<String, String> appMaps = new HashMap<String, String>(16);
        for (JSONArray cloudAndApp : allApps) {
            for (JSONObject cloudOrApp : cloudAndApp) {
                String id;
                if (cloudOrApp.get((Object)"iscloud") != null || !StringUtils.isNotBlank((CharSequence)(id = cloudOrApp.getString("id")))) continue;
                String cloudId = cloudOrApp.getString("cloudid");
                appMaps.put(id, cloudId);
            }
        }
        return appMaps;
    }

    public JSONArray getUserHasPerApp() {
        JSONArray allApps = this.getAllAppsInSystem();
        Long userId = Long.parseLong(RequestContext.get().getUserId());
        if ((allApps = this.getAppsAfterFilter(allApps, userId)) == null || allApps.size() == 0) {
            return null;
        }
        return allApps;
    }

    private JSONArray getAvailableApps(JSONArray allApps) {
        boolean onlyShowBuyApp = false;
        try {
            SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
            Object only_show_buy_app = systemParamService.loadPublicParameterFromCache("only_show_buy_app");
            if (only_show_buy_app != null && Boolean.parseBoolean(only_show_buy_app.toString())) {
                onlyShowBuyApp = true;
            }
        }
        catch (Exception e) {
            String errMsg = ResManager.loadKDString((String)"\u83b7\u53d6\u53ea\u663e\u793a\u8d2d\u4e70\u5e94\u7528\u5f00\u5173\u5f02\u5e38,\u9519\u8bef\u4fe1\u606f\uff1a", (String)"PortalUsableFuncUtil_6", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
            this.logger.info(errMsg + e.getMessage());
        }
        if (!onlyShowBuyApp) {
            return allApps;
        }
        Set apps = LicenseServiceHelper.getAvailableApps();
        if (apps == null || apps.size() == 0) {
            this.logger.info("\u6839\u636e\u8bb8\u53ef\u83b7\u53d6\u5e94\u7528\u8fd4\u56de\u4e3a\u7a7a");
            return allApps;
        }
        this.logger.info("\u6839\u636e\u8bb8\u53ef\u83b7\u53d6\u5e94\u7528\uff1a" + apps);
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                String appId;
                String isv;
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null || !"kingdee".equals(isv = cloudOrApp.getString("isv")) || apps.contains(appId = cloudOrApp.getString("id"))) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        return allApps;
    }

    private JSONArray filterAppsByPrivateOrPublicCloud(JSONArray allApps) {
        String pubTenantType = LicenseServiceHelper.getPubTenantType();
        String env = ResManager.loadKDString((String)"\u83b7\u53d6\u73af\u5883\u662f\u516c\u6709\u4e91\u8fd8\u662f\u79c1\u6709\u4e91\uff1a", (String)"PortalUsableFuncUtil_7", (String)"mpscmm-msbd-workbench", (Object[])new Object[0]);
        this.logger.info(env + pubTenantType);
        Iterator iterAllApp = allApps.iterator();
        while (iterAllApp.hasNext()) {
            JSONArray cloudAndApp = (JSONArray)iterAllApp.next();
            Iterator iterCloudAndApp = cloudAndApp.iterator();
            while (iterCloudAndApp.hasNext()) {
                JSONObject cloudOrApp = (JSONObject)iterCloudAndApp.next();
                if (cloudOrApp.get((Object)"iscloud") != null) continue;
                String number = cloudOrApp.getString("number");
                if (Boolean.parseBoolean(pubTenantType) || !"ladder".equals(number)) continue;
                iterCloudAndApp.remove();
            }
            if (cloudAndApp.size() != 1) continue;
            iterAllApp.remove();
        }
        return allApps;
    }

    private boolean filterApp(JSONObject appObject, boolean hasPersonalApps, List<String> userBizApps, List<String> userTypeList, boolean isSuperAdmin) {
        boolean isRemoveApp = false;
        String appId = appObject.getString("id");
        String allUserApp = appObject.getString("alluserapp");
        String userType = appObject.getString("usertype");
        ArrayList<Object> appUserTypeList = new ArrayList(8);
        if (userType != null) {
            String[] appUserType = appObject.getString("usertype").split(",");
            appUserTypeList = new ArrayList<String>(Arrays.asList(appUserType));
        }
        if (isSuperAdmin && allUserApp.equals("true")) {
            isRemoveApp = true;
        }
        if (!(isRemoveApp || userBizApps == null || userBizApps.contains(appId) || allUserApp.equals("true"))) {
            isRemoveApp = true;
        }
        Iterator<Object> iterator = appUserTypeList.iterator();
        while (iterator.hasNext()) {
            String appUserTypeId = (String)iterator.next();
            if (!StringUtils.isEmpty((CharSequence)appUserTypeId)) continue;
            iterator.remove();
        }
        iterator = userTypeList.iterator();
        while (iterator.hasNext()) {
            String userTypeId = (String)iterator.next();
            if (!StringUtils.isEmpty((CharSequence)userTypeId)) continue;
            iterator.remove();
        }
        if (!isRemoveApp && Collections.disjoint(appUserTypeList, userTypeList)) {
            isRemoveApp = true;
        }
        return isRemoveApp;
    }
}

