/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.license.NextCloud;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SHAUtils;
import kd.bos.portal.util.CloudLadderSkipUtils;
import kd.bos.util.HttpClientUtils;

public class UserCenterCardUtil {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_X_WWW_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String ACCESS_TOKEN = "access_token";
    public static final String CLIENT_SECRET = "client_secret";
    public static final String CATEGORY_CODE = "category_code";
    public static final String VISIT_SOURCE = "visit_source";
    public static final String CLIENT_ID = "client_id";
    public static final String INST_CODE = "inst_code";
    private static Log logger = LogFactory.getLog(UserCenterCardUtil.class);
    private static final String method = "sha1";
    private static final String categoryCode = "C05";
    private static final String visitSource = "QD017";
    private static final String searchScope = "searchScope";
    private static final String allowHtml = "true";
    private static final String seriesCode = "";
    private static final int isActivityCard = 1;
    private static final String status = "doing";
    private static ConcurrentHashMap<String, Map<String, Object>> accessTokenMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Integer> accessTokenExpiresMap = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, Long> accessTokenTimeMap = new ConcurrentHashMap();
    private static String clientId = UserCenterCardUtil.getClientId();
    private static String clientSecret = UserCenterCardUtil.getClientSecret();
    private static String userCenterHost = UserCenterCardUtil.getUserCenterHost();

    private static String getClientId() {
        String cloudId = System.getProperty("clientId");
        if (StringUtils.isEmpty((CharSequence)cloudId)) {
            cloudId = NextCloud.CLIENT_ID;
        }
        return cloudId;
    }

    private static String getClientSecret() {
        String clientSecret = System.getProperty("clientSecret");
        if (StringUtils.isEmpty((CharSequence)clientSecret)) {
            clientSecret = NextCloud.CLIENT_SECRET;
        }
        return clientSecret;
    }

    private static String getUserCenterHost() {
        String cloudUrl = System.getProperty("url");
        if (StringUtils.isEmpty((CharSequence)cloudUrl)) {
            cloudUrl = NextCloud.CLOUD_URL;
        } else if (!cloudUrl.endsWith("/")) {
            cloudUrl = cloudUrl + '/';
        }
        return cloudUrl;
    }

    public static Map<String, Object> getUserCenterAccessToken() {
        String prodInstCode = CloudLadderSkipUtils.getProdInstCode();
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)clientSecret)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)prodInstCode)) {
            return Collections.emptyMap();
        }
        if (StringUtils.isBlank((CharSequence)userCenterHost)) {
            return Collections.emptyMap();
        }
        RequestContext requestContext = RequestContext.get();
        if (Objects.isNull(requestContext)) {
            return Collections.emptyMap();
        }
        String uid = requestContext.getUid();
        String key = clientId + uid;
        Integer accessTokenExpires = accessTokenExpiresMap.get(key);
        Long accessTokenTime = accessTokenTimeMap.get(key);
        if (Objects.isNull(accessTokenExpires)) {
            accessTokenExpires = 0;
        }
        if (Objects.isNull(accessTokenTime)) {
            accessTokenTime = 0L;
        }
        long currentTime = System.currentTimeMillis();
        if (!accessTokenMap.isEmpty() && currentTime - accessTokenTime < (long)(accessTokenExpires * 1000)) {
            return accessTokenMap.get(key);
        }
        String timestamp = String.valueOf(System.currentTimeMillis());
        StringBuilder sb = new StringBuilder(clientId);
        sb.append(clientSecret).append(uid).append(prodInstCode).append(timestamp);
        String signature = SHAUtils.sha((String[])new String[]{sb.toString()});
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put(CONTENT_TYPE, APPLICATION_X_WWW_FORM_URLENCODED);
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put(CLIENT_ID, clientId);
        mpBody.put("uid", uid);
        mpBody.put("prod_inst_code", prodInstCode);
        mpBody.put("timestamp", timestamp);
        mpBody.put("method", method);
        mpBody.put("signiture", signature);
        String sURL = userCenterHost + "clouderp/access_token";
        String accessTokenInfo = seriesCode;
        try {
            accessTokenInfo = HttpClientUtils.get((String)sURL, mpHeader, mpBody);
        }
        catch (Exception var20) {
            logger.error("UserCenterCardUtil.getUserCenterAccessToken:", (Throwable)var20);
            return Collections.emptyMap();
        }
        if (StringUtils.isEmpty((CharSequence)accessTokenInfo)) {
            return Collections.emptyMap();
        }
        JSONObject userCenterAccessTokenInfo = null;
        try {
            userCenterAccessTokenInfo = JSON.parseObject((String)accessTokenInfo);
        }
        catch (Exception var19) {
            logger.error("UserCenterCardUtil.getUserCenterAccessToken.cast", (Throwable)var19);
            return Collections.emptyMap();
        }
        Map data = (Map)userCenterAccessTokenInfo.get((Object)"data");
        if (!Objects.isNull(data) && !data.isEmpty()) {
            if (Objects.nonNull(data.get(ACCESS_TOKEN)) && Objects.nonNull(data.get("expires_in"))) {
                accessTokenMap.put(key, (Map<String, Object>)userCenterAccessTokenInfo);
                accessTokenExpiresMap.put(key, (Integer)data.get("expires_in"));
                accessTokenTimeMap.put(key, System.currentTimeMillis());
            }
            return userCenterAccessTokenInfo;
        }
        return userCenterAccessTokenInfo;
    }

    public static Map<String, Object> getUserCenterCardInfo() {
        clientId = UserCenterCardUtil.getClientId();
        clientSecret = UserCenterCardUtil.getClientSecret();
        userCenterHost = UserCenterCardUtil.getUserCenterHost();
        Map<String, Object> accessTokenMap = UserCenterCardUtil.getUserCenterAccessToken();
        Map dataAcessToken = (Map)accessTokenMap.get("data");
        String accessToken = (String)dataAcessToken.get(ACCESS_TOKEN);
        String sURL = userCenterHost + "clouduser/config";
        String userCenterCardInfoRespStr = seriesCode;
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put(CONTENT_TYPE, APPLICATION_X_WWW_FORM_URLENCODED);
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put(CLIENT_ID, clientId);
        mpBody.put(CLIENT_SECRET, clientSecret);
        mpBody.put(ACCESS_TOKEN, accessToken);
        Map<String, Object> userCenterCardInfoResp = new HashMap<String, Object>();
        try {
            userCenterCardInfoRespStr = HttpClientUtils.get((String)sURL, mpHeader, mpBody);
            logger.info(String.format("getUserCenterCardInfo.userCenterCardInfoRespStr:%s", userCenterCardInfoRespStr));
            userCenterCardInfoResp = (Map)JSON.parseObject((String)userCenterCardInfoRespStr, Map.class);
        }
        catch (Exception e) {
            logger.error("getUserCenterCardInfo.error: ", (Throwable)e);
            return userCenterCardInfoResp;
        }
        return userCenterCardInfoResp;
    }

    public static Map<String, Object> getUserCenterCourse() {
        Map<String, Object> accessTokenMap = UserCenterCardUtil.getUserCenterAccessToken();
        if (Objects.isNull(accessTokenMap)) {
            return null;
        }
        Map dataAcessToken = (Map)accessTokenMap.get("data");
        if (Objects.isNull(dataAcessToken)) {
            return null;
        }
        String prodInstCode = CloudLadderSkipUtils.getProdInstCode();
        String accessToken = (String)dataAcessToken.get(ACCESS_TOKEN);
        String sURL = userCenterHost + "clouduser/course";
        String userCenterCardCourseRespStr = seriesCode;
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put(CONTENT_TYPE, APPLICATION_X_WWW_FORM_URLENCODED);
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put(CLIENT_ID, clientId);
        mpBody.put(CLIENT_SECRET, clientSecret);
        mpBody.put(ACCESS_TOKEN, accessToken);
        mpBody.put(CATEGORY_CODE, categoryCode);
        mpBody.put(INST_CODE, prodInstCode);
        mpBody.put(VISIT_SOURCE, visitSource);
        Map<String, Object> userCenterCardCourseResp = new HashMap<String, Object>();
        try {
            userCenterCardCourseRespStr = HttpClientUtils.get((String)sURL, mpHeader, mpBody);
            userCenterCardCourseResp = (Map)JSON.parseObject((String)userCenterCardCourseRespStr, Map.class);
            logger.info(String.format("getUserCenterCourse.userCenterCardCourseResp:%s", userCenterCardCourseResp));
        }
        catch (Exception e) {
            logger.error("getUserCenterKnowledge.error: ", (Throwable)e);
            return userCenterCardCourseResp;
        }
        return userCenterCardCourseResp;
    }

    public static Map<String, Object> getUserCenterKnowledge() {
        Map<String, Object> accessTokenMap = UserCenterCardUtil.getUserCenterAccessToken();
        if (Objects.isNull(accessTokenMap)) {
            return null;
        }
        Map dataAcessToken = (Map)accessTokenMap.get("data");
        if (Objects.isNull(dataAcessToken)) {
            return null;
        }
        String prodInstCode = CloudLadderSkipUtils.getProdInstCode();
        String accessToken = (String)dataAcessToken.get(ACCESS_TOKEN);
        String sURL = userCenterHost + "clouduser/knowledge";
        String userCenterCardKnowledgeRespStr = seriesCode;
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put(CONTENT_TYPE, APPLICATION_X_WWW_FORM_URLENCODED);
        HashMap<String, String> mpBody = new HashMap<String, String>();
        mpBody.put(CLIENT_ID, clientId);
        mpBody.put(CLIENT_SECRET, clientSecret);
        mpBody.put(ACCESS_TOKEN, accessToken);
        mpBody.put(CATEGORY_CODE, categoryCode);
        mpBody.put(VISIT_SOURCE, visitSource);
        mpBody.put(INST_CODE, prodInstCode);
        mpBody.put(searchScope, searchScope);
        mpBody.put("allowHtml", allowHtml);
        Map<String, Object> userCenterCardKnowledgeResp = new HashMap<String, Object>();
        try {
            userCenterCardKnowledgeRespStr = HttpClientUtils.get((String)sURL, mpHeader, mpBody);
            userCenterCardKnowledgeResp = (Map)JSON.parseObject((String)userCenterCardKnowledgeRespStr, Map.class);
        }
        catch (Exception e) {
            logger.error("getUserCenterKnowledge.error: ", (Throwable)e);
            return userCenterCardKnowledgeResp;
        }
        return userCenterCardKnowledgeResp;
    }

    public static Map<String, Object> getUsercenterActivity() {
        Map<String, Object> accessTokenMap = UserCenterCardUtil.getUserCenterAccessToken();
        if (Objects.isNull(accessTokenMap)) {
            return null;
        }
        Map dataAcessToken = (Map)accessTokenMap.get("data");
        if (Objects.isNull(dataAcessToken)) {
            return null;
        }
        String prodInstCode = CloudLadderSkipUtils.getProdInstCode();
        String accessToken = (String)dataAcessToken.get(ACCESS_TOKEN);
        String sURL = userCenterHost + "clouduser/activity";
        String userCenterCardActivityRespStr = seriesCode;
        HashMap<String, String> mpHeader = new HashMap<String, String>();
        mpHeader.put(CONTENT_TYPE, APPLICATION_X_WWW_FORM_URLENCODED);
        HashMap<String, Object> mpBody = new HashMap<String, Object>();
        mpBody.put(CLIENT_ID, clientId);
        mpBody.put(CLIENT_SECRET, clientSecret);
        mpBody.put(ACCESS_TOKEN, accessToken);
        mpBody.put(CATEGORY_CODE, categoryCode);
        mpBody.put(VISIT_SOURCE, visitSource);
        mpBody.put("isActivityCard", 1);
        mpBody.put("status", status);
        mpBody.put(INST_CODE, prodInstCode);
        Map<String, Object> userCenterCardActivityResp = new HashMap<String, Object>();
        try {
            userCenterCardActivityRespStr = HttpClientUtils.get((String)sURL, mpHeader, mpBody);
            userCenterCardActivityResp = (Map)JSON.parseObject((String)userCenterCardActivityRespStr, Map.class);
        }
        catch (Exception e) {
            logger.error("getUserCenterActivity.error: ", (Throwable)e);
            return userCenterCardActivityResp;
        }
        return userCenterCardActivityResp;
    }

    public static Map<String, Object> getUsercenterMsgList(String cardType) {
        clientId = UserCenterCardUtil.getClientId();
        clientSecret = UserCenterCardUtil.getClientSecret();
        userCenterHost = UserCenterCardUtil.getUserCenterHost();
        Map<String, Object> usercenterRespMap = null;
        switch (cardType) {
            case "index_courses": {
                usercenterRespMap = UserCenterCardUtil.getUserCenterCourse();
                break;
            }
            case "index_activity": {
                usercenterRespMap = UserCenterCardUtil.getUsercenterActivity();
                break;
            }
            case "index_knowledge": {
                usercenterRespMap = UserCenterCardUtil.getUserCenterKnowledge();
                break;
            }
        }
        return usercenterRespMap;
    }
}

