/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.workbench.util;

import com.alibaba.fastjson.JSONArray;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.DBVersion;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.SecurityUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.FileUtils;

public class WorkBenchSchemeUtil {
    public static final String KDPKGS_XML = "kdpkgs.xml";
    public static final String ERROR_INFO_TXT = "errorInfo.txt";
    public static final String APP_INFO_XML = "appInfo.xml";
    public static final String RESOURCE = "resource";
    public static final String CUSTOM = "custom";
    public static final String UPLOADSOURCE = "uploadsource";
    public static final String JSON = ".json";
    private static Log logger = LogFactory.getLog(WorkBenchSchemeUtil.class);
    public static final String ERROR = "ERROR";
    private static final String SPACE = "   ";

    public static List<String> recursiveFiles(String path, List<String> fileList) {
        logger.info("|recursiveFiles.path:" + path);
        String checkPath = WorkBenchSchemeUtil.getCheckedFilePath(path);
        checkPath = FileUtils.checkFileUrl((String)checkPath);
        File file = new File(checkPath);
        File[] files = file.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        for (File f : files) {
            if (f.isDirectory()) {
                WorkBenchSchemeUtil.recursiveFiles(f.getAbsolutePath(), fileList);
                continue;
            }
            if (!f.isFile()) continue;
            fileList.add(f.getAbsolutePath());
        }
        return fileList;
    }

    public static void zipFiles(List<String> zipNames, String zipPath, String defaultAppPackageName) {
        String staticResourcePath;
        File staticResourceFile;
        String customResourcePath;
        File customResourceFile;
        String appInfo;
        File appInfoFile;
        String errorLog;
        File errorLogFile;
        JSONArray files = new JSONArray();
        String packageXML = zipPath + File.separator + KDPKGS_XML;
        File packageXMLFile = new File(SecurityUtils.normalize((String)packageXML));
        if (packageXMLFile.exists()) {
            files.add((Object)packageXML);
        }
        if ((errorLogFile = new File(SecurityUtils.normalize((String)(errorLog = zipPath + File.separator + ERROR_INFO_TXT)))).exists()) {
            files.add((Object)errorLog);
        }
        if ((appInfoFile = new File(SecurityUtils.normalize((String)(appInfo = zipPath + File.separator + APP_INFO_XML)))).exists()) {
            files.add((Object)appInfo);
        }
        for (String zipName : zipNames) {
            String zipAppPath = zipPath + File.separator + "dm" + File.separator + zipName + ".zip";
            File zipAppFile = new File(SecurityUtils.normalize((String)zipAppPath));
            if (!zipAppFile.exists()) continue;
            files.add((Object)zipAppPath);
        }
        String libPath = zipPath + File.separator + "jar";
        File libFile = new File(SecurityUtils.normalize((String)libPath));
        if (libFile.exists()) {
            files.add((Object)libPath);
        }
        if ((customResourceFile = new File(SecurityUtils.normalize((String)(customResourcePath = zipPath + File.separator + RESOURCE + File.separator + CUSTOM)))).exists()) {
            files.add((Object)customResourcePath);
        }
        if ((staticResourceFile = new File(SecurityUtils.normalize((String)(staticResourcePath = zipPath + File.separator + RESOURCE + File.separator + UPLOADSOURCE)))).exists()) {
            files.add((Object)staticResourcePath);
        }
        File zipFile = new File(SecurityUtils.normalize((String)(zipPath + File.separator + defaultAppPackageName + ".zip")));
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            WorkBenchSchemeUtil.zipPatchFile(files, out, zipNames);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void zipFile(JSONArray files, ZipOutputStream out, String pathSign) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File(WorkBenchSchemeUtil.getCheckedFilePath((String)files.get(i)));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    tempFiles.add((Object)tempFile.getAbsolutePath());
                }
                WorkBenchSchemeUtil.zipFile(tempFiles, out, pathSign);
                continue;
            }
            String path = file.getAbsolutePath();
            String fileName = file.getName();
            int t = -1;
            if (path.contains("datamodel")) {
                t = path.indexOf("datamodel");
            }
            if (path.contains("jar") && path.endsWith(".zip") && !fileName.contains("jar")) {
                t = path.indexOf("jar");
            }
            if (StringUtils.isNotBlank((CharSequence)pathSign)) {
                if (path.contains(pathSign) && !path.contains(JSON)) {
                    t = path.indexOf("webapp");
                } else if (path.contains(JSON)) {
                    t = path.indexOf(pathSign);
                }
            } else if ((path.contains(CUSTOM) || path.contains(UPLOADSOURCE)) && path.endsWith(".zip") && !fileName.contains(CUSTOM) && !fileName.contains(UPLOADSOURCE)) {
                t = path.indexOf(RESOURCE);
            }
            if (t == -1) continue;
            if ((path = path.endsWith(JSON) ? path.substring(t + pathSign.length() + 1, path.length()) : path.substring(t, path.length())).contains("\\")) {
                path = path.replace("\\", "/");
            }
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    private static void zipPatchFile(JSONArray files, ZipOutputStream out, List<String> zipNames) {
        for (int i = 0; i < files.size(); ++i) {
            File file = new File(WorkBenchSchemeUtil.getCheckedFilePath((String)files.get(i)));
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                JSONArray tempFiles = new JSONArray();
                for (File tempFile : listFiles) {
                    tempFiles.add((Object)tempFile.getAbsolutePath());
                }
                WorkBenchSchemeUtil.zipFile(tempFiles, out, "");
                continue;
            }
            String path = file.getAbsolutePath();
            int t = -1;
            if (path.contains(KDPKGS_XML)) {
                t = path.indexOf(KDPKGS_XML);
            }
            if (path.contains(ERROR_INFO_TXT)) {
                t = path.indexOf(ERROR_INFO_TXT);
            }
            if (path.contains(APP_INFO_XML)) {
                t = path.indexOf(APP_INFO_XML);
            }
            if (path.endsWith(".zip")) {
                for (String zipName : zipNames) {
                    if (!path.endsWith(zipName + ".zip")) continue;
                    t = path.indexOf(zipName + ".zip");
                }
            }
            if (t == -1) continue;
            path = path.endsWith(".zip") ? path.substring(t - 3, path.length()) : path.substring(t, path.length());
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                ZipEntry entry = new ZipEntry(path);
                entry.setMethod(8);
                out.putNextEntry(entry);
                int n = 0;
                byte[] buf = new byte[1024];
                while ((n = in.read(buf)) != -1) {
                    out.write(buf, 0, n);
                }
                out.closeEntry();
                continue;
            }
            catch (Exception exception) {
                throw new KDBizException(exception.getMessage());
            }
        }
    }

    public static String getAppVerion(String appNum) {
        String version = DBVersion.getVer();
        if (StringUtils.isNotBlank((CharSequence)appNum)) {
            String appVer;
            QFilter filter = new QFilter("number", "=", (Object)appNum);
            if (QueryServiceHelper.exists((String)"bos_devportal_bizapp", (QFilter[])new QFilter[]{filter})) {
                version = "";
            }
            if (StringUtils.isNotBlank((CharSequence)(appVer = DBVersion.getAppVer((String)appNum)))) {
                version = appVer;
            }
        }
        return version;
    }

    public static String getCheckedFilePath(String path) {
        return path.replace("../", "#");
    }

    public static Boolean isIgnoreSql() {
        Boolean isIgnoreSql = Boolean.FALSE;
        try {
            Object object = SystemParamServiceHelper.loadPublicParameterFromCache((String)"ignoresql");
            if (object != null) {
                isIgnoreSql = Boolean.parseBoolean(object.toString());
            }
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u5c4f\u853dsql\u5bfc\u5165\u53c2\u6570\u529f\u80fd\u5f02\u5e38\uff1a" + e.getMessage());
        }
        return isIgnoreSql;
    }
}

