/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceSourceKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlStrategeColl;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceControlCompareEntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceControlMappingEntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceControlSchemeConst;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceControlSortEntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceControlStrEntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceControlStrategyEntryConst;

public class PriceControlHelper {
    private static final Log LOGGER = LogFactory.getLog(PriceControlHelper.class);
    private static final String HEADER = "header";
    private static final String ENTRY = "entry";
    private static final String RESULT = "result";

    public static boolean existScheme(String controlEntity, Map<String, Object> param) {
        QFilter totalFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter controlEntityFilter = new QFilter("controlentity", "=", (Object)controlEntity);
        totalFilter.and(statusFilter).and(enableFilter).and(controlEntityFilter);
        return QueryServiceHelper.exists((String)"msbd_pricecontrolscheme", (QFilter[])new QFilter[]{totalFilter});
    }

    public static PriceControlStrategeColl fetchSchemeFromST(String controlEntity, Map<String, Object> param) {
        QFilter totalFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        totalFilter.and(statusFilter).and(enableFilter);
        return PriceControlHelper.getPriceControlStrategeColl(controlEntity, totalFilter, param);
    }

    public static PriceControlStrategeColl fetchSchemeFromST(Long orgID, String controlEntity, Map<String, Object> param) {
        QFilter totalFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        String queryEntity = "msbd_pricecontrolstrategy";
        if (param != null && param.get("appnum") != null) {
            String appNum = (String)param.get("appnum");
            queryEntity = queryEntity.replace("msbd", appNum).trim();
        }
        QFilter orgIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)queryEntity, (Long)orgID);
        totalFilter.and(orgIdFilter);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        totalFilter.and(statusFilter).and(enableFilter);
        return PriceControlHelper.getPriceControlStrategeColl(controlEntity, totalFilter, param);
    }

    private static PriceControlStrategeColl getPriceControlStrategeColl(String controlEntity, QFilter totalFilter, Map<String, Object> param) {
        String queryEntity = "msbd_pricecontrolstrategy";
        if (param != null && param.get("appnum") != null) {
            String appID = (String)param.get("appnum");
            queryEntity = queryEntity.replace("msbd", appID).trim();
        }
        PriceControlStrategeColl priceControlStrategeColl = new PriceControlStrategeColl();
        String selecties = new StringBuffer("id,").append("createorg").append(",").append(new StringBuffer(String.join((CharSequence)",", PriceControlStrategyEntryConst.getEntrySelectorList()))).toString();
        DynamicObject[] strategys = BusinessDataServiceHelper.load((String)queryEntity, (String)selecties, (QFilter[])new QFilter[]{totalFilter}, (String)"number");
        if (strategys.length != 0) {
            for (int t = 0; t < strategys.length; ++t) {
                ArrayList<Object> schemePKs = new ArrayList<Object>(16);
                ArrayList<Object> priceControlStrategySeqInfos = new ArrayList<Object>(16);
                DynamicObject strategy = strategys[t];
                PriceControlSchemeColl priceControlSchemeColl = new PriceControlSchemeColl();
                priceControlSchemeColl.setPriceControlStratege(strategy);
                DynamicObjectCollection entrys = strategy.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject priceControlScheme = ((DynamicObject)entrys.get(i)).getDynamicObject("pricecontrolscheme");
                    if (priceControlScheme == null || !controlEntity.equals(priceControlScheme.getDynamicObject("controlentity").getPkValue())) continue;
                    schemePKs.add(priceControlScheme.getPkValue());
                    priceControlStrategySeqInfos.add(entrys.get(i));
                }
                if (schemePKs.size() <= 0) continue;
                StringBuilder props = new StringBuilder(String.join((CharSequence)",", PriceControlSchemeConst.getSelectorList()));
                StringBuilder controlStrEntryProps = new StringBuilder(String.join((CharSequence)",", PriceControlStrEntryConst.getSelectorList()));
                StringBuilder mappingEntryProps = new StringBuilder(String.join((CharSequence)",", PriceControlMappingEntryConst.getSelectorList()));
                StringBuilder conpareEntryProps = new StringBuilder(String.join((CharSequence)",", PriceControlCompareEntryConst.getSelectorList()));
                StringBuilder sortEntryProps = new StringBuilder(String.join((CharSequence)",", PriceControlSortEntryConst.getSelectorList()));
                String selector = props.append(',').append((CharSequence)controlStrEntryProps).append(',').append((CharSequence)mappingEntryProps).append(',').append((CharSequence)conpareEntryProps).append(',').append((CharSequence)sortEntryProps).toString();
                QFilter schemeStatusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                QFilter schemeEnableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
                QFilter schemeIDFilter = new QFilter("id", "in", schemePKs);
                Map schemeMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_pricecontrolscheme", (String)selector, (QFilter[])new QFilter[]{schemeStatusFilter, schemeEnableFilter, schemeIDFilter});
                for (int s = 0; s < schemePKs.size(); ++s) {
                    Object pk = schemePKs.get(s);
                    if (schemeMap.get(pk) == null) continue;
                    DynamicObject scheme = (DynamicObject)schemeMap.get(pk);
                    ((DynamicObject)priceControlStrategySeqInfos.get(s)).set("pricecontrolscheme", (Object)scheme);
                    priceControlSchemeColl.applyScheme((DynamicObject)priceControlStrategySeqInfos.get(s));
                }
                if (priceControlSchemeColl.getPriceControlSchemeInfos().size() <= 0) continue;
                priceControlStrategeColl.getSchemeCollMapping().put(strategy.getPkValue(), priceControlSchemeColl);
                priceControlStrategeColl.getPriceControlStrateges().add(strategy);
            }
        } else {
            return null;
        }
        return priceControlStrategeColl;
    }

    public static PriceEntityKeyInfo getQuoteCommonConst(String entityType, PriceControlStrategeColl strategeColl) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map entryTypeMap = headType.getAllEntities();
        List<String> dimensions = strategeColl.mergeDimension();
        ArrayList<String> quoteResultSet = new ArrayList<String>();
        String allStr = String.join((CharSequence)",", dimensions);
        PriceEntityKeyInfo qccInfo = new PriceEntityKeyInfo(entityType);
        ArrayList<String> entryNames = new ArrayList<String>();
        entryTypeMap.forEach((k, v) -> {
            if (allStr.contains(v.getName())) {
                qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                qccInfo.setLEFT_BILLENTRY_ID(qccInfo.getEntryIDAlias());
                qccInfo.setLEFT_SEQ(qccInfo.getEntrySeqAlias());
                qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                qccInfo.setEntryName(v.getName());
            }
            entryNames.add(v.getName());
        });
        if (qccInfo.getEntryCount() > 1) {
            String message = ResManager.loadKDString((String)"\u9650\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u914d\u7f6e\u4e86\u8d85\u8fc71\u4e2a\u9650\u4ef7\u5206\u5f55\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u591a\u5206\u5f55\u9650\u4ef7\u3002", (String)"PriceControlHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        boolean hasHeadPriceFiled = PriceControlHelper.hasHeadPriceField(quoteResultSet, entryNames);
        qccInfo.setHeadPriceField(hasHeadPriceFiled);
        qccInfo.setHasTable(kd.bos.util.StringUtils.isNotEmpty((String)headType.getAlias()));
        return qccInfo;
    }

    public static PriceSourceKeyInfo getSrcCommonConst(PriceControlSchemeInfo priceControlSchemeInfo) {
        String srcType = priceControlSchemeInfo.getPriceControlScheme().getDynamicObject("controlsource").getString("number");
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)srcType);
        Map entryTypeMap = headType.getAllEntities();
        String allStr = String.join((CharSequence)",", priceControlSchemeInfo.getCompareSourceFields());
        PriceSourceKeyInfo qccInfo = new PriceSourceKeyInfo();
        if (headType instanceof BasedataEntityType) {
            if (headType.getAllFields().containsKey("number")) {
                if (StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)headType.getAllFields().get("number")).getAlias())) {
                    qccInfo.setBILLNO("number");
                } else {
                    qccInfo.setBILLNO(null);
                }
            } else {
                qccInfo.setBILLNO(null);
            }
        } else if (headType instanceof BillEntityType) {
            if (headType.getAllFields().containsKey("billno")) {
                if (StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)headType.getAllFields().get("billno")).getAlias())) {
                    qccInfo.setBILLNO("billno");
                } else {
                    qccInfo.setBILLNO(null);
                }
            } else {
                qccInfo.setBILLNO(null);
            }
        } else {
            qccInfo.setBILLNO(null);
        }
        ArrayList entryNames = new ArrayList();
        entryTypeMap.forEach((k, v) -> {
            if (allStr.contains(v.getName())) {
                qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                qccInfo.setEntryName(v.getName());
            }
            entryNames.add(v.getName());
        });
        return qccInfo;
    }

    public static Map<String, Object> getHeaderAndEntryKeysWithFlag(PriceControlStrategeColl strategeColl, PriceEntityKeyInfo qccInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        List<String> dimensions = strategeColl.mergeDimension();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerProperties = new ArrayList<String>();
        if (qccInfo.getEntryCount() == 0) {
            headerProperties.add(qccInfo.getHeadIDField());
            headerProperties.addAll(dimensions);
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        } else {
            headerProperties.add(qccInfo.getHeadIDField());
            entryProperties.addAll(qccInfo.getEntryIDField());
            for (int i = 0; i < dimensions.size(); ++i) {
                String dimension = dimensions.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)dimension)) continue;
                if (dimensions.get(i).contains(qccInfo.getEntryName())) {
                    entryProperties.add(dimension);
                    continue;
                }
                headerProperties.add(dimension);
            }
            map.put(HEADER, headerProperties);
            map.put(ENTRY, entryProperties);
        }
        map.put("success", Boolean.TRUE);
        return map;
    }

    public static DataSet buildQuoteDataSetByMap(List<Map<String, Object>> entryMapList, String entityType, PriceControlStrategeColl quoteStrategeColl, PriceEntityKeyInfo qccInfo) {
        if (entryMapList != null && entryMapList.size() != 0) {
            List<String> dimensions = quoteStrategeColl.mergeDimension();
            List<String> alias = quoteStrategeColl.mergeAlias();
            return DataSetHelper.toDataSetByMap(entryMapList, entityType, dimensions, alias, qccInfo);
        }
        String message = ResManager.loadKDString((String)"\u672a\u5411\u9650\u4ef7\u670d\u52a1\u63a5\u53e3\u4f20\u9012\u9650\u4ef7\u5355\u636e\u4fe1\u606f\u3002", (String)"PriceControlHelper_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        throw new KDBizException(message);
    }

    private static boolean hasHeadPriceField(List<String> results, List<String> entryNames) {
        int countEntryPrice = 0;
        block0: for (String resultField : results) {
            for (String entryName : entryNames) {
                if (!resultField.contains(entryName)) continue;
                ++countEntryPrice;
                continue block0;
            }
        }
        return countEntryPrice != results.size();
    }
}

