/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper.advanceprice;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;

public class AdvancedPricingHelper {
    public static String getConditionExprDesc(String filterJson) {
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)filterJson, CRCondition.class);
        String exprDesc = condition.getExprDesc();
        return exprDesc;
    }

    public static String getPriceListFilterJson() {
        String chineseChar = AdvancedPricingHelper.getPriceListChineseChar();
        String priceListFilterJson = "{\"expression\":\"\",\"exprTran\":\"" + chineseChar + "\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2WIFSEZ11I4/\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2WIFSEZ11IT9\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2WIFSEZ11I40\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2WIFSEZ11IT=\",\"value\":\"1\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2WIFSEZ11I4/\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"status\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2WIFSEZ11IT9\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"2WIFSEZ11I40\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"enable\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2WIFSEZ11IT=\\\",\\\"value\\\":\\\"1\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"" + chineseChar + "\"},\"exprDesc\":\"" + chineseChar + "\"}";
        return priceListFilterJson;
    }

    public static String getPriceListChineseChar() {
        return ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838   and    \u4f7f\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528", (String)"AdvancedPricingHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
    }

    public static String getContractFilterJson() {
        String chineseChar = AdvancedPricingHelper.getContractChineseChar();
        String contractFilterJson = "{\"expression\":\"\",\"exprTran\":\"" + chineseChar + "\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2WIHQPDNHP67\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2WIHQPDNHOHZ\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"2WIHQPDNHP68\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2WIHQPDNHOI+\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"2WIHQPDNHP69\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"validstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2WIHQPDNHOI/\",\"value\":\"B\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2WIHQPDNHP67\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"rowclosestatus\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2WIHQPDNHOHZ\\\",\\\"value\\\":\\\"A\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"2WIHQPDNHP68\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"billstatus\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2WIHQPDNHOI+\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]},{\\\"id\\\":\\\"2WIHQPDNHP69\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"validstatus\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2WIHQPDNHOI/\\\",\\\"value\\\":\\\"B\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"" + chineseChar + "\"},\"exprDesc\":\"" + chineseChar + "\"}";
        return contractFilterJson;
    }

    public static String getContractChineseChar() {
        return ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u884c\u5173\u95ed\u72b6\u6001 \u7b49\u4e8e \u6b63\u5e38   and    \u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838   and    \u751f\u6548\u72b6\u6001 \u7b49\u4e8e \u5df2\u751f\u6548", (String)"AdvancedPricingHelper_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
    }

    public static String getBaseDataFilterJson() {
        String chineseChar = AdvancedPricingHelper.getBaseDataChineseChar();
        String baseDataFilterJson = "{\"expression\":\"\",\"exprTran\":\"" + chineseChar + "\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2X5=U3XWJ2CE\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2X5=U3XWIPJS\",\"value\":\"1\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2X5=U3XWJ2CE\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"enable\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2X5=U3XWIPJS\\\",\\\"value\\\":\\\"1\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"" + chineseChar + "\"},\"exprDesc\":\"" + chineseChar + "\"}";
        return baseDataFilterJson;
    }

    public static String getBaseDataChineseChar() {
        return ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001 \u7b49\u4e8e \u53ef\u7528", (String)"AdvancedPricingHelper_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
    }

    public static String getBillFilterJson() {
        String chineseChar = AdvancedPricingHelper.getBillChineseChar();
        String billFilterJson = "{\"expression\":\"\",\"exprTran\":\"" + chineseChar + "\",\"description\":{\"zh_CN\":\"\"},\"filterCondition\":{\"filterRow\":[{\"id\":\"2X5ACG3UKG9U\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"2X5ACG3UK2G6\",\"value\":\"C\"}],\"baseDataIds\":[]}],\"forList\":false},\"filterString\":\"{\\\"filterRow\\\":[{\\\"id\\\":\\\"2X5ACG3UKG9U\\\",\\\"leftBracket\\\":\\\"\\\",\\\"compareType\\\":\\\"105\\\",\\\"fieldName\\\":\\\"billstatus\\\",\\\"rightBracket\\\":\\\"\\\",\\\"logic\\\":\\\"0\\\",\\\"value\\\":[{\\\"id\\\":\\\"2X5ACG3UK2G6\\\",\\\"value\\\":\\\"C\\\"}],\\\"baseDataIds\\\":[]}],\\\"forList\\\":false}\",\"initialized\":false,\"localeExprTran\":{\"zh_CN\":\"" + chineseChar + "\"},\"exprDesc\":\"" + chineseChar + "\"}";
        return billFilterJson;
    }

    public static String getBillChineseChar() {
        return ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001 \u7b49\u4e8e \u5df2\u5ba1\u6838", (String)"AdvancedPricingHelper_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
    }

    public static String subEntryField(String fieldKey, MainEntityType mainType) {
        if (mainType == null) {
            return fieldKey;
        }
        IDataEntityProperty property = DataSetHelper.findPropertys((EntityType)mainType, fieldKey);
        if (property != null) {
            return property.getName();
        }
        return null;
    }

    public static String getEntryFullField(MainEntityType tgtMainType, String fieldId, String srcBillId, String parentName) {
        while (!srcBillId.equals(parentName)) {
            fieldId = parentName.concat(".").concat(fieldId);
            IDataEntityProperty parentProp = tgtMainType.findProperty(parentName);
            if (parentProp.getParent() == null) break;
            parentName = parentProp.getParent().getName();
        }
        return fieldId;
    }

    public static boolean checkEngLetter(String number) {
        String eng = "[0-9A-Za-z_]*";
        Pattern pattern = Pattern.compile(eng);
        Matcher matcher = pattern.matcher(number);
        return matcher.matches();
    }

    public static String getRange(BigDecimal min, BigDecimal max) {
        return String.format("[%s,%s]", min, max);
    }

    public static boolean checkRange(BigDecimal min, BigDecimal max, BigDecimal price) {
        boolean minMatched = price.compareTo(min) >= 0;
        boolean maxMatched = price.compareTo(max) <= 0;
        return minMatched && maxMatched;
    }

    public static BigDecimal getFieldPropertyMin(IDataEntityProperty property) {
        if (property instanceof PriceProp) {
            return ((PriceProp)property).getMin();
        }
        if (property instanceof AmountProp) {
            return ((AmountProp)property).getMin();
        }
        if (property instanceof BigIntProp) {
            return ((BigIntProp)property).getMin();
        }
        if (property instanceof IntegerProp) {
            return ((IntegerProp)property).getMin();
        }
        if (property instanceof QtyProp) {
            return ((QtyProp)property).getMin();
        }
        if (property instanceof DecimalProp) {
            return ((DecimalProp)property).getMin();
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getFieldPropertyMax(IDataEntityProperty property) {
        if (property instanceof PriceProp) {
            return ((PriceProp)property).getMax();
        }
        if (property instanceof AmountProp) {
            return ((AmountProp)property).getMax();
        }
        if (property instanceof BigIntProp) {
            return ((BigIntProp)property).getMax();
        }
        if (property instanceof IntegerProp) {
            return ((IntegerProp)property).getMax();
        }
        if (property instanceof QtyProp) {
            return ((QtyProp)property).getMax();
        }
        if (property instanceof DecimalProp) {
            return ((DecimalProp)property).getMax();
        }
        return BigDecimal.ZERO;
    }
}

