/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper.quote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.common.enums.EnableStatusEnum;
import kd.mpscmm.msbd.common.enums.StatusEnum;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.UpgradeQuoteSchemeHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceEntityKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceSourceKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteConditonInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategySeqInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcColl;
import kd.mpscmm.msbd.pricemodel.common.consts.advanceprice.PriceCalStrategyConst;
import kd.mpscmm.msbd.pricemodel.common.consts.advanceprice.PriceSchemeGroupConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteSchemeConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteSchemeEntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteSchemeREntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteSchemeSortEntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteStrategyCalEntryConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteStrategyConst;
import kd.mpscmm.msbd.pricemodel.common.consts.quote.QuoteStrategyEntryConst;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.MulPriceEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.PriceSourceEnum;

public class QuoteHelper {
    private static final Log LOGGER = LogFactory.getLog(QuoteHelper.class);

    public static QuoteStrategeColl fetchQuoteSchemeFromST(Long orgID, String type, Map<String, Object> param) {
        UpgradeQuoteSchemeHelper.updateQuoteStrategy();
        QuoteStrategeColl quoteStrategeColl = new QuoteStrategeColl(type);
        Long appoint_strategy_id = null;
        if (param != null && param.get("appoint_strategy") != null && param.get("appoint_strategy") instanceof Long) {
            appoint_strategy_id = (Long)param.get("appoint_strategy");
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        QFilter orgIdFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (orgID != null && !orgID.equals(Long.valueOf("0"))) {
            orgIdFilter = BaseDataServiceHelper.getBaseDataFilter((String)"plat_quotestrategy", (Long)orgID);
        }
        if (appoint_strategy_id != null) {
            orgIdFilter.and(new QFilter("id", "=", (Object)appoint_strategy_id));
        }
        StringBuilder selecties = new StringBuilder("id,").append((CharSequence)new StringBuilder(String.join((CharSequence)",", QuoteStrategyConst.getSelectorList())).append(",").append((CharSequence)new StringBuilder(String.join((CharSequence)",", QuoteStrategyEntryConst.getSelectorList()))));
        selecties.append(',').append(String.join((CharSequence)",", QuoteStrategyCalEntryConst.getSelectorList()));
        DynamicObject[] quoteStrategys = BusinessDataServiceHelper.load((String)"plat_quotestrategy", (String)selecties.toString(), (QFilter[])new QFilter[]{orgIdFilter, statusFilter, enableFilter}, (String)"number");
        HashMap<Object, DynamicObject> quoteStrategyMap = new HashMap<Object, DynamicObject>(16);
        if (quoteStrategys.length != 0) {
            Object pk;
            ArrayList<DynamicObject> conditonMatch = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> quoteSchemes = new ArrayList<DynamicObject>(16);
            ArrayList quoteSeqInfoCheckList = new ArrayList(16);
            ArrayList<QuoteStrategySeqInfo> quoteSeqInfoList = new ArrayList<QuoteStrategySeqInfo>(16);
            ArrayList<Long> schemePKs = new ArrayList<Long>(16);
            for (int t = 0; t < quoteStrategys.length; ++t) {
                int s;
                List quoteConditonInfos;
                DynamicObject quoteStrategy = quoteStrategys[t];
                boolean isNewMode = quoteStrategy.getBoolean("isnewmode");
                quoteStrategyMap.put(quoteStrategy.getPkValue(), quoteStrategy);
                DynamicObjectCollection conditionEntry = quoteStrategy.getDynamicObjectCollection("conditionentryentity");
                conditonMatch.clear();
                if (conditionEntry.size() == 0) {
                    QuoteConditonInfo quoteConditonInfo = new QuoteConditonInfo(true);
                    quoteConditonInfos = quoteStrategeColl.getMapping().computeIfAbsent(quoteStrategy.getPkValue(), key -> new ArrayList());
                    quoteConditonInfos.add(quoteConditonInfo);
                } else {
                    for (int i = 0; i < conditionEntry.size(); ++i) {
                        DynamicObject condition = (DynamicObject)conditionEntry.get(i);
                        String quoteBillType = condition.getDynamicObject("quotebill").getString("number");
                        if (!quoteBillType.equals(type)) continue;
                        conditonMatch.add(condition);
                    }
                    if (conditonMatch.size() > 0) {
                        conditonMatch.forEach(e -> {
                            QuoteConditonInfo quoteConditonInfo = new QuoteConditonInfo(true);
                            quoteConditonInfo.generateQuoteConditonInfo((DynamicObject)e, type);
                            List quoteConditonInfos = quoteStrategeColl.getMapping().computeIfAbsent(quoteStrategy.getPkValue(), key -> new ArrayList());
                            quoteConditonInfos.add(quoteConditonInfo);
                        });
                    } else {
                        if (isNewMode) {
                            quoteStrategyMap.remove(quoteStrategy.getPkValue());
                            continue;
                        }
                        QuoteConditonInfo quoteConditonInfo = new QuoteConditonInfo(false);
                        quoteConditonInfos = quoteStrategeColl.getMapping().computeIfAbsent(quoteStrategy.getPkValue(), key -> new ArrayList());
                        quoteConditonInfos.add(quoteConditonInfo);
                    }
                }
                schemePKs.clear();
                quoteSeqInfoList.clear();
                QuoteSchemeColl quoteSchemeColl = new QuoteSchemeColl(quoteStrategy);
                DynamicObjectCollection entrys = quoteStrategy.getDynamicObjectCollection("entryentity");
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject quoteScheme = ((DynamicObject)entrys.get(i)).getDynamicObject("quotescheme");
                    if (quoteScheme == null || !type.equals(quoteScheme.getDynamicObject("quoteentity").getPkValue()) && !QuoteHelper.isDimensionMode(quoteScheme)) continue;
                    schemePKs.add((Long)quoteScheme.getPkValue());
                    String preCondition = ((DynamicObject)entrys.get(i)).getString("preconditionjson_tag");
                    String preConditionOld = ((DynamicObject)entrys.get(i)).getString("qu_precondition");
                    if (StringUtils.isBlank((CharSequence)preCondition) && StringUtils.isNotBlank((CharSequence)preConditionOld)) {
                        preCondition = preConditionOld;
                    }
                    String preConditionDesc = ((DynamicObject)entrys.get(i)).getString("qu_preconditiondesc");
                    String sourceCondition = ((DynamicObject)entrys.get(i)).getString("pricesourceprecon_tag");
                    String sourceConditionDesc = ((DynamicObject)entrys.get(i)).getString("pricesourceprecondesc");
                    quoteSeqInfoList.add(new QuoteStrategySeqInfo(i + 1, ((DynamicObject)entrys.get(i)).getString("terminationsign"), preCondition, preConditionDesc, sourceCondition, sourceConditionDesc));
                }
                quoteSchemes.clear();
                quoteSeqInfoCheckList.clear();
                if (schemePKs.size() <= 0) continue;
                Map<Object, DynamicObject> schemeMap = QuoteHelper.getActiveSchemeInfo(schemePKs, true);
                HashSet<String> mustMappingBills = new HashSet<String>();
                schemeMap.forEach((k, v) -> {
                    if (QuoteHelper.isDimensionMode(v)) {
                        mustMappingBills.add(v.getDynamicObject("pricesourceentity").getString("id"));
                    }
                });
                if (mustMappingBills.size() > 0) {
                    mustMappingBills.add(type);
                }
                Map<String, Map<String, String>> billMapping = QuoteHelper.buildBillMapping(mustMappingBills);
                for (s = 0; s < schemePKs.size(); ++s) {
                    pk = schemePKs.get(s);
                    if (schemeMap.get(pk) == null) continue;
                    quoteSchemes.add(schemeMap.get(pk));
                    quoteSeqInfoCheckList.add(quoteSeqInfoList.get(s));
                }
                if (quoteSchemes.size() <= 0) continue;
                for (s = 0; s < quoteSchemes.size(); ++s) {
                    DynamicObject scheme = (DynamicObject)quoteSchemes.get(s);
                    QuoteStrategySeqInfo seqInfo = (QuoteStrategySeqInfo)quoteSeqInfoCheckList.get(s);
                    if (QuoteHelper.isDimensionMode(scheme)) {
                        seqInfo.setQuoteFieldMapping(billMapping.get(type));
                        seqInfo.setSourceFieldMapping(billMapping.get(scheme.getDynamicObject("pricesourceentity").getString("id")));
                    }
                    seqInfo.setOrigialQuoteType(type);
                    quoteSchemeColl.applyScheme(scheme, seqInfo);
                }
                quoteStrategeColl.getSchemeCollMapping().put(quoteStrategy.getPkValue(), quoteSchemeColl);
            }
            ArrayList<DynamicObject> calstrategys = new ArrayList<DynamicObject>(16);
            ArrayList calSeqInfoCheckList = new ArrayList(16);
            ArrayList<QuoteStrategySeqInfo> calSeqInfoList = new ArrayList<QuoteStrategySeqInfo>(16);
            ArrayList<Object> calstrategyPKs = new ArrayList<Object>(16);
            for (int t = 0; t < quoteStrategys.length; ++t) {
                int s;
                DynamicObject quoteStrategy = quoteStrategys[t];
                calstrategyPKs.clear();
                calSeqInfoList.clear();
                QuoteCalcColl quoteCalcColl = new QuoteCalcColl(quoteStrategy);
                DynamicObjectCollection entrys = quoteStrategy.getDynamicObjectCollection("calentry");
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject calStrategy = ((DynamicObject)entrys.get(i)).getDynamicObject("calstrategy");
                    if (calStrategy == null || !type.equals(calStrategy.getDynamicObject("quoteentity").getPkValue()) && !QuoteHelper.isDimensionMode4calStrategy(calStrategy)) continue;
                    calstrategyPKs.add(calStrategy.getPkValue());
                    String preCondition = ((DynamicObject)entrys.get(i)).getString("calprecondition_tag");
                    String preConditionDesc = ((DynamicObject)entrys.get(i)).getString("calpreconditiondesc");
                    String quotetermsign = ((DynamicObject)entrys.get(i)).getString("quotetermsign");
                    calSeqInfoList.add(new QuoteStrategySeqInfo(i + 1, quotetermsign, preCondition, preConditionDesc, null, null));
                }
                calstrategys.clear();
                calSeqInfoCheckList.clear();
                if (calstrategyPKs.size() <= 0) continue;
                Map<Object, DynamicObject> calstrategyMap = QuoteHelper.getActiveCalcstrategyInfo(calstrategyPKs);
                for (s = 0; s < calstrategyPKs.size(); ++s) {
                    pk = calstrategyPKs.get(s);
                    if (calstrategyMap.get(pk) == null) continue;
                    calstrategys.add(calstrategyMap.get(pk));
                    calSeqInfoCheckList.add(calSeqInfoList.get(s));
                }
                if (calstrategys.size() <= 0) continue;
                for (s = 0; s < calstrategys.size(); ++s) {
                    QuoteStrategySeqInfo seqInfo = (QuoteStrategySeqInfo)calSeqInfoCheckList.get(s);
                    seqInfo.setOrigialQuoteType(type);
                    quoteCalcColl.applyStratege((DynamicObject)calstrategys.get(s), (QuoteStrategySeqInfo)calSeqInfoCheckList.get(s));
                }
                quoteCalcColl.load();
                quoteStrategeColl.getCalcCollMapping().put(quoteStrategy.getPkValue(), quoteCalcColl);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u672a\u7ef4\u62a4\u53d6\u4ef7\u7b56\u7565\u3002", (String)"QuoteHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (quoteStrategeColl.getSchemeCollMapping().size() == 0 && quoteStrategeColl.getCalcCollMapping().size() == 0) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ec4\u7ec7\u7684\u53d6\u4ef7\u7b56\u7565\u4e2d\u672a\u627e\u5230\u6709\u6548\u7684\u53d6\u4ef7\u65b9\u6848\u548c\u8ba1\u7b97\u7b56\u7565\u3002", (String)"QuoteHelper_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        HashSet keySet = new HashSet();
        quoteStrategeColl.getSchemeCollMapping().forEach((k, v) -> keySet.add(k));
        quoteStrategeColl.getCalcCollMapping().forEach((k, v) -> keySet.add(k));
        keySet.forEach(key -> quoteStrategeColl.getQuoteStrateges().add((DynamicObject)quoteStrategyMap.get(key)));
        return quoteStrategeColl;
    }

    public static PriceEntityKeyInfo getQuoteCommonConst(String entityType, QuoteStrategeColl quoteStrategeColl) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map entryTypeMap = headType.getAllEntities();
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        ArrayList<String> quoteResultSet = new ArrayList<String>();
        quoteStrategeColl.mergeQuoteResult(quoteResultSet);
        dimensions.addAll(quoteResultSet);
        String allStr = String.join((CharSequence)",", dimensions);
        PriceEntityKeyInfo qccInfo = new PriceEntityKeyInfo(entityType);
        ArrayList<String> entryNames = new ArrayList<String>();
        entryTypeMap.forEach((k, v) -> {
            for (String dimension : dimensions) {
                String[] dimensionStr = dimension.split("\\.");
                if (dimensionStr == null || dimensionStr.length <= 1) continue;
                if (v.getName().equals(dimensionStr[0])) {
                    qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                    qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                    qccInfo.setLEFT_BILLENTRY_ID(qccInfo.getEntryIDAlias());
                    qccInfo.setLEFT_SEQ(qccInfo.getEntrySeqAlias());
                    qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                    qccInfo.setEntryName(v.getName());
                    break;
                }
                if (!v.getName().equals(dimensionStr[1])) continue;
                qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                qccInfo.setLEFT_BILLENTRY_ID(qccInfo.getEntryIDAlias());
                qccInfo.setLEFT_SEQ(qccInfo.getEntrySeqAlias());
                qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                qccInfo.setEntryName(v.getName());
                break;
            }
            entryNames.add(v.getName());
        });
        if (qccInfo.getEntryCount() > 1) {
            String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u65b9\u6848\u914d\u7f6e\u4e86\u8d85\u8fc71\u4e2a\u53d6\u4ef7\u5206\u5f55\uff0c\u76ee\u524d\u4e0d\u652f\u6301\u591a\u5206\u5f55\u53d6\u4ef7\u3002", (String)"QuoteHelper_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        boolean hasHeadPriceFiled = QuoteHelper.hasHeadPriceField(quoteResultSet, entryNames);
        qccInfo.setHeadPriceField(hasHeadPriceFiled);
        qccInfo.setHasTable(StringUtils.isNotEmpty((CharSequence)headType.getAlias()));
        return qccInfo;
    }

    public static Map<String, Object> getHeaderAndEntryKeysWithFlag(QuoteStrategeColl quoteStrategeColl, PriceEntityKeyInfo qccInfo) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        ArrayList<String> entryProperties = new ArrayList<String>();
        ArrayList<String> headerProperties = new ArrayList<String>();
        List<String> terminationSignList = quoteStrategeColl.mergeTerminateSign();
        ArrayList<String> allResultFieldList = new ArrayList<String>();
        quoteStrategeColl.mergeQuoteResult(allResultFieldList);
        boolean isResultFieldDelete = false;
        if (terminationSignList.size() == 0) {
            isResultFieldDelete = true;
        } else {
            for (String field : terminationSignList) {
                if (!StringUtils.isEmpty((CharSequence)field)) continue;
                isResultFieldDelete = true;
                break;
            }
        }
        if (isResultFieldDelete) {
            String message = ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u4ef7\u7b56\u7565\u4e2d\u7684\u53d6\u4ef7\u7ec8\u6b62\u5b57\u6bb5\u5728\u53d6\u4ef7\u65b9\u6848\u6216\u8005\u8ba1\u7b97\u7b56\u7565\u4e2d\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"QuoteHelper_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        if (qccInfo.getEntryCount() == 0) {
            headerProperties.add(qccInfo.getHeadIDField());
            headerProperties.addAll(dimensions);
            map.put("header", headerProperties);
            map.put("entry", entryProperties);
        } else {
            headerProperties.add(qccInfo.getHeadIDField());
            entryProperties.addAll(qccInfo.getEntryIDField());
            for (int i = 0; i < dimensions.size(); ++i) {
                String dimension = dimensions.get(i);
                if (!StringUtils.isNotEmpty((CharSequence)dimension)) continue;
                if (dimensions.get(i).contains(qccInfo.getEntryName())) {
                    entryProperties.add(dimension);
                    continue;
                }
                headerProperties.add(dimension);
            }
            map.put("header", headerProperties);
            map.put("entry", entryProperties);
        }
        map.put("result", terminationSignList);
        map.put("allresult", allResultFieldList);
        map.put("success", Boolean.TRUE);
        return map;
    }

    public static PriceSourceKeyInfo getQuoteSrcCommonConst(String entityType, QuoteSchemeInfo quoteSchemeInfo) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)entityType);
        Map entryTypeMap = headType.getAllEntities();
        List<String> results = quoteSchemeInfo.getQuoteSourceResult();
        String allStr = String.join((CharSequence)",", results);
        PriceSourceKeyInfo qccInfo = new PriceSourceKeyInfo();
        if (headType instanceof BasedataEntityType) {
            if (headType.getAllFields().containsKey("number")) {
                if (StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)headType.getAllFields().get("number")).getAlias())) {
                    qccInfo.setBILLNO("number");
                } else {
                    qccInfo.setBILLNO(null);
                }
            } else {
                qccInfo.setBILLNO(null);
            }
        } else if (headType instanceof BillEntityType) {
            if (headType.getAllFields().containsKey("billno")) {
                if (StringUtils.isNotEmpty((CharSequence)((IDataEntityProperty)headType.getAllFields().get("billno")).getAlias())) {
                    qccInfo.setBILLNO("billno");
                } else {
                    qccInfo.setBILLNO(null);
                }
            } else {
                qccInfo.setBILLNO(null);
            }
        } else {
            qccInfo.setBILLNO(null);
        }
        ArrayList entryNames = new ArrayList();
        entryTypeMap.forEach((k, v) -> {
            if (allStr.contains(v.getName())) {
                qccInfo.setBILLENTRY_ID(v.getName() + "." + "id");
                qccInfo.setBILLENTRY_SEQ(v.getName() + "." + "seq");
                qccInfo.setEntryCount(qccInfo.getEntryCount() + 1);
                qccInfo.setEntryName(v.getName());
            }
            entryNames.add(v.getName());
        });
        return qccInfo;
    }

    public static DataSet buildQuoteDataSetByMap(List<Map<String, Object>> entryMapList, String entityType, QuoteStrategeColl quoteStrategeColl, PriceEntityKeyInfo qccInfo) {
        if (entryMapList == null || entryMapList.size() == 0) {
            String message = ResManager.loadKDString((String)"\u672a\u5411\u53d6\u4ef7\u670d\u52a1\u63a5\u53e3\u4f20\u9012\u53d6\u4ef7\u5355\u636e\u4fe1\u606f\u3002", (String)"QuoteHelper_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            throw new KDBizException(message);
        }
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        List<String> alias = quoteStrategeColl.mergeAlias();
        return DataSetHelper.toDataSetByMap(entryMapList, entityType, dimensions, alias, qccInfo);
    }

    public static DataSet buildQuoteDataSet(DynamicObject[] bills, String entityType, QuoteStrategeColl quoteStrategeColl, PriceEntityKeyInfo qccInfo) {
        String[] dimensions = new String[]{};
        String[] alias = new String[]{};
        dimensions = quoteStrategeColl.mergeDimension().toArray(dimensions);
        alias = quoteStrategeColl.mergeAlias().toArray(alias);
        return DataSetHelper.toDataSet(bills, entityType, dimensions, alias, qccInfo);
    }

    public static DataSet buildQuoteDataSetByIDs(Long[] ids, String entityType, QuoteStrategeColl quoteStrategeColl, PriceEntityKeyInfo qccInfo) {
        List<String> dimensions = quoteStrategeColl.mergeDimension();
        List<String> alias = quoteStrategeColl.mergeAlias();
        qccInfo.getIDFIELDS().forEach(f -> dimensions.add((String)f));
        qccInfo.getLEFTIDFIELDS().forEach(f -> alias.add((String)f));
        for (int i = 0; i < dimensions.size(); ++i) {
            dimensions.set(i, new StringBuffer(dimensions.get(i)).append(new StringBuffer(" ")).append(new StringBuffer(alias.get(i))).toString());
        }
        DataSet result = QueryServiceHelper.queryDataSet((String)"QuoteHelper", (String)entityType, (String)String.join((CharSequence)",", dimensions), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)}, (String)"id");
        return result;
    }

    private static boolean hasHeadPriceField(List<String> results, List<String> entryNames) {
        int countEntryPrice = 0;
        block0: for (String resultField : results) {
            for (String entryName : entryNames) {
                if (!resultField.contains(entryName)) continue;
                ++countEntryPrice;
                continue block0;
            }
        }
        return countEntryPrice != results.size();
    }

    public static Map<Object, DynamicObject> getActiveSchemeInfo(List<Long> schemePKs, boolean isAllActive) {
        StringBuilder props = new StringBuilder(String.join((CharSequence)",", QuoteSchemeConst.getSelectorList()));
        StringBuilder entryProps = new StringBuilder(String.join((CharSequence)",", QuoteSchemeEntryConst.getSelectorList()));
        StringBuilder entryRProps = new StringBuilder(String.join((CharSequence)",", QuoteSchemeREntryConst.getSelectorList()));
        StringBuilder sortEntryProps = new StringBuilder(String.join((CharSequence)",", QuoteSchemeSortEntryConst.getSelectorList()));
        String selector = props.append(',').append((CharSequence)entryProps).append(',').append((CharSequence)entryRProps).append(',').append((CharSequence)sortEntryProps).toString();
        QFilter schemeIDFilter = new QFilter("id", "in", schemePKs);
        if (isAllActive) {
            QFilter schemeStatusFilter = new QFilter("status", "=", (Object)"C");
            QFilter schemeEnableFilter = new QFilter("enable", "=", (Object)"1");
            Map schemeMap = BusinessDataServiceHelper.loadFromCache((String)"plat_quotescheme", (String)selector, (QFilter[])new QFilter[]{schemeStatusFilter, schemeEnableFilter, schemeIDFilter});
            return schemeMap;
        }
        Map schemeMap = BusinessDataServiceHelper.loadFromCache((String)"plat_quotescheme", (String)selector, (QFilter[])new QFilter[]{schemeIDFilter});
        return schemeMap;
    }

    public static Map<Object, DynamicObject> getActiveCalcstrategyInfo(List<Object> strategyPKs) {
        StringBuilder props = new StringBuilder(String.join((CharSequence)",", PriceCalStrategyConst.getSelectorList()));
        StringBuilder entryProps = new StringBuilder(String.join((CharSequence)",", PriceCalStrategyConst.getGroupSelectorList()));
        StringBuilder formulaEntryProps = new StringBuilder(String.join((CharSequence)",", PriceCalStrategyConst.getFormulaSelectorList()));
        String selector = props.append(',').append((CharSequence)entryProps).append(',').append((CharSequence)formulaEntryProps).toString();
        QFilter strategyStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter strategyEnableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter strategyIDFilter = new QFilter("id", "in", strategyPKs);
        Map calcstrategyMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_calculationstrategy", (String)selector, (QFilter[])new QFilter[]{strategyStatusFilter, strategyEnableFilter, strategyIDFilter});
        calcstrategyMap.forEach((k, v) -> {
            DynamicObjectCollection groupEntrys = v.getDynamicObjectCollection("factor");
            for (int i = groupEntrys.size() - 1; i >= 0; --i) {
                DynamicObject quoteSchemeGroup = ((DynamicObject)groupEntrys.get(i)).getDynamicObject("quoteschemegroup");
                String status = quoteSchemeGroup.getString("status");
                boolean enable = quoteSchemeGroup.getBoolean("enable");
                if (StatusEnum.AUDIT.getValue().equals(status) && enable) continue;
                groupEntrys.remove(i);
            }
        });
        return calcstrategyMap;
    }

    public static DynamicObject getSimpleCalcstrategyInfo(Object strategyPK) {
        QFilter strategyIDFilter;
        QFilter strategyEnableFilter;
        QFilter strategyStatusFilter;
        StringBuilder props = new StringBuilder(String.join((CharSequence)",", PriceCalStrategyConst.getSelectorList()));
        StringBuilder entryProps = new StringBuilder(String.join((CharSequence)",", PriceCalStrategyConst.getGroupSelectorList()));
        String selector = props.append(',').append((CharSequence)entryProps).toString();
        DynamicObject calcstrategy = BusinessDataServiceHelper.loadSingleFromCache((String)"msbd_calculationstrategy", (String)selector, (QFilter[])new QFilter[]{strategyStatusFilter = new QFilter("status", "=", (Object)"C"), strategyEnableFilter = new QFilter("enable", "=", (Object)"1"), strategyIDFilter = new QFilter("id", "=", strategyPK)});
        if (calcstrategy != null) {
            DynamicObjectCollection groupEntrys = calcstrategy.getDynamicObjectCollection("factor");
            for (int i = groupEntrys.size() - 1; i >= 0; --i) {
                DynamicObject quoteSchemeGroup = ((DynamicObject)groupEntrys.get(i)).getDynamicObject("quoteschemegroup");
                String status = quoteSchemeGroup.getString("status");
                boolean enable = quoteSchemeGroup.getBoolean("enable");
                String mulPrice = quoteSchemeGroup.getString("mulprice");
                String priceSource = quoteSchemeGroup.getString("pricesource");
                if (enable && StatusEnum.AUDIT.getValue().equals(status) && MulPriceEnum.CANT_MANUAL.getValue().equals(mulPrice) && (PriceSourceEnum.SCHEME.getValue().equals(priceSource) || PriceSourceEnum.BILLFIELD.getValue().equals(priceSource))) continue;
                groupEntrys.remove(i);
            }
        }
        return calcstrategy;
    }

    public static Map<Object, DynamicObject> getActiveGroupInfo(Set<Long> groupPKs) {
        StringBuilder entryProps = new StringBuilder(String.join((CharSequence)",", PriceSchemeGroupConst.getEntrySelectorList()));
        String selector = entryProps.toString();
        QFilter groupStatusFilter = new QFilter("status", "=", (Object)"C");
        QFilter groupEnableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter groupIDFilter = new QFilter("id", "in", groupPKs);
        Map groupMap = BusinessDataServiceHelper.loadFromCache((String)"msbd_quoteschemegroup", (String)selector, (QFilter[])new QFilter[]{groupStatusFilter, groupEnableFilter, groupIDFilter});
        return groupMap;
    }

    public static void registerQuoteBill(BeforeF7SelectEvent e, String appID, boolean isQuotelog) {
        QFilter useFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)appID)) {
            if ("pmp".equals(appID) || "pm".equals(appID)) {
                useFilter = new QFilter("use", "=", (Object)"pur");
            } else if ("pms".equals(appID) || "sm".equals(appID)) {
                useFilter = new QFilter("use", "=", (Object)"sal");
            }
        }
        DynamicObjectCollection schemes = QueryServiceHelper.query((String)"plat_quotescheme", (String)"quoteentity", (QFilter[])new QFilter[]{useFilter});
        HashSet<String> quoteBills = new HashSet<String>();
        for (DynamicObject[] scheme : schemes) {
            String quoteBill = scheme.getString("quoteentity");
            if (!StringUtils.isNotEmpty((CharSequence)quoteBill)) continue;
            try {
                MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBill);
                if (!isQuotelog) {
                    if (!StringUtils.isNotEmpty((CharSequence)headType.getAlias())) continue;
                    quoteBills.add(quoteBill);
                    continue;
                }
                if ("msbd_pricetax_expenses".equals(quoteBill)) continue;
                quoteBills.add(quoteBill);
            }
            catch (Exception ex) {}
        }
        if (isQuotelog) {
            DynamicObject[] strategys;
            for (DynamicObject strategy : strategys = BusinessDataServiceHelper.load((String)"plat_quotestrategy", (String)"quotebill", (QFilter[])new QFilter[0])) {
                DynamicObjectCollection conditons = strategy.getDynamicObjectCollection("conditionentryentity");
                for (DynamicObject conditon : conditons) {
                    DynamicObject quoteEntity = conditon.getDynamicObject("quotebill");
                    if (quoteEntity == null) continue;
                    quoteBills.add(quoteEntity.getString("number"));
                }
            }
        }
        if (quoteBills.size() > 0) {
            QFilter addFilter = new QFilter("number", "in", quoteBills);
            ListShowParameter listParameter = (ListShowParameter)e.getFormShowParameter();
            List filters = listParameter.getListFilterParameter().getQFilters();
            if (filters.size() > 0) {
                listParameter.getListFilterParameter().setFilter(((QFilter)listParameter.getListFilterParameter().getQFilters().get(0)).or(addFilter));
            } else {
                listParameter.getListFilterParameter().setFilter(addFilter);
            }
        }
    }

    public static boolean isDimensionMode(DynamicObject quoteScheme) {
        return quoteScheme.getDynamicObject("quoteentity") != null && "msbd_pricetax_expenses".equals(quoteScheme.getDynamicObject("quoteentity").getString("id")) || Boolean.TRUE.equals(quoteScheme.getBoolean("isnewmode"));
    }

    private static boolean isDimensionMode4calStrategy(DynamicObject calStrategy) {
        return calStrategy.getDynamicObject("quoteentity") != null && "msbd_pricetax_expenses".equals(calStrategy.getDynamicObject("quoteentity").getString("id"));
    }

    public static Map<String, Map<String, String>> buildBillMapping(Set<String> mustMappingBills) {
        QFilter mappingTargetFilter = new QFilter("targetobj", "=", (Object)"msbd_pricetax_expenses");
        QFilter mappingSourceFilter = new QFilter("sourcebill", "in", mustMappingBills);
        QFilter mappingEnableFilter = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        ArrayList<String> mappingSelector = new ArrayList<String>();
        mappingSelector.add("targetobj");
        mappingSelector.add("sourcebill");
        mappingSelector.add("targetobjcol");
        mappingSelector.add("sourcebillcol");
        mappingSelector.add("formula_tag");
        Map mappingInfos = BusinessDataServiceHelper.loadFromCache((String)"sbs_billfieldmapping", (String)String.join((CharSequence)",", mappingSelector), (QFilter[])new QFilter[]{mappingTargetFilter, mappingSourceFilter, mappingEnableFilter});
        HashMap<String, Map<String, String>> billMapping = new HashMap<String, Map<String, String>>();
        mappingInfos.forEach((k, v) -> {
            DynamicObject sourceBill = v.getDynamicObject("sourcebill");
            if (sourceBill != null) {
                String sourceBillType = sourceBill.getString("id");
                MainEntityType quoteBillType = EntityMetadataCache.getDataEntityType((String)sourceBillType);
                if (billMapping.containsKey(sourceBillType)) {
                    String message = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4e2a%1$s\u4e0e\u4ef7\u683c\u6a21\u578b\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteHelper_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteBillType.getDisplayName());
                    throw new KDBizException(message);
                }
                HashMap<String, String> fieldMapping = new HashMap<String, String>();
                billMapping.put(sourceBillType, fieldMapping);
                DynamicObjectCollection mappingEntry = v.getDynamicObjectCollection("colsmap");
                for (DynamicObject mappingInfo : mappingEntry) {
                    String targetobjcol = mappingInfo.getString("targetobjcol");
                    String sourcebillcol = mappingInfo.getString("sourcebillcol");
                    String formula = mappingInfo.getString("formula_tag");
                    if (!StringUtils.isNotEmpty((CharSequence)targetobjcol)) continue;
                    if (StringUtils.isNotEmpty((CharSequence)sourcebillcol)) {
                        fieldMapping.put(targetobjcol, sourcebillcol);
                        continue;
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)formula)) continue;
                    try {
                        Map parameters = (Map)SerializationUtils.fromJsonString((String)formula, Map.class);
                        if (parameters.get("expression") == null || !(parameters.get("expression") instanceof String)) continue;
                        fieldMapping.put(targetobjcol, (String)parameters.get("expression"));
                    }
                    catch (Exception e) {
                        String message = String.format(ResManager.loadKDString((String)"%1$s\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u6807\u8bc6\u201c%2$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u6709\u8bef\u3002", (String)"QuoteHelper_8", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteBillType.getDisplayName(), targetobjcol);
                        throw new KDBizException(message);
                    }
                }
            }
        });
        mustMappingBills.forEach(bill -> {
            if (!billMapping.containsKey(bill)) {
                MainEntityType quoteBillType = EntityMetadataCache.getDataEntityType((String)bill);
                String message = String.format(ResManager.loadKDString((String)"\u672a\u7ef4\u62a4%1$s\u4e0e\u4ef7\u683c\u6a21\u578b\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteHelper_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), quoteBillType.getDisplayName());
                throw new KDBizException(message);
            }
        });
        return billMapping;
    }
}

