/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper.quote;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;

public class QuoteLogHelper {
    private static final String sm_tpl = "/S39P74P5==6";
    private static final String sm_basetpl = "/MN8E05AKBSU";

    public static TreeMap<String, String> getQuoteResultAliasName(QuoteStrategeColl quoteStrategeColl, String quoteBill, List<String> oneSchemeResultFields) {
        List<String> quoteResultAliasSet = quoteStrategeColl.mergeQuoteResultAlias(new ArrayList<String>());
        ArrayList<String> quoteResultAliasSetTo = new ArrayList<String>(quoteResultAliasSet.size());
        for (String quoteResultAlias : quoteResultAliasSet) {
            if (!oneSchemeResultFields.contains(quoteResultAlias)) continue;
            quoteResultAliasSetTo.add(quoteResultAlias);
        }
        String leftName = PriceHelper.getLeftName("schemegroupprice");
        if (oneSchemeResultFields.contains(leftName)) {
            quoteResultAliasSetTo.add(leftName);
        }
        TreeMap<String, String> nameMapping = new TreeMap<String, String>();
        QuoteLogHelper.getResultNameMapping(quoteBill, quoteResultAliasSetTo, nameMapping);
        return nameMapping;
    }

    public static String getResultNameMapping(String quoteBill, List<String> quoteResultAliasSet, TreeMap<String, String> nameMapping) {
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBill);
        Map allFileds = headType.getAllFields();
        String schemeGroupPriceDisplayName = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u7ec4\u8fd4\u56de\u4ef7\u683c", (String)"QuoteLogHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String schemeGroupPriceField = PriceHelper.getLeftName("schemegroupprice");
        quoteResultAliasSet.forEach(qf -> {
            if (!schemeGroupPriceField.equals(qf)) {
                String[] subFields = qf.split("__");
                String priceField = subFields[subFields.length - 1];
                IDataEntityProperty property = (IDataEntityProperty)allFileds.get(priceField);
                if (property != null) {
                    IDataEntityProperty taxProperty;
                    Class propertyType = ((IDataEntityProperty)allFileds.get(priceField)).getPropertyType();
                    if (Integer.class.isAssignableFrom(propertyType) || BigDecimal.class.isAssignableFrom(propertyType)) {
                        nameMapping.put((String)qf, ((IDataEntityProperty)allFileds.get(priceField)).getDisplayName().getLocaleValue());
                    } else if (priceField.contains("tax") && (taxProperty = (IDataEntityProperty)allFileds.get(priceField)) instanceof BasedataProp && "bd_taxrate".equals(((BasedataProp)taxProperty).getBaseEntityId())) {
                        nameMapping.put(qf + "bd_taxrate", taxProperty.getDisplayName().getLocaleValue());
                    }
                }
            } else {
                nameMapping.put((String)qf, schemeGroupPriceDisplayName);
            }
        });
        return headType.getDisplayName().toString();
    }

    public static String getMultiResultDes(TreeMap<String, String> nameMapping, Row row, String sourceBillTypeName) {
        ArrayList<String> quoteResultDescrip = new ArrayList<String>(nameMapping.size());
        String sourceBillNo = row.getString("quotesrcno");
        String seq = row.getString("quotesrcseq");
        if (StringUtils.isNotEmpty((CharSequence)sourceBillTypeName)) {
            quoteResultDescrip.add(sourceBillTypeName);
        }
        if (StringUtils.isNotEmpty((CharSequence)sourceBillNo)) {
            quoteResultDescrip.add(sourceBillNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)seq)) {
            String seqStr = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"QuoteLogProxy_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), seq);
            quoteResultDescrip.add(seqStr);
        }
        nameMapping.forEach((k, v) -> {
            if (!k.contains("bd_taxrate") && row.get(k) != null) {
                Number value = (Number)row.get(k);
                if (value == null) {
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":");
                } else {
                    BigDecimal rs = BigDecimal.valueOf(value.doubleValue());
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":" + rs.stripTrailingZeros().toPlainString());
                }
            }
        });
        return String.join((CharSequence)"/", quoteResultDescrip);
    }

    public static String getResultDes(TreeMap<String, String> nameMapping, Row row, Map<Object, DynamicObject> taxRates) {
        ArrayList quoteResultDescrip = new ArrayList(nameMapping.size());
        nameMapping.forEach((k, v) -> {
            if (k.contains("bd_taxrate")) {
                StringBuilder descrip = new StringBuilder((String)nameMapping.get(k));
                if (row.get(k = k.replace("bd_taxrate", "")) != null) {
                    String value;
                    String string = value = taxRates.get(row.get(k)) != null ? ((DynamicObject)taxRates.get(row.get(k))).getString("number") : "";
                    if (StringUtils.isNotEmpty((CharSequence)value)) {
                        quoteResultDescrip.add(descrip.append(":").append(value == null ? "" : value).toString());
                    }
                }
            } else if (row.get(k) != null) {
                Number value = (Number)row.get(k);
                if (value == null) {
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":");
                } else {
                    BigDecimal rs = BigDecimal.valueOf(value.doubleValue());
                    quoteResultDescrip.add((String)nameMapping.get(k) + ":" + rs.stripTrailingZeros().toPlainString());
                }
            }
        });
        return String.join((CharSequence)",", quoteResultDescrip);
    }

    public static String generateUniqueKey(Long billID, Long billEntryID) {
        StringBuilder key = new StringBuilder(String.valueOf(billID));
        if (billEntryID != null && billEntryID > 0L) {
            key.append("__").append(billEntryID);
        }
        return key.toString();
    }

    public static DataSet completePriceSourceField(String priceSourceType, DataSet result, String priceSourceMessage) {
        if (!DataSetHelper.isIncludeField("quotesrcbill", result)) {
            result = result.addField(DataSetHelper.getDataSetValue(priceSourceType), "quotesrcbill");
        }
        if (!DataSetHelper.isIncludeField("quotesrcno", result)) {
            result = result.addField(DataSetHelper.getDataSetValue(priceSourceMessage), "quotesrcno");
        }
        if (!DataSetHelper.isIncludeField("quotesrcseq", result)) {
            result = result.addNullField("quotesrcseq");
        }
        return result;
    }

    public static String getBizDateField(MainEntityType headType) {
        String dateField = null;
        Map allfields = headType.getAllFields();
        if (headType.getInheritPath().contains(sm_tpl) || headType.getInheritPath().contains(sm_basetpl)) {
            dateField = "bizdate";
        } else if (allfields.containsKey("bizdate")) {
            dateField = "bizdate";
        } else if (allfields.containsKey("biztime")) {
            dateField = "biztime";
        }
        return dateField;
    }

    public static String getTerminateFieldDisplayName(MainEntityType quoteType, String returnField) {
        String[] returnfields = returnField.split("\\.");
        String subField = returnfields[returnfields.length - 1];
        String displayName = "";
        if ("schemegroupprice".equals(subField)) {
            displayName = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u7ec4\u8fd4\u56de\u4ef7\u683c", (String)"QuoteLogHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        } else {
            IDataEntityProperty featureProperty = (IDataEntityProperty)quoteType.getAllFields().get(subField);
            if (featureProperty != null) {
                displayName = featureProperty.getDisplayName().getLocaleValue();
            }
        }
        return displayName;
    }
}

