/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.helper.quote;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.builder.QuoteCalLogBuilder;
import kd.mpscmm.msbd.pricemodel.business.builder.QuoteLogBuilder;
import kd.mpscmm.msbd.pricemodel.business.builder.SchemeLogBuilderFactory;
import kd.mpscmm.msbd.pricemodel.business.builder.StrategyLogBuilderFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.MarkDownHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteLogNode;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteInnerLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteSchemeGrpLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteStrategeLogProxy;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogClassEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogTypeEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.PriceCoverEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.SceneTypeEnum;

public class QuoteLogTreeNodeHelper {
    public static List<TreeNode> buildSchemeNode(String key, List<String> schemesPks, QuoteSchemeColl quoteSchemeColl, SceneTypeEnum sceneType, Map<String, Map<String, List<String>>> matchAllPriceCache) {
        ArrayList<TreeNode> schemesNodes = new ArrayList<TreeNode>();
        if (schemesPks == null || schemesPks.size() == 0) {
            return schemesNodes;
        }
        schemesPks.forEach(s -> {
            TreeNode schemeNode = new TreeNode();
            QuoteSchemeInfo scheme = quoteSchemeColl.getQuoteSchemes((String)s);
            List results = (List)((Map)matchAllPriceCache.get(s)).get(key);
            schemeNode.setId(scheme.getId());
            schemeNode.setType(sceneType.getValue());
            schemeNode.setData((Object)results);
            schemeNode.setLongNumber(String.valueOf(scheme.getSeq()));
            schemesNodes.add(schemeNode);
        });
        return schemesNodes;
    }

    public static List<TreeNode> buildStrategeNode(String key, List<String> strategePks, QuoteCalcColl quoteCalcColl, SceneTypeEnum sceneType, Map<String, Map<String, List<String>>> matchAllPriceCache) {
        ArrayList<TreeNode> strategeNodes = new ArrayList<TreeNode>();
        if (strategePks == null || strategePks.size() == 0) {
            return strategeNodes;
        }
        strategePks.forEach(s -> {
            TreeNode schemeNode = new TreeNode();
            QuoteCalcInfo calcInfo = quoteCalcColl.getQuoteCalcInfo((String)s);
            List results = (List)((Map)matchAllPriceCache.get(s)).get(key);
            schemeNode.setId(calcInfo.getId());
            schemeNode.setType(sceneType.getValue());
            schemeNode.setText(LogClassEnum.CALSTRATEGE.getValue());
            schemeNode.setData((Object)results);
            schemeNode.setLongNumber(String.valueOf(calcInfo.getSeq()));
            strategeNodes.add(schemeNode);
        });
        return strategeNodes;
    }

    public static void createQuoteLog(List<TreeNode> totalLogTreeNodes, QuoteLogProxy quoteLogProxy) {
        Object[] logArray = new DynamicObject[totalLogTreeNodes.size()];
        String[] logKeys = new String[totalLogTreeNodes.size()];
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)"plat_quotelog");
        String quoteDetailInfo = ResManager.loadKDString((String)"\u53d6\u4ef7\u8be6\u7ec6\u4fe1\u606f", (String)"QuoteLogTreeNodeHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteSuccess = ResManager.loadKDString((String)"\u53d6\u4ef7\u670d\u52a1\u6210\u529f", (String)"QuoteLogTreeNodeHelper_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteMethod = ResManager.loadKDString((String)"\u53d6\u4ef7\u89e6\u53d1\u65b9\u5f0f", (String)"QuoteLogTreeNodeHelper_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String fetchStarage = ResManager.loadKDString((String)"\u83b7\u53d6\u53d6\u4ef7\u7b56\u7565", (String)"QuoteLogTreeNodeHelper_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteStarage = ResManager.loadKDString((String)"\u53d6\u4ef7\u7b56\u7565\uff1a", (String)"QuoteLogTreeNodeHelper_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteCoverParam = ResManager.loadKDString((String)"\u53d6\u4ef7\u8986\u76d6\u53c2\u6570\uff1a", (String)"QuoteLogTreeNodeHelper_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteAuto = ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteManu = ResManager.loadKDString((String)"\u624b\u5de5\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String readStarage = ResManager.loadKDString((String)"\u89e3\u6790\u53d6\u4ef7\u7b56\u7565", (String)"QuoteLogTreeNodeHelper_8", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteStarageResult = ResManager.loadKDString((String)"\u53d6\u4ef7\u7ed3\u679c\uff1a", (String)"QuoteLogTreeNodeHelper_9", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        for (int i = 0; i < totalLogTreeNodes.size(); ++i) {
            String logKey;
            TreeNode rootNode = totalLogTreeNodes.get(i);
            DynamicObject quoteLog = new DynamicObject((DynamicObjectType)headType);
            quoteLog.set("quoteorg", (Object)quoteLogProxy.getQuoteOrgID());
            quoteLog.set("quotestarttime", (Object)quoteLogProxy.getStartTime());
            quoteLog.set("quoteendtime", (Object)quoteLogProxy.getEndTime());
            quoteLog.set("quotebill", (Object)quoteLogProxy.getQuoteBill());
            QuoteLogNode node = (QuoteLogNode)rootNode.getData();
            quoteLog.set("quotesrcbill", (Object)node.getQuoteSrcBill());
            quoteLog.set("quotesrcno", (Object)node.getQuoteSrcNo());
            if (StringUtils.isNotEmpty((CharSequence)node.getQuoteSrcSeq())) {
                quoteLog.set("quotesrcseq", (Object)Integer.valueOf(node.getQuoteSrcSeq()));
            }
            quoteLog.set("logresult", (Object)node.getResultDesc());
            StringBuilder logText = new StringBuilder(" ");
            DynamicObject starage = quoteLogProxy.getQuoteStratege();
            if (starage != null) {
                logText = new StringBuilder();
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteDetailInfo)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteSuccess)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteMethod)));
                logText.append("\n\n");
                if (quoteLogProxy.isAuto()) {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteAuto)));
                    logText.append("\n\n");
                } else {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteManu)));
                    logText.append("\n\n");
                }
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(fetchStarage)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteStarage)));
                logText.append(starage.getString("number")).append("&emsp;&emsp;").append(starage.getString("name"));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteCoverParam)));
                logText.append(PriceCoverEnum.getName(starage.getString("pricecoverrule")));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(readStarage)));
                logText.append("\n\n");
                List schemeNodes = rootNode.getChildren();
                for (TreeNode schemeNode : schemeNodes) {
                    String sceneType;
                    QuoteLogBuilder builder;
                    String[] idSeq = schemeNode.getId().split("__");
                    int seq = Integer.parseInt(schemeNode.getLongNumber());
                    if (idSeq.length > 1) {
                        seq = Integer.parseInt(idSeq[1]);
                    }
                    if ((builder = SchemeLogBuilderFactory.getBuilder(sceneType = schemeNode.getType())) != null) {
                        if (schemeNode.getData() == null) {
                            logText.append(builder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteSchemeColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, null));
                        } else {
                            logText.append(builder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteSchemeColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, (List)schemeNode.getData()));
                        }
                    } else {
                        QuoteCalLogBuilder calLogbuilder = StrategyLogBuilderFactory.getBuilder(sceneType);
                        if (schemeNode.getData() == null) {
                            logText.append(calLogbuilder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteCalcColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, null));
                        } else {
                            logText.append(calLogbuilder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteCalcColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, (List)schemeNode.getData()));
                        }
                    }
                    logText.append("\n\n");
                }
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteStarageResult)));
                logText.append("\n\n");
                String starageResult = MarkDownHelper.putTwoSpace(MarkDownHelper.thicker(new StringBuilder(quoteLog.getString("logresult")))).toString();
                logText.append(starageResult);
            }
            quoteLog.set("logjson_tag", (Object)logText.toString());
            String key = rootNode.getType();
            String[] subKeys = key.split("__");
            if (subKeys.length == 3) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
                quoteLog.set("quotebillentryid", (Object)Long.valueOf(subKeys[1]));
                quoteLog.set("quotebillseq", (Object)Integer.parseInt(subKeys[2]));
            } else if (subKeys.length == 1) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
            }
            Long billID = quoteLog.getLong("quotebillid");
            Long billEntryID = quoteLog.getLong("quotebillentryid");
            logKeys[i] = logKey = QuoteLogHelper.generateUniqueKey(billID, billEntryID);
            quoteLog.set("logkey", (Object)logKey);
            quoteLog.set("logtype", (Object)LogTypeEnum.NORMAL.getValue());
            quoteLog.set("quoteuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            logArray[i] = quoteLog;
        }
        try (TXHandle h = TX.requiresNew((String)"QuoteLogTreeNodeHelper");){
            try {
                QFilter orgFilter = new QFilter("quoteorg", "=", (Object)quoteLogProxy.getQuoteOrgID());
                QFilter quoteBillFilter = new QFilter("quotebill", "=", (Object)quoteLogProxy.getQuoteBill());
                QFilter logKeyFilter = new QFilter("logkey", "in", (Object)logKeys);
                QFilter lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.NORMAL.getValue());
                QFilter startDataFilter = new QFilter("quotestarttime", "<", (Object)quoteLogProxy.getStartTime());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{orgFilter, quoteBillFilter, logKeyFilter, lotTypeFilter, startDataFilter});
                QFilter logDelKeyFilter = new QFilter("logkey", "=", (Object)"");
                lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{logDelKeyFilter, lotTypeFilter, orgFilter, quoteBillFilter});
                SaveServiceHelper.save((IDataEntityType)headType, (Object[])logArray);
            }
            catch (KDBizException kde) {
                h.markRollback();
                throw kde;
            }
            catch (Exception kde) {
                h.markRollback();
                throw kde;
            }
        }
    }

    public static void createInnerQuoteLog(List<TreeNode> totalLogTreeNodes, QuoteInnerLogProxy quoteLogProxy) {
        Object[] logArray = new DynamicObject[totalLogTreeNodes.size()];
        String[] logKeys = new String[totalLogTreeNodes.size()];
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)"plat_quotelog");
        String quoteDetailInfo = ResManager.loadKDString((String)"\u53d6\u4ef7\u8be6\u7ec6\u4fe1\u606f", (String)"QuoteLogTreeNodeHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteSuccess = ResManager.loadKDString((String)"\u53d6\u4ef7\u670d\u52a1\u6210\u529f", (String)"QuoteLogTreeNodeHelper_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteMethod = ResManager.loadKDString((String)"\u53d6\u4ef7\u89e6\u53d1\u65b9\u5f0f", (String)"QuoteLogTreeNodeHelper_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String fetchSchemeGroup = ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u8ba1\u7b97\u56e0\u5b50\u201d\u4e0b\u7684\u53d6\u4ef7\u65b9\u6848\u7ec4", (String)"QuoteLogTreeNodeHelper_12", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String schemeGroup = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u7ec4\uff1a", (String)"QuoteLogTreeNodeHelper_13", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteAuto = ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteManu = ResManager.loadKDString((String)"\u624b\u5de5\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String readStarage = ResManager.loadKDString((String)"\u89e3\u6790\u53d6\u4ef7\u65b9\u6848\u7ec4", (String)"QuoteLogTreeNodeHelper_14", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteStarageResult = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u7ec4\u4ef7\u683c\u7ed3\u679c\uff1a", (String)"QuoteLogTreeNodeHelper_15", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        for (int i = 0; i < totalLogTreeNodes.size(); ++i) {
            String logKey;
            TreeNode rootNode = totalLogTreeNodes.get(i);
            DynamicObject quoteLog = new DynamicObject((DynamicObjectType)headType);
            quoteLog.set("quoteorg", (Object)quoteLogProxy.getQuoteOrgID());
            quoteLog.set("quotestarttime", (Object)quoteLogProxy.getStartTime());
            quoteLog.set("quoteendtime", (Object)quoteLogProxy.getEndTime());
            quoteLog.set("quotebill", (Object)quoteLogProxy.getQuoteBill());
            QuoteLogNode node = (QuoteLogNode)rootNode.getData();
            quoteLog.set("quotesrcbill", (Object)node.getQuoteSrcBill());
            quoteLog.set("quotesrcno", (Object)node.getQuoteSrcNo());
            if (StringUtils.isNotEmpty((CharSequence)node.getQuoteSrcSeq())) {
                quoteLog.set("quotesrcseq", (Object)Integer.valueOf(node.getQuoteSrcSeq()));
            }
            quoteLog.set("logresult", (Object)node.getResultDesc());
            StringBuilder logText = new StringBuilder(" ");
            List schemeNodes = rootNode.getChildren();
            QuoteSchemeGroupInfo schemeGroupInfo = quoteLogProxy.getQuoteSchemeGroupInfo();
            if (schemeGroupInfo != null && schemeNodes != null && schemeNodes.size() > 0) {
                logText = new StringBuilder();
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteDetailInfo)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteSuccess)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteMethod)));
                logText.append("\n\n");
                if (quoteLogProxy.isAuto()) {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteAuto)));
                    logText.append("\n\n");
                } else {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteManu)));
                    logText.append("\n\n");
                }
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(fetchSchemeGroup)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(schemeGroup)));
                logText.append(schemeGroupInfo.getNumber()).append("&emsp;&emsp;").append(schemeGroupInfo.getName());
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(readStarage)));
                logText.append("\n\n");
                for (TreeNode schemeNode : schemeNodes) {
                    String sceneType;
                    QuoteLogBuilder builder;
                    String[] idSeq = schemeNode.getId().split("__");
                    int seq = Integer.parseInt(schemeNode.getLongNumber());
                    if (idSeq.length > 1) {
                        seq = Integer.parseInt(idSeq[1]);
                    }
                    if ((builder = SchemeLogBuilderFactory.getBuilder(sceneType = schemeNode.getType())) != null) {
                        if (schemeNode.getData() == null) {
                            logText.append(builder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteSchemeColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, null));
                        } else {
                            logText.append(builder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteSchemeColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, (List)schemeNode.getData()));
                        }
                    } else {
                        QuoteCalLogBuilder calLogbuilder = StrategyLogBuilderFactory.getBuilder(sceneType);
                        if (schemeNode.getData() == null) {
                            logText.append(calLogbuilder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteCalcColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, null));
                        } else {
                            logText.append(calLogbuilder.build(quoteLogProxy.getQuoteStrategeColl().getQuoteCalcColl(quoteLogProxy.getQuoteStratege()), schemeNode.getId(), seq, (List)schemeNode.getData()));
                        }
                    }
                    logText.append("\n\n");
                }
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteStarageResult)));
                logText.append("\n\n");
                String starageResult = MarkDownHelper.putTwoSpace(MarkDownHelper.thicker(new StringBuilder(quoteLog.getString("logresult")))).toString();
                logText.append(starageResult);
            }
            quoteLog.set("logjson_tag", (Object)logText.toString());
            String key = rootNode.getType();
            String[] subKeys = key.split("__");
            if (subKeys.length == 3) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
                quoteLog.set("quotebillentryid", (Object)Long.valueOf(subKeys[1]));
                quoteLog.set("quotebillseq", (Object)Integer.parseInt(subKeys[2]));
            } else if (subKeys.length == 1) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
            }
            Long billID = quoteLog.getLong("quotebillid");
            Long billEntryID = quoteLog.getLong("quotebillentryid");
            logKeys[i] = logKey = QuoteLogHelper.generateUniqueKey(billID, billEntryID);
            quoteLog.set("logkey", (Object)logKey);
            quoteLog.set("logtype", (Object)LogTypeEnum.NORMAL.getValue());
            quoteLog.set("quoteuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            String calcID = quoteLogProxy.getQuoteCalcInfo().getId();
            calcID = calcID.split("__")[0];
            quoteLog.set("calstrategy", (Object)Long.valueOf(calcID));
            Long groupID = quoteLogProxy.getQuoteSchemeGroupInfo().getId();
            quoteLog.set("quoteschemegroup", (Object)groupID);
            quoteLog.set("featurevalue", (Object)node.getFeatureValue());
            logArray[i] = quoteLog;
        }
        try (TXHandle h = TX.requiresNew((String)"QuoteLogTreeNodeHelper");){
            try {
                QFilter orgFilter = new QFilter("quoteorg", "=", (Object)quoteLogProxy.getQuoteOrgID());
                QFilter quoteBillFilter = new QFilter("quotebill", "=", (Object)quoteLogProxy.getQuoteBill());
                QFilter logDelKeyFilter = new QFilter("logkey", "=", (Object)"");
                QFilter lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{logDelKeyFilter, lotTypeFilter, orgFilter, quoteBillFilter});
                SaveServiceHelper.save((IDataEntityType)headType, (Object[])logArray);
            }
            catch (KDBizException kde) {
                h.markRollback();
                throw kde;
            }
            catch (Exception kde) {
                h.markRollback();
                throw kde;
            }
        }
    }

    public static void createSchemeGrpQuoteLog(List<TreeNode> totalLogTreeNodes, QuoteSchemeGrpLogProxy quoteLogProxy) {
        Object[] logArray = new DynamicObject[totalLogTreeNodes.size()];
        String[] logKeys = new String[totalLogTreeNodes.size()];
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)"plat_quotelog");
        String quoteDetailInfo = ResManager.loadKDString((String)"\u53d6\u4ef7\u8be6\u7ec6\u4fe1\u606f", (String)"QuoteLogTreeNodeHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteSuccess = ResManager.loadKDString((String)"\u53d6\u4ef7\u670d\u52a1\u6210\u529f", (String)"QuoteLogTreeNodeHelper_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteMethod = ResManager.loadKDString((String)"\u53d6\u4ef7\u89e6\u53d1\u65b9\u5f0f", (String)"QuoteLogTreeNodeHelper_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String fetchSchemeGroup = ResManager.loadKDString((String)"\u83b7\u53d6\u201c\u8ba1\u7b97\u56e0\u5b50\u201d\u4e0b\u7684\u53d6\u4ef7\u65b9\u6848\u7ec4", (String)"QuoteLogTreeNodeHelper_12", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String schemeGroup = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u7ec4\uff1a", (String)"QuoteLogTreeNodeHelper_13", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteAuto = ResManager.loadKDString((String)"\u81ea\u52a8\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteManu = ResManager.loadKDString((String)"\u624b\u5de5\u53d6\u4ef7", (String)"QuoteLogTreeNodeHelper_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String readStarage = ResManager.loadKDString((String)"\u89e3\u6790\u53d6\u4ef7\u65b9\u6848\u7ec4", (String)"QuoteLogTreeNodeHelper_14", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteStarageResult = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u7ec4\u4ef7\u683c\u7ed3\u679c\uff1a", (String)"QuoteLogTreeNodeHelper_15", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteSchemeGroupInfo = ResManager.loadKDString((String)"\u65b9\u6848\u7ec4\u4ef7\u683c\u7ed3\u679c\u6765\u81ea\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\uff1a", (String)"QuoteLogTreeNodeHelper_16", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        for (int i = 0; i < totalLogTreeNodes.size(); ++i) {
            String logKey;
            TreeNode rootNode = totalLogTreeNodes.get(i);
            DynamicObject quoteLog = new DynamicObject((DynamicObjectType)headType);
            quoteLog.set("quoteorg", (Object)quoteLogProxy.getQuoteOrgID());
            quoteLog.set("quotestarttime", (Object)quoteLogProxy.getStartTime());
            quoteLog.set("quoteendtime", (Object)quoteLogProxy.getEndTime());
            quoteLog.set("quotebill", (Object)quoteLogProxy.getQuoteBill());
            QuoteLogNode node = (QuoteLogNode)rootNode.getData();
            quoteLog.set("quotesrcbill", (Object)node.getQuoteSrcBill());
            quoteLog.set("quotesrcno", (Object)node.getQuoteSrcNo());
            if (StringUtils.isNotEmpty((CharSequence)node.getQuoteSrcSeq())) {
                quoteLog.set("quotesrcseq", (Object)Integer.valueOf(node.getQuoteSrcSeq()));
            }
            quoteLog.set("logresult", (Object)node.getResultDesc());
            StringBuilder logText = new StringBuilder();
            QuoteSchemeGroupInfo schemeGroupInfo = quoteLogProxy.getQuoteSchemeGroupInfo();
            if (schemeGroupInfo != null) {
                logText = new StringBuilder();
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteDetailInfo)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteSuccess)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteMethod)));
                logText.append("\n\n");
                if (quoteLogProxy.isAuto()) {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteAuto)));
                    logText.append("\n\n");
                } else {
                    logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteManu)));
                    logText.append("\n\n");
                }
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(fetchSchemeGroup)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(schemeGroup)));
                logText.append(schemeGroupInfo.getNumber()).append("&emsp;&emsp;").append(schemeGroupInfo.getName());
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(readStarage)));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteSchemeGroupInfo).append(rootNode.getText())));
                logText.append("\n\n");
                logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteStarageResult)));
                logText.append("\n\n");
                String starageResult = MarkDownHelper.putTwoSpace(MarkDownHelper.thicker(new StringBuilder(quoteLog.getString("logresult")))).toString();
                logText.append(starageResult);
            }
            quoteLog.set("logjson_tag", (Object)logText.toString());
            String key = rootNode.getType();
            String[] subKeys = key.split("__");
            if (subKeys.length == 3) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
                quoteLog.set("quotebillentryid", (Object)Long.valueOf(subKeys[1]));
                quoteLog.set("quotebillseq", (Object)Integer.parseInt(subKeys[2]));
            } else if (subKeys.length == 1) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
            }
            Long billID = quoteLog.getLong("quotebillid");
            Long billEntryID = quoteLog.getLong("quotebillentryid");
            logKeys[i] = logKey = QuoteLogHelper.generateUniqueKey(billID, billEntryID);
            quoteLog.set("logkey", (Object)logKey);
            quoteLog.set("logtype", (Object)LogTypeEnum.NORMAL.getValue());
            quoteLog.set("quoteuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            String calcID = quoteLogProxy.getQuoteCalcInfo().getId();
            calcID = calcID.split("__")[0];
            quoteLog.set("calstrategy", (Object)Long.valueOf(calcID));
            Long groupID = quoteLogProxy.getQuoteSchemeGroupInfo().getId();
            quoteLog.set("quoteschemegroup", (Object)groupID);
            logArray[i] = quoteLog;
        }
        try (TXHandle h = TX.requiresNew((String)"QuoteLogTreeNodeHelper");){
            try {
                QFilter orgFilter = new QFilter("quoteorg", "=", (Object)quoteLogProxy.getQuoteOrgID());
                QFilter quoteBillFilter = new QFilter("quotebill", "=", (Object)quoteLogProxy.getQuoteBill());
                QFilter logDelKeyFilter = new QFilter("logkey", "=", (Object)"");
                QFilter lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
                DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{logDelKeyFilter, lotTypeFilter, orgFilter, quoteBillFilter});
                SaveServiceHelper.save((IDataEntityType)headType, (Object[])logArray);
            }
            catch (KDBizException kde) {
                h.markRollback();
                throw kde;
            }
            catch (Exception kde) {
                h.markRollback();
                throw kde;
            }
        }
    }

    public static void createQuoteStrategeLog(List<TreeNode> totalLogTreeNodes, QuoteStrategeLogProxy strategeLogProxy, String reasonType) {
        Object[] logArray = new DynamicObject[totalLogTreeNodes.size()];
        String[] logKeys = new String[totalLogTreeNodes.size()];
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)"plat_quotelog");
        String quoteDetailInfo = ResManager.loadKDString((String)"\u53d6\u4ef7\u8be6\u7ec6\u4fe1\u606f", (String)"QuoteLogTreeNodeHelper_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String quoteSuccess = ResManager.loadKDString((String)"\u53d6\u4ef7\u670d\u52a1\u6210\u529f", (String)"QuoteLogTreeNodeHelper_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        String fetchStarage = "";
        if ("MULTI".equals(reasonType)) {
            fetchStarage = ResManager.loadKDString((String)"\u83b7\u53d6\u53d6\u4ef7\u7b56\u7565\u5931\u8d25\uff0c\u547d\u4e2d\u591a\u6761\u53d6\u4ef7\u7b56\u7565\u3002", (String)"QuoteLogTreeNodeHelper_10", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        } else if ("NONE".equals(reasonType)) {
            fetchStarage = ResManager.loadKDString((String)"\u83b7\u53d6\u53d6\u4ef7\u7b56\u7565\u5931\u8d25\uff0c\u6ca1\u6709\u547d\u4e2d\u53d6\u4ef7\u7b56\u7565\u3002", (String)"QuoteLogTreeNodeHelper_11", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        }
        for (int i = 0; i < totalLogTreeNodes.size(); ++i) {
            String logKey;
            TreeNode rootNode = totalLogTreeNodes.get(i);
            DynamicObject quoteLog = new DynamicObject((DynamicObjectType)headType);
            quoteLog.set("quoteorg", (Object)strategeLogProxy.getQuoteOrgID());
            quoteLog.set("quotestarttime", (Object)strategeLogProxy.getStartTime());
            quoteLog.set("quoteendtime", (Object)strategeLogProxy.getEndTime());
            quoteLog.set("quotebill", (Object)strategeLogProxy.getQuoteBill());
            QuoteLogNode node = (QuoteLogNode)rootNode.getData();
            quoteLog.set("logresult", (Object)node.getResultDesc());
            StringBuilder logText = new StringBuilder();
            logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(quoteDetailInfo)));
            logText.append("\n\n");
            logText.append((CharSequence)MarkDownHelper.putTwoSpace(new StringBuilder(quoteSuccess)));
            logText.append("\n\n");
            logText.append((CharSequence)MarkDownHelper.getFourLevel(new StringBuilder(fetchStarage)));
            logText.append("\n\n");
            quoteLog.set("logjson_tag", (Object)logText.toString());
            String key = rootNode.getType();
            String[] subKeys = key.split("__");
            if (subKeys.length == 3) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
                quoteLog.set("quotebillentryid", (Object)Long.valueOf(subKeys[1]));
                quoteLog.set("quotebillseq", (Object)Integer.parseInt(subKeys[2]));
            } else if (subKeys.length == 1) {
                quoteLog.set("quotebillid", (Object)Long.valueOf(subKeys[0]));
            }
            Long billID = quoteLog.getLong("quotebillid");
            Long billEntryID = quoteLog.getLong("quotebillentryid");
            logKeys[i] = logKey = QuoteLogHelper.generateUniqueKey(billID, billEntryID);
            quoteLog.set("logkey", (Object)logKey);
            quoteLog.set("logtype", (Object)LogTypeEnum.NORMAL.getValue());
            quoteLog.set("quoteuser", (Object)Long.valueOf(RequestContext.get().getUserId()));
            logArray[i] = quoteLog;
        }
        if (logArray.length > 0) {
            try (TXHandle h = TX.requiresNew((String)"QuoteLogTreeNodeHelper");){
                try {
                    QFilter orgFilter = new QFilter("quoteorg", "=", (Object)strategeLogProxy.getQuoteOrgID());
                    QFilter quoteBillFilter = new QFilter("quotebill", "=", (Object)strategeLogProxy.getQuoteBill());
                    QFilter logKeyFilter = new QFilter("logkey", "in", (Object)logKeys);
                    QFilter lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.NORMAL.getValue());
                    DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{orgFilter, quoteBillFilter, logKeyFilter, lotTypeFilter});
                    QFilter logDelKeyFilter = new QFilter("logkey", "=", (Object)"");
                    lotTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
                    DeleteServiceHelper.delete((String)"plat_quotelog", (QFilter[])new QFilter[]{logDelKeyFilter, lotTypeFilter, orgFilter, quoteBillFilter});
                    SaveServiceHelper.save((IDataEntityType)headType, (Object[])logArray);
                }
                catch (KDBizException kde) {
                    h.markRollback();
                    throw kde;
                }
                catch (Exception kde) {
                    h.markRollback();
                    throw kde;
                }
            }
        }
    }
}

