/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.quote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategySeqInfo;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;

public class QuoteSchemeColl {
    private DynamicObject quoteStratege;
    protected List<DynamicObject> quoteSchemes = new ArrayList<DynamicObject>();
    protected Map<String, QuoteSchemeInfo> mapping = new HashMap<String, QuoteSchemeInfo>();
    protected List<QuoteSchemeInfo> quoteSchemeInfos = new ArrayList<QuoteSchemeInfo>();

    public QuoteSchemeColl(DynamicObject quoteStratege) {
        this.quoteStratege = quoteStratege;
    }

    public void applyScheme(DynamicObject quoteScheme, QuoteStrategySeqInfo quoteStrategySeqInfo) {
        this.quoteSchemes.add(quoteScheme);
        QuoteSchemeInfo quoteSchemeInfo = new QuoteSchemeInfo();
        this.mapping.put(QuoteOtherHelper.generateSchemeKey(quoteScheme.getPkValue(), quoteStrategySeqInfo.getSeq()), quoteSchemeInfo.generateSchemeInfo(quoteScheme, quoteStrategySeqInfo));
        this.quoteSchemeInfos.add(quoteSchemeInfo);
    }

    public List<String> mergeDimension(List<String> dimensionSet) {
        this.quoteSchemeInfos.forEach(q -> {
            q.getQuoteDimensions().forEach(d -> {
                if (!dimensionSet.contains(d)) {
                    dimensionSet.add((String)d);
                }
            });
            q.getConfigureDimension().forEach(d -> {
                if (!dimensionSet.contains(d)) {
                    dimensionSet.add((String)d);
                }
            });
            q.getQuotePreFilters().forEach(f -> this.generateDimension(dimensionSet, (QFilter)f));
        });
        return dimensionSet;
    }

    public List<String> mergeAlias(List<String> aliasSet) {
        this.quoteSchemeInfos.forEach(q -> {
            q.getQuoteAlias().forEach(d -> {
                if (!aliasSet.contains(d)) {
                    aliasSet.add((String)d);
                }
            });
            q.getConfigureAlias().forEach(d -> {
                if (!aliasSet.contains(d)) {
                    aliasSet.add((String)d);
                }
            });
            q.getQuotePreFilters().forEach(f -> this.generateAlias(aliasSet, (QFilter)f));
        });
        return aliasSet;
    }

    public List<String> mergeTerminateSign(List<String> terminateSignSet) {
        this.quoteSchemeInfos.forEach(qs -> {
            String terminationSign = qs.getTerminationSignX();
            if (!terminateSignSet.contains(terminationSign)) {
                terminateSignSet.add(terminationSign);
            }
        });
        return terminateSignSet;
    }

    public List<String> mergeQuoteResult(List<String> quoteResultSet) {
        this.quoteSchemeInfos.forEach(q -> q.getQuoteResults().forEach(d -> {
            if (!quoteResultSet.contains(d) && !"schemegroupprice".equals(d)) {
                quoteResultSet.add((String)d);
            }
        }));
        return quoteResultSet;
    }

    public List<String> mergeQuoteResultAlias(List<String> quoteResultAliasSet) {
        this.quoteSchemeInfos.forEach(q -> q.getQuoteResultsAlias().forEach(d -> {
            if (!quoteResultAliasSet.contains(d) && !PriceHelper.getLeftName("schemegroupprice").equals(d)) {
                quoteResultAliasSet.add((String)d);
            }
        }));
        return quoteResultAliasSet;
    }

    public List<DynamicObject> getQuoteSchemes() {
        return this.quoteSchemes;
    }

    public QuoteSchemeInfo getQuoteSchemes(String qsID) {
        return this.mapping.get(qsID);
    }

    public DynamicObject getQuoteStratege() {
        return this.quoteStratege;
    }

    public void setQuoteStratege(DynamicObject quoteStratege) {
        this.quoteStratege = quoteStratege;
    }

    public List<QuoteSchemeInfo> getQuoteSchemeInfos() {
        return this.quoteSchemeInfos;
    }

    private void generateDimension(List<String> dimensionSet, QFilter f) {
        if (!dimensionSet.contains(f.getProperty())) {
            dimensionSet.add(f.getProperty());
        }
        if (f.isExpressValue() && !dimensionSet.contains(f.getValue())) {
            dimensionSet.add(f.getValue().toString());
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateDimension(dimensionSet, nestFilter);
        }
    }

    private void generateAlias(List<String> aliasSet, QFilter f) {
        String valueAlias;
        String alias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(f.getProperty().replaceAll("\\.", "__"))).toString();
        if (!aliasSet.contains(alias)) {
            aliasSet.add(alias);
        }
        if (f.isExpressValue() && !aliasSet.contains(valueAlias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(f.getValue().toString().replaceAll("\\.", "__"))).toString())) {
            aliasSet.add(valueAlias);
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateAlias(aliasSet, nestFilter);
        }
    }
}

