/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.quote;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteExtHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceSourceKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteProcessInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategySeqInfo;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.OrderEnum;
import kd.sdk.mpscmm.msbd.expoint.quote.QuoteFilterParam;

public class QuoteSchemeInfo
extends QuoteProcessInfo {
    private DynamicObject quoteScheme;
    private boolean orgDivide;
    private List<String> quoteDimensions = new ArrayList<String>();
    private List<String> quoteDimensionsDes = new ArrayList<String>();
    private List<String> quoteAlias = new ArrayList<String>();
    private List<String> configureDimension = new ArrayList<String>();
    private List<String> configureAlias = new ArrayList<String>();
    private List<String> configureDimensionDes = new ArrayList<String>();
    private List<String> configureSourceDimension = new ArrayList<String>();
    private List<String> configureSourceAlias = new ArrayList<String>();
    private List<String> configureSourceDimensionDes = new ArrayList<String>();
    private List<String> quoteSourceDimensions = new ArrayList<String>();
    private List<String> quoteSourceDimensionsDes = new ArrayList<String>();
    private List<String> quoteSourceAlias = new ArrayList<String>();
    private List<String> quoteSourceResult = new ArrayList<String>();
    private List<String> quoteSourceResultAlias = new ArrayList<String>();
    private PriceSourceKeyInfo PriceSourceKeyInfo;
    private List<String> operators = new ArrayList<String>();
    private List<String> configureOperators = new ArrayList<String>();
    private List<String> sortSignFields = new ArrayList<String>();
    private List<String> sortSignsDes = new ArrayList<String>();
    private List<String> sortSignAlias = new ArrayList<String>();
    private List<String> sortOrders = new ArrayList<String>();

    private QuoteSchemeInfo generateSchemeInfo(DynamicObject quoteScheme) {
        String sourceSign;
        String quoteSign;
        this.quoteScheme = quoteScheme;
        DynamicObjectCollection mappingEntry = quoteScheme.getDynamicObjectCollection("entryentity");
        for (Object mappingInfo : mappingEntry) {
            String matchFlag = mappingInfo.getString("matchflag");
            quoteSign = mappingInfo.getString("quotesign");
            sourceSign = mappingInfo.getString("sourcesign");
            String quoteSignDes = mappingInfo.getString("quotesignname");
            String sourceSignDes = mappingInfo.getString("sourcesignname");
            if (OperatorEnum.CONFIGURED.getValue().equals(matchFlag)) {
                this.configureDimension.add(quoteSign);
                this.configureDimensionDes.add(quoteSignDes);
                this.configureSourceDimension.add(sourceSign);
                this.configureSourceDimensionDes.add(sourceSignDes);
                this.configureAlias.add(PriceHelper.getLeftName(quoteSign));
                this.configureSourceAlias.add(PriceHelper.getRightName(sourceSign));
                this.configureOperators.add(matchFlag);
                continue;
            }
            this.quoteDimensions.add(quoteSign);
            this.quoteDimensionsDes.add(quoteSignDes);
            this.quoteAlias.add(PriceHelper.getLeftName(quoteSign));
            this.quoteSourceDimensions.add(sourceSign);
            this.quoteSourceDimensionsDes.add(sourceSignDes);
            this.quoteSourceAlias.add(PriceHelper.getRightName(sourceSign));
            this.operators.add(matchFlag);
        }
        DynamicObjectCollection resultEntry = quoteScheme.getDynamicObjectCollection("entryresult");
        for (DynamicObject resultInfo : resultEntry) {
            quoteSign = resultInfo.getString("quotesignr");
            sourceSign = resultInfo.getString("sourcesignr");
            if (StringUtils.isNotEmpty((String)quoteSign)) {
                this.quoteResults.add(quoteSign);
                this.quoteResultsAlias.add(PriceHelper.getLeftName(quoteSign));
            } else {
                this.quoteResults.add("schemegroupprice");
                this.quoteResultsAlias.add(PriceHelper.getLeftName("schemegroupprice"));
            }
            this.quoteSourceResult.add(sourceSign);
            this.quoteSourceResultAlias.add(PriceHelper.getRightName(sourceSign));
        }
        this.PriceSourceKeyInfo = QuoteHelper.getQuoteSrcCommonConst(this.quoteSrcType, this);
        DynamicObjectCollection sortEntry = quoteScheme.getDynamicObjectCollection("pricesortentity");
        for (DynamicObject sortInfo : sortEntry) {
            if (!StringUtils.isNotEmpty((String)sortInfo.getString("sortsign"))) continue;
            this.sortSignFields.add(sortInfo.getString("sortsign"));
            this.sortSignsDes.add(sortInfo.getString("sortsignname"));
            this.sortOrders.add(OrderEnum.getProptery(sortInfo.getString("order")));
            this.sortSignAlias.add(PriceHelper.getRightName(sortInfo.getString("sortsign")));
        }
        this.orgDivide = quoteScheme.getBoolean("orgdivide");
        this.use = quoteScheme.getString("use");
        return this;
    }

    private QuoteSchemeInfo generateSchemeInfoByMapping(DynamicObject quoteScheme, QuoteStrategySeqInfo quoteStrategySeqInfo) {
        String sourceSignDes;
        String quoteSignDes;
        String sourceSign;
        String quoteSign;
        this.quoteScheme = quoteScheme;
        this.quoteSrcType = quoteScheme.getDynamicObject("pricesourceentity").getString("number");
        DynamicObjectCollection mappingEntry = quoteScheme.getDynamicObjectCollection("entryentity");
        Map<String, String> quoteFieldMapping = quoteStrategySeqInfo.getQuoteFieldMapping();
        Map<String, String> sourceFieldMapping = quoteStrategySeqInfo.getSourceFieldMapping();
        MainEntityType quoteBillType = EntityMetadataCache.getDataEntityType((String)this.getQuoteType());
        MainEntityType priceSourceType = EntityMetadataCache.getDataEntityType((String)this.getQuoteSrcType());
        for (Object mappingInfo : mappingEntry) {
            String matchFlag = mappingInfo.getString("matchflag");
            quoteSign = mappingInfo.getString("quotesign");
            sourceSign = mappingInfo.getString("sourcesign");
            quoteSignDes = mappingInfo.getString("quotesignname");
            sourceSignDes = mappingInfo.getString("sourcesignname");
            quoteSign = quoteFieldMapping.get(quoteSign);
            sourceSign = sourceFieldMapping.get(sourceSign);
            if (StringUtils.isEmpty((String)quoteSign)) {
                String message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u53d6\u4ef7\u5355\u636e\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), this.getName(), quoteBillType.getDisplayName(), quoteSignDes);
                throw new KDBizException(message);
            }
            if (StringUtils.isEmpty((String)sourceSign)) {
                String message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u4ef7\u683c\u6765\u6e90\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), this.getName(), priceSourceType.getDisplayName(), sourceSignDes);
                throw new KDBizException(message);
            }
            quoteSignDes = QuoteOtherHelper.getFullCaption(quoteBillType, quoteSign);
            sourceSignDes = QuoteOtherHelper.getFullCaption(priceSourceType, sourceSign);
            if (OperatorEnum.CONFIGURED.getValue().equals(matchFlag)) {
                this.configureDimension.add(quoteSign);
                this.configureDimensionDes.add(quoteSignDes);
                this.configureSourceDimension.add(sourceSign);
                this.configureSourceDimensionDes.add(sourceSignDes);
                this.configureAlias.add(PriceHelper.getLeftName(quoteSign));
                this.configureSourceAlias.add(PriceHelper.getRightName(sourceSign));
                this.configureOperators.add(matchFlag);
                continue;
            }
            this.quoteDimensions.add(quoteSign);
            this.quoteDimensionsDes.add(quoteSignDes);
            this.quoteAlias.add(PriceHelper.getLeftName(quoteSign));
            this.quoteSourceDimensions.add(sourceSign);
            this.quoteSourceDimensionsDes.add(sourceSignDes);
            this.quoteSourceAlias.add(PriceHelper.getRightName(sourceSign));
            this.operators.add(matchFlag);
        }
        DynamicObjectCollection resultEntry = quoteScheme.getDynamicObjectCollection("entryresult");
        for (DynamicObject resultInfo : resultEntry) {
            quoteSign = resultInfo.getString("quotesignr");
            sourceSign = resultInfo.getString("sourcesignr");
            quoteSignDes = resultInfo.getString("quotesignnamer");
            sourceSignDes = resultInfo.getString("sourcesignnamer");
            quoteSign = quoteFieldMapping.get(quoteSign);
            sourceSign = sourceFieldMapping.get(sourceSign);
            if (StringUtils.isEmpty((String)quoteSign)) {
                String message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u53d6\u4ef7\u5355\u636e\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), this.getName(), quoteBillType.getDisplayName(), quoteSignDes);
                throw new KDBizException(message);
            }
            if (StringUtils.isEmpty((String)sourceSign)) {
                String message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u89e3\u6790\u5931\u8d25\uff0c\u672a\u7ef4\u62a4\u4ef7\u683c\u6765\u6e90\u201c%2$s\u201d\u4e0e\u4ef7\u683c\u6a21\u578b\u5b57\u6bb5\u201c%3$s\u201d\u7684\u901a\u7528\u6620\u5c04\u914d\u7f6e\u3002", (String)"QuoteSchemeInfo_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), this.getName(), priceSourceType.getDisplayName(), sourceSignDes);
                throw new KDBizException(message);
            }
            if (StringUtils.isNotEmpty((String)quoteSign)) {
                this.quoteResults.add(quoteSign);
                this.quoteResultsAlias.add(PriceHelper.getLeftName(quoteSign));
            } else {
                this.quoteResults.add("schemegroupprice");
                this.quoteResultsAlias.add(PriceHelper.getLeftName("schemegroupprice"));
            }
            this.quoteSourceResult.add(sourceSign);
            this.quoteSourceResultAlias.add(PriceHelper.getRightName(sourceSign));
        }
        this.PriceSourceKeyInfo = QuoteHelper.getQuoteSrcCommonConst(this.quoteSrcType, this);
        DynamicObjectCollection sortEntry = quoteScheme.getDynamicObjectCollection("pricesortentity");
        for (DynamicObject sortInfo : sortEntry) {
            if (!StringUtils.isNotEmpty((String)sortInfo.getString("sortsign"))) continue;
            this.sortSignFields.add(sortInfo.getString("sortsign"));
            this.sortSignsDes.add(sortInfo.getString("sortsignname"));
            this.sortOrders.add(OrderEnum.getProptery(sortInfo.getString("order")));
            this.sortSignAlias.add(PriceHelper.getRightName(sortInfo.getString("sortsign")));
        }
        this.orgDivide = quoteScheme.getBoolean("orgdivide");
        this.use = quoteScheme.getString("use");
        return this;
    }

    public QuoteSchemeInfo generateSchemeInfo(DynamicObject quoteScheme, QuoteStrategySeqInfo quoteStrategySeqInfo) {
        QuoteFilterParam event;
        List<Boolean> extResult;
        this.quoteSrcType = quoteScheme.getDynamicObject("pricesourceentity").getString("number");
        if (StringUtils.isNotEmpty((String)quoteStrategySeqInfo.getTerminationSign())) {
            quoteStrategySeqInfo.setTerminationSign(new StringBuffer(PriceConst.RIGHT).append(new StringBuffer(quoteStrategySeqInfo.getTerminationSign().replaceAll("\\.", "__"))).toString());
        }
        super.generateProcessInfo(quoteScheme, quoteStrategySeqInfo);
        if (!QuoteHelper.isDimensionMode(quoteScheme)) {
            this.generateSchemeInfo(quoteScheme);
        } else {
            this.generateSchemeInfoByMapping(quoteScheme, quoteStrategySeqInfo);
            DynamicObject quoteEntity = BusinessDataServiceHelper.newDynamicObject((String)"bos_entityobject");
            quoteEntity.set("number", (Object)this.quoteType);
            quoteEntity.set("id", (Object)this.quoteType);
            quoteScheme.set("quoteentity", (Object)quoteEntity);
        }
        List<String> quoteSourceResult = this.getQuoteSourceResultAlias();
        String terminationSignInit = this.getTerminationSignInit();
        List<String> results = this.getQuoteResults();
        for (int i = 0; i < quoteSourceResult.size(); ++i) {
            if (!quoteSourceResult.get(i).equals(terminationSignInit)) continue;
            this.terminationSignX = results.get(i);
            break;
        }
        if ((extResult = QuoteExtHelper.callResetFilter(event = new QuoteFilterParam(this.getQuotePreFilter(), this.getQuoteSrcFilter(), this.getQuoteScheme(), null))) != null && extResult.size() > 0) {
            this.setQuoteSrcFilter(event.getSourceFilter());
            this.setQuotePreFilter(event.getQuotePreFilter());
            this.quotePreConditonDesc = StringUtils.isEmpty((String)this.quotePreConditonDesc) ? event.getQuotePreFilterDesc() : this.quotePreConditonDesc + " " + "and" + " " + event.getQuotePreFilterDesc();
            this.quotePreFilters = PriceHelper.transferToQFilters(event.getQuotePreFilter());
        }
        if (!QuoteExtHelper.isReplaceQuote(this) && this.isLackSourceField()) {
            String message = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u53ef\u80fd\u65b9\u6848\u62d3\u5c55\u573a\u666f\u5b58\u5728\u903b\u8f91\u53d8\u66f4\u3002", (String)"QuoteSchemeInfo_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), this.getName());
            throw new KDBizException(message);
        }
        return this;
    }

    public List<String> mergeQuoteSourceFields() {
        ArrayList<String> allSourceSelecties = new ArrayList<String>();
        this.getQuoteSourceDimensions().forEach(q -> {
            if (!allSourceSelecties.contains(q) && StringUtils.isNotEmpty((String)q)) {
                allSourceSelecties.add((String)q);
            }
        });
        this.getConfigureSourceDimension().forEach(q -> {
            if (!allSourceSelecties.contains(q) && StringUtils.isNotEmpty((String)q)) {
                allSourceSelecties.add((String)q);
            }
        });
        this.getQuoteSourceResult().forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        this.getSortSignFields().forEach(q -> {
            if (!allSourceSelecties.contains(q)) {
                allSourceSelecties.add((String)q);
            }
        });
        return allSourceSelecties;
    }

    public List<String> mergeQuoteSourceAlias() {
        ArrayList<String> allAliasSelecties = new ArrayList<String>();
        this.getQuoteSourceAlias().forEach(q -> {
            String qback = PriceHelper.backRightName(q);
            if (!allAliasSelecties.contains(q) && StringUtils.isNotEmpty((String)qback)) {
                allAliasSelecties.add((String)q);
            }
        });
        this.getConfigureSourceAlias().forEach(q -> {
            String qback = PriceHelper.backRightName(q);
            if (!allAliasSelecties.contains(q) && StringUtils.isNotEmpty((String)qback)) {
                allAliasSelecties.add((String)q);
            }
        });
        this.getQuoteSourceResultAlias().forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        this.getSortSignAlias().forEach(q -> {
            if (!allAliasSelecties.contains(q)) {
                allAliasSelecties.add((String)q);
            }
        });
        return allAliasSelecties;
    }

    public boolean isConfigure() {
        return this.configureDimension.size() > 0;
    }

    public boolean isLackSourceField() {
        for (String quoteSourceDimension : this.getQuoteSourceDimensions()) {
            if (!StringUtils.isEmpty((String)quoteSourceDimension)) continue;
            return true;
        }
        for (String configureDimension : this.getConfigureSourceDimension()) {
            if (!StringUtils.isEmpty((String)configureDimension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getQuoteSrcType() {
        return this.quoteSrcType;
    }

    public List<String> getQuoteDimensions() {
        return this.quoteDimensions;
    }

    public List<String> getQuoteSourceDimensions() {
        return this.quoteSourceDimensions;
    }

    public List<String> getQuoteSourceResult() {
        return this.quoteSourceResult;
    }

    public List<String> getQuoteAlias() {
        return this.quoteAlias;
    }

    public List<String> getQuoteSourceAlias() {
        return this.quoteSourceAlias;
    }

    public List<String> getQuoteSourceResultAlias() {
        return this.quoteSourceResultAlias;
    }

    public List<String> getOperators() {
        return this.operators;
    }

    public List<String> getSortSignFields() {
        return this.sortSignFields;
    }

    public List<String> getSortOrders() {
        return this.sortOrders;
    }

    public List<String> getSortSignAlias() {
        return this.sortSignAlias;
    }

    public PriceSourceKeyInfo getPriceSourceKeyInfo() {
        return this.PriceSourceKeyInfo;
    }

    public List<String> getSortSignsDes() {
        return this.sortSignsDes;
    }

    public List<String> getQuoteDimensionsDes() {
        return this.quoteDimensionsDes;
    }

    public List<String> getQuoteSourceDimensionsDes() {
        return this.quoteSourceDimensionsDes;
    }

    public boolean isOrgDivide() {
        return this.orgDivide;
    }

    public void setOrgDivide(boolean orgDivide) {
        this.orgDivide = orgDivide;
    }

    public List<String> getConfigureDimension() {
        return this.configureDimension;
    }

    public List<String> getConfigureAlias() {
        return this.configureAlias;
    }

    public List<String> getConfigureDimensionDes() {
        return this.configureDimensionDes;
    }

    public List<String> getConfigureSourceDimension() {
        return this.configureSourceDimension;
    }

    public List<String> getConfigureSourceAlias() {
        return this.configureSourceAlias;
    }

    public List<String> getConfigureSourceDimensionDes() {
        return this.configureSourceDimensionDes;
    }

    public DynamicObject getQuoteScheme() {
        return this.quoteScheme;
    }

    public void setQuoteScheme(DynamicObject quoteScheme) {
        this.quoteScheme = quoteScheme;
    }

    public List<String> getConfigureOperators() {
        return this.configureOperators;
    }
}

