/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.quote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteConditonInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcColl;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;

public class QuoteStrategeColl {
    private List<DynamicObject> quoteStrateges = new ArrayList<DynamicObject>();
    private Map<Object, List<QuoteConditonInfo>> mapping = new HashMap<Object, List<QuoteConditonInfo>>();
    private Map<Object, QuoteSchemeColl> schemeCollMapping = new HashMap<Object, QuoteSchemeColl>();
    private Map<Object, QuoteCalcColl> calcCollMapping = new HashMap<Object, QuoteCalcColl>();
    private String quoteType;

    public QuoteStrategeColl(String quoteType) {
        this.quoteType = quoteType;
    }

    public List<String> mergeDimension() {
        ArrayList<String> dimensionSet = new ArrayList<String>();
        this.mapping.forEach((k, v) -> v.forEach(s -> this.generateDimension(dimensionSet, s.getQs_preFilter())));
        this.schemeCollMapping.forEach((k, v) -> v.mergeDimension(dimensionSet));
        this.calcCollMapping.forEach((k, v) -> v.mergeDimension(dimensionSet));
        return dimensionSet;
    }

    public List<String> mergeAlias() {
        ArrayList<String> aliasSet = new ArrayList<String>();
        this.mapping.forEach((k, v) -> v.forEach(s -> this.generateAlias(aliasSet, s.getQs_preFilter())));
        this.schemeCollMapping.forEach((k, v) -> v.mergeAlias(aliasSet));
        this.calcCollMapping.forEach((k, v) -> v.mergeAlias(aliasSet));
        return aliasSet;
    }

    public List<String> mergeTerminateSign() {
        ArrayList<String> terminateSignSet = new ArrayList<String>();
        this.schemeCollMapping.forEach((k, v) -> v.mergeTerminateSign(terminateSignSet));
        this.calcCollMapping.forEach((k, v) -> v.mergeTerminateSign(terminateSignSet));
        return terminateSignSet;
    }

    public List<String> mergeQuoteResult(List<String> quoteResultSet) {
        this.schemeCollMapping.forEach((k, v) -> v.mergeQuoteResult(quoteResultSet));
        this.calcCollMapping.forEach((k, v) -> v.mergeQuoteResult(quoteResultSet));
        return quoteResultSet;
    }

    public List<String> mergeQuoteResultAlias(List<String> quoteResultAliasSet) {
        this.schemeCollMapping.forEach((k, v) -> v.mergeQuoteResultAlias(quoteResultAliasSet));
        this.calcCollMapping.forEach((k, v) -> v.mergeQuoteResultAlias(quoteResultAliasSet));
        return quoteResultAliasSet;
    }

    public List[] divideHeadAndEntryResultsAlias() {
        ArrayList<String> quoteResultAliasSet = new ArrayList<String>();
        this.mergeQuoteResultAlias(quoteResultAliasSet);
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)this.quoteType);
        Map entryTypeMap = headType.getAllEntities();
        ArrayList entryNames = new ArrayList();
        entryTypeMap.forEach((k, v) -> entryNames.add(v.getName()));
        ArrayList headResult = new ArrayList();
        ArrayList entryResult = new ArrayList();
        quoteResultAliasSet.forEach(a -> {
            if (QuoteOtherHelper.isEntryPriceField(a, entryNames)) {
                entryResult.add(a);
            } else {
                headResult.add(a);
            }
        });
        List[] result = new List[]{headResult, entryResult};
        return result;
    }

    private void generateDimension(List<String> dimensionSet, QFilter f) {
        if (!"1".equals(f.getProperty()) && !dimensionSet.contains(f.getProperty())) {
            dimensionSet.add(f.getProperty());
        }
        if (f.isExpressValue() && !dimensionSet.contains(f.getValue())) {
            dimensionSet.add(f.getValue().toString());
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateDimension(dimensionSet, nestFilter);
        }
    }

    private void generateAlias(List<String> aliasSet, QFilter f) {
        String valueAlias;
        String alias;
        if (!"1".equals(f.getProperty()) && !aliasSet.contains(alias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(f.getProperty().replaceAll("\\.", "__"))).toString())) {
            aliasSet.add(alias);
        }
        if (f.isExpressValue() && !aliasSet.contains(valueAlias = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(f.getValue().toString().replaceAll("\\.", "__"))).toString())) {
            aliasSet.add(valueAlias);
        }
        List listFilterNest = f.getNests(false);
        for (QFilter.QFilterNest nest : listFilterNest) {
            QFilter nestFilter = nest.getFilter();
            this.generateAlias(aliasSet, nestFilter);
        }
    }

    public List<DynamicObject> getQuoteStrateges() {
        return this.quoteStrateges;
    }

    public Map<Object, List<QuoteConditonInfo>> getMapping() {
        return this.mapping;
    }

    public Map<Object, QuoteSchemeColl> getSchemeCollMapping() {
        return this.schemeCollMapping;
    }

    public Map<Object, QuoteCalcColl> getCalcCollMapping() {
        return this.calcCollMapping;
    }

    public QuoteSchemeColl getQuoteSchemeColl(DynamicObject quoteStratege) {
        Object quoteStrategePk = quoteStratege.getPkValue();
        QuoteSchemeColl coll = this.getSchemeCollMapping().get(quoteStrategePk);
        if (coll == null) {
            return new QuoteSchemeColl(quoteStratege);
        }
        return coll;
    }

    public QuoteCalcColl getQuoteCalcColl(DynamicObject quoteStratege) {
        Object quoteStrategePk = quoteStratege.getPkValue();
        QuoteCalcColl coll = this.getCalcCollMapping().get(quoteStrategePk);
        if (coll == null) {
            return new QuoteCalcColl(quoteStratege);
        }
        return coll;
    }
}

