/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteExtHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteProcessInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategySeqInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcFormulaInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.sdk.mpscmm.msbd.expoint.quote.QuoteFilterParam;

public class QuoteCalcInfo
extends QuoteProcessInfo {
    private DynamicObject quoteStratege;
    private DynamicObject calcStratege;
    private List<QuoteSchemeGroupInfo> schemeGroupInfos = new ArrayList<QuoteSchemeGroupInfo>(16);
    private List<QuoteCalcFormulaInfo> formulaInfos = new ArrayList<QuoteCalcFormulaInfo>(16);
    private Map<Long, QuoteSchemeGroupInfo> groupMapping = new HashMap<Long, QuoteSchemeGroupInfo>(16);
    private Map<String, Object> addResult = new HashMap<String, Object>();

    public QuoteCalcInfo generateStrategeInfo(DynamicObject calcStratege, QuoteStrategySeqInfo quoteStrategySeqInfo, DynamicObject quoteStratege) {
        QuoteFilterParam extParam;
        List<Boolean> extResult;
        super.generateProcessInfo(calcStratege, quoteStrategySeqInfo);
        this.quoteStratege = quoteStratege;
        this.calcStratege = calcStratege;
        this.terminationSignX = this.terminationSignInit;
        DynamicObjectCollection groupEntrys = calcStratege.getDynamicObjectCollection("factor");
        for (Object groupEntry : groupEntrys) {
            DynamicObject quoteSchemeGroup = groupEntry.getDynamicObject("quoteschemegroup");
            Long id = (Long)quoteSchemeGroup.getPkValue();
            String number = quoteSchemeGroup.getString("number");
            String name = quoteSchemeGroup.getString("name");
            String mulPrice = quoteSchemeGroup.getString("mulprice");
            String quoteSign = quoteSchemeGroup.getString("quotesign");
            String priceSource = quoteSchemeGroup.getString("pricesource");
            boolean require = groupEntry.getBoolean("required");
            QuoteSchemeGroupInfo groupInfo = new QuoteSchemeGroupInfo(quoteStratege, id, number, name, mulPrice, quoteSign, priceSource, require);
            this.groupMapping.put(id, groupInfo);
            this.schemeGroupInfos.add(groupInfo);
        }
        if (StringUtils.isNotEmpty((String)this.terminationSignInit)) {
            DynamicObjectCollection formulaEntrys = calcStratege.getDynamicObjectCollection("calformula");
            for (DynamicObject formulaEntry : formulaEntrys) {
                String formula = formulaEntry.getString("formula");
                String quoteSign = formulaEntry.getString("quotesign");
                DynamicObject processFactor = formulaEntry.getDynamicObject("processfactor");
                QuoteCalcFormulaInfo formulaInfo = new QuoteCalcFormulaInfo(quoteSign, formula, processFactor, formulaEntry);
                if (StringUtils.isNotEmpty((String)quoteSign)) {
                    this.quoteResults.add(quoteSign);
                    this.quoteResultsAlias.add(PriceHelper.getLeftName(quoteSign));
                }
                this.formulaInfos.add(formulaInfo);
            }
        }
        if ((extResult = QuoteExtHelper.callResetFilter(extParam = new QuoteFilterParam(this.getQuotePreFilter(), this.getQuoteSrcFilter(), null, this.getCalcStratege()))) != null && extResult.size() > 0) {
            this.setQuoteSrcFilter(extParam.getSourceFilter());
            this.setQuotePreFilter(extParam.getQuotePreFilter());
            this.quotePreConditonDesc = StringUtils.isEmpty((String)this.quotePreConditonDesc) ? extParam.getQuotePreFilterDesc() : this.quotePreConditonDesc + " " + "and" + " " + extParam.getQuotePreFilterDesc();
            this.quotePreFilters = PriceHelper.transferToQFilters(extParam.getQuotePreFilter());
        }
        return this;
    }

    public List<QuoteSchemeGroupInfo> getSchemeGroupInfos() {
        return this.schemeGroupInfos;
    }

    public List<QuoteCalcFormulaInfo> getFormulaInfos() {
        return this.formulaInfos;
    }

    public Map<Long, QuoteSchemeGroupInfo> getGroupMapping() {
        return this.groupMapping;
    }

    @Override
    public List<String> getQuoteResults() {
        return this.quoteResults;
    }

    public DynamicObject getQuoteStratege() {
        return this.quoteStratege;
    }

    public Map<String, Object> getAddResult() {
        return this.addResult;
    }

    public DynamicObject getCalcStratege() {
        return this.calcStratege;
    }
}

