/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor;

import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.IPriceFormulaCalculate;

public class PriceFormulaCalculateExpr
implements IPriceFormulaCalculate {
    private String targetField;
    private final String expressionStr;
    private BOSExpression expression;

    public static PriceFormulaCalculateExpr create(String targetField, String expression) {
        PriceFormulaCalculateExpr calExpr = new PriceFormulaCalculateExpr(targetField, expression);
        String errMessage = calExpr.expression.getErrMessage();
        if (StringUtils.isNotEmpty((CharSequence)errMessage)) {
            throw new KDBizException(errMessage);
        }
        return calExpr;
    }

    @Override
    public String getTargetField() {
        return this.targetField;
    }

    private PriceFormulaCalculateExpr(String targetField, String expression) {
        this.targetField = targetField;
        this.expressionStr = expression;
        this.expression = new BOSExpression(this.expressionStr);
    }

    public Set<String> getCalFactors() {
        return this.expression.getVars();
    }

    @Override
    public Object calculate(Map<String, Object> parameterInfo) {
        Object calculateResult = null;
        try {
            Set<String> calFactors = this.getCalFactors();
            boolean flag = false;
            for (String factor : calFactors) {
                Object value = parameterInfo.get(factor);
                if (value != null) continue;
                flag = true;
                break;
            }
            if (!flag) {
                calculateResult = FormulaEngine.execExcelFormula((Expr)this.expression.getExpr(), parameterInfo);
            }
        }
        catch (ArithmeticException e) {
            return BigDecimal.ZERO;
        }
        if (calculateResult instanceof Integer) {
            calculateResult = BigDecimal.valueOf(((Integer)calculateResult).intValue());
        }
        return calculateResult;
    }

    public String toString() {
        return String.format("%s = %s", this.getTargetField(), this.expressionStr);
    }
}

