/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.pricecontrol.step;

import java.util.ArrayList;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlPolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.pricecontrol.step.PriceControlStep;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class PriceControlJoinStep
extends PriceControlStep {
    @Override
    public void excute(PriceControlPolicyParam priceControlPolicyParam) {
        PriceControlSchemeInfo priceControlSchemeInfo = priceControlPolicyParam.getQsInfo();
        JoinDataSet priceResultSet = priceControlPolicyParam.getPriceDataSet().join(priceControlPolicyParam.getPriceSourceDataSet(), JoinType.INNER);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        for (int i = 0; i < priceControlSchemeInfo.getOperators().size(); ++i) {
            String operator = priceControlSchemeInfo.getOperators().get(i);
            if (!OperatorEnum.EQUALS.getValue().equals(operator)) continue;
            try {
                priceResultSet = priceResultSet.on(priceControlSchemeInfo.getDimensionAliass().get(i), priceControlSchemeInfo.getSourceDimensionAliass().get(i)).hint(hint);
                continue;
            }
            catch (AlgoException e) {
                String message = ResManager.loadKDString((String)"\u9650\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u9650\u4ef7\u6761\u4ef6\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u9519\u8bef\u7684\u9650\u4ef7\u6761\u4ef6\u5b57\u6bb5\u662f\u201c%2$s\u201d\u3002", (String)"PriceControlJoinStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, priceControlSchemeInfo.getPriceControlScheme().getString("name"), priceControlSchemeInfo.getDimensionDescs().get(i));
                throw new KDBizException(message);
            }
        }
        Field[] priceFields = priceControlPolicyParam.getPriceDataSet().getRowMeta().getFields();
        ArrayList<String> leftSelector = new ArrayList<String>(priceFields.length);
        for (Field f : priceFields) {
            leftSelector.add(f.getName());
        }
        Field[] priceSourceFields = priceControlPolicyParam.getPriceSourceDataSet().getRowMeta().getFields();
        ArrayList<String> rightSelector = new ArrayList<String>(priceSourceFields.length);
        for (Field f : priceSourceFields) {
            rightSelector.add(f.getName());
        }
        priceControlPolicyParam.setResultSet(priceResultSet.select(leftSelector.toArray(new String[0]), rightSelector.toArray(new String[0])).finish());
    }
}

