/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.pricecontrol.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceSourceKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlPolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.pricecontrol.PriceControlSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.pricecontrol.step.PriceControlStep;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class PriceControlSourceFilterStep
extends PriceControlStep {
    private static final Log logger = LogFactory.getLog(PriceControlSourceFilterStep.class);

    @Override
    public void excute(PriceControlPolicyParam priceControlPolicyParam) {
        PriceControlSchemeInfo priceControlSchemeInfo = priceControlPolicyParam.getQsInfo();
        List<String> allSourceSelecties = priceControlSchemeInfo.mergeQuoteSourceFields();
        List<String> allAliasSelecties = priceControlSchemeInfo.mergeQuoteSourceAlias();
        for (int i = 0; i < allSourceSelecties.size(); ++i) {
            allSourceSelecties.set(i, new StringBuffer(allSourceSelecties.get(i)).append(new StringBuffer(" ")).append(new StringBuffer(allAliasSelecties.get(i))).toString());
        }
        PriceSourceKeyInfo priceSourceKeyInfo = priceControlSchemeInfo.getPriceControlSrcKeyInfo();
        ArrayList<String> allSrcSelecties = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)priceSourceKeyInfo.getBILLNO())) {
            allSrcSelecties.add(priceSourceKeyInfo.getBILLNO() + " " + "pricesrcno");
        }
        if (StringUtils.isNotEmpty((CharSequence)priceSourceKeyInfo.getBILLENTRY_SEQ())) {
            allSrcSelecties.add(priceSourceKeyInfo.getBILLENTRY_SEQ() + " " + "pricesrcseq");
        }
        allSourceSelecties.addAll(allSrcSelecties);
        DataSet srcDataSet = null;
        try {
            if (priceControlSchemeInfo.getSrcFilter() != null && logger.isInfoEnabled()) {
                logger.info("srcfilter=======" + priceControlSchemeInfo.getSrcFilter());
            }
            QFilter qConditionFilter = this.getLimitFilter(priceControlPolicyParam, priceControlSchemeInfo);
            if (logger.isInfoEnabled()) {
                logger.info("quotesrclimitfilter=======" + qConditionFilter);
            }
            String priceSrcType = priceControlSchemeInfo.getPriceControlScheme().getDynamicObject("controlsource").getString("number");
            srcDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)priceSrcType, (String)String.join((CharSequence)",", allSourceSelecties), (QFilter[])new QFilter[]{qConditionFilter, priceControlSchemeInfo.getSrcFilter()}, null);
            srcDataSet = srcDataSet.addField("'" + priceSrcType + "'", "pricesrcbill");
            if (StringUtils.isEmpty((CharSequence)priceSourceKeyInfo.getBILLNO())) {
                srcDataSet = srcDataSet.addNullField("pricesrcno");
            }
            if (StringUtils.isEmpty((CharSequence)priceSourceKeyInfo.getBILLENTRY_SEQ())) {
                srcDataSet = srcDataSet.addNullField("pricesrcseq");
            }
        }
        catch (Throwable e) {
            if (srcDataSet == null) {
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u9650\u4ef7\u6765\u6e90\u5355\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u9650\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u7684\u9650\u4ef7\u6765\u6e90\u5b57\u6bb5\u548c\u9650\u4ef7\u5355\u636e\u5b57\u6bb5\u53ef\u80fd\u5b58\u5728\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u6216\u9650\u4ef7\u6765\u6e90\u5355\u636e\u7684\u5143\u6570\u636e\u5b57\u6bb5\u53ef\u80fd\u53d1\u751f\u4e86\u53d8\u66f4\u3002", (String)"PriceControlSourceFilterStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, priceControlSchemeInfo.getPriceControlScheme().getString("name"));
                throw new KDBizException(message);
            }
            try {
                srcDataSet.close();
            }
            catch (Throwable var15) {
                e.addSuppressed(var15);
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u53d6\u4ef7\u6765\u6e90\u5355\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"PriceControlSourceFilterStep_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
        }
        priceControlPolicyParam.setPriceSourceDataSet(srcDataSet);
    }

    protected List<String> getLimitFields() {
        return Arrays.asList("org", "billno", "material");
    }

    private QFilter getLimitFilter(PriceControlPolicyParam priceControlPolicyParam, PriceControlSchemeInfo priceControlSchemeInfo) {
        List<String> limitFields = this.getLimitFields();
        ArrayList<String> valueFields = new ArrayList<String>(priceControlSchemeInfo.getOperators().size());
        ArrayList<String> conditonFields = new ArrayList<String>(priceControlSchemeInfo.getOperators().size());
        for (int i = 0; i < priceControlSchemeInfo.getOperators().size(); ++i) {
            String operator = priceControlSchemeInfo.getOperators().get(i);
            if (!OperatorEnum.EQUALS.getValue().equals(operator)) continue;
            for (String limitField : limitFields) {
                if (!priceControlSchemeInfo.getDimensionAliass().get(i).contains(limitField)) continue;
                valueFields.add(priceControlSchemeInfo.getDimensionAliass().get(i));
                conditonFields.add(priceControlSchemeInfo.getSourceDimensions().get(i));
            }
        }
        ArrayList valuesSet = new ArrayList(valueFields.size());
        valueFields.forEach(e -> valuesSet.add(new HashSet()));
        DataSet conditionSet = priceControlPolicyParam.getPriceDataSet().copy();
        Object object = null;
        try {
            for (Row conditonRow : conditionSet) {
                for (int i = 0; i < valueFields.size(); ++i) {
                    Object value = conditonRow.get((String)valueFields.get(i));
                    ((Set)valuesSet.get(i)).add(value);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (conditionSet != null) {
                if (object != null) {
                    try {
                        conditionSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    conditionSet.close();
                }
            }
        }
        QFilter qConditionFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (int i = 0; i < conditonFields.size(); ++i) {
            if (((Set)valuesSet.get(i)).size() > 500) continue;
            qConditionFilter.and(new QFilter((String)conditonFields.get(i), "in", valuesSet.get(i)));
        }
        return qConditionFilter;
    }
}

