/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.AbstractPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;

public abstract class QuotePolicy
extends AbstractPolicy
implements AutoCloseable {
    private List<QuoteStep> steps = new ArrayList<QuoteStep>();
    private QuoteSchemeInfo quoteSchemeInfo;

    public QuotePolicy(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo) {
        super(quotePolicyParam);
        this.quoteSchemeInfo = quoteSchemeInfo;
    }

    @Override
    public void close() {
    }

    public void query(QuoteLogProxy logProxy) {
        try {
            for (QuoteStep s : this.steps) {
                s.excute(this.quotePolicyParam, this.quoteSchemeInfo, logProxy);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public void addStep(QuoteStep invStep) {
        this.steps.add(invStep);
    }

    protected List<QuoteStep> getSteps() {
        return this.steps;
    }

    public QuoteSchemeInfo getQuoteSchemeInfo() {
        return this.quoteSchemeInfo;
    }
}

