/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteProcessInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteStrategeColl;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.AbstractPolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuoteEngine;
import kd.mpscmm.msbd.pricemodel.business.service.quote.QuotePolicy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteInnerLogProxy;
import kd.mpscmm.msbd.pricemodel.common.consts.PriceConst;

public class QuoteSchemeGroupEngine
extends QuoteEngine {
    private static final Log log = LogFactory.getLog(QuoteSchemeGroupEngine.class);

    public QuoteSchemeGroupEngine(QuoteInnerLogProxy logProxy) {
        super(logProxy);
    }

    @Override
    protected Map<String, Object> buildResult(List<AbstractPolicy> quotePolicys, QuoteParam quoteParam, QuoteStrategeColl quoteStrategeColl, DynamicObject quoteStratege) {
        HashMap<String, Object> priceMapping = new HashMap<String, Object>();
        if (quotePolicys.size() == 0) {
            return priceMapping;
        }
        List[] resultFieldsAliasArray = quoteStrategeColl.divideHeadAndEntryResultsAlias();
        List headAliasFields = resultFieldsAliasArray[0];
        List entryAliasFields = resultFieldsAliasArray[1];
        QuoteSchemeGroupInfo schemeGroupInfo = null;
        if (quoteParam.getOtherParam().get("SCHEMEGROUP") != null) {
            schemeGroupInfo = (QuoteSchemeGroupInfo)quoteParam.getOtherParam().get("SCHEMEGROUP");
        }
        HashMap allResultRecord = new HashMap();
        for (int i = 0; i < quotePolicys.size(); ++i) {
            QuotePolicy p = (QuotePolicy)quotePolicys.get(i);
            try (DataSet result = p.getQuotePolicyParam().getResultSet();){
                List<String> includeHeadAliasFields = DataSetHelper.getIncludeFields(headAliasFields, result);
                List<String> includeEntryAliasFields = DataSetHelper.getIncludeFields(entryAliasFields, result);
                for (Row row : result) {
                    Object priceResult;
                    String key;
                    String priceField;
                    String[] subFields;
                    ArrayList<String> keyCollection = new ArrayList<String>();
                    String mainKey = PriceHelper.generateRowKey(quoteParam.getQccInfo(), row);
                    if (schemeGroupInfo != null) {
                        String terminationSignX = p.getQuoteSchemeInfo().getTerminationSignX();
                        terminationSignX = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(terminationSignX.replaceAll("\\.", "__"))).toString();
                        schemeGroupInfo.getGroupResult().put(mainKey, row.get(terminationSignX));
                        if (p.getQuoteSchemeInfo().isConfigure()) {
                            schemeGroupInfo.getFeatureResult().put(mainKey, row.get("featurevalue"));
                        }
                    }
                    if (includeHeadAliasFields.size() > 0) {
                        for (String headAliasField : includeHeadAliasFields) {
                            subFields = headAliasField.split("__");
                            priceField = subFields[subFields.length - 1];
                            key = this.generateHeadKey(row, priceField);
                            priceResult = row.get(headAliasField);
                            keyCollection.add(key);
                            this.arrangeHeadPriceValue(priceMapping, key, priceResult);
                        }
                    }
                    if (includeEntryAliasFields.size() > 0) {
                        for (String entryAliasField : includeEntryAliasFields) {
                            subFields = entryAliasField.split("__");
                            priceField = subFields[subFields.length - 1];
                            key = this.generateKey(quoteParam.getQccInfo(), row, priceField);
                            priceResult = row.get(entryAliasField);
                            keyCollection.add(key);
                            priceMapping.put(key, priceResult);
                        }
                    }
                    allResultRecord.put(mainKey, keyCollection);
                }
                continue;
            }
        }
        quoteParam.getOtherParam().put("KEYRELATIONGROUP", allResultRecord);
        priceMapping.put("success", Boolean.TRUE);
        return priceMapping;
    }

    @Override
    protected void fillEmpty(QuoteParam quoteParam) {
        QuoteSchemeGroupInfo schemeGroupInfo = null;
        if (quoteParam.getOtherParam().get("SCHEMEGROUP") != null) {
            schemeGroupInfo = (QuoteSchemeGroupInfo)quoteParam.getOtherParam().get("SCHEMEGROUP");
        }
        log.info("\u586b\u5145\u7a7a\u503c\u5f00\u59cb\uff1a\u65b0\u8fd4\u56de\u63a5\u53e3\u5c06\u4e0d\u8fd4\u56de\u7a7a\u503c\uff0c\u53ea\u8bb0\u5f55\u65e5\u5fd7");
        try (DataSet quoteOriginDataSet = quoteParam.getQuoteOriginDataSet();){
            this.logProxy.setMissedRecDataSet(quoteOriginDataSet);
            if (schemeGroupInfo != null) {
                for (Row row : quoteOriginDataSet) {
                    String mainKey = PriceHelper.generateRowKey(quoteParam.getQccInfo(), row);
                    schemeGroupInfo.getGroupResult().put(mainKey, null);
                }
            }
        }
        log.info("\u586b\u5145\u7a7a\u503c\u7ed3\u675f\uff1a\u65b0\u8fd4\u56de\u63a5\u53e3\u5c06\u4e0d\u8fd4\u56de\u7a7a\u503c\uff0c\u53ea\u8bb0\u5f55\u65e5\u5fd7");
    }

    @Override
    protected void suplusDataSet(QuoteParam quoteParam, QuotePolicyParam quotePolicyParam, QuoteProcessInfo quoteProcessInfo) {
        QuoteSchemeGroupInfo schemeGroupInfo = null;
        if (quoteParam.getOtherParam().get("SCHEMEGROUP") != null) {
            schemeGroupInfo = (QuoteSchemeGroupInfo)quoteParam.getOtherParam().get("SCHEMEGROUP");
        }
        QuoteSchemeInfo quoteSchemeInfo = (QuoteSchemeInfo)quoteProcessInfo;
        String terminationSign = quoteProcessInfo.getTerminationSignX();
        terminationSign = new StringBuffer(PriceConst.LEFT).append(new StringBuffer(terminationSign.replaceAll("\\.", "__"))).toString();
        String filterStr_no = new StringBuffer(terminationSign).append(" ").append("is null").toString();
        try (DataSet noResult = quotePolicyParam.getResultSet().copy().where(filterStr_no);){
            for (Row removeRow : noResult) {
                String mainKey = PriceHelper.generateRowKey(quoteParam.getQccInfo(), removeRow);
                if (schemeGroupInfo == null || !quoteSchemeInfo.isConfigure()) continue;
                schemeGroupInfo.getFeatureResult().put(mainKey, removeRow.get("featurevalue"));
            }
        }
        super.suplusDataSet(quoteParam, quotePolicyParam, quoteProcessInfo);
    }
}

