/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.log;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogTreeNodeHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteLogNode;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteExpLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteSchemeGrpLogProxy;

public class QuoteSchemeGrpLogRunnable
implements Runnable {
    private QuoteSchemeGrpLogProxy proxy;
    private static final Log LOGGER = LogFactory.getLog(QuoteSchemeGrpLogRunnable.class);

    public QuoteSchemeGrpLogRunnable(QuoteSchemeGrpLogProxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public void run() {
        try {
            String[] subFields;
            String priceField;
            MainEntityType headType;
            Map allFileds;
            IDataEntityProperty property;
            ArrayList<TreeNode> totalLogTreeNodes = new ArrayList<TreeNode>(16);
            String quoteSrcNo = ResManager.loadKDString((String)"\u5f53\u524d\u53d6\u4ef7\u5355\u636e", (String)"QuoteSchemeGrpLogRunnable_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            String quoteResultDescrip = ResManager.loadKDString((String)"\u672a\u627e\u5230\u5339\u914d\u7684\u4ef7\u683c\u3002", (String)"QuoteLogRunnable_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            String quoteFieldSign = this.proxy.getQuoteSchemeGroupInfo().getQuoteFieldSign();
            if (StringUtils.isNotEmpty((String)quoteFieldSign) && (property = (IDataEntityProperty)(allFileds = (headType = EntityMetadataCache.getDataEntityType((String)this.proxy.getQuoteCalcInfo().getQuoteType())).getAllFields()).get(priceField = (subFields = quoteFieldSign.split("\\."))[subFields.length - 1])) != null) {
                this.proxy.getGroupResult().forEach((key, value) -> {
                    String[] keyList = key.split("__");
                    String seq = "";
                    if (keyList.length > 1) {
                        seq = keyList[keyList.length - 1];
                    }
                    String resultDesc = "";
                    Class propertyType = property.getPropertyType();
                    if (Integer.class.isAssignableFrom(propertyType) || BigDecimal.class.isAssignableFrom(propertyType)) {
                        if (value == null) {
                            resultDesc = quoteResultDescrip;
                        } else {
                            BigDecimal rs = new BigDecimal(String.valueOf(value));
                            value = rs.stripTrailingZeros().toPlainString();
                            resultDesc = property.getDisplayName().getLocaleValue() + ":" + value;
                        }
                    }
                    QuoteLogNode node = new QuoteLogNode(quoteSrcNo, this.proxy.getQuoteCalcInfo().getQuoteType(), seq, null, resultDesc);
                    TreeNode treeRoot = this.getSchemeGroupNode((String)key, node, property.getDisplayName().getLocaleValue());
                    totalLogTreeNodes.add(treeRoot);
                });
                QuoteLogTreeNodeHelper.createSchemeGrpQuoteLog(totalLogTreeNodes, this.proxy);
            }
        }
        catch (KDBizException e) {
            this.close();
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e383\uff1a", (String)"QuoteStrategeLogRunnable_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e.getMessage());
            }
        }
        catch (Exception e1) {
            LOGGER.info(e1.getMessage());
            this.close();
            try (QuoteExpLogProxy expLogProxy = new QuoteExpLogProxy(true, this.proxy.getQuoteOrgID(), this.proxy.getQuoteBill());){
                String quoteLogExp = ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u91c7\u96c6\u8fc7\u7a0b\u51fa\u73b0\u5f02\u5e384\uff1a", (String)"QuoteStrategeLogRunnable_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                expLogProxy.setCancle(false);
                expLogProxy.setLogResult(quoteLogExp + e1.getClass() + e1.getMessage());
            }
        }
    }

    private void close() {
    }

    private TreeNode getSchemeGroupNode(String key, QuoteLogNode node, String groupInfo) {
        TreeNode schemeGroupNode = new TreeNode();
        schemeGroupNode.setId(this.proxy.getQuoteCalcInfo().getId());
        schemeGroupNode.setType(key);
        schemeGroupNode.setText(groupInfo);
        schemeGroupNode.setData((Object)node);
        return schemeGroupNode;
    }
}

