/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step;

import java.util.ArrayList;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class JoinStep
extends QuoteStep {
    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        JoinDataSet priceResultSet = quotePolicyParam.getQuoteDataSet().join(quotePolicyParam.getQuoteSourceDataSet(), JoinType.INNER);
        JoinHint hint = new JoinHint();
        hint.setNullAsZero(true);
        for (int i = 0; i < quoteSchemeInfo.getOperators().size(); ++i) {
            String operator = quoteSchemeInfo.getOperators().get(i);
            if (!OperatorEnum.EQUALS.getValue().equals(operator)) continue;
            try {
                priceResultSet = priceResultSet.on(quoteSchemeInfo.getQuoteAlias().get(i), quoteSchemeInfo.getQuoteSourceAlias().get(i)).hint(hint);
                continue;
            }
            catch (AlgoException e) {
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u53d6\u4ef7\u6761\u4ef6\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u9519\u8bef\u7684\u53d6\u4ef7\u6761\u4ef6\u5b57\u6bb5\u662f\u201c%2$s\u201d\u3002", (String)"JoinStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, quoteSchemeInfo.getName(), quoteSchemeInfo.getQuoteDimensionsDes().get(i));
                throw new KDBizException(message);
            }
        }
        Field[] quoteFields = quotePolicyParam.getQuoteDataSet().getRowMeta().getFields();
        ArrayList<String> leftSelector = new ArrayList<String>(quoteFields.length);
        for (Field f : quoteFields) {
            leftSelector.add(f.getName());
        }
        Field[] quoteSourceFields = quotePolicyParam.getQuoteSourceDataSet().getRowMeta().getFields();
        ArrayList<String> rightSelector = new ArrayList<String>(quoteSourceFields.length);
        for (Field f : quoteSourceFields) {
            rightSelector.add(f.getName());
        }
        quotePolicyParam.setResultSet(priceResultSet.select(leftSelector.toArray(new String[0]), rightSelector.toArray(new String[0])).finish());
    }
}

