/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step;

import kd.bos.algo.DataSet;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogClassEnum;

public class QuoteBillPreFilterStep
extends QuoteStep {
    private static final Log logger = LogFactory.getLog(QuoteBillPreFilterStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        logProxy.missSchemeCache(quotePolicyParam.getQuoteDataSet(), quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.QUOTESCHEME);
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteSchemeInfo.getQuoteType());
        QFilter totalFilter = quoteSchemeInfo.getQuotePreFilter();
        String conditionStr = PriceHelper.dataTypeAdapte(totalFilter, headType);
        DataSet quoteDataSet = quotePolicyParam.getQuoteDataSet();
        quoteDataSet = quoteDataSet.filter(conditionStr);
        quotePolicyParam.setQuoteDataSet(quoteDataSet);
        logProxy.missPriceCache(quotePolicyParam.getQuoteDataSet(), quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.QUOTESCHEME);
    }
}

