/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.CustomAggFunction;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.FeatureValueInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteInnerLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;
import kd.mpscmm.msbd.pricemodel.common.consts.log.QuoteLogConst;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogClassEnum;

public class QuoteConfigureCollectStep
extends QuoteStep {
    private static BigDecimal DEFAULTVALUE = BigDecimal.valueOf(-999999L);
    private static final Log log = LogFactory.getLog(QuoteConfigureCollectStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        DataSet logDataSetX2;
        Object object;
        DataSet logDataSet;
        boolean isMust = true;
        QuoteSchemeGroupInfo schemeGroupInfo = null;
        if (quotePolicyParam.getOtherParam().get("SCHEMEGROUP") != null) {
            schemeGroupInfo = (QuoteSchemeGroupInfo)quotePolicyParam.getOtherParam().get("SCHEMEGROUP");
        }
        if (schemeGroupInfo != null) {
            isMust = schemeGroupInfo.isRequire();
        }
        DataSet result = quotePolicyParam.getResultSet();
        String configureField = quoteSchemeInfo.getConfigureAlias().get(0);
        String filterConfigure = new StringBuffer(configureField).append("=0").toString();
        DataSet dataSet_xr = result.copy().where(filterConfigure);
        ArrayList<String> baseSelector = new ArrayList<String>(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size() + 1);
        quotePolicyParam.getQccInfo().getLEFTIDFIELDS().forEach(f -> baseSelector.add((String)f));
        baseSelector.add("featurevalue");
        ArrayList<String> selector = new ArrayList<String>(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size() + quoteSchemeInfo.getQuoteSourceResultAlias().size() + 1);
        selector.addAll(baseSelector);
        quoteSchemeInfo.getQuoteSourceResultAlias().forEach(f -> selector.add(new StringBuffer("Cast(0 as BigDecimal) as ").append((String)f).toString()));
        dataSet_xr = dataSet_xr.select(selector.toArray(new String[selector.size()]));
        String filterFeature = new StringBuffer(configureField).append(" != 0").append(" AND ").append("featureexpand").append(" ").append("is null").toString();
        DataSet dataSet_xf = result.copy().where(filterFeature);
        dataSet_xf = dataSet_xf.select(selector.toArray(new String[selector.size()]));
        DataSet allDataSet = dataSet_xr.union(dataSet_xf);
        String filterFeatureV = new StringBuffer(configureField).append(" != 0").append(" AND ").append("featureexpand").append(" ").append("is not null").toString();
        DataSet dataSet_xfv = result.where(filterFeatureV);
        ArrayList<String> sorter = new ArrayList<String>();
        if (quoteSchemeInfo.getSortSignAlias().size() > 0) {
            for (int i = 0; i < quoteSchemeInfo.getSortSignAlias().size(); ++i) {
                String sign = quoteSchemeInfo.getSortSignAlias().get(i);
                sorter.add(new StringBuffer(sign).append(" ").append(quoteSchemeInfo.getSortOrders().get(i)).toString());
            }
        }
        if (sorter.size() > 0) {
            ArrayList<String> grouper = new ArrayList<String>();
            grouper.addAll(quotePolicyParam.getQccInfo().getLEFTIDFIELDS());
            grouper.add(quoteSchemeInfo.getConfigureAlias().get(0));
            grouper.add("featureexpand");
            grouper.add("featurevalue");
            ArrayList<String> newSorter = new ArrayList<String>();
            newSorter.addAll(grouper);
            newSorter.addAll(sorter);
            dataSet_xfv = dataSet_xfv.orderBy(newSorter.toArray(new String[0]));
            result = this.getTopRows(quoteSchemeInfo, grouper, dataSet_xfv, isMust);
            if (schemeGroupInfo != null) {
                log.info(new StringBuffer("\u65b9\u6848\u7ec4").append(schemeGroupInfo.getNumber()).append("\u8bb0\u5f55\u7279\u5f81\u503c\u4ef7\u683c\u660e\u7ec6\u4fe1\u606f").toString());
                try (DataSet featureResult = result.copy();){
                    for (Row featureRow : featureResult) {
                        FeatureValueInfo featureValueInfo;
                        String mainKey = PriceHelper.generateRowKey(quotePolicyParam.getQccInfo(), featureRow);
                        Optional<Object> t = Optional.ofNullable(featureRow.get("featurevalue"));
                        String featureValue = null;
                        if (t.isPresent()) {
                            featureValue = t.get().toString();
                            log.info("\u8bb0\u5f55\u8be5\u884c\u7279\u5f81\u503c=" + featureValue);
                        } else {
                            log.info("\u8bb0\u5f55\u8be5\u884c\u7279\u5f81\u503c\u4e3a\u7a7a");
                        }
                        String terminationSignX = quoteSchemeInfo.getTerminationSignInit();
                        Optional<Object> t1 = Optional.ofNullable(featureRow.get(terminationSignX));
                        String quoteSrcbill = featureRow.getString("quotesrcbill");
                        String quoteSrcNo = featureRow.getString("quotesrcno");
                        String quoteSrcSeq = featureRow.getString("quotesrcseq");
                        if (t1.isPresent()) {
                            featureValueInfo = new FeatureValueInfo(featureValue, (BigDecimal)featureRow.get(terminationSignX));
                            featureValueInfo.initLogInfo(quoteSrcbill, quoteSrcNo, quoteSrcSeq, quoteSchemeInfo.getTerminationSignX());
                            schemeGroupInfo.updateFeatureResult(featureValueInfo, mainKey);
                            continue;
                        }
                        featureValueInfo = new FeatureValueInfo(featureValue, null);
                        featureValueInfo.initLogInfo(quoteSrcbill, quoteSrcNo, quoteSrcSeq, quoteSchemeInfo.getTerminationSignX());
                        schemeGroupInfo.updateFeatureResult(featureValueInfo, mainKey);
                    }
                }
            }
        }
        result = this.sum(quoteSchemeInfo, quotePolicyParam.getQccInfo().getLEFTIDFIELDS(), result);
        result = result.union(allDataSet);
        result = this.buildResult(baseSelector, quoteSchemeInfo, result, logProxy);
        String terminateField = PriceHelper.getLeftName(quoteSchemeInfo.getTerminationSignX());
        String filterStr_r = new StringBuffer(terminateField).append(" ").append("is not null").toString();
        String priceSourceMessage = ResManager.loadKDString((String)"\u9009\u914d\u5408\u8ba1", (String)"QuoteConfigureCollectStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
        if (logProxy instanceof QuoteInnerLogProxy) {
            logDataSet = result.copy();
            object = null;
            try {
                logDataSetX2 = logDataSet.where(filterStr_r);
                logDataSetX2 = QuoteLogHelper.completePriceSourceField(quoteSchemeInfo.getQuoteSrcType(), logDataSetX2, priceSourceMessage);
                logProxy.addMatchAllPriceCache(quoteSchemeInfo.getId(), logDataSetX2, false, LogClassEnum.QUOTESCHEME);
                logProxy.addShootSourceCache(logDataSetX2);
                logProxy.shootPriceCache(logDataSetX2, quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.QUOTESCHEME);
            }
            catch (Throwable logDataSetX2) {
                object = logDataSetX2;
                throw logDataSetX2;
            }
            finally {
                if (logDataSet != null) {
                    if (object != null) {
                        try {
                            logDataSet.close();
                        }
                        catch (Throwable logDataSetX2) {
                            ((Throwable)object).addSuppressed(logDataSetX2);
                        }
                    } else {
                        logDataSet.close();
                    }
                }
            }
        }
        result = result.where(filterStr_r);
        logDataSet = result.copy();
        object = null;
        try {
            logDataSetX2 = QuoteLogHelper.completePriceSourceField(quoteSchemeInfo.getQuoteSrcType(), logDataSet, priceSourceMessage);
            logProxy.addMatchAllPriceCache(quoteSchemeInfo.getId(), logDataSetX2, false, LogClassEnum.QUOTESCHEME);
            logProxy.addShootSourceCache(logDataSetX2);
            logProxy.shootPriceCache(logDataSetX2, quoteSchemeInfo.getId(), quotePolicyParam.getQccInfo(), LogClassEnum.QUOTESCHEME);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (logDataSet != null) {
                if (object != null) {
                    try {
                        logDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    logDataSet.close();
                }
            }
        }
        quotePolicyParam.setResultSet(result);
    }

    private DataSet buildResult(List<String> baseSelector, QuoteSchemeInfo quoteSchemeInfo, DataSet result, QuoteLogProxy logProxy) {
        int i;
        ArrayList<String> selector = new ArrayList<String>(baseSelector.size() + quoteSchemeInfo.getQuoteSourceResultAlias().size());
        selector.addAll(baseSelector);
        ArrayList<String> dulplicateResultFields = new ArrayList<String>(16);
        for (i = 0; i < quoteSchemeInfo.getQuoteSourceResultAlias().size(); ++i) {
            block6: {
                if (!dulplicateResultFields.contains(quoteSchemeInfo.getQuoteResultsAlias().get(i))) break block6;
                String message = ResManager.loadKDString((String)"\u53d6\u4ef7\u65b9\u6848\u201c%s\u201d\u7684\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u4e2d\u5b58\u5728\u91cd\u590d\u914d\u7f6e\u7684\u53d6\u4ef7\u5b57\u6bb5\u3002", (String)"QuoteCollectStep_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, quoteSchemeInfo.getName());
                try {
                    if (result != null) {
                        result.close();
                    }
                }
                finally {
                    throw new KDBizException(message);
                }
                {
                }
            }
            dulplicateResultFields.add(quoteSchemeInfo.getQuoteResultsAlias().get(i));
        }
        for (i = 0; i < quoteSchemeInfo.getQuoteSourceResultAlias().size(); ++i) {
            selector.add(new StringBuffer(quoteSchemeInfo.getQuoteSourceResultAlias().get(i)).append(" ").append(new StringBuffer(quoteSchemeInfo.getQuoteResultsAlias().get(i))).toString());
        }
        result = result.select(selector.toArray(new String[selector.size()]));
        return result;
    }

    private DataSet getTopRows(QuoteSchemeInfo quoteSchemeInfo, List<String> grouper, DataSet result, final boolean isMust) {
        GroupbyDataSet groupby = result.groupBy(grouper.toArray(new String[grouper.size()]));
        ArrayList<String> keepFields = new ArrayList<String>(quoteSchemeInfo.getQuoteSourceResultAlias().size() + 3);
        keepFields.addAll(quoteSchemeInfo.getQuoteSourceResultAlias());
        keepFields.addAll(Arrays.asList(QuoteLogConst.getQuotelogSearchfields()));
        for (int i = 0; i < keepFields.size(); ++i) {
            String fieldKey = (String)keepFields.get(i);
            groupby.agg((CustomAggFunction)new CustomAggFunction<Object>("getTopRec", result.getRowMeta().getField(fieldKey).getDataType()){
                private int i;
                {
                    super(x0, x1);
                    this.i = 0;
                }

                public Object newAggValue() {
                    return null;
                }

                public Object addValue(Object o, Object o2) {
                    if (o == null) {
                        this.i = 0;
                    }
                    if (this.i == 0) {
                        ++this.i;
                        if (isMust) {
                            return o2;
                        }
                        return DataSetHelper.defaultValue4Null(o2, this.getResultDataType());
                    }
                    return o;
                }

                public Object combineAggValue(Object o, Object t1) {
                    return o;
                }

                public Object getResult(Object o) {
                    return o;
                }
            }, fieldKey, fieldKey);
        }
        result = groupby.finish();
        return result;
    }

    private DataSet sum(QuoteSchemeInfo quoteSchemeInfo, List<String> grouper, DataSet result) {
        GroupbyDataSet groupby = result.groupBy(grouper.toArray(new String[grouper.size()]));
        groupby.agg((CustomAggFunction)new CustomAggFunction<Object>("sum", result.getRowMeta().getField("featurevalue").getDataType()){

            public Object newAggValue() {
                return "";
            }

            public Object addValue(Object o, Object o2) {
                Optional<Object> a = Optional.ofNullable(o);
                o = a.orElse("");
                Optional<Object> b = Optional.ofNullable(o2);
                o2 = b.orElse("");
                if ("".equals(o)) {
                    return new StringBuffer(o.toString()).append(" ").append(o2).toString();
                }
                return new StringBuffer(o.toString()).append(",").append(o2).toString();
            }

            public Object combineAggValue(Object o, Object t1) {
                return o;
            }

            public Object getResult(Object o) {
                return o;
            }
        }, "featurevalue", "featurevalue");
        for (int i = 0; i < quoteSchemeInfo.getQuoteSourceResultAlias().size(); ++i) {
            String fieldKey = quoteSchemeInfo.getQuoteSourceResultAlias().get(i);
            groupby.agg((CustomAggFunction)new CustomAggFunction<Object>("sum", result.getRowMeta().getField(fieldKey).getDataType()){

                public Object newAggValue() {
                    return BigDecimal.ZERO;
                }

                public Object addValue(Object o, Object o2) {
                    if (o == null || o2 == null) {
                        return DEFAULTVALUE;
                    }
                    if (DEFAULTVALUE.compareTo((BigDecimal)o) == 0 || DEFAULTVALUE.compareTo((BigDecimal)o2) == 0) {
                        return DEFAULTVALUE;
                    }
                    return ((BigDecimal)o).add((BigDecimal)o2);
                }

                public Object combineAggValue(Object o, Object t1) {
                    return o;
                }

                public Object getResult(Object o) {
                    if (DEFAULTVALUE.compareTo((BigDecimal)o) == 0) {
                        return null;
                    }
                    return o;
                }
            }, fieldKey, fieldKey);
        }
        result = groupby.finish();
        return result;
    }
}

