/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceSourceKeyInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.QuoteStep;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class QuoteSourceFilterStep
extends QuoteStep {
    private static final Log logger = LogFactory.getLog(QuoteSourceFilterStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo, QuoteLogProxy logProxy) {
        logger.info("quote into this QuoteSourceFilterStep  path:");
        List<String> allSourceSelecties = quoteSchemeInfo.mergeQuoteSourceFields();
        List<String> allAliasSelecties = quoteSchemeInfo.mergeQuoteSourceAlias();
        for (int i = 0; i < allSourceSelecties.size(); ++i) {
            allSourceSelecties.set(i, new StringBuffer(allSourceSelecties.get(i)).append(new StringBuffer(" ")).append(new StringBuffer(allAliasSelecties.get(i))).toString());
        }
        PriceSourceKeyInfo quoteSrcKeyInfo = quoteSchemeInfo.getPriceSourceKeyInfo();
        ArrayList<String> allSrcSelecties = new ArrayList<String>();
        if (StringUtils.isNotEmpty((CharSequence)quoteSrcKeyInfo.getBILLNO())) {
            allSrcSelecties.add(quoteSrcKeyInfo.getBILLNO() + " " + "quotesrcno");
        }
        if (StringUtils.isNotEmpty((CharSequence)quoteSrcKeyInfo.getBILLENTRY_SEQ())) {
            allSrcSelecties.add(quoteSrcKeyInfo.getBILLENTRY_SEQ() + " " + "quotesrcseq");
        }
        allSourceSelecties.addAll(allSrcSelecties);
        DataSet quoteSrcDataSet = null;
        try {
            block41: {
                if (quoteSchemeInfo.getQuoteSrcFilter() != null && logger.isInfoEnabled()) {
                    logger.info("quotesrcfilter=======" + quoteSchemeInfo.getQuoteSrcFilter());
                }
                QFilter qConditionFilter = this.getLimitFilter(quotePolicyParam, quoteSchemeInfo);
                try (TXHandle h = TX.requiresNew((String)this.getClass().getName());){
                    try {
                        if (QFilter.of((String)"1=1", (Object[])new Object[0]).equals(quoteSchemeInfo.getQuoteSrcFilter())) {
                            logger.info("quote into this QuoteSourceFilterStep  path 1");
                            quoteSrcDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)quoteSchemeInfo.getQuoteSrcType(), (String)String.join((CharSequence)",", allSourceSelecties), (QFilter[])new QFilter[]{qConditionFilter, quoteSchemeInfo.getQuoteSrcFilter()}, null);
                            break block41;
                        }
                        try (DataSet offlineDataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)quoteSchemeInfo.getQuoteSrcType(), (String)String.join((CharSequence)",", allSourceSelecties), (QFilter[])new QFilter[]{qConditionFilter, quoteSchemeInfo.getQuoteSrcFilter()}, null);){
                            logger.info("quote into this QuoteSourceFilterStep  path 2");
                            quoteSrcDataSet = offlineDataSet.copy();
                        }
                    }
                    catch (Exception ex) {
                        logger.info("quote into this QuoteSourceFilterStep  exception");
                        h.markRollback();
                        throw ex;
                    }
                    finally {
                        h.commit();
                    }
                }
            }
            quoteSrcDataSet = quoteSrcDataSet.addField("'" + quoteSchemeInfo.getQuoteSrcType() + "'", "quotesrcbill");
            if (StringUtils.isEmpty((CharSequence)quoteSrcKeyInfo.getBILLNO())) {
                quoteSrcDataSet = quoteSrcDataSet.addNullField("quotesrcno");
            }
            if (StringUtils.isEmpty((CharSequence)quoteSrcKeyInfo.getBILLENTRY_SEQ())) {
                quoteSrcDataSet = quoteSrcDataSet.addNullField("quotesrcseq");
            }
        }
        catch (Throwable e) {
            if (quoteSrcDataSet == null) {
                logger.info("quote into this QuoteSourceFilterStep  exception x");
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u53d6\u4ef7\u6765\u6e90\u5355\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u53d6\u4ef7\u65b9\u6848\u201c%1$s\u201d\u7684\u5b57\u6bb5\u6620\u5c04\u5206\u5f55\u7684\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u548c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u53ef\u80fd\u5b58\u5728\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5339\u914d\u6216\u4ef7\u683c\u6765\u6e90\u5355\u636e\u7684\u5143\u6570\u636e\u5b57\u6bb5\u53ef\u80fd\u53d1\u751f\u4e86\u53d8\u66f4\u3002", (String)"QuoteSourceFilterStep_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                message = String.format(message, quoteSchemeInfo.getName());
                throw new KDBizException(message);
            }
            try {
                quoteSrcDataSet.close();
            }
            catch (Throwable var15) {
                logger.info("quote into this QuoteSourceFilterStep  exception y");
                e.addSuppressed(var15);
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u53d6\u4ef7\u6765\u6e90\u5355\u636e\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (String)"QuoteSourceFilterStep_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
        }
        logger.info("quote output this QuoteSourceFilterStep  path:");
        quotePolicyParam.setQuoteSourceDataSet(quoteSrcDataSet);
    }

    protected List<String> getLimitFields() {
        return Arrays.asList("org", "billno", "material", "customer", "supplier", "cpnn");
    }

    private QFilter getLimitFilter(QuotePolicyParam quotePolicyParam, QuoteSchemeInfo quoteSchemeInfo) {
        List<String> limitFields = this.getLimitFields();
        ArrayList<String> valueFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        ArrayList<String> conditonFields = new ArrayList<String>(quoteSchemeInfo.getOperators().size());
        for (int i = 0; i < quoteSchemeInfo.getOperators().size(); ++i) {
            String operator = quoteSchemeInfo.getOperators().get(i);
            if (!OperatorEnum.EQUALS.getValue().equals(operator)) continue;
            for (String limitField : limitFields) {
                if (!quoteSchemeInfo.getQuoteAlias().get(i).contains(limitField) || !StringUtils.isNotEmpty((CharSequence)quoteSchemeInfo.getQuoteSourceDimensions().get(i))) continue;
                valueFields.add(quoteSchemeInfo.getQuoteAlias().get(i));
                conditonFields.add(quoteSchemeInfo.getQuoteSourceDimensions().get(i));
            }
        }
        ArrayList valuesSet = new ArrayList(valueFields.size());
        valueFields.forEach(e -> valuesSet.add(new HashSet()));
        DataSet conditionSet = quotePolicyParam.getQuoteDataSet().copy();
        Object object = null;
        try {
            for (Row conditonRow : conditionSet) {
                for (int i = 0; i < valueFields.size(); ++i) {
                    Object value = conditonRow.get((String)valueFields.get(i));
                    ((Set)valuesSet.get(i)).add(value);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (conditionSet != null) {
                if (object != null) {
                    try {
                        conditionSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    conditionSet.close();
                }
            }
        }
        QFilter qConditionFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        for (int i = 0; i < conditonFields.size(); ++i) {
            if (((Set)valuesSet.get(i)).size() > 2000) continue;
            qConditionFilter.and(new QFilter((String)conditonFields.get(i), "in", valuesSet.get(i)));
        }
        return qConditionFilter;
    }
}

