/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc;

import java.math.BigDecimal;
import java.util.ArrayList;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuotePolicyParam;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteCalcInfo;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.QuoteSchemeGroupInfo;
import kd.mpscmm.msbd.pricemodel.business.service.quote.log.QuoteLogProxy;
import kd.mpscmm.msbd.pricemodel.business.service.quote.step.calc.CalcStep;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.MulPriceEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.PriceSourceEnum;

public class CalcScheGrpResultStep
extends CalcStep {
    private static final Log logger = LogFactory.getLog(CalcScheGrpResultStep.class);

    @Override
    public void excute(QuotePolicyParam quotePolicyParam, QuoteCalcInfo quoteCalcInfo, QuoteLogProxy logProxy) {
        int i;
        ArrayList fieldList = new ArrayList(16);
        quotePolicyParam.getQccInfo().getLEFTIDFIELDS().forEach(e -> fieldList.add(e));
        quoteCalcInfo.getSchemeGroupInfos().forEach(quoteSchemeGroupInfo -> {
            if (PriceSourceEnum.BILLFIELD.getValue().equals(quoteSchemeGroupInfo.getPriceSource()) || PriceSourceEnum.SCHEME.getValue().equals(quoteSchemeGroupInfo.getPriceSource())) {
                fieldList.add(quoteSchemeGroupInfo.getNumber());
            } else if (MulPriceEnum.MANUAL.getValue().equals(quoteSchemeGroupInfo.getMulPrice())) {
                fieldList.add(quoteSchemeGroupInfo.getNumber());
            }
        });
        DataType[] dataTypes = new DataType[fieldList.size()];
        RowMeta origialMeta = quotePolicyParam.getQuoteDataSet().getRowMeta();
        for (i = 0; i < quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size(); ++i) {
            String key = quotePolicyParam.getQccInfo().getLEFTIDFIELDS().get(i);
            int index = origialMeta.getFieldIndex(key);
            dataTypes[i] = origialMeta.getDataType(index);
        }
        for (i = quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size(); i < dataTypes.length; ++i) {
            dataTypes[i] = DataType.BigDecimalType;
        }
        String[] fieldNames = fieldList.toArray(new String[fieldList.size()]);
        RowMeta quoteRowMeta = new RowMeta(fieldNames, dataTypes);
        ArrayList<Object[]> quoteBillList = new ArrayList<Object[]>();
        try (DataSet quoteDataSet = quotePolicyParam.getQuoteDataSet();){
            for (Row row : quoteDataSet) {
                Object[] quoteRow = new Object[quoteRowMeta.getFieldCount()];
                String mainKey = PriceHelper.generateRowKey(quotePolicyParam.getQccInfo(), row);
                for (int i2 = 0; i2 < quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size(); ++i2) {
                    quoteRow[i2] = row.get(quotePolicyParam.getQccInfo().getLEFTIDFIELDS().get(i2));
                }
                int index = quotePolicyParam.getQccInfo().getLEFTIDFIELDS().size();
                for (QuoteSchemeGroupInfo quoteSchemeGroupInfo2 : quoteCalcInfo.getSchemeGroupInfos()) {
                    if (PriceSourceEnum.BILLFIELD.getValue().equals(quoteSchemeGroupInfo2.getPriceSource()) || PriceSourceEnum.SCHEME.getValue().equals(quoteSchemeGroupInfo2.getPriceSource())) {
                        Object value = quoteSchemeGroupInfo2.getGroupResult().get(mainKey);
                        quoteRow[index] = value != null && !(value instanceof BigDecimal) ? new BigDecimal(value.toString()) : value;
                        if (quoteRow[index] == null && !quoteSchemeGroupInfo2.isRequire()) {
                            quoteRow[index] = BigDecimal.ZERO;
                        }
                        ++index;
                        continue;
                    }
                    if (!MulPriceEnum.MANUAL.getValue().equals(quoteSchemeGroupInfo2.getMulPrice())) continue;
                    if (!quoteSchemeGroupInfo2.isRequire()) {
                        quoteRow[index] = BigDecimal.ZERO;
                        ++index;
                        continue;
                    }
                    quoteRow[index] = null;
                    ++index;
                }
                quoteBillList.add(quoteRow);
            }
        }
        DataSet resultSet = Algo.create((String)"CalcScheGrpResultStep").createDataSet(quoteBillList.iterator(), quoteRowMeta);
        quotePolicyParam.setResultSet(resultSet);
    }
}

