/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin;

import java.util.EventObject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.base.BaseShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.LicenseHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;

public class PriceControlStrategyPlugin
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(PriceControlStrategyPlugin.class);
    private static final String FORMID_SELECTCONDITION = "botp_condition";
    private static final String SM_SALEPRICELIST = "sm_salepricelist";
    private static final String PM_PURPRICELIST = "pm_purpricelist";
    private static final String CONM_PURCONTRACT = "conm_purcontract";
    private static final String CONM_SALCONTRACT = "conm_salcontract";

    public void preOpenForm(PreOpenFormEventArgs e) {
        String formId;
        String appId;
        Map<String, Object> result;
        super.preOpenForm(e);
        if (e.getFormShowParameter() != null && Boolean.TRUE.equals((result = LicenseHelper.checkLicense(appId = e.getFormShowParameter().getServiceAppId(), formId = ((BaseShowParameter)e.getSource()).getFormId())).get("isCancel"))) {
            e.setCancelMessage((String)result.get("cancelMessage"));
            e.setCancel(true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.getView().getControl("preconditiondesc") != null) {
            this.addClickListeners(new String[]{"preconditiondesc"});
        }
        if (this.getView().getControl("ctlsrcconditondesc") != null) {
            this.addClickListeners(new String[]{"ctlsrcconditondesc"});
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if (c.getKey().equalsIgnoreCase("preconditiondesc")) {
            this.showCondition(OpenSource.CONTROL);
        }
        if (c.getKey().equalsIgnoreCase("ctlsrcconditondesc")) {
            this.showCondition(OpenSource.SOURCE);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (Boolean.TRUE.equals(this.getModel().getValue("ispreset"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bar_unaudit"});
        }
        AtomicBoolean change = new AtomicBoolean(false);
        this.loadSchemeEntryCaption(change);
        if (change.get()) {
            this.getModel().setDataChanged(false);
        }
    }

    private void loadSchemeEntryCaption(AtomicBoolean change) {
        for (int row = 0; row < this.getModel().getEntryRowCount("entryentity"); ++row) {
            String conditonJson;
            FilterBuilder filterBuilder;
            String sourceConditonJson;
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("pricecontrolscheme", row);
            if (scheme == null) continue;
            DynamicObject sourcebill = scheme.getDynamicObject("controlsource");
            DynamicObject quotebill = scheme.getDynamicObject("controlentity");
            if (sourcebill != null && StringUtils.isNotEmpty((CharSequence)(sourceConditonJson = (String)this.getModel().getValue("ctlsrcconditon_tag", row)))) {
                filterBuilder = PriceHelper.convertFullStringToQFilter(sourceConditonJson, (String)sourcebill.getPkValue());
                filterBuilder.buildFilter();
                this.getModel().setValue("ctlsrcconditondesc", (Object)filterBuilder.getFilterStringDesc(), row);
                change.set(true);
            }
            if (quotebill == null || !StringUtils.isNotEmpty((CharSequence)(conditonJson = (String)this.getModel().getValue("preconditionjson_tag", row)))) continue;
            filterBuilder = PriceHelper.convertFullStringToQFilter(conditonJson, (String)quotebill.getPkValue());
            filterBuilder.buildFilter();
            this.getModel().setValue("preconditiondesc", (Object)filterBuilder.getFilterStringDesc(), row);
            change.set(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (CommonUtils.isRealChanged((ChangeData)changeSet[0])) {
            switch (key) {
                case "pricecontrolscheme": {
                    for (int j = 0; j < changeSet.length; ++j) {
                        DynamicObject priceSourceEntity;
                        int row = changeSet[j].getRowIndex();
                        DynamicObject priceControlScheme = (DynamicObject)this.getModel().getValue("pricecontrolscheme", row);
                        this.getModel().setValue("preconditiondesc", null, row);
                        this.getModel().setValue("preconditionjson", null, row);
                        this.getModel().setValue("preconditionjson_tag", null, row);
                        this.getModel().setValue("ctlsrcconditondesc", null, row);
                        this.getModel().setValue("ctlsrcconditon_tag", null, row);
                        this.getModel().setValue("ctlsrcconditon", null, row);
                        if (priceControlScheme == null || (priceSourceEntity = priceControlScheme.getDynamicObject("controlsource")) == null) continue;
                        try {
                            IDataEntityProperty billStatus;
                            FilterBuilder filterBuilder;
                            FilterBuilder filterBuilder2;
                            String entityId = (String)priceSourceEntity.getPkValue();
                            IDataModel model = this.getModel();
                            if (SM_SALEPRICELIST.equals(entityId) || PM_PURPRICELIST.equals(entityId)) {
                                String priceListFilterJson = AdvancedPricingHelper.getPriceListFilterJson();
                                model.setValue("ctlsrcconditondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(priceListFilterJson), row);
                                model.setValue("ctlsrcconditon_tag", (Object)priceListFilterJson, row);
                                filterBuilder2 = PriceHelper.convertFullStringToQFilter(priceListFilterJson, entityId);
                                filterBuilder2.buildFilter();
                                model.setValue("ctlsrcconditondesc", (Object)filterBuilder2.getFilterStringDesc(), row);
                                continue;
                            }
                            if (CONM_PURCONTRACT.equals(entityId) || CONM_SALCONTRACT.equals(entityId)) {
                                String contractFilterJson = AdvancedPricingHelper.getContractFilterJson();
                                model.setValue("ctlsrcconditondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(contractFilterJson), row);
                                model.setValue("ctlsrcconditon_tag", (Object)contractFilterJson, row);
                                filterBuilder2 = PriceHelper.convertFullStringToQFilter(contractFilterJson, entityId);
                                filterBuilder2.buildFilter();
                                model.setValue("ctlsrcconditondesc", (Object)filterBuilder2.getFilterStringDesc(), row);
                                continue;
                            }
                            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
                            if (dataEntityType instanceof BasedataEntityType) {
                                IDataEntityProperty enable = dataEntityType.findProperty("enable");
                                if (enable == null) continue;
                                String baseDataFilterJson = AdvancedPricingHelper.getBaseDataFilterJson();
                                model.setValue("ctlsrcconditondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(baseDataFilterJson), row);
                                model.setValue("ctlsrcconditon_tag", (Object)baseDataFilterJson, row);
                                filterBuilder = PriceHelper.convertFullStringToQFilter(baseDataFilterJson, dataEntityType.getName());
                                filterBuilder.buildFilter();
                                model.setValue("ctlsrcconditondesc", (Object)filterBuilder.getFilterStringDesc(), row);
                                continue;
                            }
                            if (!(dataEntityType instanceof BillEntityType) || (billStatus = dataEntityType.findProperty("billstatus")) == null) continue;
                            String billFilterJson = AdvancedPricingHelper.getBillFilterJson();
                            model.setValue("ctlsrcconditondesc", (Object)AdvancedPricingHelper.getConditionExprDesc(billFilterJson), row);
                            model.setValue("ctlsrcconditon_tag", (Object)billFilterJson, row);
                            filterBuilder = PriceHelper.convertFullStringToQFilter(billFilterJson, entityId);
                            filterBuilder.buildFilter();
                            model.setValue("ctlsrcconditondesc", (Object)filterBuilder.getFilterStringDesc(), row);
                            continue;
                        }
                        catch (Exception ea) {
                            logger.info("scheme sourcefilter tansfer fail");
                        }
                    }
                    break;
                }
                case "preconditiondesc": {
                    int row = this.getModel().getEntryCurrentRowIndex("entryentity");
                    if (newValue != null && !"".equals(newValue)) break;
                    this.getModel().setValue("preconditionjson_tag", null, row);
                    this.getModel().setValue("preconditionjson", null, row);
                    break;
                }
                case "ctlsrcconditondesc": {
                    int rowY = this.getModel().getEntryCurrentRowIndex("entryentity");
                    if (newValue != null && !"".equals(newValue)) break;
                    this.getModel().setValue("ctlsrcconditon_tag", null, rowY);
                    this.getModel().setValue("ctlsrcconditon", null, rowY);
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.receiveCondition((String)e.getReturnData(), "entryentity", OpenSource.getName(e.getActionId()), e.getActionId());
    }

    private void showCondition(OpenSource source) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        DynamicObject priceControlscheme = (DynamicObject)this.getModel().getValue("pricecontrolscheme", row);
        if (priceControlscheme == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9650\u4ef7\u65b9\u6848\u3002", (String)"PriceControlStrategyPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        DynamicObject quoteentity = priceControlscheme.getDynamicObject(source.source);
        String number = quoteentity.getString("number");
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
        String conditionJson = (String)this.getModel().getValue(source.valueField, row);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(dataEntityType);
        TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
        String flsNodes = SerializationUtils.toJsonString((Object)treeNode);
        this.showConditionForm(conditionJson, dataEntityType.getName(), flsNodes, source.descField);
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTCONDITION);
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void receiveCondition(String conditionJson, String entryEntityKey, String conditionFldKey, String descFldKey) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String exprTran = condition.getExprDesc();
            int row = this.getModel().getEntryCurrentRowIndex(entryEntityKey);
            this.getModel().setValue(conditionFldKey, (Object)conditionJson, row);
            this.getModel().setValue(descFldKey, (Object)exprTran, row);
            DynamicObject sourcebill = null;
            DynamicObject scheme = (DynamicObject)this.getModel().getValue("pricecontrolscheme", row);
            if (scheme != null) {
                sourcebill = OpenSource.SOURCE.descField.equals(descFldKey) ? scheme.getDynamicObject("controlsource") : scheme.getDynamicObject("controlentity");
            }
            if (sourcebill != null) {
                FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)((String)sourcebill.getPkValue())), condition.getFilterCondition());
                fb.buildFilter();
                this.getModel().setValue(descFldKey, (Object)fb.getFilterStringDesc(), row);
            }
        }
    }

    public static enum OpenSource {
        SOURCE("ctlsrcconditondesc", "ctlsrcconditon_tag", "controlsource"),
        CONTROL("preconditiondesc", "preconditionjson_tag", "controlentity");

        private String descField;
        private String valueField;
        private String source;

        private OpenSource(String descFieldParam, String valueFieldParam, String sourceParam) {
            this.descField = descFieldParam;
            this.valueField = valueFieldParam;
            this.source = sourceParam;
        }

        public static String getName(String descField) {
            String name = null;
            for (OpenSource source : OpenSource.values()) {
                if (!source.descField.equals(descField)) continue;
                name = source.valueField;
                break;
            }
            return name;
        }
    }
}

