/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.advanceprice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.PriceFormulaHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceFormulaExprInfo;

public class PriceCalStrategyPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static final String MSBD_FORMULADEFINE = "msbd_formuladefine";
    private static final String FORMULA_KEY = "_formula_key_";
    private static final String QUOTESIGNNAME_KEY = "_quotesignname_key_";
    private static final String MSBD_FIELDSELECT = "msbd_fieldselect";
    private static final String STOPCHANGE = "stopChange";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String CONFIRM_QUOTEENTITY_FLAG = "confirm_quoteentity_flag";
    private static final String NEW_QUOTEENTITY_VALUE = "new_quoteentity_value";

    public void registerListener(EventObject e) {
        EntryGrid entry;
        BasedataEdit quoteBill;
        BasedataEdit processFactor;
        BasedataEdit quoteSchemeGroup = (BasedataEdit)this.getView().getControl("quoteschemegroup");
        if (quoteSchemeGroup != null) {
            quoteSchemeGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((processFactor = (BasedataEdit)this.getView().getControl("processfactor")) != null) {
            processFactor.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((quoteBill = (BasedataEdit)this.getView().getControl("quoteentity")) != null) {
            quoteBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entry = (EntryGrid)this.getControl("factor")) != null) {
            entry.addRowClickListener((RowClickEventListener)this);
        }
        this.addClickListeners(new String[]{"formula", "formulades", "quotesignname"});
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("quoteschemegroup".equals(key) || "processfactor".equals(key)) {
            int i;
            ArrayList<Long> notList;
            IDataModel model = this.getModel();
            DynamicObject quoteEntity = (DynamicObject)model.getValue("quoteentity");
            if (quoteEntity == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"PriceCalStrategyPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            String number = quoteEntity.getString("number");
            String quoteEntityFilterSign = "quoteentity".concat(".").concat("number");
            QFilter entityQFilter = new QFilter(quoteEntityFilterSign, "=", (Object)number);
            ListFilterParameter listFilterParameter = ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter();
            QFilter excIncQFilter = null;
            if ("quoteschemegroup".equals(key)) {
                notList = new ArrayList<Long>(16);
                DynamicObjectCollection factorList = model.getDataEntity(true).getDynamicObjectCollection("factor");
                for (i = 0; i < factorList.size(); ++i) {
                    DynamicObject quoteSchemeGroup;
                    DynamicObject factorRow = (DynamicObject)factorList.get(i);
                    if (factorRow == null || (quoteSchemeGroup = factorRow.getDynamicObject("quoteschemegroup")) == null) continue;
                    notList.add((Long)quoteSchemeGroup.getPkValue());
                }
                excIncQFilter = new QFilter("pricesource", "!=", (Object)"B");
                if (notList.size() > 0) {
                    excIncQFilter.and(new QFilter("id", "not in", notList));
                }
            }
            if ("processfactor".equals(key)) {
                notList = new ArrayList(16);
                DynamicObjectCollection calFormulaList = model.getDataEntity(true).getDynamicObjectCollection("calformula");
                for (i = 0; i < calFormulaList.size(); ++i) {
                    DynamicObject processFactor;
                    DynamicObject calFormulaRow = (DynamicObject)calFormulaList.get(i);
                    if (calFormulaRow == null || (processFactor = calFormulaRow.getDynamicObject("processfactor")) == null) continue;
                    notList.add((Long)processFactor.getPkValue());
                }
                excIncQFilter = new QFilter("pricesource", "=", (Object)"B");
                excIncQFilter.and(new QFilter("id", "not in", notList));
            }
            QFilter qfilter = entityQFilter.and(excIncQFilter);
            listFilterParameter.setFilter(qfilter);
        } else if ("quoteentity".equals(key)) {
            String appID = this.getModel().getDataEntityType() != null ? this.getModel().getDataEntityType().getAppId() : "";
            QuoteHelper.registerQuoteBill(e, appID, false);
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String fieldKey = source.getKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        if ("formulades".equals(fieldKey)) {
            int rowIndex = model.getEntryCurrentRowIndex("calformula");
            DynamicObject calFormula = (DynamicObject)model.getEntryEntity("calformula").get(rowIndex);
            String formula = calFormula.getString("formula");
            String formulaDes = calFormula.getString("formulades");
            PriceFormulaExprInfo priceFormulaExpressionInfo = PriceFormulaExprInfo.getInstance();
            priceFormulaExpressionInfo.setExpression(formula);
            priceFormulaExpressionInfo.getLocaleExprTran().setItem(Lang.get().toString(), (Object)formulaDes);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId(MSBD_FORMULADEFINE);
            String treeNodeJson = this.getTreeNodeJson(rowIndex);
            showParameter.getCustomParams().put("treenodes", treeNodeJson);
            String entityInfo = SerializationUtils.toJsonString((Object)priceFormulaExpressionInfo);
            showParameter.getCustomParams().put("formula", entityInfo);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORMULA_KEY));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            view.showForm(showParameter);
        }
        if ("quotesignname".equals(fieldKey)) {
            DynamicObject bill = (DynamicObject)this.getModel().getValue("quoteentity");
            if (bill == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"PriceCalStrategyPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
            this.showQuoteEntityField();
        }
    }

    private String getTreeNodeJson(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObjectCollection factor = model.getDataEntity(true).getDynamicObjectCollection("factor");
        TreeNode treeNode = new TreeNode("", "0", ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50", (String)"PriceCalStrategyPlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
        treeNode.setIsOpened(true);
        for (int i = 0; i < factor.size(); ++i) {
            DynamicObject factorRow = (DynamicObject)factor.get(i);
            DynamicObject quoteSchemeGroup = factorRow.getDynamicObject("quoteschemegroup");
            if (quoteSchemeGroup == null) continue;
            String number = quoteSchemeGroup.getString("number");
            String name = quoteSchemeGroup.getLocaleString("name").getLocaleValue();
            treeNode.addChild(new TreeNode("0", number, name));
        }
        DynamicObjectCollection calFormulaList = model.getDataEntity(true).getDynamicObjectCollection("calformula");
        for (int i = 0; i < rowIndex; ++i) {
            DynamicObject calFormulaRow = (DynamicObject)calFormulaList.get(i);
            DynamicObject processFactor = calFormulaRow.getDynamicObject("processfactor");
            if (processFactor == null) continue;
            String number = processFactor.getString("number");
            String name = processFactor.getLocaleString("name").getLocaleValue();
            treeNode.addChild(new TreeNode("0", number, name));
        }
        String fieldNodes = SerializationUtils.toJsonString((Object)treeNode);
        return fieldNodes;
    }

    private void showQuoteEntityField() {
        DynamicObject quoteEntity = (DynamicObject)this.getModel().getValue("quoteentity");
        MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)quoteEntity.getString("number"));
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)sourceEntityType, (PropTreeBuildOption)option);
        this.showSrcFieldForm(treeNode);
    }

    private void showSrcFieldForm(TreeNode billNode) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(MSBD_FIELDSELECT);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, QUOTESIGNNAME_KEY));
        showParameter.setCaption(ResManager.loadKDString((String)"\u9009\u62e9\u5355\u636e\u5b57\u6bb5", (String)"PriceCalStrategyPlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        PriceFormulaExprInfo formula;
        String type;
        String actionId = closedCallBackEvent.getActionId();
        String returnDataStr = (String)closedCallBackEvent.getReturnData();
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("calformula");
        if (FORMULA_KEY.equals(actionId) && "btnok".equals(type = (formula = PriceFormulaHelper.deserialize(returnDataStr)).getType())) {
            String expression = formula.getExpression();
            String expTran = formula.getLocaleExprTran().getLocaleValue();
            model.setValue("formula", (Object)expression, rowIndex);
            model.setValue("formulades", (Object)expTran, rowIndex);
            this.getView().updateView("calformula");
        }
        if (returnDataStr != null && QUOTESIGNNAME_KEY.equals(actionId)) {
            String[] fieldIds;
            String fieldId = returnDataStr;
            DynamicObject srcBill = (DynamicObject)this.getModel().getValue("quoteentity");
            String srcBillId = srcBill.getString("number");
            MainEntityType srcBillMainType = MetadataServiceHelper.getDataEntityType((String)srcBillId);
            String fieldCaption = EntityParseHelper.buildPropFullCaption((EntityType)srcBillMainType, (String)fieldId);
            String[] split = fieldId.split("\\.");
            String tempFieldId = split[0];
            IDataEntityProperty findProperty = srcBillMainType.findProperty(tempFieldId);
            boolean isEntryField = false;
            if (findProperty != null) {
                String parentName = findProperty.getParent().getName();
                fieldId = AdvancedPricingHelper.getEntryFullField(srcBillMainType, fieldId, srcBillId, parentName);
                if (!srcBillId.equals(parentName)) {
                    isEntryField = true;
                }
            }
            if ((fieldIds = fieldId.split("\\.")) != null && fieldIds.length > 4) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5c0f\u4e8e\u56db\u7ea7\u7684\u5b57\u6bb5\u3002", (String)"PriceCalStrategyPlugin_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            }
            if (fieldIds != null && isEntryField && fieldIds.length > 2 || fieldIds != null && !isEntryField && fieldIds.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u672c\u8eab\u7684\u5b57\u6bb5\u3002", (String)"PriceCalStrategyPlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            }
            this.getModel().setValue("quotesignname", (Object)fieldCaption, rowIndex);
            this.getModel().setValue("quotesign", (Object)fieldId, rowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        DynamicObjectCollection formulaRow;
        AbstractGrid calFormula;
        String number;
        int focusRow;
        int m;
        int[] selectedRows;
        String name = e.getEntryProp().getName();
        if ("factor".equals(name)) {
            AbstractGrid factor = (AbstractGrid)this.getControl("factor");
            selectedRows = factor.getEntryState().getSelectedRows();
            DynamicObjectCollection factorRow = this.getModel().getDataEntity(true).getDynamicObjectCollection("factor");
            for (m = 0; m < selectedRows.length; ++m) {
                boolean flag;
                focusRow = selectedRows[m];
                DynamicObject rowFactor = (DynamicObject)factorRow.get(focusRow);
                DynamicObject quoteSchemeGroup = rowFactor.getDynamicObject("quoteschemegroup");
                if (quoteSchemeGroup == null || !(flag = this.checkFactor(number = quoteSchemeGroup.getString("number")))) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u56e0\u5b50\u201d\u7b2c%s\u884c\uff0c\u5df2\u88ab\u8ba1\u7b97\u516c\u5f0f\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PriceCalStrategyPlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), focusRow + 1);
                this.getView().showTipNotification(msg);
                e.setCancel(true);
                break;
            }
        }
        if ("calformula".equals(name) && (selectedRows = (calFormula = (AbstractGrid)this.getControl("calformula")).getEntryState().getSelectedRows()).length != (formulaRow = this.getModel().getDataEntity(true).getDynamicObjectCollection("calformula")).size()) {
            block1: for (m = 0; m < selectedRows.length; ++m) {
                focusRow = selectedRows[m];
                DynamicObject rowFormula = (DynamicObject)formulaRow.get(focusRow);
                DynamicObject processFactor = rowFormula.getDynamicObject("processfactor");
                if (processFactor == null) {
                    return;
                }
                number = processFactor.getString("number");
                for (int i = focusRow + 1; i < formulaRow.size(); ++i) {
                    DynamicObject surplusRowFormula;
                    String calFactor;
                    int ix = i;
                    if (!Arrays.stream(selectedRows).noneMatch(s -> s == ix) || !(calFactor = (surplusRowFormula = (DynamicObject)formulaRow.get(i)).getString("formula")).contains(number)) continue;
                    String msg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7b2c%s\u884c\u7684\u8fc7\u7a0b\u56e0\u5b50\uff0c\u5df2\u88ab\u8ba1\u7b97\u516c\u5f0f\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PriceCalStrategyPlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i);
                    this.getView().showTipNotification(msg);
                    e.setCancel(true);
                    continue block1;
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (TRUE.equals(this.getPageCache().get(STOPCHANGE))) {
            return;
        }
        String fieldName = e.getProperty().getName();
        if (CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            block7 : switch (fieldName) {
                case "quoteentity": {
                    DynamicObject newQuoteEntity = (DynamicObject)newValue;
                    DynamicObject oldQuoteEntity = (DynamicObject)oldValue;
                    boolean isFlag = false;
                    DynamicObjectCollection factorColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("factor");
                    int factorCount = factorColl.size();
                    for (int i = 0; i < factorCount; ++i) {
                        DynamicObject factor = (DynamicObject)factorColl.get(i);
                        DynamicObject quoteSchemeGroup = factor.getDynamicObject("quoteschemegroup");
                        if (quoteSchemeGroup == null) continue;
                        isFlag = true;
                        break;
                    }
                    if (!isFlag) {
                        DynamicObjectCollection formulaColl = this.getModel().getDataEntity(true).getDynamicObjectCollection("calformula");
                        int formulaCount = formulaColl.size();
                        for (int i = 0; i < formulaCount; ++i) {
                            DynamicObject formula = (DynamicObject)formulaColl.get(i);
                            String quoteSign = formula.getString("quotesign");
                            if (!StringUtils.isNotEmpty((CharSequence)quoteSign)) continue;
                            isFlag = true;
                            break;
                        }
                    }
                    if (!isFlag) break;
                    String entityId = "";
                    if (newQuoteEntity != null) {
                        entityId = (String)newQuoteEntity.getPkValue();
                    }
                    this.getPageCache().put(NEW_QUOTEENTITY_VALUE, entityId);
                    MessageBoxOptions options = MessageBoxOptions.OKCancel;
                    ConfirmTypes confirmTypes = ConfirmTypes.Wait;
                    ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_QUOTEENTITY_FLAG, (IFormPlugin)this);
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u201c\u53d6\u4ef7\u5355\u636e\u201d\u5207\u6362\uff0c\u5c06\u6e05\u9664\u8ba1\u7b97\u7b56\u7565\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\u5207\u6362\uff1f", (String)"PriceCalStrategyPlugin_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), options, confirmTypes, callBack);
                    this.getPageCache().put(STOPCHANGE, TRUE);
                    this.getModel().setValue("quoteentity", (Object)oldQuoteEntity);
                    this.getPageCache().put(STOPCHANGE, FALSE);
                    break;
                }
                case "quoteschemegroup": {
                    String number;
                    boolean flag;
                    DynamicObject newQuoteSchGroup = (DynamicObject)newValue;
                    DynamicObject oldQuoteSchGroup = (DynamicObject)oldValue;
                    if (oldQuoteSchGroup == null || newQuoteSchGroup != null && newQuoteSchGroup == oldQuoteSchGroup || !(flag = this.checkFactor(number = oldQuoteSchGroup.getString("number")))) break;
                    this.getPageCache().put(STOPCHANGE, TRUE);
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("factor");
                    this.getModel().setValue("quoteschemegroup", (Object)oldQuoteSchGroup, rowIndex);
                    this.getPageCache().put(STOPCHANGE, FALSE);
                    String msg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u56e0\u5b50\u201d\u5df2\u88ab\u8ba1\u7b97\u516c\u5f0f\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u6e05\u7a7a\u3002", (String)"PriceCalStrategyPlugin_8", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), new Object[0]);
                    this.getView().showTipNotification(msg);
                    break;
                }
                case "processfactor": {
                    DynamicObject newProcessFactor = (DynamicObject)newValue;
                    DynamicObject oldProcessFactor = (DynamicObject)oldValue;
                    if (oldProcessFactor == null || newProcessFactor != null && oldProcessFactor == newProcessFactor) break;
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("calformula");
                    String number = oldProcessFactor.getString("number");
                    DynamicObjectCollection formulaRow = this.getModel().getDataEntity(true).getDynamicObjectCollection("calformula");
                    for (int i = rowIndex + 1; i < formulaRow.size(); ++i) {
                        DynamicObject surplusRowFormula = (DynamicObject)formulaRow.get(i);
                        String calFactor = surplusRowFormula.getString("formula");
                        if (!calFactor.contains(number)) continue;
                        this.getPageCache().put(STOPCHANGE, TRUE);
                        this.getModel().setValue("processfactor", (Object)oldProcessFactor, rowIndex);
                        this.getPageCache().put(STOPCHANGE, FALSE);
                        String msg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7684\u8fc7\u7a0b\u56e0\u5b50\uff0c\u5df2\u88ab\u8ba1\u7b97\u516c\u5f0f\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u5207\u6362\u6216\u6e05\u7a7a\u3002", (String)"PriceCalStrategyPlugin_9", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), new Object[0]);
                        this.getView().showTipNotification(msg);
                        break block7;
                    }
                    break;
                }
                case "formulades": {
                    if (newValue != null && !"".equals(newValue)) break;
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("calformula");
                    this.getModel().setValue("formula", null, rowIndex);
                    break;
                }
                case "quotesignname": {
                    if (newValue != null && !"".equals(newValue)) break;
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("calformula");
                    this.getModel().setValue("quotesign", null, rowIndex);
                    break;
                }
            }
        }
    }

    private boolean checkFactor(String number) {
        DynamicObjectCollection formulaRow = this.getModel().getDataEntity(true).getDynamicObjectCollection("calformula");
        int indexRow = 0;
        for (int i = 0; i < formulaRow.size(); ++i) {
            DynamicObject rowFormula = (DynamicObject)formulaRow.get(i);
            String formula = rowFormula.getString("formula");
            if (!formula.contains(number)) continue;
            indexRow = i + 1;
            break;
        }
        boolean flag = false;
        if (indexRow > 0) {
            flag = true;
        }
        return flag;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((CharSequence)CONFIRM_QUOTEENTITY_FLAG, (CharSequence)callBackId) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            IPageCache pageCache = this.getPageCache();
            pageCache.put(STOPCHANGE, TRUE);
            String newQuoteEntityValue = this.getPageCache().get(NEW_QUOTEENTITY_VALUE);
            this.getModel().setValue("quoteentity", (Object)newQuoteEntityValue);
            pageCache.remove(NEW_QUOTEENTITY_VALUE);
            pageCache.put(STOPCHANGE, FALSE);
            IDataModel model = this.getModel();
            DynamicObjectCollection factor = model.getDataEntity(true).getDynamicObjectCollection("factor");
            int factorSize = factor.size();
            for (int i = factorSize - 1; i >= 0; --i) {
                factor.remove(i);
            }
            DynamicObjectCollection calFormula = model.getDataEntity(true).getDynamicObjectCollection("calformula");
            int calFormulaSize = calFormula.size();
            for (int i = calFormulaSize - 1; i >= 0; --i) {
                calFormula.remove(i);
            }
            IFormView view = this.getView();
            view.updateView("quoteentity");
            view.updateView("factor");
            view.updateView("calformula");
        }
    }
}

