/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.advanceprice;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.formula.excel.FormulaException;
import kd.bos.lang.Lang;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.PriceFormulaHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.PriceFormulaExprInfo;

public class PriceFormulaDefinePlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String FEXPRESSION = "fexpression";
    private static final String TREENODES = "treenodes";
    private static final String FORMULA = "formula";
    private static final String BTNOK = "btnok";
    private static final String BTNCANCEL = "btncancel";
    private static final String CLR = "clr";
    private static final String BACKSPACE = "backspace";
    private static final String RIGHT_BRACKETS = ")";
    private static final String LEFT_BRACKETS = "(";
    private static final String HEADNODEID = "0";
    private static final String TV_FIELDS = "tv_fields";
    private static final String FTRANEXPR = "ftranexpr";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK, BTNCANCEL});
        this.addClickListeners(new String[]{"btnfunction", CLR, BACKSPACE});
        this.addClickListeners(new String[]{"btnadd", "btnsubtraction", "btnmultiplication", "btndivison", "btnleft", "btnright"});
        TreeView tv = (TreeView)this.getView().getControl(TV_FIELDS);
        tv.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String formula = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
        PriceFormulaHelper.initData(this.getModel(), formula);
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        String treeNodeJson = (String)view.getFormShowParameter().getCustomParam(TREENODES);
        TreeView tree = (TreeView)view.getControl(TV_FIELDS);
        TreeNode treeNode = null;
        if (StringUtils.isNotEmpty((String)treeNodeJson)) {
            treeNode = (TreeNode)SerializationUtils.fromJsonString((String)treeNodeJson, TreeNode.class);
            tree.addNode(treeNode);
        } else {
            treeNode = new TreeNode("", HEADNODEID, ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50", (String)"PriceFormulaDefinePlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            tree.addNode(treeNode);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
    }

    private void clickCompareButton(String compareKey) {
        String compareValue = "";
        switch (compareKey) {
            case "btnadd": {
                compareValue = "+";
                break;
            }
            case "btnsubtraction": {
                compareValue = "-";
                break;
            }
            case "btnmultiplication": {
                compareValue = "*";
                break;
            }
            case "btndivison": {
                compareValue = "/";
                break;
            }
            case "btnleft": {
                compareValue = LEFT_BRACKETS;
                break;
            }
            case "btnright": {
                compareValue = RIGHT_BRACKETS;
                break;
            }
        }
        if (!StringUtils.isBlank((String)compareValue)) {
            PriceFormulaHelper.insertExpression(this.getView(), compareKey, FEXPRESSION, compareValue);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String currNodeId = (String)e.getNodeId();
        if (HEADNODEID.equals(currNodeId)) {
            currNodeId = "";
        }
        PriceFormulaHelper.insertExpression(this.getView(), TV_FIELDS, FEXPRESSION, currNodeId);
    }

    public void treeNodeDoubleClick(TreeNodeEvent e) {
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String keySign = source.getKey();
        if (BTNOK.equals(keySign)) {
            String formula = (String)this.getView().getFormShowParameter().getCustomParam(FORMULA);
            PriceFormulaExprInfo priceFormulaExpressionInfo = PriceFormulaHelper.deserialize(formula);
            priceFormulaExpressionInfo.setType(BTNOK);
            PriceFormulaHelper.getFormulaObj(this.getModel(), priceFormulaExpressionInfo);
            try {
                if (StringUtils.isEmpty((String)priceFormulaExpressionInfo.getExpression())) {
                    this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)priceFormulaExpressionInfo));
                    this.getView().close();
                    return;
                }
                String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
                String tranExpr = PriceFormulaHelper.tranExpression(priceFormulaExpressionInfo.getExpression(), json);
                priceFormulaExpressionInfo.getLocaleExprTran().setItem(Lang.get().toString(), (Object)tranExpr);
            }
            catch (Exception exp) {
                String expMsg = String.format(ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u6709\u8bed\u6cd5\u9519\u8bef\uff1a%s", (String)"PriceFormulaDefinePlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), exp.getMessage());
                this.getView().showErrorNotification(expMsg);
                return;
            }
            this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)priceFormulaExpressionInfo));
            this.getView().close();
        } else if (BTNCANCEL.equals(keySign)) {
            PriceFormulaExprInfo.getPriceFormulaExpressionInfo(BTNCANCEL);
            this.getView().close();
        } else if (CLR.equals(keySign)) {
            this.getModel().setValue(FEXPRESSION, (Object)"");
            PriceFormulaHelper.setCursorIndex(this.getView(), FEXPRESSION, 0);
        } else if (BACKSPACE.equals(keySign)) {
            PriceFormulaHelper.backSpaceExpression(this.getView(), BACKSPACE, FEXPRESSION);
        } else {
            this.clickCompareButton(keySign);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (e.getProperty().getName().equalsIgnoreCase(FEXPRESSION)) {
            String expression = (String)this.getModel().getValue(FEXPRESSION);
            if (StringUtils.isEmpty((String)expression)) {
                this.getModel().setValue(FTRANEXPR, (Object)"");
                return;
            }
            String json = (String)this.getView().getFormShowParameter().getCustomParam(TREENODES);
            String tranExpr = "";
            try {
                tranExpr = PriceFormulaHelper.tranExpression(expression, json);
            }
            catch (FormulaException var5) {
                tranExpr = var5.getCause() != null ? var5.getCause().getMessage() : var5.getMessage();
            }
            catch (Exception var6) {
                tranExpr = ResManager.loadKDString((String)"\u8868\u8fbe\u5f0f\u8bed\u6cd5\u89e3\u6790\u9519\u8bef\uff0c\u81ea\u52a8\u7ffb\u8bd1\u5931\u8d25\u3002", (String)"PriceFormulaDefinePlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            }
            this.getModel().setValue(FTRANEXPR, (Object)tranExpr);
        }
    }
}

