/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.advanceprice;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.common.enums.BillStatusEnum;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PropertyChangeHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.PriceProcessHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.calc.FeatureValueInfo;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.IPriceFormulaCalculate;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.PriceFormulaCalculateExpr;
import kd.mpscmm.msbd.pricemodel.business.service.formulaexecutor.PriceFormulaExecutor;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.MulPriceEnum;

public class PricingProcessPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(PricingProcessPlugin.class);
    private static final String RECALCULATEBAR = "recalculatebar";
    private static final String RETURNDATA = "returndata";
    private static final String RECALCULATE = "recalculate";
    private static final String CLOSECONFIRMKEY = "close";
    private static final String BAR_RETURNDATA = "bar_returndata";
    private static final String BILLSTATUS = "billStatus";
    private static final String ID = "id";
    private static final String NUMBER = "number";
    private static final String SUCCESS = "success";
    private static final String MSG = "msg";

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{RECALCULATEBAR});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("factor");
        if (entryGrid != null) {
            entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        String billStatus = (String)formShowParameter.getCustomParam(BILLSTATUS);
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus) || BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            view.setEnable(Boolean.FALSE, new String[]{RECALCULATE, BAR_RETURNDATA});
            view.setEnable(Boolean.FALSE, new String[]{"factor"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (PropertyChangeHelper.isStopChange(this.getPageCache())) {
            return;
        }
        String fieldName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if (CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            switch (fieldName) {
                case "result": {
                    String newValueStr = (String)newValue;
                    if (StringUtils.isEmpty((String)newValueStr)) {
                        this.getModel().setValue("price", null, e.getChangeSet()[0].getRowIndex());
                        break;
                    }
                    if (PriceHelper.isNumeric(newValueStr)) {
                        DecimalFormat df4 = PriceProcessHelper.getPriceFormat((DynamicObject)this.getModel().getValue("currency"));
                        PropertyChangeHelper.stopChange(this.getPageCache());
                        this.getModel().setValue("result", (Object)df4.format(new BigDecimal(newValueStr)), e.getChangeSet()[0].getRowIndex());
                        PropertyChangeHelper.release(this.getPageCache());
                        this.getView().updateView("result", e.getChangeSet()[0].getRowIndex());
                        this.getModel().setValue("price", (Object)new BigDecimal(newValueStr), e.getChangeSet()[0].getRowIndex());
                        break;
                    }
                    PropertyChangeHelper.stopChange(this.getPageCache());
                    this.getModel().setValue("result", oldValue, e.getChangeSet()[0].getRowIndex());
                    PropertyChangeHelper.release(this.getPageCache());
                    break;
                }
                case "price": {
                    this.getView().invokeOperation(RECALCULATE);
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String itemKey = e.getOperateKey();
        if (RECALCULATE.equals(itemKey)) {
            this.repeatCal();
        } else if (RETURNDATA.equals(itemKey)) {
            HashMap<String, Object> returnDataX = new HashMap<String, Object>(16);
            HashMap<String, BigDecimal> returnData = new HashMap<String, BigDecimal>(16);
            DynamicObjectCollection formulaRow = this.getModel().getDataEntity(true).getDynamicObjectCollection("calformula");
            DynamicObject quoteEntity = (DynamicObject)this.getModel().getValue("quoteentity");
            String number = quoteEntity.getString(NUMBER);
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)number);
            boolean flag = false;
            for (int i = 0; i < formulaRow.size(); ++i) {
                boolean checkRange;
                DynamicObject row = (DynamicObject)formulaRow.get(i);
                String quoteSign = row.getString("quotesign");
                if (StringUtils.isBlank((String)quoteSign) || !StringUtils.isNotEmpty((String)(quoteSign = AdvancedPricingHelper.subEntryField(quoteSign, entityType)))) continue;
                Map allFieldList = entityType.getAllFields();
                IDataEntityProperty property = (IDataEntityProperty)allFieldList.get(quoteSign);
                BigDecimal fieldPropertyMin = AdvancedPricingHelper.getFieldPropertyMin(property);
                BigDecimal fieldPropertyMax = AdvancedPricingHelper.getFieldPropertyMax(property);
                BigDecimal priceResult = row.getBigDecimal("priceresult");
                if (priceResult != null && !(checkRange = AdvancedPricingHelper.checkRange(fieldPropertyMin, fieldPropertyMax, priceResult))) {
                    flag = true;
                    break;
                }
                returnData.put(quoteSign, priceResult);
            }
            returnDataX.put("priceresult", returnData);
            returnDataX.put("entryid", this.getModel().getValue("entryid"));
            if (!flag) {
                this.getView().returnDataToParent(returnDataX);
                this.getView().close();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (!this.getModel().getDataChanged()) {
            return;
        }
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CLOSECONFIRMKEY, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5b9a\u4ef7\u8fc7\u7a0b\u8fdb\u884c\u4e86\u91cd\u65b0\u8ba1\u7b97\u6216\u8005\u4fee\u6539\uff0c\u662f\u5426\u76f4\u63a5\u9000\u51fa\u800c\u4e0d\u8fd4\u56de\u6570\u636e\uff1f", (String)"PricingProcessPlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
        e.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (CLOSECONFIRMKEY.equals(evt.getCallBackId()) && "Yes".equals(evt.getResultValue())) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldKey = hyperLinkClickEvent.getFieldName();
        int row = hyperLinkClickEvent.getRowIndex();
        switch (fieldKey) {
            case "quotesuccess": {
                ReportShowParameter showParam = new ReportShowParameter();
                ReportQueryParam param = new ReportQueryParam();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.addFilterItem("quoteorgfield", this.getModel().getValue("org"));
                filterInfo.addFilterItem("quotebillfield", this.getModel().getValue("quoteentity"));
                filterInfo.addFilterItem("materialfield", this.getModel().getValue("material"));
                filterInfo.addFilterItem("quotebillidfield", this.getModel().getValue("billid"));
                filterInfo.addFilterItem("quotebillentryidfield", this.getModel().getValue("entryid"));
                filterInfo.addFilterItem("calstrategyfield", this.getModel().getValue("calstrategy"));
                filterInfo.addFilterItem("calfactorfield", this.getModel().getValue("quoteschemegroup", row));
                param.setFilter(filterInfo);
                showParam.setFormId("plat_quotelogview");
                showParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                Long processID = (Long)this.getModel().getValue(ID);
                DynamicObject calStrategy = (DynamicObject)this.getModel().getValue("calstrategy");
                DynamicObject calFactor = (DynamicObject)this.getModel().getValue("quoteschemegroup", row);
                StringBuilder pageID = new StringBuilder("plat_quotelogview");
                pageID.append("__").append(processID);
                pageID.append("__").append(calStrategy != null ? Long.valueOf(calStrategy.getLong(ID)) : "");
                pageID.append("__").append(calFactor != null ? Long.valueOf(calFactor.getLong(ID)) : "");
                showParam.setPageId(pageID.toString());
                showParam.setPermissionItemId(null);
                showParam.setQueryParam(param);
                this.getView().showForm((FormShowParameter)showParam);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object id;
        DynamicObject priceProcess;
        String opKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate && RETURNDATA.equals(opKey = ((FormOperate)args.getSource()).getOperateKey()) && null == (priceProcess = BusinessDataServiceHelper.loadSingle((Object)(id = this.getModel().getValue(ID)), (String)"msbd_pricingprocess", (String)"id,billid"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9a\u4ef7\u8fc7\u7a0b\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u67e5\u770b\u3002", (String)"PricingProcessViewPlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    private void repeatCal() {
        IDataModel model = this.getModel();
        Object id = model.getValue(ID);
        DynamicObject priceProcess = BusinessDataServiceHelper.loadSingle((Object)id, (String)"msbd_pricingprocess", (String)"id,billid");
        if (null == priceProcess) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u5b9a\u4ef7\u8fc7\u7a0b\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u67e5\u770b\u3002", (String)"PricingProcessViewPlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return;
        }
        if (this.refreshFactor()) {
            return;
        }
        DynamicObjectCollection formulaRow = model.getDataEntity(true).getDynamicObjectCollection("calformula");
        DynamicObjectCollection factorRow = model.getDataEntity(true).getDynamicObjectCollection("factor");
        HashMap<String, Object> calFactorValue = new HashMap<String, Object>(16);
        this.buildCalFactorValue(factorRow, calFactorValue);
        HashMap<String, Object> processFactorValueMap = new HashMap<String, Object>(16);
        this.buildProcessFactorValue(formulaRow, calFactorValue, processFactorValueMap);
        ArrayList<IPriceFormulaCalculate> calExprList = new ArrayList<IPriceFormulaCalculate>(16);
        this.buildCalFormulaList(formulaRow, calExprList);
        PriceFormulaExecutor priceFormulaExecutor = PriceFormulaExecutor.create(calExprList);
        Map<String, Object> calculateResult = priceFormulaExecutor.calculate(calFactorValue);
        DecimalFormat df4 = PriceProcessHelper.getPriceFormat((DynamicObject)this.getModel().getValue("currency"));
        for (int i = 0; i < formulaRow.size(); ++i) {
            DynamicObject rowFormula = (DynamicObject)formulaRow.get(i);
            String quoteSign = rowFormula.getString("quotesign");
            if (StringUtils.isBlank((String)quoteSign)) {
                DynamicObject processFactor = rowFormula.getDynamicObject("processfactor");
                if (processFactor == null) continue;
                String number = processFactor.getString(NUMBER);
                Object result = processFactorValueMap.get(number);
                rowFormula.set("priceresult", result);
            } else {
                rowFormula.set("priceresult", calculateResult.get(quoteSign));
            }
            this.fillEmptyPrice(df4, rowFormula, "priceresult", "calresult");
        }
        this.getView().updateView("calformula");
    }

    private boolean refreshFactor() {
        DynamicObjectCollection factorList = this.getModel().getDataEntity(true).getDynamicObjectCollection("factor");
        boolean needRepeatFactor = this.getNeedRepeatFactor(factorList);
        if (needRepeatFactor) {
            HashMap<String, Object> otherParam = new HashMap<String, Object>(16);
            Map<String, Object> groupResult = PriceProcessHelper.simpleCalc((Long)this.getModel().getValue(ID), otherParam);
            if (Boolean.FALSE.equals(groupResult.get(SUCCESS))) {
                String tipMsg = String.format(ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5931\u8d25\uff1a%s", (String)"PricingProcessPlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), groupResult.get(MSG));
                this.getView().showTipNotification(tipMsg);
                return true;
            }
            Long billID = (Long)this.getModel().getValue("billid");
            Long billEntryID = (Long)this.getModel().getValue("entryid");
            StringBuilder resultMainKey = new StringBuilder(String.valueOf(billID));
            if (billEntryID != null && billEntryID > 0L) {
                resultMainKey.append("$$").append(billEntryID);
            }
            String featureKey = new StringBuilder(resultMainKey).append("$$").append("featurevalue").toString();
            DecimalFormat df4 = PriceProcessHelper.getPriceFormat((DynamicObject)this.getModel().getValue("currency"));
            String featureGroupNumber = "";
            for (int i = factorList.size() - 1; i >= 0; --i) {
                DynamicObject rowFactor = (DynamicObject)factorList.get(i);
                DynamicObject quoteSchemeGroup = rowFactor.getDynamicObject("quoteschemegroup");
                String featureValue = rowFactor.getString("configuredvalue");
                if (quoteSchemeGroup == null) continue;
                String mulPrice = quoteSchemeGroup.getString("mulprice");
                String number = quoteSchemeGroup.getString(NUMBER);
                if (!MulPriceEnum.CANT_MANUAL.getValue().equals(mulPrice)) continue;
                if (featureValue != null && featureValue.length() > 0) {
                    Map featureResultMap;
                    if (!featureGroupNumber.equals(number)) {
                        List featureValueInfos;
                        featureGroupNumber = number;
                        featureResultMap = new HashMap();
                        if (groupResult.get(featureKey) != null) {
                            featureResultMap = (Map)groupResult.get(featureKey);
                        }
                        if ((featureValueInfos = (List)featureResultMap.get(number)) != null && featureValueInfos.size() > 0) {
                            for (int j = 0; j < featureValueInfos.size(); ++j) {
                                int insertRow = this.getModel().insertEntryRow("factor", j + i + 1);
                                DynamicObject rowFactorCloneX = (DynamicObject)this.getModel().getEntryEntity("factor").get(insertRow);
                                rowFactorCloneX.set("quoteschemegroup", rowFactor.get("quoteschemegroup"));
                                rowFactorCloneX.set("required", rowFactor.get("required"));
                                rowFactorCloneX.set("quotesuccess", rowFactor.get("quotesuccess"));
                                rowFactorCloneX.set("configuredvalue", (Object)((FeatureValueInfo)featureValueInfos.get(j)).getFeatureValue());
                                rowFactorCloneX.set("price", (Object)((FeatureValueInfo)featureValueInfos.get(j)).getValue());
                                this.fillEmptyPrice(df4, rowFactorCloneX, "price", "result");
                            }
                            this.getModel().deleteEntryRow("factor", i);
                            continue;
                        }
                        rowFactor.set("price", null);
                        rowFactor.set("result", null);
                        continue;
                    }
                    featureResultMap = new HashMap();
                    if (groupResult.get(featureKey) != null) {
                        featureResultMap = (Map)groupResult.get(featureKey);
                    }
                    if (featureResultMap.containsKey(number)) {
                        this.getModel().deleteEntryRow("factor", i);
                        continue;
                    }
                    rowFactor.set("price", null);
                    rowFactor.set("result", null);
                    continue;
                }
                String groupNum = quoteSchemeGroup.getString(NUMBER);
                StringBuilder groupKey = new StringBuilder(resultMainKey).append("$$").append(groupNum);
                rowFactor.set("price", groupResult.get(groupKey.toString()));
                this.fillEmptyPrice(df4, rowFactor, "price", "result");
            }
            logger.info("\u624b\u5de5\u4e0d\u53ef\u6539\u83b7\u53d6\u5230\u56e0\u5b50\u7684\u503c\u8d4b\u503c\u5b8c\u6bd5\u3002");
            this.getView().updateView("factor");
        }
        return false;
    }

    private void fillEmptyPrice(DecimalFormat df4, DynamicObject rowFactorClone, String sourceField, String targetField) {
        BigDecimal price = rowFactorClone.getBigDecimal(sourceField);
        if (price == null) {
            rowFactorClone.set(targetField, null);
        } else {
            rowFactorClone.set(targetField, (Object)df4.format(price));
        }
    }

    private boolean getNeedRepeatFactor(DynamicObjectCollection factorList) {
        boolean flag = false;
        for (int i = 0; i < factorList.size(); ++i) {
            DynamicObject rowFactor = (DynamicObject)factorList.get(i);
            DynamicObject quoteSchemeGroup = rowFactor.getDynamicObject("quoteschemegroup");
            if (quoteSchemeGroup == null) continue;
            String mulPrice = quoteSchemeGroup.getString("mulprice");
            if (!MulPriceEnum.CANT_MANUAL.getValue().equals(mulPrice)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void buildCalFormulaList(DynamicObjectCollection formulaRow, List<IPriceFormulaCalculate> calExpr) {
        for (int i = 0; i < formulaRow.size(); ++i) {
            DynamicObject rowFormula = (DynamicObject)formulaRow.get(i);
            String formula = rowFormula.getString("formula");
            String quoteSign = rowFormula.getString("quotesign");
            if (StringUtils.isBlank((String)quoteSign)) continue;
            calExpr.add(PriceFormulaCalculateExpr.create(quoteSign, formula));
        }
    }

    private void buildProcessFactorValue(DynamicObjectCollection formulaRow, Map<String, Object> calFactorValue, Map<String, Object> processFactorValueMap) {
        for (int i = 0; i < formulaRow.size(); ++i) {
            DynamicObject rowFormula = (DynamicObject)formulaRow.get(i);
            String formula = rowFormula.getString("formula");
            DynamicObject processFactor = rowFormula.getDynamicObject("processfactor");
            if (processFactor == null) continue;
            String number = processFactor.getString(NUMBER);
            PriceFormulaExecutor priceFormulaExecutor = PriceFormulaExecutor.create(PriceFormulaCalculateExpr.create(number, formula));
            Map<String, Object> result = priceFormulaExecutor.calculate(calFactorValue);
            calFactorValue.put(number, result.get(number));
            processFactorValueMap.put(number, result.get(number));
        }
    }

    private void buildCalFactorValue(DynamicObjectCollection factorRow, Map<String, Object> calFactorValue) {
        for (int i = 0; i < factorRow.size(); ++i) {
            DynamicObject rowFactor = (DynamicObject)factorRow.get(i);
            DynamicObject quoteSchemeGroup = rowFactor.getDynamicObject("quoteschemegroup");
            if (quoteSchemeGroup == null) continue;
            String number = quoteSchemeGroup.getString(NUMBER);
            String featureValue = rowFactor.getString("configuredvalue");
            BigDecimal price = rowFactor.getBigDecimal("price");
            String result = rowFactor.getString("result");
            if (StringUtils.isEmpty((String)result)) {
                price = null;
            }
            if (StringUtils.isNotEmpty((String)featureValue)) {
                boolean existKey = calFactorValue.containsKey(number);
                if (existKey) {
                    if (calFactorValue.get(number) == null) continue;
                    if (price == null) {
                        calFactorValue.put(number, null);
                        continue;
                    }
                    calFactorValue.put(number, ((BigDecimal)calFactorValue.get(number)).add(price));
                    continue;
                }
                calFactorValue.put(number, price);
                continue;
            }
            calFactorValue.put(number, price);
        }
    }
}

