/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.basedata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.msbd.pricemodel.common.consts.basedata.PriceDimensionMemberConst;

public class PriceDimensionMemberPlugin
extends AbstractBasePlugIn {
    private static final String FORMID_SELECTFIELD = "botp_selectfield";
    private static final String SOURCETREENODES = "treenodes";
    private static final String NOW_KEY = "now";
    private static final String CONFIRM_KEY = "continue_close";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.refresh();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"sign"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("sign".equalsIgnoreCase(c.getKey())) {
            this.showBillTree();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (StringUtils.isEmpty((CharSequence)actionId) || returnData == null) {
            return;
        }
        switch (actionId) {
            case "sign": {
                MainEntityType mainType;
                IDataEntityProperty prop;
                if (!(returnData instanceof String)) break;
                String returnDataStr = (String)returnData;
                int row = this.getModel().getEntryCurrentRowIndex("entryentity");
                if (!StringUtils.isNotEmpty((CharSequence)returnDataStr) || (prop = (IDataEntityProperty)(mainType = MetadataServiceHelper.getDataEntityType((String)"msbd_pricetax_expenses")).getAllFields().get(returnDataStr)) == null) break;
                this.getModel().setValue("sign", (Object)returnDataStr, row);
                this.getModel().setValue("signname", (Object)prop.getDisplayName().getLocaleValue(), row);
                OrmLocaleValue value = (OrmLocaleValue)this.getModel().getValue("description", row);
                value.clear();
                this.getModel().setValue("description", (Object)value, row);
                break;
            }
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        int[] deleteRows = e.getRowIndexs();
        ArrayList<Integer> actualRows = new ArrayList<Integer>();
        ArrayList<String> preSetMsgList = new ArrayList<String>();
        for (int index : deleteRows) {
            boolean isPreset = (Boolean)this.getModel().getValue("ispreset", index);
            String sign = (String)this.getModel().getValue("sign", index);
            if (isPreset && StringUtils.isNotEmpty((CharSequence)sign)) {
                String msg = String.format(ResManager.loadKDString((String)"%0$s\uff1a\u7cfb\u7edf\u9884\u8bbe\u5b57\u6bb5\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PriceDimensionMemberPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), sign);
                preSetMsgList.add(msg);
                continue;
            }
            actualRows.add(index);
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, Integer> idMapSeq = new HashMap<Long, Integer>();
        Iterator iterator = actualRows.iterator();
        while (iterator.hasNext()) {
            int index;
            index = (Integer)iterator.next();
            String sign = (String)this.getModel().getValue("sign", index);
            Long id = (Long)this.getModel().getValue("id", index);
            if (id == null || Long.valueOf("0").equals(id) || !StringUtils.isNotEmpty((CharSequence)sign)) continue;
            ids.add(id);
            idMapSeq.put(id, index);
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        BasedataEntityType mainType = (BasedataEntityType)MetadataServiceHelper.getDataEntityType((String)"msbd_pricedimmem");
        Map refrenceResult = checker.checkRef(mainType, ids.toArray());
        ArrayList refCheckMsgList = new ArrayList();
        refrenceResult.forEach((k, v) -> {
            if (v.isRefence()) {
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)v.getRefenceKey().getRefEntityKey());
                String billName = refMainType.getDisplayName().getLocaleValue();
                int index = (Integer)idMapSeq.get(k);
                String sign = (String)this.getModel().getValue("sign", index);
                String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u7684\u5b57\u6bb5\u201c\u7ef4\u5ea6\u6210\u5458\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"PriceDimensionMemberPlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), sign, billName);
                refCheckMsgList.add(msg);
            }
        });
        preSetMsgList.addAll(refCheckMsgList);
        int failNum = preSetMsgList.size();
        if (failNum == 1) {
            String msg = (String)preSetMsgList.get(0);
            int split = msg.indexOf(65306);
            if (split > 0) {
                msg = msg.substring(split + 1);
            } else {
                split = msg.indexOf(58);
                if (split > 0) {
                    msg = msg.substring(split + 1);
                }
            }
            this.getView().showTipNotification(msg);
            e.setCancel(true);
        } else if (failNum > 1) {
            String totalMsg = String.join((CharSequence)"\n", preSetMsgList);
            String msg = ResManager.loadKDString((String)"\u5220\u884c\u5931\u8d25\u3002", (String)"PriceDimensionMemberPlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            this.getView().showMessage(msg, totalMsg, MessageTypes.Commit);
            e.setCancel(true);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String key = operate.getOperateKey();
        if ("save".equals(key)) {
            if (this.checkVersion()) {
                ArrayList priceDimensionMembers = new ArrayList();
                MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"msbd_pricedimmem");
                Date now = TimeServiceHelper.now();
                DynamicObjectCollection memberEntrys = this.getModel().getEntryEntity("entryentity");
                AtomicInteger seq = new AtomicInteger(100);
                memberEntrys.forEach(m -> {
                    if (StringUtils.isNotEmpty((CharSequence)m.getString("sign")) && !m.getBoolean("ispreset")) {
                        DynamicObject priceDimensionMember = new DynamicObject((DynamicObjectType)mainType);
                        PriceDimensionMemberConst.FIELDS.forEach(f -> priceDimensionMember.set(f, m.get(f)));
                        priceDimensionMember.set("seqx", (Object)seq.incrementAndGet());
                        this.getModel().getValue("signname", 14);
                        priceDimensionMember.set("modifytime", (Object)now);
                        priceDimensionMembers.add(priceDimensionMember);
                    }
                });
                if (priceDimensionMembers.size() > 0) {
                    OperationServiceHelper.executeOperate((String)"save", (String)"msbd_pricedimmem", (DynamicObject[])priceDimensionMembers.toArray(new DynamicObject[0]), null);
                } else {
                    DeleteServiceHelper.delete((String)"msbd_pricedimmem", (QFilter[])new QFilter[]{new QFilter("ispreset", "=", (Object)Boolean.FALSE)});
                }
                this.refresh();
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"PriceDimensionMemberPlugin_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                this.getView().showSuccessNotification(msg);
            }
        } else if ("refresh".equals(key)) {
            this.refresh();
        } else {
            super.beforeDoOperation(args);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getModel().getDataChanged()) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"PriceDimensionMemberPlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"PriceDimensionMemberPlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f", (String)"PriceDimensionMemberPlugin_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBack, btnNameMaps);
            e.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "continue_close": {
                if (!"Yes".equals(evt.getResultValue())) break;
                this.getModel().setDataChanged(false);
                this.getView().close();
                break;
            }
        }
    }

    private boolean checkVersion() {
        String nowStr = this.getPageCache().get(NOW_KEY);
        Date now = new Date(Long.parseLong(nowStr));
        boolean isModify = QueryServiceHelper.exists((String)"msbd_pricedimmem", (QFilter[])new QFilter[]{new QFilter("modifytime", ">", (Object)now)});
        if (isModify) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u7f16\u8f91\u3002", (String)"PriceDimensionMemberPlugin_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            Long id = (Long)this.getModel().getValue("id", i);
            if (id == null || id.equals(Long.valueOf("0"))) continue;
            ids.add(id);
        }
        DynamicObjectCollection existRecs = QueryServiceHelper.query((String)"msbd_pricedimmem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)}, null);
        if (existRecs == null || ids.size() != existRecs.size()) {
            String msg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u7ecf\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u7f16\u8f91\u3002", (String)"PriceDimensionMemberPlugin_7", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return false;
        }
        ArrayList<String> totalMsgList = new ArrayList<String>();
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"msbd_pricetax_expenses");
        for (int i = 0; i < this.getModel().getEntryRowCount("entryentity"); ++i) {
            String msg;
            String sign = (String)this.getModel().getValue("sign", i);
            String signName = "";
            OrmLocaleValue signNameLocale = (OrmLocaleValue)this.getModel().getValue("signname", i);
            if (signNameLocale != null) {
                signName = signNameLocale.getLocaleValue();
            }
            if (StringUtils.isNotEmpty((CharSequence)sign) && StringUtils.isNotEmpty((CharSequence)signName) && StringUtils.isNotEmpty((CharSequence)sign) && !mainType.getAllFields().containsKey(sign)) {
                msg = String.format(ResManager.loadKDString((String)"%0$s\uff1a\u5728\u4ef7\u683c\u6a21\u578b\u5b9e\u4f53\u4e2d\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5220\u884c\u540e\u518d\u4fdd\u5b58\u3002", (String)"PriceDimensionMemberPlugin_14", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), sign);
                totalMsgList.add(msg);
            }
            if (StringUtils.isEmpty((CharSequence)sign) && StringUtils.isNotEmpty((CharSequence)signName)) {
                msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%0$s\u884c\uff1a\u201c\u6807\u8bc6\u201d\u3002", (String)"PriceDimensionMemberPlugin_8", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                totalMsgList.add(msg);
            }
            if (!StringUtils.isNotEmpty((CharSequence)sign) || !StringUtils.isEmpty((CharSequence)signName)) continue;
            msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%0$s\u884c\uff1a\u201c\u540d\u79f0\u201d\u3002", (String)"PriceDimensionMemberPlugin_9", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
            totalMsgList.add(msg);
        }
        if (totalMsgList.size() == 1) {
            this.getView().showTipNotification((String)totalMsgList.get(0));
            return false;
        }
        if (totalMsgList.size() > 1) {
            String totalMsg = String.join((CharSequence)"\n", totalMsgList);
            String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"PriceDimensionMemberPlugin_10", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            this.getView().showMessage(msg, totalMsg, MessageTypes.Commit);
            return false;
        }
        return true;
    }

    private void refresh() {
        Date now = TimeServiceHelper.now();
        this.getPageCache().put(NOW_KEY, String.valueOf(now.getTime()));
        DynamicObject[] priceDimensionMembers = BusinessDataServiceHelper.load((String)"msbd_pricedimmem", (String)String.join((CharSequence)",", PriceDimensionMemberConst.ALL_FIELDS), (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])}, (String)"seqx");
        this.getModel().deleteEntryData("entryentity");
        if (priceDimensionMembers.length > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", priceDimensionMembers.length);
            int i = 0;
            while (i < this.getModel().getEntryRowCount("entryentity")) {
                int index = i++;
                PriceDimensionMemberConst.ALL_FIELDS.forEach(f -> this.getModel().setValue(f, priceDimensionMembers[index].get(f), index));
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void showBillTree() {
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)"msbd_pricetax_expenses");
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setIncludePKField(true);
        option.setOnlyPhysicsField(false);
        TreeNode treeNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
        this.arrangeTreeNode(treeNode);
        this.showSrcFieldForm(treeNode, "sign");
    }

    private void showSrcFieldForm(TreeNode billNode, String fieldKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        String nodesJson = SerializationUtils.toJsonString((Object)billNode);
        showParameter.getCustomParams().put(SOURCETREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void arrangeTreeNode(TreeNode treeNode) {
        if (treeNode.getChildren() != null && treeNode.getChildren().size() > 0) {
            DynamicObjectCollection memberEntrys = this.getModel().getEntryEntity("entryentity");
            ArrayList members = new ArrayList(memberEntrys.size());
            memberEntrys.forEach(m -> members.add(m.getString("sign")));
            TreeNode parentNode = (TreeNode)treeNode.getChildren().get(0);
            if (parentNode != null && parentNode.getChildren() != null && parentNode.getChildren().size() > 0) {
                parentNode.getChildren().remove(0);
                List leafNodes = parentNode.getChildren();
                if (leafNodes != null) {
                    for (int i = leafNodes.size() - 1; i >= 0; --i) {
                        TreeNode leafNode = (TreeNode)leafNodes.get(i);
                        if (members.contains(leafNode.getId())) {
                            parentNode.deleteChildNode(leafNode.getId());
                            continue;
                        }
                        if (leafNode.getChildren() == null || leafNode.getChildren().size() <= 0) continue;
                        leafNode.setChildren(null);
                    }
                }
                treeNode.getChildren().remove(0);
                treeNode.addChildren(leafNodes);
            }
        }
    }
}

