/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.quote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinHint;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.business.helper.FetchPriceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.common.consts.log.QuoteLogConst;
import kd.mpscmm.msbd.pricemodel.common.consts.log.QuoteLogViewConst;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogTypeEnum;

public class QuoteLogQueryPlugin
extends AbstractReportListDataPlugin {
    private static final List<String> billKeys = Arrays.asList("id", "entryid");
    private static final List<String> logKeys = Arrays.asList("quotebillid", "quotebillentryid");
    private static final String DEFAULT_MATERIALFIELD = "billentry.material.masterid";
    private static final String DEFAULT_ENTRYNAME = "billentry";
    private static final Log log = LogFactory.getLog(QuoteLogQueryPlugin.class);
    private static List<String> SCMBILLS = Arrays.asList("sm_salorder", "sm_salesagency", "sm_quotationbill", "sm_delivernotice", "im_purinbill", "pm_purapplybill", "pm_transferbill", "pm_purorderbill", "im_saloutbill", "sctm_scpo", "conm_salcontract", "conm_purcontract", "pm_om_purorderbill");

    public DataSet query(ReportQueryParam queryParam, Object arg1) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection quoteBills = filterInfo.getDynamicObjectCollection("quotebillfield");
        ArrayList<String> billNoList = new ArrayList<String>();
        String billNoStr = filterInfo.getString("quotebillnofield");
        if (StringUtils.isNotEmpty((CharSequence)billNoStr.trim())) {
            String[] billNos;
            for (String subBillNo : billNos = billNoStr.split(",")) {
                String[] subBillNos;
                for (String billNo : subBillNos = subBillNo.split("\uff0c")) {
                    billNoList.add(billNo);
                }
            }
        }
        ArrayList<Date> quoteBillDates = new ArrayList<Date>(2);
        Date quotebillDate_start = filterInfo.getDate("quotedatefield_startdate");
        Date quoteDate_end = filterInfo.getDate("quotedatefield_enddate");
        if (quotebillDate_start != null) {
            quoteBillDates.add(quotebillDate_start);
            quoteBillDates.add(quoteDate_end);
        }
        ArrayList<Long> materialList = new ArrayList<Long>();
        DynamicObjectCollection materialColl = filterInfo.getDynamicObjectCollection("materialfield");
        if (materialColl != null && materialColl.size() > 0) {
            materialColl.forEach(m -> materialList.add(m.getLong("masterid")));
        }
        ArrayList<Date> quoteStartTimes = new ArrayList<Date>(2);
        Date quoteStartTime_start = filterInfo.getDate("quotestarttimefield_start");
        Date quoteStartTime_end = filterInfo.getDate("quotestarttimefield_end");
        if (quoteStartTime_start != null) {
            quoteStartTimes.add(quoteStartTime_start);
            quoteStartTimes.add(quoteStartTime_end);
        }
        DataSet totaldataSet4AllBill = null;
        for (DynamicObject quoteBill : quoteBills) {
            DataSet quoteBillDataSet;
            String quoteBillType = (String)quoteBill.getPkValue();
            DataSet quoteLogDataSet = this.queryQuoteLog4SingleQuoteType(filterInfo, quoteStartTimes, quoteBillType);
            MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBillType);
            if (StringUtils.isEmpty((CharSequence)headType.getAlias())) {
                return quoteLogDataSet;
            }
            Long billID = filterInfo.getLong("quotebillidfield");
            HashSet<Long> quoteBillIDs = new HashSet<Long>();
            if (billID != null && !Long.valueOf("0").equals(billID)) {
                quoteBillIDs.add(billID);
                log.info("\u53d6\u4ef7\u65e5\u5fd7\u8bb0\u5f55\u8d70\u8fd9\u4e2a\u5206\u652f");
            } else {
                try (DataSet quoteLogDataSetCopy = quoteLogDataSet.copy();){
                    for (Row row : quoteLogDataSetCopy) {
                        Long quoteBillID = row.getLong("quotebillid");
                        quoteBillIDs.add(quoteBillID);
                    }
                }
            }
            DynamicObject quoteOrg = filterInfo.getDynamicObject("quoteorgfield");
            try {
                quoteBillDataSet = this.queryBillInfo4SingleQuoteType(quoteOrg, billNoList, quoteBillDates, materialList, quoteBillType, quoteBillIDs);
            }
            catch (Exception e) {
                if (e instanceof KDBizException) {
                    AppCache.get((String)"alert").put("alert", (Object)e.getMessage());
                } else {
                    String infoMsg = String.format(ResManager.loadKDString((String)"\u53d6\u4ef7\u65e5\u5fd7\u67e5\u8be2\u65f6\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u65e5\u5fd7\u3002", (String)"QuoteLogQueryPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), new Object[0]);
                    AppCache.get((String)"alert").put("alert", (Object)infoMsg);
                    log.info("\u53d6\u4ef7\u65e5\u5fd7\u67e5\u8be2\u5355\u636e\u4fe1\u606f\u5f02\u5e38" + e.getMessage());
                }
                quoteLogDataSet = quoteLogDataSet.filter("1!=1");
                return quoteLogDataSet;
            }
            if (quoteBillDataSet == null) continue;
            JoinDataSet joinDataSet = quoteBillDataSet.join(quoteLogDataSet, JoinType.INNER);
            JoinHint hint = new JoinHint();
            hint.setNullAsZero(true);
            for (int i = 0; i < billKeys.size(); ++i) {
                joinDataSet = joinDataSet.on(billKeys.get(i), logKeys.get(i)).hint(hint);
            }
            DataSet totalLogDataSet = joinDataSet.select(QuoteLogViewConst.getQuotelogviewBillfields(), QuoteLogViewConst.getQuotelogviewLogfields()).finish();
            DataSet quoteExpLogDataSet = this.queryQuoteExpLog4SingleQuoteType(filterInfo, quoteStartTimes, quoteBillType);
            JoinDataSet joinExpDataSet = quoteExpLogDataSet.join(quoteBillDataSet, JoinType.LEFT);
            for (int i = 0; i < billKeys.size(); ++i) {
                joinExpDataSet = joinExpDataSet.on(logKeys.get(i), billKeys.get(i)).hint(hint);
            }
            DataSet totalExpLogDataSet = joinExpDataSet.select(QuoteLogViewConst.getQuotelogviewLogfields(), QuoteLogViewConst.getQuotelogviewBillfields()).finish();
            totalExpLogDataSet = totalExpLogDataSet.select(QuoteLogViewConst.getQuotelogviewAllfields());
            DataSet totalDataSet = totalLogDataSet.union(totalExpLogDataSet);
            if (totaldataSet4AllBill == null) {
                totaldataSet4AllBill = totalDataSet;
                continue;
            }
            totaldataSet4AllBill = totaldataSet4AllBill.union(totalDataSet);
        }
        if (totaldataSet4AllBill != null) {
            totaldataSet4AllBill = totaldataSet4AllBill.orderBy(QuoteLogViewConst.getORDERKEYS().toArray(new String[QuoteLogViewConst.getORDERKEYS().size()]));
        }
        return totaldataSet4AllBill;
    }

    private DataSet queryBillInfo4SingleQuoteType(DynamicObject quoteOrg, List<String> billNoList, List<Date> quoteBillDates, List<Long> materialList, String quoteBillType, Set<Long> quoteBillIds) {
        String dateField;
        MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBillType);
        Map allfields = headType.getAllFields();
        String billNoField = "";
        if (headType.getAllFields().containsKey("billno")) {
            billNoField = "billno";
        } else if (headType.getAllFields().containsKey("number")) {
            billNoField = "number";
        }
        ArrayList<QFilter> quoteBillfilters = new ArrayList<QFilter>();
        QFilter billIDFilter = new QFilter("id", "in", quoteBillIds);
        quoteBillfilters.add(billIDFilter);
        if (billNoList.size() > 0 && StringUtils.isNotEmpty((CharSequence)billNoField)) {
            QFilter billNoFilter = new QFilter(billNoField, "in", billNoList);
            quoteBillfilters.add(billNoFilter);
        }
        if (StringUtils.isNotEmpty((CharSequence)(dateField = QuoteLogHelper.getBizDateField(headType))) && quoteBillDates.size() > 0) {
            QFilter quotebillDateStartFilter = new QFilter(dateField, ">=", (Object)quoteBillDates.get(0));
            QFilter quotebillDateEndFilter = new QFilter(dateField, "<=", (Object)quoteBillDates.get(1));
            quoteBillfilters.add(quotebillDateStartFilter);
            quoteBillfilters.add(quotebillDateEndFilter);
        }
        HashSet<Long> orgIds = new HashSet<Long>();
        Long quoteOrgID = quoteOrg.getLong("id");
        orgIds.add(quoteOrgID);
        boolean isDefault = true;
        this.getQueryParam().getCustomParam().put(DEFAULT_ENTRYNAME, DEFAULT_ENTRYNAME);
        this.getQueryParam().getCustomParam().put(DEFAULT_MATERIALFIELD, DEFAULT_MATERIALFIELD);
        if (!SCMBILLS.contains(quoteBillType)) {
            Map priceKey = FetchPriceHelper.fetchPriceConditonKey(orgIds, (String)quoteBillType);
            if (priceKey.get(quoteOrgID) != null && Boolean.TRUE.equals(((Map)priceKey.get(quoteOrgID)).get("success"))) {
                log.info(((Map)priceKey.get(quoteOrgID)).toString());
                List entryFields = (List)((Map)priceKey.get(quoteOrgID)).get("entry");
                if (entryFields != null && entryFields.size() > 0) {
                    String entryName = ((String)entryFields.get(0)).split("\\.")[0];
                    this.getQueryParam().getCustomParam().put(DEFAULT_ENTRYNAME, entryName);
                }
                if (isDefault = this.setMaterialFilter(entryFields, allfields, quoteBillfilters, 1, materialList)) {
                    log.info("\u53d6\u4ef7\u65e5\u5fd7\u5355\u5934\u53d6\u4ef7");
                    List headerFields = (List)((Map)priceKey.get(quoteOrgID)).get("header");
                    isDefault = this.setMaterialFilter(headerFields, allfields, quoteBillfilters, 0, materialList);
                }
            } else if (priceKey.get(quoteOrgID) != null && Boolean.FALSE.equals(((Map)priceKey.get(quoteOrgID)).get("success"))) {
                log.info(((Map)priceKey.get(quoteOrgID)).toString());
                isDefault = false;
                if (((Map)priceKey.get(quoteOrgID)).get("msg") != null) {
                    String msg = (String)((Map)priceKey.get(quoteOrgID)).get("msg");
                    throw new KDBizException(msg);
                }
            }
        }
        if (materialList.size() > 0 && isDefault && allfields.containsKey("material")) {
            QFilter materialFilter = new QFilter(DEFAULT_MATERIALFIELD, "in", materialList);
            quoteBillfilters.add(materialFilter);
        }
        String selectBillFields = this.getQuoteBillSelector(billNoField, dateField, allfields);
        log.info("\u53d6\u4ef7\u65e5\u5fd7\u67e5\u8be2\u53d6\u4ef7\u5355\u636e\u4fe1\u606f");
        log.info("\u53d6\u4ef7\u65e5\u5fd7\u67e5\u8be2\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u4fe1\u606f" + selectBillFields);
        DataSet quoteBillDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)quoteBillType, (String)selectBillFields, (QFilter[])quoteBillfilters.toArray(new QFilter[quoteBillfilters.size()]), null);
        return quoteBillDataSet;
    }

    private String getQuoteBillSelector(String billNoField, String dateField, Map<String, IDataEntityProperty> allfields) {
        ArrayList<String> selectorSet = new ArrayList<String>(32);
        selectorSet.add("id");
        if (StringUtils.isNotEmpty((CharSequence)billNoField)) {
            selectorSet.add(billNoField + " as " + "quotebillno");
        }
        if (StringUtils.isNotEmpty((CharSequence)dateField)) {
            selectorSet.add(dateField + " as " + "quotebillbizdate");
        } else {
            selectorSet.add("null as " + "quotebillbizdate");
        }
        if (this.getQueryParam().getCustomParam().get(DEFAULT_ENTRYNAME) != null) {
            String entryName = (String)this.getQueryParam().getCustomParam().get(DEFAULT_ENTRYNAME);
            selectorSet.add(entryName + '.' + "id as entryid");
            selectorSet.add(entryName + '.' + "seq as " + "quotebillseq");
        }
        if (this.getQueryParam().getCustomParam().get(DEFAULT_MATERIALFIELD) != null) {
            String materialField = (String)this.getQueryParam().getCustomParam().get(DEFAULT_MATERIALFIELD);
            selectorSet.add(materialField + " as " + "materialnum");
            selectorSet.add(materialField + " as " + "materialname");
        }
        String unitField = this.getUnit(allfields);
        IMatchTypePlugin<IDataEntityProperty> unitFilter = new IMatchTypePlugin<IDataEntityProperty>(){

            @Override
            public boolean isMatch(IDataEntityProperty v) {
                return v instanceof UnitProp;
            }
        };
        this.addExtraFieldSelector(allfields, selectorSet, unitField, "unit", unitFilter);
        IMatchTypePlugin<IDataEntityProperty> auxptyFilter = new IMatchTypePlugin<IDataEntityProperty>(){

            @Override
            public boolean isMatch(IDataEntityProperty v) {
                return v instanceof FlexProp;
            }
        };
        String auxtyField = this.getAuxpty(allfields);
        this.addExtraFieldSelector(allfields, selectorSet, auxtyField, "auxpty", auxptyFilter);
        return String.join((CharSequence)",", selectorSet);
    }

    private DataSet queryQuoteLog4SingleQuoteType(FilterInfo filterInfo, List<Date> quoteStartTimes, String quoteBillType) {
        ArrayList<QFilter> logQFilters = new ArrayList<QFilter>();
        QFilter quoteOrgFitler = new QFilter("quoteorg", "=", filterInfo.getDynamicObject("quoteorgfield").getPkValue());
        logQFilters.add(quoteOrgFitler);
        QFilter quoteBillFitler = new QFilter("quotebill", "=", (Object)quoteBillType);
        logQFilters.add(quoteBillFitler);
        QFilter logTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.NORMAL.getValue());
        Long billID = filterInfo.getLong("quotebillidfield");
        Long billEntryID = filterInfo.getLong("quotebillentryidfield");
        if (billID != null && !Long.valueOf("0").equals(billID) && billEntryID != null && !Long.valueOf("0").equals(billEntryID)) {
            String logKey = QuoteLogHelper.generateUniqueKey(billID, billEntryID);
            QFilter uniqueKeyFilter = new QFilter("logkey", "=", (Object)logKey);
            logQFilters.add(uniqueKeyFilter);
        }
        if (filterInfo.getDynamicObject("calstrategyfield") != null) {
            Long calStrategyID = filterInfo.getDynamicObject("calstrategyfield").getLong("id");
            QFilter calcStrategyFilter = new QFilter("calstrategy", "=", (Object)calStrategyID);
            logQFilters.add(calcStrategyFilter);
            if (filterInfo.getDynamicObject("calfactorfield") != null) {
                Long calFactorID = filterInfo.getDynamicObject("calfactorfield").getLong("id");
                QFilter calcFactorFilter = new QFilter("quoteschemegroup", "=", (Object)calFactorID);
                logQFilters.add(calcFactorFilter);
            }
        } else {
            QFilter calcStrategy_IsNull_Filter = new QFilter("calstrategy", "=", (Object)0L);
            logQFilters.add(calcStrategy_IsNull_Filter);
        }
        logQFilters.add(logTypeFilter);
        if (quoteStartTimes.size() > 0) {
            QFilter quoteStartTimeFilter_start = new QFilter("quotestarttime", ">=", (Object)quoteStartTimes.get(0));
            QFilter quoteStartTimeFilter_end = new QFilter("quotestarttime", "<=", (Object)quoteStartTimes.get(1));
            logQFilters.add(quoteStartTimeFilter_start);
            logQFilters.add(quoteStartTimeFilter_end);
        }
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"plat_quotelog", (String)this.getQuoteLogSelector(), (QFilter[])logQFilters.toArray(new QFilter[logQFilters.size()]), null);
    }

    private DataSet queryQuoteExpLog4SingleQuoteType(FilterInfo filterInfo, List<Date> quoteStartTimes, String quoteBillType) {
        ArrayList<QFilter> logQFilters = new ArrayList<QFilter>();
        QFilter quoteOrgFitler = new QFilter("quoteorg", "=", filterInfo.getDynamicObject("quoteorgfield").getPkValue());
        logQFilters.add(quoteOrgFitler);
        QFilter quoteBillFitler = new QFilter("quotebill", "=", (Object)quoteBillType);
        logQFilters.add(quoteBillFitler);
        QFilter logTypeFilter = new QFilter("logtype", "=", (Object)LogTypeEnum.EXCEPTION.getValue());
        logQFilters.add(logTypeFilter);
        if (quoteStartTimes.size() > 0) {
            QFilter quoteStartTimeFilter_start = new QFilter("quotestarttime", ">=", (Object)quoteStartTimes.get(0));
            QFilter quoteStartTimeFilter_end = new QFilter("quotestarttime", "<=", (Object)quoteStartTimes.get(1));
            logQFilters.add(quoteStartTimeFilter_start);
            logQFilters.add(quoteStartTimeFilter_end);
        }
        return QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"plat_quotelog", (String)this.getQuoteLogSelector(), (QFilter[])logQFilters.toArray(new QFilter[logQFilters.size()]), null);
    }

    private String getQuoteLogSelector() {
        return String.join((CharSequence)",", QuoteLogConst.getQUOTELOGFIELDS());
    }

    private boolean setMaterialFilter(List<String> fields, Map<String, IDataEntityProperty> allfields, List<QFilter> quoteBillfilters, int index, List<Long> materialList) {
        if (fields != null && !fields.isEmpty()) {
            for (String field : fields) {
                String[] headfieldArray = field.split("\\.");
                IDataEntityProperty property = allfields.get(headfieldArray[index]);
                if (!(property instanceof MaterielProp)) continue;
                StringBuilder materialProp = new StringBuilder(headfieldArray[0]);
                log.info("\u53d6\u4ef7\u65e5\u5fd7\u7269\u6599\u6807\u8bc60" + materialProp);
                for (int i = 1; i <= index; ++i) {
                    materialProp.append('.').append(headfieldArray[i]);
                }
                log.info("\u53d6\u4ef7\u65e5\u5fd7\u7269\u6599\u6807\u8bc61" + materialProp);
                String baseEntityId = ((MaterielProp)property).getBaseEntityId();
                if ("bd_material".equals(baseEntityId)) {
                    log.info("\u53d6\u4ef7\u65e5\u5fd7\u7269\u6599\u6807\u8bc6X" + materialProp);
                    this.getQueryParam().getCustomParam().put(DEFAULT_MATERIALFIELD, materialProp.toString());
                    if (materialList.size() <= 0) continue;
                    QFilter materialFilter = new QFilter(materialProp.toString(), "in", materialList);
                    quoteBillfilters.add(materialFilter);
                    return false;
                }
                materialProp.append('.').append("masterid");
                log.info("\u53d6\u4ef7\u65e5\u5fd7\u7269\u6599\u6807\u8bc6Y" + materialProp);
                this.getQueryParam().getCustomParam().put(DEFAULT_MATERIALFIELD, materialProp.toString());
                if (materialList.size() > 0) {
                    QFilter materialFilter = new QFilter(materialProp.toString(), "in", materialList);
                    quoteBillfilters.add(materialFilter);
                }
                return false;
            }
        }
        return true;
    }

    protected String getUnit(Map<String, IDataEntityProperty> allFields) {
        if (allFields.containsKey("unit")) {
            return "unit";
        }
        if (allFields.containsKey("e_measureunit")) {
            return "e_measureunit";
        }
        if (allFields.containsKey("measureunit")) {
            return "measureunit";
        }
        return "unit";
    }

    protected String getAuxpty(Map<String, IDataEntityProperty> allFields) {
        if (allFields.containsKey("auxpty")) {
            return "auxpty";
        }
        if (allFields.containsKey("e_assistantattr")) {
            return "e_assistantattr";
        }
        if (allFields.containsKey("auxptyid")) {
            return "auxptyid";
        }
        return "auxpty";
    }

    private void addExtraFieldSelector(Map<String, IDataEntityProperty> allfields, List<String> selectorSet, String field, String alias, IMatchTypePlugin<IDataEntityProperty> matchCase) {
        IDataEntityProperty prop = allfields.get(field);
        if (prop != null) {
            IDataEntityType unitParent = prop.getParent();
            if (unitParent instanceof EntryType) {
                field = unitParent.getName() + '.' + field;
            }
            selectorSet.add(field + " as " + alias);
        } else {
            for (Map.Entry<String, IDataEntityProperty> entry : allfields.entrySet()) {
                IDataEntityProperty v = entry.getValue();
                if (!matchCase.isMatch(v)) continue;
                IDataEntityType unitParent = v.getParent();
                if (this.getQueryParam().getCustomParam().get(DEFAULT_ENTRYNAME) != null) {
                    String entryName = (String)this.getQueryParam().getCustomParam().get(DEFAULT_ENTRYNAME);
                    if (!entryName.equals(unitParent.getName())) continue;
                    field = unitParent.getName() + '.' + v.getName();
                    selectorSet.add(field + " as " + alias);
                    break;
                }
                if (unitParent instanceof EntryType) continue;
                field = v.getName();
                selectorSet.add(field + " as " + alias);
                break;
            }
        }
    }

    public static interface IMatchTypePlugin<T> {
        default public boolean isMatch(T v) {
            return true;
        }
    }
}

