/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.quote;

import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.PropertyChangeHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteLogHelper;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.LogTypeEnum;

public class QuoteLogViewPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener {
    private static String[] PRICEPROCESSFIELDS = new String[]{"quotebillfield", "quoteorgfield", "materialfield", "calfactorfield", "calstrategyfield", "quotebillidfield", "quotebillentryidfield", "quotebillnofield", "quotedatefield_startdate", "quotedatefield_enddate", "quotestarttimefield_start", "quotestarttimefield_end"};
    private static String EXTRA = "x";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgField = (BasedataEdit)this.getView().getControl("quoteorgfield");
        orgField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit quoteBillField = (BasedataEdit)this.getView().getControl("quotebillfield");
        quoteBillField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialField = (BasedataEdit)this.getView().getControl("materialfield");
        materialField.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addRowClickListener((RowClickEventListener)this);
    }

    public void beforeBindData(EventObject e) {
        FilterInfo filterInfo;
        Long billID;
        IDataModel model = this.getModel();
        boolean isFromPriceProcess = false;
        ReportQueryParam reportQueryParam = ((ReportShowParameter)this.getView().getFormShowParameter()).getReportQueryParam();
        if (reportQueryParam != null && reportQueryParam.getFilter() != null && (billID = Long.valueOf((filterInfo = reportQueryParam.getFilter()).getLong("quotebillidfield"))) != null && !Long.valueOf("0").equals(billID)) {
            String quoteBillType = filterInfo.getDynamicObject("quotebillfield").getString("id");
            MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBillType);
            String billNoField = "billno";
            if (headType instanceof BasedataEntityType) {
                billNoField = "number";
            }
            String bizDateField = QuoteLogHelper.getBizDateField(headType);
            String selecties = billNoField + "," + bizDateField;
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billID, (String)quoteBillType, (String)selecties);
            if (bill != null) {
                model.setValue("quotebillnofield", (Object)bill.getString(billNoField));
                model.setValue("quotedatefield_startdate", (Object)bill.getDate(bizDateField));
                model.setValue("quotedatefield_enddate", (Object)bill.getDate(bizDateField));
                this.getView().setVisible(Boolean.FALSE, new String[]{"reportfilterap"});
                this.getView().setEnable(Boolean.FALSE, new String[]{"displayfield"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"displayfield"});
                isFromPriceProcess = true;
                for (String field : PRICEPROCESSFIELDS) {
                    this.getModel().setValue(field + EXTRA, this.getModel().getValue(field));
                }
            }
        }
        if (!isFromPriceProcess) {
            String formId = this.getView().getFormShowParameter().getFormId();
            if (model.getValue("quoteorgfield") == null) {
                HasPermOrgResult hasPermOrgResult = this.getHasPermissionOrg(formId, this.getView().getFormShowParameter().getAppId());
                if (!hasPermOrgResult.hasAllOrgPerm()) {
                    List orgList = hasPermOrgResult.getHasPermOrgs();
                    if (orgList != null && orgList.size() > 0) {
                        Long orgId = RequestContext.get().getOrgId();
                        if (orgList.contains(orgId)) {
                            model.setValue("quoteorgfield", (Object)orgId);
                        } else {
                            model.setValue("quoteorgfield", orgList.get(0));
                        }
                    }
                } else {
                    Long orgId = RequestContext.get().getOrgId();
                    model.setValue("quoteorgfield", (Object)orgId);
                }
            }
            java.util.Date today = TimeServiceHelper.today();
            if (model.getValue("quotedatefield_startdate") == null) {
                Instant instant = today.toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime localDateTime = LocalDateTime.ofInstant(instant, zone);
                LocalDate date = localDateTime.toLocalDate().minusDays(7L);
                model.setValue("quotedatefield_startdate", (Object)Date.valueOf(date));
            }
            if (model.getValue("quotedatefield_enddate") == null) {
                model.setValue("quotedatefield_enddate", (Object)today);
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"displayfield"});
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{"logdetails_flex"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formID = this.getView().getFormShowParameter().getFormId();
        switch (fieldKey) {
            case "quoteorgfield": {
                HasPermOrgResult hasPermOrgResult = this.getHasPermissionOrg(formID, this.getView().getFormShowParameter().getAppId());
                if (hasPermOrgResult.hasAllOrgPerm()) break;
                List orgList = hasPermOrgResult.getHasPermOrgs();
                if (orgList != null && orgList.size() > 0) {
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                break;
            }
            case "quotebillfield": {
                DynamicObject quoteOrgField = (DynamicObject)this.getModel().getValue("quoteorgfield");
                if (quoteOrgField == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u7ec4\u7ec7\u3002", (String)"QuoteLogViewPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QuoteHelper.registerQuoteBill(e, null, true);
                break;
            }
            case "materialfield": {
                DynamicObject quoteOrg = (DynamicObject)this.getModel().getValue("quoteorgfield");
                if (quoteOrg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u7ec4\u7ec7\u3002", (String)"QuoteLogViewPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_material", (Long)Long.valueOf(quoteOrg.getPkValue().toString()));
                showParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
                showParameter.setCustomParam("useOrg", (Object)quoteOrg.getPkValue().toString());
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        ListSelectedRowCollection returnData = (ListSelectedRowCollection)e.getReturnData();
        if ("quotebillfield".equalsIgnoreCase(actionId) && returnData != null) {
            if (returnData.size() == 0) {
                this.getModel().setValue("quotebillfield", null);
            } else {
                Object[] objects = new Object[returnData.size()];
                for (int i = 0; i < returnData.size(); ++i) {
                    objects[i] = returnData.get(i).getNumber();
                }
                this.getModel().setValue("quotebillfield", (Object)objects);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObject org = filter.getDynamicObject("quoteorgfield");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u7ec4\u7ec7\u3002", (String)"QuoteLogViewPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return false;
        }
        DynamicObjectCollection quoteBills = filter.getDynamicObjectCollection("quotebillfield");
        if (quoteBills == null || quoteBills.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u3002", (String)"QuoteLogViewPlugin_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return false;
        }
        for (DynamicObject quoteBill : quoteBills) {
            String quoteBillType = (String)quoteBill.getPkValue();
            MainEntityType headType = EntityMetadataCache.getDataEntityType((String)quoteBillType);
            if (!StringUtils.isEmpty((CharSequence)headType.getAlias()) || quoteBills.size() <= 1) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u5b9e\u4f53\u8868\u6216\u5176\u662f\u52a8\u6001\u8868\u5355\uff0c\u8bf7\u5355\u72ec\u8fdb\u884c\u67e5\u8be2\u3002", (String)"QuoteLogViewPlugin_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), headType.getDisplayName().getLocaleValue()));
            return false;
        }
        java.util.Date quoteBillDateStart = filter.getDate("quotedatefield_startdate");
        java.util.Date quoteBillDateEnd = filter.getDate("quotedatefield_enddate");
        java.util.Date quoteStartTimeStart = filter.getDate("quotestarttimefield_start");
        java.util.Date quoteStartTimeEnd = filter.getDate("quotestarttimefield_end");
        if (quoteBillDateStart == null || quoteBillDateEnd == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u53d6\u4ef7\u5355\u636e\u65e5\u671f\u8303\u56f4\u3002", (String)"QuoteLogViewPlugin_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return false;
        }
        if (quoteStartTimeStart != null && quoteStartTimeEnd != null && quoteStartTimeStart.after(quoteStartTimeEnd)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u53d6\u4ef7\u5f00\u59cb\u65f6\u95f4\u4ece\u201d\u4e0d\u80fd\u665a\u4e8e\u201c\u53d6\u4ef7\u5f00\u59cb\u65f6\u95f4\u81f3\u201d\u3002", (String)"QuoteLogViewPlugin_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            return false;
        }
        this.getQueryParam().getCustomParam().remove("alert");
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        if (PropertyChangeHelper.isStopChange(this.getPageCache())) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "quoteorgfield": {
                Object newValue = e.getChangeSet()[0].getNewValue();
                Object oldValue = e.getChangeSet()[0].getOldValue();
                if ((newValue != null || oldValue == null) && (newValue == null || oldValue == null || ((DynamicObject)newValue).getPkValue().equals(((DynamicObject)oldValue).getPkValue()))) break;
                this.getModel().setValue("quotebillfield", null);
                this.getModel().setValue("materialfield", null);
                this.getModel().setValue("quotebillnofield", null);
                break;
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row > 0) {
            ReportList reportList = (ReportList)evt.getSource();
            this.showLogDetails(reportList.getReportModel(), row);
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.getView().setVisible(Boolean.FALSE, new String[]{"logdetails_flex"});
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        if (queryParam.getFilter() != null && queryParam.getFilter().getDynamicObject("calstrategyfield") != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"calstrategy", "quoteschemegroup"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"calstrategy", "quoteschemegroup"});
        }
        String msg = (String)AppCache.get((String)"alert").get("alert", String.class);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            this.getView().showTipNotification(msg);
            AppCache.get((String)"alert").clear();
        }
        if (reportModel.getRowCount() > 0) {
            this.showLogDetails(reportModel, 1);
        }
    }

    private void showLogDetails(IReportListModel reportModel, int row) {
        Long quoteLogID = (Long)reportModel.getValue(row, "id");
        QFilter idFilter = new QFilter("id", "=", (Object)quoteLogID);
        String selecors = String.join((CharSequence)",", Arrays.asList("logjson_tag", "logtype", "logresult"));
        DynamicObject quoteLog = BusinessDataServiceHelper.loadSingle((String)"plat_quotelog", (String)selecors, (QFilter[])new QFilter[]{idFilter});
        if (quoteLog != null) {
            if (LogTypeEnum.EXCEPTION.getValue().equals(quoteLog.getString("logtype"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"logdetails_flex"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"logdetails_flex"});
                String xMDJson = quoteLog.getString("logjson_tag");
                Markdown md = (Markdown)this.getView().getControl("logdetails");
                if (StringUtils.isNotEmpty((CharSequence)xMDJson)) {
                    md.setText(xMDJson);
                } else {
                    md.setText("");
                }
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u53d6\u4ef7\u65e5\u5fd7\u8bb0\u5f55\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u3002", (String)"QuoteLogViewPlugin_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"logdetails_flex"});
        }
    }

    private HasPermOrgResult getHasPermissionOrg(String formID, String appID) {
        long userID = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult hermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userID, (String)"15", (String)appID, (String)formID, (String)"47150e89000000ac");
        return hermOrgResult;
    }
}

