/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.formplugin.quote;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.designer.botp.EntityParseHelper;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.common.utils.CommonUtils;
import kd.mpscmm.msbd.pricemodel.business.helper.PriceHelper;

public class QuoteStrategyCalEntryPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String NUMBER = "number";
    private static final String CALSTRATEGYCON = "_cal_strategy_con_";
    private static final String MULPRICETERM = "_mul_price_term_";

    public void registerListener(EventObject e) {
        BasedataEdit calStrategy;
        if (this.getView().getControl("calpreconditiondesc") != null) {
            this.addClickListeners(new String[]{"calpreconditiondesc"});
        }
        if (this.getView().getControl("quotetermsigndesc") != null) {
            this.addClickListeners(new String[]{"quotetermsigndesc"});
        }
        if ((calStrategy = (BasedataEdit)this.getView().getControl("calstrategy")) != null) {
            calStrategy.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        MainEntityType entityType = this.getModel().getDataEntityType();
        AtomicBoolean change = new AtomicBoolean(false);
        this.loadCalEntryCaption(change);
        if (change.get()) {
            this.getModel().setDataChanged(false);
        }
        super.afterBindData(e);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String clickKey = control.getKey();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("calentry");
        if (rowIndex < 0) {
            return;
        }
        DynamicObjectCollection calEntryList = this.getModel().getEntryEntity("calentry");
        DynamicObject calEntry = (DynamicObject)calEntryList.get(rowIndex);
        DynamicObject calStrategy = calEntry.getDynamicObject("calstrategy");
        if ("calpreconditiondesc".equals(clickKey) || "quotetermsigndesc".equals(clickKey)) {
            if (calStrategy == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u8ba1\u7b97\u7b56\u7565\u201d\u3002", (String)"QuoteStrategyCalEntryPlugin_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                return;
            }
            if ("calpreconditiondesc".equals(clickKey)) {
                DynamicObject quoteEntity = calStrategy.getDynamicObject("quoteentity");
                String entityNumber = quoteEntity.getString(NUMBER);
                String calPreCondition = calEntry.getString("calprecondition_tag");
                BillTreeBuildParameter parameter = new BillTreeBuildParameter(MetadataServiceHelper.getDataEntityType((String)entityNumber));
                TreeNode treeNode = EntityParseHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter);
                String treeNodeStr = SerializationUtils.toJsonString((Object)treeNode);
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId("msbd_pricecondition");
                showParameter.getCustomParams().put("formula", calPreCondition);
                showParameter.getCustomParams().put("entitynumber", entityNumber);
                showParameter.getCustomParams().put("treenodes", treeNodeStr);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALSTRATEGYCON));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(showParameter);
            }
            if ("quotetermsigndesc".equals(clickKey)) {
                String quoteTermSign = calEntry.getString("quotetermsign");
                Long calStrategyId = (Long)calStrategy.getPkValue();
                List<String[]> parameterList = this.queryPriceTermField(calStrategyId);
                this.selectQuoteTermSign(parameterList, quoteTermSign);
            }
        }
    }

    private List<String[]> queryPriceTermField(Long calStrategyId) {
        DynamicObject calStrategy = BusinessDataServiceHelper.loadSingle((Object)calStrategyId, (String)"msbd_calculationstrategy");
        ArrayList<String[]> parameterList = new ArrayList<String[]>(16);
        DynamicObjectCollection calFormulaList = calStrategy.getDynamicObjectCollection("calformula");
        for (DynamicObject calFormula : calFormulaList) {
            String quoteSignName = calFormula.getString("quotesignname");
            String quoteSign = calFormula.getString("quotesign");
            String[] parameter = new String[]{quoteSignName, quoteSign};
            parameterList.add(parameter);
        }
        return parameterList;
    }

    private void selectQuoteTermSign(List<String[]> list, String sign) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("plat_quotesignsetting");
        parameter.setCustomParam("priceresultfieldlist", (Object)SerializationUtils.toJsonString(list));
        if (StringUtils.isNotEmpty((CharSequence)sign)) {
            parameter.setCustomParam("sign", (Object)sign);
        }
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MULPRICETERM));
        this.getView().showForm(parameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        IDataModel model = this.getModel();
        if (StringUtils.equals((CharSequence)MULPRICETERM, (CharSequence)actionId)) {
            if (returnData == null) {
                return;
            }
            Map map = (Map)returnData;
            model.setValue("quotetermsigndesc", map.get("terminationsigndesc"));
            model.setValue("quotetermsign", map.get("terminationsign"));
        }
        if (StringUtils.equals((CharSequence)CALSTRATEGYCON, (CharSequence)actionId)) {
            if (returnData == null) {
                return;
            }
            String conditionJson = (String)returnData;
            if (StringUtils.isNotBlank((Object)returnData)) {
                DynamicObject qutebill;
                int row = this.getModel().getEntryCurrentRowIndex("calentry");
                CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
                String exprTran = condition.getExprDesc();
                model.setValue("calpreconditiondesc", (Object)exprTran, row);
                model.setValue("calprecondition_tag", (Object)conditionJson, row);
                DynamicObject calcStrategy = (DynamicObject)this.getModel().getValue("calstrategy", row);
                if (calcStrategy != null && (qutebill = calcStrategy.getDynamicObject("quoteentity")) != null) {
                    FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)((String)qutebill.getPkValue())), condition.getFilterCondition());
                    fb.buildFilter();
                    this.getModel().setValue("calpreconditiondesc", (Object)fb.getFilterStringDesc(), row);
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate source = (FormOperate)args.getSource();
        String itemKey = source.getOperateKey();
        if ("save".equals(itemKey) || "submit".equals(itemKey)) {
            DynamicObject bill = this.getModel().getDataEntity(true);
            DynamicObjectCollection calStrategyList = bill.getDynamicObjectCollection("calentry");
            int entrySize = calStrategyList.size();
            for (int i = entrySize - 1; i >= 0; --i) {
                DynamicObject row = (DynamicObject)calStrategyList.get(i);
                DynamicObject calStrategy = row.getDynamicObject("calstrategy");
                if (calStrategy != null) continue;
                calStrategyList.remove(i);
            }
            this.getView().updateView("calentry");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        if (CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            Object oldValue = e.getChangeSet()[0].getOldValue();
            Object newValue = e.getChangeSet()[0].getNewValue();
            switch (fieldName) {
                case "calstrategy": {
                    IDataModel model = this.getModel();
                    ChangeData[] changeSet = e.getChangeSet();
                    for (int i = 0; i < changeSet.length; ++i) {
                        Object newCalStrategy = changeSet[i].getNewValue();
                        int rowIndex = changeSet[i].getRowIndex();
                        model.setValue("calpreconditiondesc", null, rowIndex);
                        model.setValue("calprecondition", null, rowIndex);
                        model.setValue("calprecondition_tag", null, rowIndex);
                        model.setValue("quotetermsigndesc", null, rowIndex);
                        model.setValue("quotetermsign", null, rowIndex);
                        DynamicObject calStrategy = (DynamicObject)newCalStrategy;
                        if (calStrategy == null) continue;
                        DynamicObjectCollection calFormulaList = calStrategy.getDynamicObjectCollection("calformula");
                        int m = calFormulaList.size() - 1;
                        DynamicObject calFormula = (DynamicObject)calFormulaList.get(m);
                        String quoteSignName = calFormula.getString("quotesignname");
                        String quoteSign = calFormula.getString("quotesign");
                        model.setValue("quotetermsign", (Object)quoteSign, rowIndex);
                        model.setValue("quotetermsigndesc", (Object)quoteSignName, rowIndex);
                    }
                    break;
                }
                case "calpreconditiondesc": {
                    if (newValue != null && !"".equals(newValue)) break;
                    int rowIndex = this.getModel().getEntryCurrentRowIndex("calentry");
                    this.getModel().setValue("calprecondition", null, rowIndex);
                    this.getModel().setValue("calprecondition_tag", null, rowIndex);
                    break;
                }
            }
        }
    }

    private void loadCalEntryCaption(AtomicBoolean change) {
        for (int row = 0; row < this.getModel().getEntryRowCount("calentry"); ++row) {
            String conditonJson;
            DynamicObject quotebill;
            DynamicObject calStrategy = (DynamicObject)this.getModel().getValue("calstrategy", row);
            if (calStrategy == null || (quotebill = calStrategy.getDynamicObject("quoteentity")) == null) continue;
            String terminateSign = (String)this.getModel().getValue("quotetermsign", row);
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)((String)quotebill.getPkValue()));
            if (StringUtils.isNotEmpty((CharSequence)terminateSign)) {
                String quoteSignName = this.getCaption(terminateSign, mainType);
                this.getModel().setValue("quotetermsigndesc", (Object)quoteSignName, row);
                change.set(true);
            }
            if (!StringUtils.isNotEmpty((CharSequence)(conditonJson = (String)this.getModel().getValue("calprecondition_tag", row)))) continue;
            FilterBuilder filterBuilder = PriceHelper.convertFullStringToQFilter(conditonJson, (String)quotebill.getPkValue());
            filterBuilder.buildFilter();
            this.getModel().setValue("calpreconditiondesc", (Object)filterBuilder.getFilterStringDesc(), row);
            change.set(true);
        }
    }

    private String getCaption(String terminateSign, MainEntityType entityType) {
        String tempFieldId;
        IDataEntityProperty findProperty;
        String[] terminateSign_sub = terminateSign.split("\\.");
        if (terminateSign_sub.length > 1 && (findProperty = entityType.findProperty(tempFieldId = terminateSign_sub[0])) instanceof EntryProp) {
            int index = terminateSign.indexOf(46, 0);
            terminateSign = terminateSign.substring(index + 1);
        }
        String quoteSignName = EntityParseHelper.buildPropFullCaption((EntityType)entityType, (String)terminateSign);
        return quoteSignName;
    }
}

