/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin;

import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;

public class PriceControlSchemeUnAuditValidator
extends AbstractValidator {
    public void validate() {
        if (this.getValidateContext() == null || this.getValidateContext().getValidateResults() == null || this.getValidateContext().getValidateResults().errorSize() <= 0) {
            for (ExtendedDataEntity data : this.dataEntities) {
                this.check(data, true);
            }
        } else {
            for (ExtendedDataEntity data : this.dataEntities) {
                this.check(data, false);
            }
        }
    }

    private void check(ExtendedDataEntity data, boolean isWarning) {
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        DynamicObject bill = data.getDataEntity();
        BaseDataCheckRefrenceResult refrenceResult = checker.checkRef((BasedataEntityType)bill.getDataEntityType(), bill.getPkValue());
        if (refrenceResult.isRefence()) {
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().getLocaleValue();
            if (isWarning) {
                this.addWarningMessage(data, String.format(ResManager.loadKDString((String)"\u8be5\u9650\u4ef7\u65b9\u6848\u5df2\u88ab\u201c%s\u201d\u5f15\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"PriceControlSchemeUnAuditValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), billName));
            } else {
                this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8be5\u9650\u4ef7\u65b9\u6848\u5df2\u88ab\u201c%s\u201d\u5f15\u7528\u3002", (String)"PriceControlSchemeUnAuditValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), billName));
            }
        }
    }
}

