/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.pricemodel.common.enums.PriceServiceEnum;
import kd.mpscmm.msbd.pricemodel.opplugin.PriceServiceRegisterStatusValidator;
import kd.mpscmm.msbd.pricemodel.opplugin.PriceServiceRegisterUniqueValidator;

public class PriceServiceRegisterActiveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("service");
        e.getFieldKeys().add("enable");
        e.getFieldKeys().add("controlpoint");
        e.getFieldKeys().add("bizentity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new PriceServiceRegisterStatusValidator());
        e.addValidator((AbstractValidator)new PriceServiceRegisterUniqueValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        if (datas != null) {
            for (DynamicObject data : datas) {
                String service = data.getString("service");
                DynamicObject bizEntityObj = data.getDynamicObject("bizentity");
                String controlPoint = data.getString("controlpoint");
                boolean enable = data.getBoolean("enable");
                if (!StringUtils.isNotEmpty((String)service) || bizEntityObj == null || !StringUtils.isNotEmpty((String)controlPoint) || !enable) continue;
                String serviceSign = PriceServiceEnum.getServiceSign(service);
                String entityNumber = bizEntityObj.getString("id");
                String[] ops = controlPoint.split(",");
                OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)entityNumber, (String)serviceSign, Arrays.asList(ops));
            }
        }
    }
}

