/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.advanceprice;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;

public class PriceCalStrategySubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity strategy : this.dataEntities) {
            DynamicObject bill = strategy.getDataEntity();
            this.validator("factor", "quoteschemegroup", strategy);
            this.validator("calformula", "quotesign", strategy);
            this.validator("calformula", "processfactor", strategy);
            DynamicObjectCollection calFormulaList = bill.getDynamicObjectCollection("calformula");
            for (int i = 0; i < calFormulaList.size(); ++i) {
                DynamicObject calFormula = (DynamicObject)calFormulaList.get(i);
                DynamicObject processFactor = calFormula.getDynamicObject("processfactor");
                String quoteSign = calFormula.getString("quotesign");
                if (processFactor == null && (quoteSign == null || "".equals(quoteSign))) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7b2c%s\u884c\uff0c\u8bf7\u81f3\u5c11\u5f55\u5165\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u6216\u201c\u8fc7\u7a0b\u56e0\u5b50\u201d\u3002", (String)"PriceCalStrategySubmitValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                    this.addMessage(strategy, tipMsg, ErrorLevel.Error);
                }
                if (!StringUtils.isNotBlank((CharSequence)quoteSign)) continue;
                String quoteSignEntity = bill.getDynamicObject("quoteentity").getString("number");
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)quoteSignEntity);
                if (StringUtils.isEmpty((CharSequence)(quoteSign = AdvancedPricingHelper.subEntryField(quoteSign, entityType)))) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7b2c%s\u884c\uff0c\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"PriceCalStrategySubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                    this.addMessage(strategy, tipMsg, ErrorLevel.Error);
                    continue;
                }
                Map allFields = entityType.getAllFields();
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(quoteSign);
                if (iDataEntityProperty == null) {
                    String tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7b2c%s\u884c\uff0c\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"PriceCalStrategySubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                    this.addMessage(strategy, tipMsg, ErrorLevel.Error);
                    continue;
                }
                Class type = iDataEntityProperty.getPropertyType();
                if (type != null && BigDecimal.class.isAssignableFrom(type)) continue;
                String tipMsg = String.format(ResManager.loadKDString((String)"\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7b2c%s\u884c\uff0c\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"PriceCalStrategySubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                this.addMessage(strategy, tipMsg, ErrorLevel.Error);
            }
            DynamicObjectCollection calFormulas = bill.getDynamicObjectCollection("calformula");
            boolean resultFieldExists = false;
            for (DynamicObject calFormula : calFormulas) {
                if (!StringUtils.isNotEmpty((CharSequence)calFormula.getString("quotesign"))) continue;
                resultFieldExists = true;
                break;
            }
            if (resultFieldExists) continue;
            String tipMsg = ResManager.loadKDString((String)"\u201d\u8ba1\u7b97\u516c\u5f0f\u201c\u5206\u5f55\uff0c\u8bf7\u7ef4\u62a4\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"PriceCalStrategySubmitValidator_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            this.addMessage(strategy, tipMsg, ErrorLevel.Error);
        }
    }

    private void validator(String entrySymbol, String fieldSymbol, ExtendedDataEntity strategy) {
        HashMap<String, Integer> quoteEntityFieldColl = new HashMap<String, Integer>(16);
        DynamicObject bill = strategy.getDataEntity();
        int rowFormulaIndex = 1;
        DynamicObjectCollection calFormulaList = bill.getDynamicObjectCollection(entrySymbol);
        for (DynamicObject row : calFormulaList) {
            String fieldSymbolKey = null;
            Object fieldSymbolObj = row.get(fieldSymbol);
            if (fieldSymbolObj == null || "".equals(fieldSymbolObj)) continue;
            if (fieldSymbolObj instanceof String) {
                fieldSymbolKey = (String)fieldSymbolObj;
            } else if (fieldSymbolObj instanceof DynamicObject) {
                Long pkValue = (Long)((DynamicObject)fieldSymbolObj).getPkValue();
                fieldSymbolKey = String.valueOf(pkValue);
            }
            Integer integer = (Integer)quoteEntityFieldColl.get(fieldSymbolKey);
            if (integer != null) {
                String tipMsg = null;
                if ("quotesign".equals(fieldSymbol)) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u5206\u5f55\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u7b2c%1$d\u884c\u4e0e%2$d\u884c\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u7684\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u3002", (String)"PriceCalStrategySubmitValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), rowFormulaIndex, integer);
                } else if ("quoteschemegroup".equals(fieldSymbol)) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u56e0\u5b50\u5206\u5f55\u53d6\u4ef7\u65b9\u6848\u7ec4\u7b2c%1$d\u884c\u4e0e%2$d\u884c\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u7684\u53d6\u4ef7\u65b9\u6848\u7ec4\u3002", (String)"PriceCalStrategySubmitValidator_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), rowFormulaIndex, integer);
                } else if ("processfactor".equals(fieldSymbol)) {
                    tipMsg = String.format(ResManager.loadKDString((String)"\u8ba1\u7b97\u516c\u5f0f\u5206\u5f55\u8fc7\u7a0b\u56e0\u5b50\u7b2c%1$d\u884c\u4e0e%2$d\u884c\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u76f8\u540c\u7684\u8fc7\u7a0b\u56e0\u5b50\u3002", (String)"PriceCalStrategySubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), rowFormulaIndex, integer);
                }
                this.addMessage(strategy, tipMsg, ErrorLevel.Error);
            } else {
                quoteEntityFieldColl.put(fieldSymbolKey, rowFormulaIndex);
            }
            ++rowFormulaIndex;
        }
    }
}

