/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.advanceprice;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.MulPriceEnum;
import kd.mpscmm.msbd.pricemodel.common.enums.quote.PriceSourceEnum;

public class PriceSchemeGroupSubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject quoteSchemeGroup = data.getDataEntity();
            String number = quoteSchemeGroup.getString("number");
            if (StringUtils.isNotBlank((CharSequence)number)) {
                boolean isNum;
                boolean containChinese = AdvancedPricingHelper.checkEngLetter(number);
                if (!containChinese) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u8bf7\u91c7\u7528\u82f1\u6587\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf\u8fdb\u884c\u547d\u540d\u3002", (String)"PriceSchemeGroupSubmitValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), number);
                    this.addErrorMessage(data, errorMsg);
                }
                if (isNum = Character.isDigit(number.charAt(0))) {
                    String errorMsg = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u7981\u6b62\u53d6\u4ef7\u65b9\u6848\u7ec4\u7f16\u7801\u4f7f\u7528\u6570\u5b57\u5f00\u5934\u3002", (String)"PriceSchemeGroupSubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), number);
                    this.addErrorMessage(data, errorMsg);
                }
            }
            if (MulPriceEnum.MANUAL.getValue().equals(quoteSchemeGroup.getString("mulprice"))) continue;
            String priceSource = quoteSchemeGroup.getString("pricesource");
            if (PriceSourceEnum.SCHEME.getValue().equals(priceSource)) {
                DynamicObjectCollection entry = quoteSchemeGroup.getDynamicObjectCollection("entry");
                if (entry.size() <= 0) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u65b9\u6848\u6392\u5e8f\u201d\u5206\u5f55\u6ca1\u6709\u5f55\u5165\u6570\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PriceSchemeGroupSubmitValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                } else {
                    for (int row = 0; row < entry.size(); ++row) {
                        DynamicObject scheme = ((DynamicObject)entry.get(row)).getDynamicObject("quotescheme");
                        if (scheme != null) continue;
                        String msg = String.format(ResManager.loadKDString((String)"\u201c\u65b9\u6848\u6392\u5e8f\u201d\u5206\u5f55\u4e2d\u7b2c%1$s\u884c\u7684\u53d6\u4ef7\u65b9\u6848\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PriceSchemeGroupSubmitValidator_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), row + 1);
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                }
            }
            if (!PriceSourceEnum.BILLFIELD.getValue().equals(priceSource)) continue;
            String quoteSign = quoteSchemeGroup.getString("quotesign");
            if (StringUtils.isBlank((CharSequence)quoteSign)) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002 ", (String)"PriceSchemeGroupSubmitValidator_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]));
                continue;
            }
            String quoteSignEntity = quoteSchemeGroup.getDynamicObject("quoteentity").getString("number");
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)quoteSignEntity);
            if (StringUtils.isEmpty((CharSequence)(quoteSign = AdvancedPricingHelper.subEntryField(quoteSign, entityType)))) {
                this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"PriceSchemeGroupSubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Map allFields = entityType.getAllFields();
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(quoteSign);
            if (iDataEntityProperty == null) {
                this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"PriceSchemeGroupSubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            Class type = iDataEntityProperty.getPropertyType();
            if (type != null && BigDecimal.class.isAssignableFrom(type)) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u503c\u7c7b\u578b\u7684\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"PriceSchemeGroupSubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }
}

