/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.quote;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.DataSetHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.advanceprice.AdvancedPricingHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.common.enums.OperatorEnum;

public class QuoteSchemeConfigureSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(QuoteSchemeConfigureSubmitValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            this.addMessage(data, bill);
        }
    }

    private void addMessage(ExtendedDataEntity data, DynamicObject bill) {
        if (bill.getDynamicObject("pricesourceentity") == null) {
            return;
        }
        if (bill.getDynamicObject("quoteentity") == null) {
            return;
        }
        this.conditionCheck(data, bill);
        this.fieldBigDecimalCheck(data, bill);
    }

    private void fieldBigDecimalCheck(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObjectCollection entries;
        if (this.isConfigure(bill) && (entries = bill.getDynamicObjectCollection("entryresult")) != null && entries.size() > 0) {
            String sourceEntity = QuoteOtherHelper.getPriceSourceEntity(bill);
            if (StringUtils.isEmpty((CharSequence)sourceEntity)) {
                return;
            }
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)sourceEntity);
            for (DynamicObject entry : entries) {
                String sourceSign = entry.getString("sourcesignr");
                if (!StringUtils.isNotEmpty((CharSequence)sourceSign)) continue;
                String msg = ResManager.loadKDString((String)"\u9009\u914d\u6620\u5c04\u7684\u53d6\u4ef7\u65b9\u6848\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b\u7684\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u3002", (String)"QuoteSchemeConfigureSubmitValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                if (QuoteOtherHelper.isDimensionMode(bill)) {
                    msg = ResManager.loadKDString((String)"\u9009\u914d\u6620\u5c04\u7684\u53d6\u4ef7\u65b9\u6848\u53ea\u652f\u6301\u6570\u503c\u7c7b\u578b\u7684\u201c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u4f5c\u4e3a\u53d6\u4ef7\u7ed3\u679c\u3002", (String)"QuoteSchemeConfigureSubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                }
                if (StringUtils.isEmpty((CharSequence)(sourceSign = AdvancedPricingHelper.subEntryField(sourceSign, dataEntityType)))) {
                    this.addMessage(data, msg, ErrorLevel.Error);
                    continue;
                }
                Map allFields = dataEntityType.getAllFields();
                IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(sourceSign);
                if (iDataEntityProperty == null) {
                    this.addMessage(data, msg, ErrorLevel.Error);
                    continue;
                }
                Class type = iDataEntityProperty.getPropertyType();
                if (type != null && BigDecimal.class.isAssignableFrom(type)) continue;
                this.addMessage(data, msg, ErrorLevel.Error);
            }
        }
    }

    private void conditionCheck(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObjectCollection collection = bill.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < collection.size(); ++i) {
            String sourceEntity;
            IDataEntityProperty currentProp;
            DynamicObject row = (DynamicObject)collection.get(i);
            String sourceSign = row.getString("sourcesign");
            String matchFlag = row.getString("matchflag");
            String quoteSign = row.getString("quotesign");
            if (!OperatorEnum.CONFIGURED.getValue().equals(matchFlag)) continue;
            boolean isCheck = false;
            boolean isCheckSource = false;
            if (bill.getDynamicObject("quoteentity") != null && StringUtils.isNotEmpty((CharSequence)quoteSign)) {
                String number = bill.getDynamicObject("quoteentity").getString("number");
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)number);
                currentProp = DataSetHelper.findPropertys((EntityType)dataEntityType, quoteSign);
                if (currentProp instanceof BasedataProp) {
                    if (!"bd_configuredcode".equals(((BasedataProp)currentProp).getBaseEntityId())) {
                        isCheck = true;
                    }
                } else {
                    isCheck = true;
                }
                if (isCheck) {
                    this.addMessage(data, ResManager.loadKDString((String)"\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u7684\u6bd4\u8f83\u7b26\u4e3a\u201c\u9009\u914d\u6620\u5c04\u201d\u65f6\uff0c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u8bf7\u9009\u62e9\u201c\u914d\u7f6e\u53f7\u201d\u5b57\u6bb5\u3002", (String)"QuoteSchemeConfigureSubmitValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(sourceEntity = QuoteOtherHelper.getPriceSourceEntity(bill))) && StringUtils.isNotEmpty((CharSequence)sourceSign)) {
                if (QuoteOtherHelper.isDimensionMode(bill)) {
                    if (!"kitnumber".equals(sourceSign) && !"featurevalue".equals(sourceSign)) {
                        String msg = ResManager.loadKDString((String)"\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u7684\u6bd4\u8f83\u7b26\u5305\u542b\u201c\u9009\u914d\u6620\u5c04\u201d\u65f6\uff0c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u8bf7\u9009\u62e9\u201c\u7279\u5f81\u503c\u201d\u5b57\u6bb5\u6216\u201d\u7ec4\u4ef6\u7f16\u7801\u201d\u5b57\u6bb5\u3002", (String)"QuoteSchemeConfigureSubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                } else {
                    MainEntityType sourceEntityType = MetadataServiceHelper.getDataEntityType((String)sourceEntity);
                    currentProp = DataSetHelper.findPropertys((EntityType)sourceEntityType, sourceSign);
                    if (currentProp instanceof BasedataProp) {
                        if (!"pdm_featuredefinition".equals(((BasedataProp)currentProp).getBaseEntityId())) {
                            isCheckSource = true;
                        }
                    } else if (!(currentProp instanceof TextProp) || "pdm_featuredefinition".equals(currentProp.getParent().getName())) {
                        isCheckSource = true;
                    }
                    if (isCheckSource) {
                        String msg = ResManager.loadKDString((String)"\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u7684\u6bd4\u8f83\u7b26\u5305\u542b\u201c\u9009\u914d\u6620\u5c04\u201d\u65f6\uff0c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u8bf7\u9009\u62e9\u201c\u7279\u5f81\u5b9a\u4e49\u201d\u5b57\u6bb5\u6216\u5b57\u7b26\u578b\u5b57\u6bb5\u3002", (String)"QuoteSchemeConfigureSubmitValidator_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                }
            }
            if (isCheck || isCheckSource) break;
        }
    }

    private boolean isConfigure(DynamicObject bill) {
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        if (entries != null && entries.size() > 0) {
            for (DynamicObject entry : entries) {
                String matchFlag = entry.getString("matchflag");
                if (!OperatorEnum.CONFIGURED.getValue().equals(matchFlag)) continue;
                return true;
            }
        }
        return false;
    }
}

