/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.quote;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteExtHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.quote.QuoteOtherHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.quote.QuoteSchemeInfo;

public class QuoteSchemeExtSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(QuoteSchemeExtSubmitValidator.class);

    public void validate() {
        for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            this.addMessage(data, bill);
        }
    }

    private void addMessage(ExtendedDataEntity data, DynamicObject bill) {
        if (bill.getDynamicObject("pricesourceentity") == null) {
            return;
        }
        if (bill.getDynamicObject("quoteentity") == null) {
            return;
        }
        QuoteSchemeInfo quoteSchemeInfo = new QuoteSchemeInfo();
        quoteSchemeInfo.setQuoteScheme(bill);
        boolean isReplace = QuoteExtHelper.isReplaceQuote(quoteSchemeInfo);
        if (!isReplace) {
            this.entryMustInputCheck(data, bill);
            this.resultEntryMustInputCheck(data, bill);
        } else {
            DynamicObjectCollection collection = bill.getDynamicObjectCollection("entryentity");
            int countEmpty = 0;
            for (int i = 0; collection != null && i < collection.size(); ++i) {
                if (!kd.bos.util.StringUtils.isEmpty((String)((DynamicObject)collection.get(i)).getString("sourcesign"))) continue;
                ++countEmpty;
            }
            if (collection != null && countEmpty == collection.size()) {
                this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u5728\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u4e2d\u81f3\u5c11\u5b8c\u6574\u7ef4\u62a4\u7269\u6599\u5b57\u6bb5\u6761\u4ef6\u3002", (String)"QuoteSchemeExtSubmitValidator_2", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
    }

    private void entryMustInputCheck(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObjectCollection collection = bill.getDynamicObjectCollection("entryentity");
        for (int i = 0; collection != null && i < collection.size(); ++i) {
            String message;
            if (kd.bos.util.StringUtils.isEmpty((String)((DynamicObject)collection.get(i)).getString("sourcesign"))) {
                if (QuoteOtherHelper.isDimensionMode(bill)) {
                    message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u7b2c%1$s\u884c\u7684\u201c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemeExtSubmitValidator_3", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                    this.addMessage(data, message, ErrorLevel.Error);
                } else {
                    message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u7b2c%1$s\u884c\u7684\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemeExtSubmitValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                    this.addMessage(data, message, ErrorLevel.Error);
                }
            }
            if (!kd.bos.util.StringUtils.isEmpty((String)((DynamicObject)collection.get(i)).getString("quotesign")) || !QuoteOtherHelper.isDimensionMode(bill)) continue;
            message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u4ef7\u6761\u4ef6\u6620\u5c04\u5206\u5f55\u201d\u7b2c%1$s\u884c\u7684\u201c\u76ee\u6807\u5b9e\u4f53\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemeExtSubmitValidator_6", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
            this.addMessage(data, message, ErrorLevel.Error);
        }
    }

    private void resultEntryMustInputCheck(ExtendedDataEntity data, DynamicObject bill) {
        DynamicObjectCollection collection = bill.getDynamicObjectCollection("entryresult");
        if (collection != null && collection.size() > 0) {
            for (int i = 0; collection != null && i < collection.size(); ++i) {
                String message;
                DynamicObject entry = (DynamicObject)collection.get(i);
                String sourceSignr = entry.getString("sourcesignr");
                String quoteSign = entry.getString("quotesignr");
                if (!QuoteOtherHelper.isDimensionMode(bill)) {
                    if (StringUtils.isEmpty((CharSequence)quoteSign)) {
                        String msg = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u7b2c%1$s\u884c\uff1a\u201c\u53d6\u4ef7\u5355\u636e\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemeSubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                        this.addMessage(data, msg, ErrorLevel.Error);
                    }
                    if (!kd.bos.util.StringUtils.isEmpty((String)sourceSignr)) continue;
                    message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u7b2c%1$s\u884c\u7684\u201c\u4ef7\u683c\u6765\u6e90\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemeExtSubmitValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                    this.addMessage(data, message, ErrorLevel.Error);
                    continue;
                }
                if (!kd.bos.util.StringUtils.isEmpty((String)sourceSignr)) continue;
                message = String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u7b2c%1$s\u884c\u7684\u201c\u6765\u6e90\u5b9e\u4f53\u5b57\u6bb5\u201d\u3002", (String)"QuoteSchemeExtSubmitValidator_4", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), i + 1);
                this.addMessage(data, message, ErrorLevel.Error);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u53d6\u4ef7\u7ed3\u679c\u6620\u5c04\u5206\u5f55\u201d\u3002", (String)"QuoteSchemeExtSubmitValidator_5", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]);
            this.addMessage(data, message, ErrorLevel.Error);
        }
    }
}

