/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msbd.pricemodel.opplugin.quote;

import java.util.HashMap;
import java.util.List;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataRefenceKey;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;

public class QuoteSchemeUnAuditValidator
extends AbstractValidator {
    public void validate() {
        if (this.getValidateContext() == null || this.getValidateContext().getValidateResults() == null || this.getValidateContext().getValidateResults().errorSize() <= 0) {
            for (ExtendedDataEntity data : this.dataEntities) {
                this.check(data, true);
            }
        } else {
            for (ExtendedDataEntity data : this.dataEntities) {
                this.check(data, false);
            }
        }
    }

    private void check(ExtendedDataEntity data, boolean isWarning) {
        DynamicObject bill = data.getDataEntity();
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        List allRefList = checker.getAllRefs((BasedataEntityType)bill.getDataEntityType(), bill.getPkValue());
        HashMap<String, String> uniqueName = new HashMap<String, String>(16);
        for (BaseDataRefenceKey baseData : allRefList) {
            String refEntityKey = baseData.getRefEntityKey();
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refEntityKey);
            String billName = refMainType.getDisplayName().toString();
            String check = (String)uniqueName.get(billName);
            if (check != null) continue;
            uniqueName.put(billName, billName);
            if (isWarning) {
                this.addWarningMessage(data, String.format(ResManager.loadKDString((String)"\u8be5\u53d6\u4ef7\u65b9\u6848\u5df2\u88ab\u201c%s\u201d\u5f15\u7528\uff0c\u662f\u5426\u7ee7\u7eed\u4fee\u6539\uff1f", (String)"QuoteSchemeUnAuditValidator_0", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), billName));
                continue;
            }
            this.addMessage(data, String.format(ResManager.loadKDString((String)"\u8be5\u53d6\u4ef7\u65b9\u6848\u5df2\u88ab\u201c%s\u201d\u5f15\u7528\u3002", (String)"QuoteSchemeUnAuditValidator_1", (String)"mpscmm-msbd-pricemodel", (Object[])new Object[0]), billName));
        }
    }
}

